/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.services.ISimpleTimer;
import com.tc.services.IStripeMonitoringWrapper;
import com.tc.services.LocalMonitoringProducer;
import com.tc.services.TerracottaServiceProviderRegistry;
import com.tc.util.Assert;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.BasicServiceConfiguration;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.monitoring.IStripeMonitoring;
import org.terracotta.monitoring.PlatformServer;

public class BestEffortsMonitoring {
    private static final Logger LOGGER = LoggerFactory.getLogger(BestEffortsMonitoring.class);
    public static final long ASYNC_FLUSH_DELAY_MILLIS = 1000L;
    private final ISimpleTimer timer;
    private final Map<Long, Map<String, Serializable>> bestEffortsCache;
    private LocalMonitoringProducer.ActivePipeWrapper activeWrapper;
    private long outstandingTimerToken;

    public BestEffortsMonitoring(ISimpleTimer timer) {
        this.timer = timer;
        this.bestEffortsCache = new HashMap<Long, Map<String, Serializable>>();
    }

    public synchronized void flushAfterActivePromotion(PlatformServer thisServer, TerracottaServiceProviderRegistry globalRegistry) {
        this.ensureTimerCancelled();
        for (Map.Entry<Long, Map<String, Serializable>> perConsumerEntry : this.bestEffortsCache.entrySet()) {
            IStripeMonitoringWrapper collector = null;
            Collection underlyingCollector = globalRegistry.subRegistry(perConsumerEntry.getKey()).getServices((ServiceConfiguration)new BasicServiceConfiguration(IStripeMonitoring.class));
            Assert.assertNotNull((Object)underlyingCollector);
            collector = new IStripeMonitoringWrapper(underlyingCollector, LOGGER);
            for (Map.Entry<String, Serializable> entry : perConsumerEntry.getValue().entrySet()) {
                collector.pushBestEffortsData(thisServer, entry.getKey(), entry.getValue());
            }
        }
        this.bestEffortsCache.clear();
    }

    public synchronized void attachToNewActive(LocalMonitoringProducer.ActivePipeWrapper activeWrapper) {
        this.ensureTimerCancelled();
        this.activeWrapper = activeWrapper;
        if (!this.bestEffortsCache.isEmpty()) {
            this.flushCacheAndReset();
        }
    }

    public synchronized void pushBestEfforts(long consumerID, String name, Serializable data) {
        if (!this.bestEffortsCache.containsKey(consumerID)) {
            this.bestEffortsCache.put(consumerID, new HashMap());
        }
        Map<String, Serializable> map = this.bestEffortsCache.get(consumerID);
        map.put(name, data);
        this.requestFlushIfNonePending();
    }

    public synchronized void backgroundThreadFlush() {
        if (0L != this.outstandingTimerToken) {
            this.outstandingTimerToken = 0L;
            this.flushCacheAndReset();
        }
    }

    private void requestFlushIfNonePending() {
        if (0L == this.outstandingTimerToken && null != this.activeWrapper) {
            this.outstandingTimerToken = this.timer.addDelayed(new Runnable(){

                @Override
                public void run() {
                    BestEffortsMonitoring.this.backgroundThreadFlush();
                }
            }, this.timer.currentTimeMillis() + 1000L);
            Assert.assertTrue((this.outstandingTimerToken > 0L ? 1 : 0) != 0);
        }
    }

    private void flushCacheAndReset() {
        Assert.assertTrue((null != this.activeWrapper ? 1 : 0) != 0);
        Assert.assertTrue((0L == this.outstandingTimerToken ? 1 : 0) != 0);
        int messagesInBatch = 0;
        for (Map.Entry<Long, Map<String, Serializable>> entry : this.bestEffortsCache.entrySet()) {
            messagesInBatch += entry.getValue().size();
        }
        Assert.assertTrue((messagesInBatch > 0 ? 1 : 0) != 0);
        long[] consumerIDs = new long[messagesInBatch];
        String[] keys = new String[messagesInBatch];
        Serializable[] values = new Serializable[messagesInBatch];
        int index = 0;
        for (Map.Entry<Long, Map<String, Serializable>> entry : this.bestEffortsCache.entrySet()) {
            long consumerID = entry.getKey();
            for (Map.Entry<String, Serializable> mapEntry : entry.getValue().entrySet()) {
                consumerIDs[index] = consumerID;
                keys[index] = mapEntry.getKey();
                values[index] = mapEntry.getValue();
                ++index;
            }
        }
        this.bestEffortsCache.clear();
        this.activeWrapper.pushBestEffortsBatch(consumerIDs, keys, values);
    }

    private void ensureTimerCancelled() {
        if (0L != this.outstandingTimerToken) {
            this.timer.cancel(this.outstandingTimerToken);
            this.outstandingTimerToken = 0L;
        }
    }
}

