/*
 * Decompiled with CFR 0.152.
 */
package com.tc.server;

import com.tc.async.api.SEDA;
import com.tc.async.api.Stage;
import com.tc.config.ServerConfigurationManager;
import com.tc.l2.state.ServerMode;
import com.tc.l2.state.StateManager;
import com.tc.lang.TCThreadGroup;
import com.tc.lang.ThrowableHandler;
import com.tc.lang.ThrowableHandlerImpl;
import com.tc.logging.TCLogging;
import com.tc.management.beans.L2Dumper;
import com.tc.management.beans.L2MBeanNames;
import com.tc.management.beans.TCServerInfo;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.net.protocol.transport.ConnectionPolicyImpl;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.core.impl.GuardianContext;
import com.tc.objectserver.core.impl.ServerManagementContext;
import com.tc.objectserver.impl.DistributedObjectServer;
import com.tc.objectserver.impl.JMXSubsystem;
import com.tc.productinfo.ProductInfo;
import com.tc.server.TCServer;
import com.tc.server.UnexpectedStateException;
import com.tc.spi.Guardian;
import com.tc.stats.Client;
import com.tc.stats.DSO;
import com.tc.text.PrettyPrinter;
import com.tc.util.Assert;
import com.tc.util.State;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.monitoring.PlatformStopException;
import org.terracotta.server.StopAction;

public class TCServerImpl
extends SEDA
implements TCServer {
    private static final Logger logger = LoggerFactory.getLogger(TCServer.class);
    private static final Logger consoleLogger = TCLogging.getConsoleLogger();
    private volatile long startTime = -1L;
    private volatile long activateTime = -1L;
    private DistributedObjectServer dsoServer;
    private boolean dsoStarted;
    private final ServerConfigurationManager configurationSetupManager;
    protected final ConnectionPolicy connectionPolicy;
    private final CompletableFuture<Boolean> shutdownGate = new CompletableFuture();
    private final JMXSubsystem subsystem;
    private DSO dso;

    TCServerImpl(DistributedObjectServer dso, ServerConfigurationManager configurationSetupManager) {
        this(configurationSetupManager, new TCThreadGroup((ThrowableHandler)new ThrowableHandlerImpl(logger)));
        this.dsoServer = dso;
        this.dsoStarted = true;
    }

    public TCServerImpl(ServerConfigurationManager configurationSetupManager, TCThreadGroup threadGroup) {
        this(configurationSetupManager, threadGroup, (ConnectionPolicy)new ConnectionPolicyImpl(Integer.MAX_VALUE));
    }

    protected TCServerImpl(ServerConfigurationManager manager, TCThreadGroup group, ConnectionPolicy connectionPolicy) {
        super(group);
        this.subsystem = new JMXSubsystem(!group.isStoppable() ? ManagementFactory.getPlatformMBeanServer() : MBeanServerFactory.createMBeanServer());
        this.connectionPolicy = connectionPolicy;
        Assert.assertNotNull((Object)manager);
        this.configurationSetupManager = manager;
        GuardianContext.setServer(this);
    }

    @Override
    public JMXSubsystem getJMX() {
        return this.subsystem;
    }

    @Override
    public ProductInfo productInfo() {
        return this.configurationSetupManager.getProductInfo();
    }

    @Override
    public String getL2Identifier() {
        return this.configurationSetupManager.getServerConfiguration().getName();
    }

    @Override
    public void stopIfPassive(StopAction ... restartMode) throws PlatformStopException {
        if (!this.getStateManager().moveToStopStateIf(ServerMode.PASSIVE_STATES)) {
            throw new UnexpectedStateException("Server is not in passive state, current state: " + (Object)((Object)this.getStateManager().getCurrentMode()));
        }
        this.stop(restartMode);
    }

    @Override
    public void stopIfActive(StopAction ... restartMode) throws PlatformStopException {
        if (!this.getStateManager().moveToStopStateIf(EnumSet.of(ServerMode.ACTIVE))) {
            throw new UnexpectedStateException("Server is not in active state, current state: " + (Object)((Object)this.getStateManager().getCurrentMode()));
        }
        this.stop(restartMode);
    }

    @Override
    public void stop(StopAction ... restartMode) {
        block7: {
            this.audit("Stop invoked", new Properties());
            TCLogging.getConsoleLogger().info("Stopping server");
            if (this.dsoServer != null) {
                try {
                    this.getStateManager().moveToStopStateIf(EnumSet.complementOf(EnumSet.of(ServerMode.STOP)));
                    EnumSet<StopAction> set = EnumSet.noneOf(StopAction.class);
                    for (StopAction s : restartMode) {
                        set.add(s);
                    }
                    if (set.contains(StopAction.ZAP)) {
                        TCLogging.getConsoleLogger().info("Setting data to dirty");
                        this.dsoServer.getPersistor().getClusterStatePersistor().setDBClean(false);
                    }
                    CompletableFuture<Void> dsoStop = this.dsoServer.destroy(set.contains(StopAction.IMMEDIATE));
                    if (set.contains(StopAction.RESTART)) {
                        TCLogging.getConsoleLogger().info("Requesting restart");
                        dsoStop.thenRun(() -> this.shutdownGate.complete(true));
                        break block7;
                    }
                    dsoStop.thenRun(() -> this.shutdownGate.complete(false));
                }
                catch (Throwable e) {
                    logger.error("trouble shutting down", e);
                    this.shutdownGate.completeExceptionally(e);
                }
            } else {
                this.shutdownGate.complete(false);
            }
        }
    }

    @Override
    public void start() {
        if (this.dsoServer == null) {
            try {
                this.startServer().get();
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        } else {
            logger.warn("Server in incorrect state (" + this.getStateManager().getCurrentMode().getName() + ") to be started.");
        }
    }

    @Override
    public boolean canShutdown() {
        ServerMode serverState = this.getStateManager().getCurrentMode();
        return serverState == ServerMode.PASSIVE || serverState == ServerMode.ACTIVE || serverState == ServerMode.UNINITIALIZED || serverState == ServerMode.SYNCING;
    }

    @Override
    public synchronized void shutdown() {
        if (this.canShutdown()) {
            consoleLogger.info("Server exiting...");
            this.stop(new StopAction[0]);
        } else {
            logger.warn("Server in incorrect state (" + this.getStateManager().getCurrentMode().getName() + ") to be shutdown.");
        }
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void updateActivateTime() {
        if (this.activateTime == -1L) {
            this.activateTime = System.currentTimeMillis();
        }
    }

    @Override
    public long getActivateTime() {
        return this.activateTime;
    }

    public void audit(String msg, Properties additional) {
        GuardianContext.validate(Guardian.Op.AUDIT_OP, msg, additional);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getConfig() {
        try (InputStream is = this.configurationSetupManager.rawConfigFile();){
            ByteArrayOutputStream writer = new ByteArrayOutputStream();
            int c = is.read();
            while (c >= 0) {
                writer.write((byte)c);
                c = is.read();
            }
            String string = new String(writer.toByteArray(), Charset.defaultCharset());
            return string;
        }
        catch (IOException ioe) {
            return ioe.getLocalizedMessage();
        }
    }

    @Override
    public int getTSAListenPort() {
        if (this.dsoServer != null) {
            return this.dsoServer.getListenPort();
        }
        throw new IllegalStateException("TSA Server not running");
    }

    @Override
    public int getTSAGroupPort() {
        if (this.dsoServer != null) {
            return this.dsoServer.getGroupPort();
        }
        throw new IllegalStateException("TSA Server not running");
    }

    public DistributedObjectServer getDSOServer() {
        return this.dsoServer;
    }

    private StateManager getStateManager() {
        return this.dsoServer.getContext().getL2Coordinator().getStateManager();
    }

    @Override
    public synchronized boolean isStarted() {
        return !this.dsoStarted || this.getStateManager().getCurrentMode().isStartup();
    }

    @Override
    public boolean isActive() {
        return this.dsoStarted && this.getStateManager().isActiveCoordinator();
    }

    @Override
    public synchronized boolean isStopped() {
        return this.dsoStarted && this.getStateManager().getCurrentMode() == ServerMode.STOP;
    }

    @Override
    public boolean isPassiveUnitialized() {
        return this.dsoStarted && this.getStateManager().getCurrentMode() == ServerMode.UNINITIALIZED;
    }

    @Override
    public boolean isPassiveStandby() {
        return this.dsoStarted && this.getStateManager().getCurrentMode() == ServerMode.PASSIVE;
    }

    @Override
    public boolean isReconnectWindow() {
        return this.dsoStarted && this.dsoServer.getContext().getClientHandshakeManager().isStarting();
    }

    @Override
    public boolean isAcceptingClients() {
        return this.dsoStarted && this.dsoServer.isL1Listening() && this.dsoServer.getContext().getClientHandshakeManager().isStarted();
    }

    @Override
    public int getReconnectWindowTimeout() {
        return this.configurationSetupManager.getServerConfiguration().getClientReconnectWindow();
    }

    @Override
    public State getState() {
        return this.getStateManager().getCurrentMode().getState();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Server: ").append(super.toString()).append("\n");
        if (this.isActive()) {
            buf.append("Active since ").append(new Date(this.getStartTime())).append("\n");
        } else if (this.isStarted()) {
            buf.append("Started at ").append(new Date(this.getStartTime())).append("\n");
        } else {
            buf.append("Server is stopped").append("\n");
        }
        return buf.toString();
    }

    protected void warnOfStall(String name, long delay, int queueDepth) {
    }

    protected Future<Void> startServer() throws Exception {
        CompletableFuture<Void> complete = new CompletableFuture<Void>();
        new Thread((ThreadGroup)this.getThreadGroup(), new StartAction(complete), "Server Startup Thread").start();
        return complete;
    }

    private void startDSOServer() throws Exception {
        Assert.assertTrue((this.dsoServer == null ? 1 : 0) != 0);
        this.dsoServer = this.createDistributedObjectServer(this.configurationSetupManager, this.connectionPolicy, this);
        this.dsoServer.start();
        this.dsoStarted = true;
        MBeanServer mbean = this.subsystem.getServer();
        this.registerDSOServer(mbean);
        this.registerServerMBeans(mbean);
    }

    protected DistributedObjectServer createDistributedObjectServer(ServerConfigurationManager configSetupManager, ConnectionPolicy policy, TCServerImpl serverImpl) {
        DistributedObjectServer dso = new DistributedObjectServer(configSetupManager, this.getThreadGroup(), policy, this, this);
        return dso;
    }

    @Override
    public void dump() {
        this.audit("Dump invoked", new Properties());
        TCLogging.getDumpLogger().info(new String(this.dsoServer.getClusterState(Charset.defaultCharset(), null), Charset.defaultCharset()));
    }

    protected synchronized void registerDSOServer(MBeanServer mBeanServer) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ServerManagementContext mgmtContext = this.dsoServer.getManagementContext();
        ServerConfigurationContext configContext = this.dsoServer.getContext();
        this.registerDSOMBeans(mgmtContext, configContext, mBeanServer);
    }

    protected void registerServerMBeans(MBeanServer mBeanServer) throws NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        mBeanServer.registerMBean(new TCServerInfo(this), L2MBeanNames.TC_SERVER_INFO);
        mBeanServer.registerMBean(new L2Dumper(this, mBeanServer), L2MBeanNames.DUMPER);
    }

    protected void unregisterServerMBeans(MBeanServer mbs) throws MBeanRegistrationException, InstanceNotFoundException {
        mbs.unregisterMBean(L2MBeanNames.TC_SERVER_INFO);
        mbs.unregisterMBean(L2MBeanNames.DUMPER);
    }

    protected void registerDSOMBeans(ServerManagementContext mgmtContext, ServerConfigurationContext configContext, MBeanServer mBeanServer) throws NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        this.dso = new DSO(mgmtContext, configContext, mBeanServer);
        mBeanServer.registerMBean(this.dso, L2MBeanNames.DSO);
    }

    protected void unregisterDSOMBeans(MBeanServer mbs) throws MBeanRegistrationException, InstanceNotFoundException {
        mbs.unregisterMBean(L2MBeanNames.DSO);
    }

    @Override
    public boolean waitUntilShutdown() {
        try {
            return this.shutdownGate.get();
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    @Override
    public String[] processArguments() {
        return this.configurationSetupManager.getProcessArguments();
    }

    @Override
    public String getClusterState(PrettyPrinter form) {
        return new String(this.dsoServer.getClusterState(Charset.defaultCharset(), form), Charset.defaultCharset());
    }

    @Override
    public List<Client> getConnectedClients() {
        return this.dso.getConnectedClients();
    }

    public void pause(String path) {
        if (path.equalsIgnoreCase("L1")) {
            try {
                this.dsoServer.getCommunicationsManager().getConnectionManager().getTcComm().pause();
            }
            catch (NullPointerException nullPointerException) {}
        } else if (path.equalsIgnoreCase("L2")) {
            try {
                this.dsoServer.getGroupManager().getConnectionManager().getTcComm().pause();
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            Stage s = this.getStageManager().getStage(path, Object.class);
            if (s != null) {
                s.pause();
            }
        }
    }

    public void unpause(String path) {
        if (path.equalsIgnoreCase("L1")) {
            try {
                this.dsoServer.getCommunicationsManager().getConnectionManager().getTcComm().unpause();
            }
            catch (NullPointerException nullPointerException) {}
        } else if (path.equalsIgnoreCase("L2")) {
            try {
                this.dsoServer.getGroupManager().getConnectionManager().getTcComm().unpause();
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            Stage s = this.getStageManager().getStage(path, Object.class);
            if (s != null) {
                s.unpause();
            }
        }
    }

    public Map<String, ?> getStateMap() {
        return this.getStageManager().getStateMap();
    }

    public void stageWarning(Object description) {
        super.stageWarning(description);
    }

    private class StartAction
    implements Runnable {
        private final CompletableFuture<Void> finish;

        public StartAction(CompletableFuture<Void> finish) {
            this.finish = finish;
        }

        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting Terracotta server instance...");
            }
            TCServerImpl.this.startTime = System.currentTimeMillis();
            if (Runtime.getRuntime().maxMemory() != Long.MAX_VALUE) {
                consoleLogger.info("Available Max Runtime Memory: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "MB");
            }
            try {
                TCServerImpl.this.startDSOServer();
            }
            catch (Throwable e) {
                this.finish.completeExceptionally(e);
            }
            String serverName = TCServerImpl.this.configurationSetupManager.getServerConfiguration().getName();
            if (serverName != null) {
                logger.info("Server started as " + serverName);
            }
            this.finish.complete(null);
        }
    }
}

