/*
 * Decompiled with CFR 0.152.
 */
package com.tc.server;

import com.tc.classloader.ServiceLocator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceClassLoader
extends ClassLoader {
    private final Map<String, Class<?>> cached = new HashMap();

    public ServiceClassLoader(ServiceLocator loader, Class<?> ... serviceTypes) {
        super(loader.getServiceLoader());
        for (Class<?> serviceType : serviceTypes) {
            List<Class<?>> svcs = loader.getImplementations(serviceType);
            this.loadServiceClasses(svcs);
        }
    }

    public ServiceClassLoader(ClassLoader loader, Class<?> ... serviceTypes) {
        super(loader);
        ServiceLocator locator = new ServiceLocator(loader);
        for (Class<?> serviceType : serviceTypes) {
            List<Class<?>> svcs = locator.getImplementations(serviceType);
            this.loadServiceClasses(svcs);
        }
    }

    public void addServiceClass(Class<?> svc) {
        this.cached.put(svc.getName(), svc);
    }

    private void loadServiceClasses(List<Class<?>> svcs) {
        for (Class<?> svc : svcs) {
            this.cached.put(svc.getName(), svc);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> get = this.cached.get(name);
        if (get != null) {
            return get;
        }
        return super.loadClass(name, resolve);
    }
}

