/*
 * Decompiled with CFR 0.152.
 */
package com.tc.server;

import com.tc.exception.ExceptionHelper;
import com.tc.exception.ExceptionHelperImpl;
import com.tc.exception.RuntimeExceptionHelper;
import com.tc.exception.TCNotRunningException;
import com.tc.exception.TCRuntimeException;
import com.tc.handler.CallbackStartupExceptionLoggingAdapter;
import com.tc.lang.ThrowableHandler;
import com.tc.logging.CallbackOnExitHandler;
import com.tc.logging.CallbackOnExitState;
import com.tc.logging.TCLogging;
import com.tc.properties.TCPropertiesImpl;
import com.tc.server.CallbackShutdownExceptionLoggingAdapter;
import com.tc.server.ConfigurationExceptionLoggingAdapter;
import com.tc.util.TCDataFileLockingException;
import com.tc.util.Throwables;
import com.tc.util.startuplock.FileNotCreatedException;
import com.tc.util.startuplock.LocationNotCreatedException;
import java.net.BindException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.terracotta.configuration.ConfigurationException;
import org.terracotta.server.ServerEnv;
import org.terracotta.server.StopAction;

public class BootstrapThrowableHandler
implements ThrowableHandler {
    private static final String OOME_ERROR_MSG = "Fatal error: out of available memory. Exiting...";
    protected final Logger logger;
    private final ExceptionHelperImpl helper;
    private final List<CallbackOnExitHandler> callbackOnExitDefaultHandlers = new CopyOnWriteArrayList<CallbackOnExitHandler>();
    private final Map<Class<?>, CallbackOnExitHandler> callbackOnExitExceptionHandlers = new HashMap();
    private final Object dumpLock = new Object();
    private static final long TIME_OUT = TCPropertiesImpl.getProperties().getLong("l2.dump.on.exception.timeout") * 1000L;
    private boolean isExitScheduled;
    private boolean isDumpTaken;

    public BootstrapThrowableHandler(Logger logger) {
        this.logger = logger;
        this.helper = new ExceptionHelperImpl();
        this.helper.addHelper((ExceptionHelper)new RuntimeExceptionHelper());
        this.registerStartupExceptionCallbackHandlers();
    }

    public void addHelper(ExceptionHelper toAdd) {
        this.helper.addHelper(toAdd);
    }

    private void registerStartupExceptionCallbackHandlers() {
        String bindExceptionExtraMessage = ".  Please make sure the server isn't already running or choose a different port.";
        this.addCallbackOnExitExceptionHandler(BindException.class, (CallbackOnExitHandler)new CallbackStartupExceptionLoggingAdapter(bindExceptionExtraMessage));
        this.addCallbackOnExitExceptionHandler(LocationNotCreatedException.class, (CallbackOnExitHandler)new CallbackStartupExceptionLoggingAdapter());
        this.addCallbackOnExitExceptionHandler(FileNotCreatedException.class, (CallbackOnExitHandler)new CallbackStartupExceptionLoggingAdapter());
        this.addCallbackOnExitExceptionHandler(TCDataFileLockingException.class, (CallbackOnExitHandler)new CallbackStartupExceptionLoggingAdapter());
        this.addCallbackOnExitExceptionHandler(TCNotRunningException.class, new CallbackShutdownExceptionLoggingAdapter());
        this.addCallbackOnExitExceptionHandler(InterruptedException.class, new CallbackShutdownExceptionLoggingAdapter());
        this.addCallbackOnExitExceptionHandler(IllegalStateException.class, new CallbackShutdownExceptionLoggingAdapter());
        this.addCallbackOnExitExceptionHandler(TCRuntimeException.class, new CallbackShutdownExceptionLoggingAdapter());
        this.addCallbackOnExitExceptionHandler(ConfigurationException.class, new ConfigurationExceptionLoggingAdapter());
    }

    public void addCallbackOnExitDefaultHandler(CallbackOnExitHandler callbackOnExitHandler) {
        this.callbackOnExitDefaultHandlers.add(callbackOnExitHandler);
    }

    public void addCallbackOnExitExceptionHandler(Class<?> c, CallbackOnExitHandler exitHandler) {
        this.callbackOnExitExceptionHandlers.put(c, exitHandler);
    }

    public void handleThrowable(Thread thread, Throwable t) {
        this.handlePossibleOOME(t);
        CallbackOnExitState throwableState = new CallbackOnExitState(t);
        Throwable proximateCause = this.helper.getProximateCause(t);
        Throwable ultimateCause = this.helper.getUltimateCause(t);
        try {
            CallbackOnExitHandler registeredExitHandlerObject = this.callbackOnExitExceptionHandlers.get(proximateCause.getClass());
            if (registeredExitHandlerObject != null) {
                try {
                    registeredExitHandlerObject.callbackOnExit(throwableState);
                }
                catch (Throwable unhandled) {
                    this.handleDefaultException(thread, new CallbackOnExitState(unhandled));
                }
            } else {
                registeredExitHandlerObject = this.callbackOnExitExceptionHandlers.get(ultimateCause.getClass());
                if (registeredExitHandlerObject != null) {
                    try {
                        registeredExitHandlerObject.callbackOnExit(throwableState);
                    }
                    catch (Throwable unhandled) {
                        this.handleDefaultException(thread, new CallbackOnExitState(unhandled));
                    }
                } else {
                    this.handleDefaultException(thread, throwableState);
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Error while handling uncaught expection" + t.getCause(), throwable);
        }
        this.exit(throwableState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePossibleOOME(Throwable t) {
        Throwable rootCause = Throwables.getRootCause((Throwable)t);
        if (rootCause instanceof OutOfMemoryError) {
            try {
                this.logger.error(OOME_ERROR_MSG);
                String msg = rootCause.getMessage();
                if (msg != null && msg.length() > 0) {
                    this.logger.error(msg);
                }
            }
            finally {
                this.exit(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDefaultException(Thread thread, CallbackOnExitState throwableState) {
        this.logException(thread, throwableState);
        Object object = this.dumpLock;
        synchronized (object) {
            if (!this.isDumpTaken) {
                this.isDumpTaken = true;
                for (CallbackOnExitHandler handler : this.callbackOnExitDefaultHandlers) {
                    handler.callbackOnExit(throwableState);
                }
            }
        }
    }

    private void logException(Thread thread, CallbackOnExitState throwableState) {
        try {
            Throwable cause;
            TCLogging.getConsoleLogger().error("Thread:" + thread + " got an uncaught exception. calling CallbackOnExitDefaultHandlers. " + cause.getMessage(), cause);
            int tab = 0;
            for (cause = throwableState.getThrowable(); cause != null; cause = cause.getCause()) {
                StringBuilder spaces = new StringBuilder(tab * 2);
                for (int x = 0; x < tab * 2; ++x) {
                    spaces.setCharAt(x, ' ');
                }
                TCLogging.getConsoleLogger().error("{}{}:{}", new Object[]{spaces, cause.getClass().getName(), cause.getMessage()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void exit(CallbackOnExitState throwableState) {
        boolean autoRestart = TCPropertiesImpl.getProperties().getBoolean("l2.nha.autoRestart");
        if (!ServerEnv.getServer().isStopped()) {
            this.logger.info("ExitState : " + throwableState + "; AutoRestart: " + autoRestart);
            if (autoRestart && throwableState.isRestartNeeded()) {
                this.exit(true);
            } else {
                this.exit(false);
            }
        }
    }

    protected synchronized void exit(boolean status) {
        StopAction[] stopActionArray;
        if (status) {
            StopAction[] stopActionArray2 = new StopAction[1];
            stopActionArray = stopActionArray2;
            stopActionArray2[0] = StopAction.RESTART;
        } else {
            stopActionArray = new StopAction[]{};
        }
        StopAction[] actions = stopActionArray;
        ServerEnv.getServer().stop(actions);
    }
}

