/*
 * Decompiled with CFR 0.152.
 */
package com.tc.server;

import com.tc.classloader.ServiceLocator;
import com.tc.config.ServerConfigurationManager;
import com.tc.l2.logging.TCLogbackLogging;
import com.tc.lang.TCThreadGroup;
import com.tc.lang.ThrowableHandler;
import com.tc.logging.TCLogging;
import com.tc.management.TerracottaManagement;
import com.tc.objectserver.core.impl.GuardianContext;
import com.tc.objectserver.impl.JMXSubsystem;
import com.tc.productinfo.ProductInfo;
import com.tc.server.BootstrapService;
import com.tc.server.BootstrapThrowableHandler;
import com.tc.server.ServiceClassLoader;
import com.tc.server.TCServerImpl;
import com.tc.spi.Pauseable;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.configuration.ConfigurationException;
import org.terracotta.configuration.ConfigurationProvider;
import org.terracotta.monitoring.PlatformStopException;
import org.terracotta.server.Server;
import org.terracotta.server.ServerEnv;
import org.terracotta.server.ServerJMX;
import org.terracotta.server.StopAction;

public class Bootstrap
implements BootstrapService {
    private static final Logger CONSOLE = LoggerFactory.getLogger((String)"org.terracotta.console");

    public Server createServer(List<String> args, OutputStream out, ClassLoader loader) {
        TCLogbackLogging.bootstrapLogging(out);
        ServiceLocator locator = ServiceLocator.createPlatformServiceLoader(loader);
        ServerConfigurationManager setup = new ServerConfigurationManager(Bootstrap.getConfigurationProvider(locator), locator, args);
        Bootstrap.writeVersion(setup.getProductInfo());
        Bootstrap.writePID();
        BootstrapThrowableHandler throwableHandler = new BootstrapThrowableHandler(LoggerFactory.getLogger(TCServerImpl.class));
        TCThreadGroup threadGroup = new TCThreadGroup((ThrowableHandler)throwableHandler, Integer.toString(System.identityHashCode(this)), out != null);
        TCServerImpl impl = new TCServerImpl(setup, threadGroup);
        Server server = this.wrap(setup, args, locator, impl);
        boolean redirected = false;
        try {
            ServerEnv.setDefaultServer((Server)server);
            setup.initialize();
            TCLogbackLogging.setServerName(setup.getServerConfiguration().getName());
            TCLogbackLogging.redirectLogging(setup.getServerConfiguration().getLogsLocation());
            redirected = true;
            Bootstrap.writeSystemProperties();
            impl.start();
        }
        catch (ConfigurationException config) {
            throwableHandler.handleThrowable(Thread.currentThread(), config);
            if (config.getMessage().equals("print usage information")) {
                redirected = true;
            }
        }
        catch (Throwable t) {
            throwableHandler.handleThrowable(Thread.currentThread(), t);
            throw t;
        }
        finally {
            if (!redirected) {
                TCLogbackLogging.redirectLogging(null);
            }
        }
        return server;
    }

    private static void writeVersion(ProductInfo info) {
        String versionMessage;
        String longProductString = info.toLongString();
        CONSOLE.info(longProductString);
        CONSOLE.info("Extensions:");
        for (String ext : info.getExtensions()) {
            CONSOLE.info(ext);
        }
        if (info.isPatched()) {
            String longPatchString = info.toLongPatchString();
            CONSOLE.info(longPatchString);
        }
        if (!(versionMessage = info.versionMessage()).isEmpty()) {
            CONSOLE.info(versionMessage);
        }
    }

    private static void writePID() {
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            long pid = Long.parseLong(processName.split("@")[0]);
            CONSOLE.info("PID is {}", (Object)pid);
        }
        catch (Throwable t) {
            CONSOLE.warn("Unable to fetch the PID of this process.");
        }
    }

    private static void writeSystemProperties() {
        try {
            Properties properties = System.getProperties();
            int maxKeyLength = 1;
            ArrayList<String> keys = new ArrayList<String>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object objKey = entry.getKey();
                Object objValue = entry.getValue();
                if (!(objKey instanceof String) || !(objValue instanceof String)) continue;
                String key = (String)objKey;
                keys.add(key);
                maxKeyLength = Math.max(maxKeyLength, key.length());
            }
            String inputArguments = null;
            try {
                RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
                inputArguments = mxbean.getInputArguments().toString();
            }
            catch (SecurityException se) {
                inputArguments = "unknown";
            }
            String nl = System.getProperty("line.separator");
            StringBuffer data = new StringBuffer();
            data.append("All Java System Properties for this Terracotta instance:");
            data.append(nl);
            data.append("========================================================================");
            data.append(nl);
            data.append("JVM arguments: " + inputArguments);
            data.append(nl);
            Object[] sortedKeys = keys.toArray(new String[keys.size()]);
            Arrays.sort(sortedKeys);
            for (Object key : sortedKeys) {
                data.append((String)key);
                for (int i = 0; i < maxKeyLength - ((String)key).length(); ++i) {
                    data.append(' ');
                }
                data.append(" : ");
                data.append(properties.get(key));
                data.append(nl);
            }
            data.append("========================================================================");
            LoggerFactory.getLogger(TCLogbackLogging.class).info(data.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private Server wrap(final ServerConfigurationManager config, final List<String> args, final ServiceLocator loader, final TCServerImpl impl) {
        return new PauseableServer(){

            public Map<String, ?> getStateMap() {
                return impl.getStateMap();
            }

            public void pause(String path) {
                impl.pause(path);
            }

            public void unpause(String path) {
                impl.unpause(path);
            }

            public int getServerCount() {
                return config.getConfiguration().getServerConfigurations().size();
            }

            public String[] processArguments() {
                return args.toArray(new String[args.size()]);
            }

            public void stop(StopAction ... modes) {
                impl.stop(modes);
            }

            public boolean stopIfPassive(StopAction ... modes) {
                try {
                    impl.stopIfPassive(modes);
                }
                catch (PlatformStopException stop) {
                    this.warn("unable to stop server", new Object[]{stop});
                    return false;
                }
                return true;
            }

            public boolean stopIfActive(StopAction ... modes) {
                try {
                    impl.stopIfActive(modes);
                }
                catch (PlatformStopException stop) {
                    this.warn("unable to stop server", new Object[]{stop});
                    return false;
                }
                return true;
            }

            public boolean isActive() {
                return impl.isActive();
            }

            public boolean isStopped() {
                return impl.isStopped();
            }

            public boolean isPassiveUnitialized() {
                return impl.isPassiveUnitialized();
            }

            public boolean isPassiveStandby() {
                return impl.isPassiveStandby();
            }

            public boolean isReconnectWindow() {
                return impl.isReconnectWindow();
            }

            public String getState() {
                return impl.getState().toString();
            }

            public long getStartTime() {
                return impl.getStartTime();
            }

            public long getActivateTime() {
                return impl.getActivateTime();
            }

            public String getIdentifier() {
                return impl.getL2Identifier();
            }

            public int getClientPort() {
                return config.getServerConfiguration().getTsaPort().getPort();
            }

            public int getServerPort() {
                return config.getServerConfiguration().getGroupPort().getPort();
            }

            public String getServerHostName() {
                return config.getServerConfiguration().getHost();
            }

            public int getReconnectWindowTimeout() {
                return config.getServerConfiguration().getClientReconnectWindow();
            }

            public boolean waitUntilShutdown() {
                try {
                    boolean bl = impl.waitUntilShutdown();
                    return bl;
                }
                finally {
                    TCLogbackLogging.resetLogging();
                }
            }

            public void dump() {
                impl.dump();
            }

            public String getClusterState() {
                return impl.getClusterState(null);
            }

            public String getConfiguration() {
                return config.rawConfigString();
            }

            public ClassLoader getServiceClassLoader(ClassLoader parent, Class<?> ... serviceClasses) {
                return new ServiceClassLoader(parent, serviceClasses);
            }

            public <T> List<Class<? extends T>> getImplementations(Class<T> serviceClasses) {
                return loader.getImplementations(serviceClasses);
            }

            public ServerJMX getManagement() {
                final JMXSubsystem system = impl.getJMX();
                return new ServerJMX(){

                    public String get(String target, String attr) {
                        return system.get(target, attr);
                    }

                    public String set(String target, String attr, String val) {
                        return system.set(target, attr, val);
                    }

                    public String call(String target, String cmd, String arg) {
                        return system.call(target, cmd, arg);
                    }

                    public void registerMBean(String target, Object object) {
                        try {
                            system.getServer().registerMBean(object, TerracottaManagement.createObjectName(null, (String)target, (TerracottaManagement.MBeanDomain)TerracottaManagement.MBeanDomain.PUBLIC));
                        }
                        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public MBeanServer getMBeanServer() {
                        return system.getServer();
                    }
                };
            }

            public Properties getCurrentChannelProperties() {
                return GuardianContext.getCurrentChannelProperties();
            }

            public void warn(String warning, Object ... event) {
                TCLogging.getConsoleLogger().warn(warning, event);
            }

            public void console(String message, Object ... sub) {
                TCLogging.getConsoleLogger().info(message, sub);
            }

            public void audit(String msg, Properties additional) {
                impl.audit(msg, additional);
            }
        };
    }

    private static ConfigurationProvider getConfigurationProvider(ServiceLocator loader) {
        List<Class<ConfigurationProvider>> pl = loader.getImplementations(ConfigurationProvider.class);
        if (pl.isEmpty()) {
            throw new RuntimeException("No ConfigurationProvider found");
        }
        if (pl.size() == 1) {
            try {
                return (ConfigurationProvider)((Class)pl.iterator().next()).newInstance();
            }
            catch (IllegalAccessException | InstantiationException ii) {
                throw new RuntimeException("unable to load configuration");
            }
        }
        throw new RuntimeException("Found multiple implementations of ConfigurationProvider");
    }

    private static interface PauseableServer
    extends Server,
    Pauseable {
    }
}

