/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.persistence;

import com.tc.net.ClientID;
import com.tc.net.core.ProductID;
import com.tc.object.tx.TransactionID;
import com.tc.util.AbstractIdentifier;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Future;
import org.terracotta.persistence.IPlatformPersistence;

public class TransactionOrderPersistor {
    private final IPlatformPersistence storageManager;
    private Long receivedTransactionCount = 0L;
    private List<ClientTransaction> globalList = null;
    private final Set<ClientID> permNodeIDs = new HashSet<ClientID>();
    private final Map<ClientID, List<ClientTransaction>> fastSequenceCache = new HashMap<ClientID, List<ClientTransaction>>();

    public TransactionOrderPersistor(IPlatformPersistence storageManager, Set<ClientID> clients) {
        this.storageManager = storageManager;
        for (ClientID oneClient : clients) {
            this.permNodeIDs.add(oneClient);
        }
    }

    public synchronized Future<Void> updateWithNewMessage(ClientID source, TransactionID transactionID, TransactionID oldestTransactionOnClient) {
        if (null == oldestTransactionOnClient || null == transactionID) {
            throw new IllegalArgumentException("Transactions cannot be null");
        }
        if (oldestTransactionOnClient.compareTo((AbstractIdentifier)transactionID) > 0) {
            throw new IllegalArgumentException("Oldest transaction cannot come after new transaction");
        }
        this.globalList = null;
        TransactionOrderPersistor transactionOrderPersistor = this;
        transactionOrderPersistor.receivedTransactionCount = transactionOrderPersistor.receivedTransactionCount + 1L;
        if (!source.isNull() && oldestTransactionOnClient.isValid()) {
            Object transaction;
            if (this.permNodeIDs.contains(source)) {
                transaction = new IPlatformPersistence.SequenceTuple();
                transaction.localSequenceID = transactionID.toLong();
                transaction.globalSequenceID = this.receivedTransactionCount;
                return this.storageManager.fastStoreSequence(source.toLong(), transaction, oldestTransactionOnClient.toLong());
            }
            transaction = new ClientTransaction();
            transaction.localTransactionID = transactionID.toLong();
            transaction.globalTransactionID = this.receivedTransactionCount;
            return this.fastStoreSequence(source, (ClientTransaction)transaction, oldestTransactionOnClient.toLong());
        }
        return null;
    }

    synchronized void addTrackingForClient(ClientID source, ProductID product) {
        if (product.isPermanent()) {
            this.permNodeIDs.add(source);
        } else if (product.isReconnectEnabled()) {
            this.fastSequenceCache.put(source, new LinkedList());
        }
    }

    synchronized void removeTrackingForClient(ClientID source) {
        long sourceID = source.toLong();
        try {
            if (this.permNodeIDs.remove(source)) {
                this.storageManager.deleteSequence(sourceID);
            } else {
                this.fastSequenceCache.remove(source);
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    private Future<Void> fastStoreSequence(ClientID sequenceIndex, ClientTransaction newEntry, long oldestValidSequenceID) {
        List<ClientTransaction> sequence = this.fastSequenceCache.get(sequenceIndex);
        if (sequence != null) {
            if (!sequence.isEmpty()) {
                Iterator<ClientTransaction> tuple = sequence.iterator();
                while (tuple.hasNext() && tuple.next().localTransactionID < oldestValidSequenceID) {
                    tuple.remove();
                }
            }
            sequence.add(newEntry);
        }
        return null;
    }

    private synchronized List<ClientTransaction> buildGlobalListIfNecessary() {
        if (null == this.globalList) {
            TreeMap<Long, ClientTransaction> sortMap = new TreeMap<Long, ClientTransaction>();
            for (ClientID clientID : this.permNodeIDs) {
                List transactions = null;
                try {
                    transactions = this.storageManager.loadSequence(clientID.toLong());
                }
                catch (IOException e) {
                    Assert.fail((String)e.getLocalizedMessage());
                }
                if (transactions == null) continue;
                for (IPlatformPersistence.SequenceTuple tuple : transactions) {
                    ClientTransaction transaction = new ClientTransaction();
                    transaction.clientID = clientID.toLong();
                    transaction.localTransactionID = tuple.localSequenceID;
                    transaction.globalTransactionID = tuple.globalSequenceID;
                    sortMap.put(tuple.globalSequenceID, transaction);
                }
            }
            for (List list : this.fastSequenceCache.values()) {
                if (list == null) continue;
                for (ClientTransaction t : list) {
                    sortMap.put(t.globalTransactionID, t);
                }
            }
            this.globalList = Collections.unmodifiableList(new ArrayList(sortMap.values()));
            this.receivedTransactionCount = !sortMap.isEmpty() ? (Long)sortMap.lastKey() : Long.valueOf(0L);
        }
        return this.globalList;
    }

    public int getIndexToReplay(ClientID source, TransactionID transaction) {
        long sourceID = source.toLong();
        long transactionID = transaction.toLong();
        int index = -1;
        List<ClientTransaction> list = this.buildGlobalListIfNecessary();
        int seek = 0;
        for (ClientTransaction oneTransaction : list) {
            if (oneTransaction.clientID == sourceID && oneTransaction.localTransactionID == transactionID) {
                index = seek;
                break;
            }
            ++seek;
        }
        return index;
    }

    public synchronized void clearAllRecords() {
        this.globalList = null;
        for (ClientID nodeID : this.permNodeIDs) {
            try {
                this.storageManager.deleteSequence(nodeID.toLong());
            }
            catch (IOException e) {
                Assert.fail((String)e.getLocalizedMessage());
            }
        }
        this.fastSequenceCache.clear();
    }

    public long getReceivedTransactionCount() {
        return this.receivedTransactionCount;
    }

    public synchronized Map<String, Object> reportStateToMap(Map<String, Object> map) {
        LinkedHashMap clientMap;
        map.put("className", this.getClass().getName());
        map.put("receivedTransactions", this.getReceivedTransactionCount());
        if (this.permNodeIDs != null && this.storageManager != null) {
            clientMap = new LinkedHashMap();
            map.put("permanentClients", clientMap);
            for (ClientID clientNodeID : this.permNodeIDs) {
                List transactions = null;
                try {
                    transactions = this.storageManager.loadSequence(clientNodeID.toLong());
                }
                catch (IOException e) {
                    Assert.fail((String)e.getLocalizedMessage());
                }
                ArrayList<String> trans = new ArrayList<String>();
                if (transactions != null) {
                    for (IPlatformPersistence.SequenceTuple transaction : transactions) {
                        trans.add("Global seq Id = " + transaction.globalSequenceID + ", local seq id = " + transaction.localSequenceID);
                    }
                }
                clientMap.put(clientNodeID.toString(), trans);
            }
        }
        clientMap = new LinkedHashMap();
        map.put("regularClients", clientMap);
        for (Map.Entry<ClientID, List<ClientTransaction>> entry : this.fastSequenceCache.entrySet()) {
            ArrayList<String> trans = new ArrayList<String>();
            if (entry.getValue() == null) continue;
            clientMap.put(entry.getKey().toString(), trans);
            for (ClientTransaction transaction : entry.getValue()) {
                trans.add("Global seq Id = " + transaction.globalTransactionID + ", local seq id = " + transaction.localTransactionID);
            }
        }
        return map;
    }

    private static class ClientTransaction {
        public long clientID;
        public long localTransactionID;
        public long globalTransactionID;

        private ClientTransaction() {
        }

        public int hashCode() {
            return (int)(7L * this.clientID ^ 5L * this.localTransactionID ^ this.globalTransactionID);
        }

        public boolean equals(Object obj) {
            boolean isEqual;
            boolean bl = isEqual = obj == this;
            if (!isEqual && obj instanceof ClientTransaction) {
                ClientTransaction other = (ClientTransaction)obj;
                isEqual = this.clientID == other.clientID && this.localTransactionID == other.localTransactionID && this.globalTransactionID == other.globalTransactionID;
            }
            return isEqual;
        }

        public String toString() {
            return "{clientID=" + this.clientID + ", localTransactionID=" + this.localTransactionID + ", globalTransactionID=" + this.globalTransactionID + '}';
        }
    }
}

