/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.persistence;

import com.tc.net.ClientID;
import com.tc.net.core.ProductID;
import com.tc.objectserver.api.ClientNotFoundException;
import com.tc.objectserver.persistence.ClientStatePersistor;
import com.tc.objectserver.persistence.ClusterStatePersistor;
import com.tc.objectserver.persistence.EntityPersistor;
import com.tc.objectserver.persistence.TransactionOrderPersistor;
import com.tc.text.PrettyPrintable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.terracotta.persistence.IPlatformPersistence;

public class Persistor
implements PrettyPrintable {
    private final IPlatformPersistence persistentStorage;
    private volatile boolean started = false;
    private final ClusterStatePersistor clusterStatePersistor;
    private ClientStatePersistor clientStatePersistor;
    private final EntityPersistor entityPersistor;
    private TransactionOrderPersistor transactionOrderPersistor;

    public Persistor(IPlatformPersistence persistentStorage) {
        this.persistentStorage = persistentStorage;
        this.clusterStatePersistor = new ClusterStatePersistor(persistentStorage);
        this.entityPersistor = new EntityPersistor(persistentStorage);
    }

    public boolean start(boolean trackClients) {
        this.clientStatePersistor = new ClientStatePersistor(this.persistentStorage);
        this.transactionOrderPersistor = new TransactionOrderPersistor(this.persistentStorage, this.clientStatePersistor.loadPermanentClientIDs());
        for (ClientID orphan : this.clientStatePersistor.loadOrphanClientIDs()) {
            try {
                this.removeClientState(orphan);
            }
            catch (ClientNotFoundException clientNotFoundException) {}
        }
        if (!trackClients) {
            this.entityPersistor.clearEntityClientJournal();
        }
        boolean wasDBClean = this.clusterStatePersistor.isDBClean();
        this.started = true;
        return wasDBClean;
    }

    public void close() {
    }

    public void addClientState(ClientID node, ProductID product) {
        this.clientStatePersistor.saveClientState(node, product);
        this.entityPersistor.addTrackingForClient(node);
        this.transactionOrderPersistor.addTrackingForClient(node, product);
    }

    public void removeClientState(ClientID node) throws ClientNotFoundException {
        this.transactionOrderPersistor.removeTrackingForClient(node);
        this.entityPersistor.removeTrackingForClient(node);
        this.clientStatePersistor.deleteClientState(node);
    }

    public ClientStatePersistor getClientStatePersistor() {
        this.checkStarted();
        return this.clientStatePersistor;
    }

    public ClusterStatePersistor getClusterStatePersistor() {
        return this.clusterStatePersistor;
    }

    public EntityPersistor getEntityPersistor() {
        return this.entityPersistor;
    }

    public TransactionOrderPersistor getTransactionOrderPersistor() {
        return this.transactionOrderPersistor;
    }

    protected final void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Persistor is not yet started.");
        }
    }

    public void shutdown() {
        this.entityPersistor.close();
    }

    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> substate;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("className", this.getClass().getName());
        map.put("started", this.started);
        if (this.clusterStatePersistor != null) {
            substate = new LinkedHashMap<String, Object>();
            map.put("clusterState", substate);
            this.clusterStatePersistor.reportStateToMap(substate);
        }
        if (this.entityPersistor != null) {
            substate = new LinkedHashMap();
            map.put("entityPersistor", substate);
            this.entityPersistor.reportStateToMap(substate);
        }
        if (this.clientStatePersistor != null) {
            substate = new LinkedHashMap();
            map.put("clientPersistor", substate);
            this.clientStatePersistor.reportStateToMap(substate);
        }
        if (this.transactionOrderPersistor != null) {
            substate = new LinkedHashMap();
            map.put("orderPersistor", substate);
            this.transactionOrderPersistor.reportStateToMap(substate);
        }
        return map;
    }
}

