/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.persistence;

import com.tc.exception.ServerException;
import com.tc.net.ClientID;
import com.tc.net.utils.L2Utils;
import com.tc.object.EntityID;
import com.tc.objectserver.persistence.EntityData;
import com.tc.util.Assert;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.persistence.IPlatformPersistence;

public class EntityPersistor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityPersistor.class);
    private static final String ENTITIES_ALIVE_FILE_NAME = "entities_alive.map";
    private static final String JOURNAL_CONTAINER_FILE_NAME = "journal_container.map";
    private static final String COUNTERS_FILE_NAME = "counters.map";
    private static final String COUNTERS_CONSUMER_ID = "counters:consumerID";
    private final IPlatformPersistence storageManager;
    private final HashMap<EntityData.Key, EntityData.Value> entities;
    private final HashMap<EntityData.Key, EntityData.Value> deletes = new HashMap();
    private final HashMap<ClientID, List<EntityData.JournalEntry>> entityLifeJournal;
    private final HashMap<String, Long> counters;
    private final Map<EntityID, PermanentEntityResult> result = new ConcurrentHashMap<EntityID, PermanentEntityResult>();

    public EntityPersistor(IPlatformPersistence storageManager) {
        this.storageManager = storageManager;
        try {
            HashMap entities = (HashMap)this.storageManager.loadDataElement(ENTITIES_ALIVE_FILE_NAME);
            this.entities = null != entities ? entities : new HashMap();
            HashMap entityLifeJournal = (HashMap)this.storageManager.loadDataElement(JOURNAL_CONTAINER_FILE_NAME);
            this.entityLifeJournal = null != entityLifeJournal ? entityLifeJournal : new HashMap();
            HashMap counters = (HashMap)this.storageManager.loadDataElement(COUNTERS_FILE_NAME);
            HashMap hashMap = this.counters = null != counters ? counters : new HashMap();
            if (!this.counters.containsKey(COUNTERS_CONSUMER_ID)) {
                this.counters.put(COUNTERS_CONSUMER_ID, new Long(1L));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failure reading EntityPersistor map files", e);
        }
    }

    public synchronized void clear() {
        this.entities.clear();
        this.entityLifeJournal.clear();
        this.counters.clear();
        if (!this.counters.containsKey(COUNTERS_CONSUMER_ID)) {
            this.counters.put(COUNTERS_CONSUMER_ID, new Long(1L));
        }
        try {
            this.storageManager.storeDataElement(ENTITIES_ALIVE_FILE_NAME, null);
            this.storageManager.storeDataElement(JOURNAL_CONTAINER_FILE_NAME, null);
            this.storageManager.storeDataElement(COUNTERS_FILE_NAME, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Failure storing EntityPersistor map files", e);
        }
    }

    public synchronized void clearEntityClientJournal() {
        this.entityLifeJournal.clear();
        try {
            this.storageManager.storeDataElement(JOURNAL_CONTAINER_FILE_NAME, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Failure storing EntityPersistor map files", e);
        }
    }

    public synchronized Collection<EntityData.Value> loadEntityData() {
        return this.entities.values();
    }

    public synchronized boolean containsEntity(EntityID id) {
        LOGGER.debug("containsEntity " + id);
        EntityData.Key key = new EntityData.Key();
        key.className = id.getClassName();
        key.entityName = id.getEntityName();
        Assert.assertNotNull((Object)key.className);
        Assert.assertNotNull((Object)key.entityName);
        return this.entities.containsKey(key);
    }

    public synchronized boolean wasEntityCreatedInJournal(EntityID eid, ClientID clientID, long transactionID) throws ServerException {
        boolean didSucceed = false;
        LOGGER.debug("wasEntityCreatedInJournal " + clientID + " " + transactionID);
        EntityData.JournalEntry entry = this.getEntryForTransaction(clientID, transactionID);
        if (null != entry) {
            if (null == entry.failure) {
                didSucceed = true;
            } else {
                Exception e = entry.failure;
                if (e instanceof ServerException) {
                    throw (ServerException)((Object)e);
                }
                throw ServerException.wrapException((EntityID)eid, (Exception)e);
            }
        }
        return didSucceed;
    }

    public synchronized void entityCreateFailed(EntityID eid, ClientID clientID, long transactionID, long oldestTransactionOnClient, ServerException error) {
        LOGGER.debug("createFailed " + clientID + " " + transactionID, (Throwable)error);
        this.addToJournal(clientID, transactionID, oldestTransactionOnClient, EntityData.Operation.CREATE, null, error);
        if (clientID.isNull()) {
            this.permanentEntityCreated(eid, 0L, (Exception)((Object)error));
        }
    }

    public synchronized void entityCreated(ClientID clientID, long transactionID, long oldestTransactionOnClient, EntityID id, long version, long consumerID, boolean canDelete, byte[] configuration) {
        LOGGER.debug("entityCreated " + clientID + " " + transactionID + " " + id + " " + version);
        Assert.assertTrue((boolean)canDelete);
        Assert.assertFalse((boolean)clientID.isNull());
        this.addNewEntityToMap(id, version, consumerID, canDelete, configuration);
        this.addToJournal(clientID, transactionID, oldestTransactionOnClient, EntityData.Operation.CREATE, null, null);
    }

    public synchronized void entityCreatedNoJournal(EntityID id, long version, long consumerID, boolean canDelete, byte[] configuration) {
        LOGGER.debug("entityCreatedNoJournal " + id);
        this.addNewEntityToMap(id, version, consumerID, canDelete, configuration);
        if (!canDelete) {
            this.permanentEntityCreated(id, consumerID, null);
        }
    }

    public synchronized boolean wasEntityDestroyedInJournal(EntityID eid, ClientID clientID, long transactionID) throws ServerException {
        LOGGER.debug("wasEntityDestroyedInJournal " + clientID + " " + transactionID);
        boolean didSucceed = false;
        EntityData.JournalEntry entry = this.getEntryForTransaction(clientID, transactionID);
        if (null != entry) {
            if (null == entry.failure) {
                didSucceed = true;
            } else {
                Exception e = entry.failure;
                if (e instanceof ServerException) {
                    throw (ServerException)((Object)e);
                }
                throw ServerException.wrapException((EntityID)eid, (Exception)e);
            }
        }
        return didSucceed;
    }

    public synchronized void entityDestroyFailed(ClientID clientID, long transactionID, long oldestTransactionOnClient, ServerException error) {
        LOGGER.debug("entityDestroyFailed " + clientID + " " + transactionID);
        this.addToJournal(clientID, transactionID, oldestTransactionOnClient, EntityData.Operation.DESTROY, null, error);
    }

    public synchronized void entityDestroyed(ClientID clientID, long transactionID, long oldestTransactionOnClient, EntityID id) {
        LOGGER.debug("entityDestroyed " + clientID + " " + transactionID + " " + id);
        EntityData.Key key = new EntityData.Key();
        key.className = id.getClassName();
        key.entityName = id.getEntityName();
        Assert.assertTrue((this.entities.containsKey(key) || this.deletes.containsKey(key) ? 1 : 0) != 0);
        if (this.deletes.remove(key) == null) {
            this.entities.remove(key);
        }
        this.storeToDisk(ENTITIES_ALIVE_FILE_NAME, this.entities);
        this.addToJournal(clientID, transactionID, oldestTransactionOnClient, EntityData.Operation.DESTROY, null, null);
    }

    public synchronized byte[] reconfiguredResultInJournal(EntityID eid, ClientID clientID, long transactionID) throws ServerException {
        LOGGER.debug("reconfiguredResultInJournal " + clientID + " " + transactionID);
        byte[] cachedResult = null;
        EntityData.JournalEntry entry = this.getEntryForTransaction(clientID, transactionID);
        if (null != entry) {
            if (null == entry.failure) {
                Assert.assertNotNull((Object)entry.reconfigureResponse);
                cachedResult = entry.reconfigureResponse;
            } else {
                Exception e = entry.failure;
                if (e instanceof ServerException) {
                    throw (ServerException)((Object)e);
                }
                throw ServerException.wrapException((EntityID)eid, (Exception)e);
            }
        }
        return cachedResult;
    }

    public synchronized void entityReconfigureFailed(ClientID clientID, long transactionID, long oldestTransactionOnClient, ServerException error) {
        LOGGER.debug("entityReconfigureFailed " + clientID + " " + transactionID);
        this.addToJournal(clientID, transactionID, oldestTransactionOnClient, EntityData.Operation.RECONFIGURE, null, error);
    }

    public synchronized byte[] entityReconfigureSucceeded(ClientID clientID, long transactionID, long oldestTransactionOnClient, EntityID id, long version, byte[] configuration) {
        LOGGER.debug("entityReconfigureSucceeded " + clientID + " " + transactionID);
        String className = id.getClassName();
        String entityName = id.getEntityName();
        EntityData.Key key = new EntityData.Key();
        key.className = className;
        key.entityName = entityName;
        EntityData.Value val = this.entities.get(key);
        byte[] previousConfiguration = val.configuration;
        Assert.assertNotNull((Object)previousConfiguration);
        val.configuration = configuration;
        Assert.assertEquals((long)version, (long)val.version);
        this.entities.put(key, val);
        this.storeToDisk(ENTITIES_ALIVE_FILE_NAME, this.entities);
        this.addToJournal(clientID, transactionID, oldestTransactionOnClient, EntityData.Operation.RECONFIGURE, previousConfiguration, null);
        return previousConfiguration;
    }

    public synchronized long getNextConsumerID() {
        long consumerID = this.counters.get(COUNTERS_CONSUMER_ID);
        this.counters.put(COUNTERS_CONSUMER_ID, new Long(consumerID + 1L));
        this.storeToDisk(COUNTERS_FILE_NAME, this.counters);
        return consumerID;
    }

    public synchronized void setNextConsumerID(long consumerID) {
        long checkID = this.counters.get(COUNTERS_CONSUMER_ID);
        if (consumerID >= checkID) {
            this.counters.put(COUNTERS_CONSUMER_ID, new Long(consumerID + 1L));
            this.storeToDisk(COUNTERS_FILE_NAME, this.counters);
        }
    }

    public synchronized void addTrackingForClient(ClientID sourceNodeID) {
        if (this.entityLifeJournal.putIfAbsent(sourceNodeID, new ArrayList()) == null) {
            this.storeToDisk(JOURNAL_CONTAINER_FILE_NAME, this.entityLifeJournal);
        }
    }

    public synchronized void removeTrackingForClient(ClientID sourceNodeID) {
        this.entityLifeJournal.remove(sourceNodeID);
        this.storeToDisk(JOURNAL_CONTAINER_FILE_NAME, this.entityLifeJournal);
    }

    public void reportStateToMap(Map<String, Object> map) {
        map.put("className", this.getClass().getName());
        ArrayList<String> entityList = new ArrayList<String>();
        map.put("existingEntities", entityList);
        if (this.entities != null) {
            for (EntityData.Key key : this.entities.keySet()) {
                entityList.add(key.className + "-" + key.entityName);
            }
        }
        if (this.entityLifeJournal != null) {
            LinkedHashMap journals = new LinkedHashMap();
            map.put("journals", journals);
            for (Map.Entry<ClientID, List<EntityData.JournalEntry>> entry : this.entityLifeJournal.entrySet()) {
                ArrayList<String> items = new ArrayList<String>();
                journals.put(entry.getKey().toString(), items);
                for (EntityData.JournalEntry journalEntry : entry.getValue()) {
                    items.add(journalEntry.toString());
                }
            }
        }
        map.put("nextConsumerID", this.counters.get(COUNTERS_CONSUMER_ID));
    }

    private List<EntityData.JournalEntry> filterJournal(List<EntityData.JournalEntry> list, long oldestTransactionOnClient) {
        Assert.assertNotNull(list);
        ArrayList<EntityData.JournalEntry> newList = new ArrayList<EntityData.JournalEntry>();
        for (EntityData.JournalEntry entry : list) {
            if (entry.transactionID < oldestTransactionOnClient) continue;
            newList.add(entry);
        }
        return newList;
    }

    private void addToJournal(ClientID clientID, long transactionID, long oldestTransactionOnClient, EntityData.Operation operation, byte[] reconfigureResult, ServerException error) {
        List<EntityData.JournalEntry> rawJournal;
        if (!clientID.isNull() && (rawJournal = this.entityLifeJournal.get(clientID)) != null) {
            List<EntityData.JournalEntry> clientJournal = this.filterJournal(rawJournal, oldestTransactionOnClient);
            EntityData.JournalEntry newEntry = new EntityData.JournalEntry();
            newEntry.operation = operation;
            newEntry.transactionID = transactionID;
            newEntry.failure = error;
            newEntry.reconfigureResponse = reconfigureResult;
            clientJournal.add(newEntry);
            this.entityLifeJournal.put(clientID, clientJournal);
            this.storeToDisk(JOURNAL_CONTAINER_FILE_NAME, this.entityLifeJournal);
        }
    }

    private EntityData.JournalEntry getEntryForTransaction(ClientID clientID, long transactionID) {
        EntityData.JournalEntry foundEntry = null;
        List<EntityData.JournalEntry> clientJournal = this.entityLifeJournal.get(clientID);
        LOGGER.debug("checking " + clientID + " " + clientJournal);
        if (null != clientJournal) {
            for (EntityData.JournalEntry entry : clientJournal) {
                if (entry.transactionID != transactionID) continue;
                foundEntry = entry;
                break;
            }
        }
        return foundEntry;
    }

    private void addNewEntityToMap(EntityID id, long version, long consumerID, boolean canDelete, byte[] configuration) {
        String className = id.getClassName();
        String entityName = id.getEntityName();
        EntityData.Key key = new EntityData.Key();
        EntityData.Value value = new EntityData.Value();
        key.className = className;
        key.entityName = entityName;
        value.className = className;
        value.version = version;
        value.consumerID = consumerID;
        value.canDelete = canDelete;
        value.entityName = entityName;
        value.configuration = configuration;
        EntityData.Value previous = this.entities.put(key, value);
        if (previous != null) {
            this.deletes.put(key, value);
        }
        this.storeToDisk(ENTITIES_ALIVE_FILE_NAME, this.entities);
    }

    private void permanentEntityCreated(EntityID id, long consumerid, Exception e) {
        PermanentEntityResult perm = this.result.computeIfAbsent(id, c -> new PermanentEntityResult());
        perm.setResult(consumerid, e);
    }

    public void waitForPermanentEntityCreation(EntityID id) throws Exception {
        PermanentEntityResult perm = this.result.computeIfAbsent(id, c -> new PermanentEntityResult());
        perm.waitForResult();
    }

    public synchronized void removeOrphanedClientsFromJournal(Set<ClientID> connectedClients) {
        this.entityLifeJournal.entrySet().removeIf(e -> !connectedClients.contains(e.getKey()));
        this.storeToDisk(JOURNAL_CONTAINER_FILE_NAME, this.entityLifeJournal);
    }

    public synchronized void serialize(ObjectOutput bucket) throws IOException {
        Set<ClientID> locals = this.entityLifeJournal.keySet();
        int size = locals.size();
        bucket.writeInt(size);
        for (ClientID local : locals) {
            bucket.writeObject(local);
            bucket.writeObject(this.entityLifeJournal.get(local));
        }
        bucket.writeLong(this.counters.get(COUNTERS_CONSUMER_ID));
    }

    public synchronized void layer(ObjectInput bucket) throws IOException {
        try {
            int size = bucket.readInt();
            LOGGER.debug("log size " + size);
            for (int x = 0; x < size; ++x) {
                ClientID key = (ClientID)bucket.readObject();
                List journal = (List)bucket.readObject();
                List<EntityData.JournalEntry> check = this.entityLifeJournal.get(key);
                if (check == null) {
                    this.entityLifeJournal.put(key, journal);
                    LOGGER.debug(key + " putting " + journal);
                    continue;
                }
                int pos = 0;
                for (EntityData.JournalEntry je : journal) {
                    while (pos < check.size() && check.get((int)pos).transactionID < je.transactionID) {
                        ++pos;
                    }
                    if (pos != check.size() && check.get((int)pos).transactionID == je.transactionID) continue;
                    check.add(pos, je);
                }
                LOGGER.debug(key + " layering " + journal + " " + check);
                this.entityLifeJournal.put(key, check);
            }
        }
        catch (ClassNotFoundException cnf) {
            throw new IOException(cnf);
        }
        this.storeToDisk(JOURNAL_CONTAINER_FILE_NAME, this.entityLifeJournal);
        long nextConsumer = bucket.readLong();
        this.counters.put(COUNTERS_CONSUMER_ID, nextConsumer);
        this.storeToDisk(COUNTERS_FILE_NAME, this.counters);
    }

    private void storeToDisk(String dataName, Serializable dataElement) {
        try {
            this.storageManager.storeDataElement(dataName, dataElement);
        }
        catch (IOException e) {
            throw new RuntimeException("Failure storing EntityPersistor map file", e);
        }
    }

    public void close() {
        this.result.values().forEach(r -> ((PermanentEntityResult)r).setResult(-1L, new IOException("closed")));
    }

    private static class PermanentEntityResult {
        boolean finished;
        Exception failed;
        long consumerid;

        private PermanentEntityResult() {
        }

        private synchronized void waitForResult() throws Exception {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    L2Utils.handleInterrupted(LOGGER, ie);
                }
            }
            if (this.failed != null) {
                throw this.failed;
            }
        }

        private synchronized void setResult(long consumerid, Exception error) {
            this.finished = true;
            this.consumerid = consumerid;
            this.failed = error;
            this.notifyAll();
        }
    }
}

