/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.persistence;

import com.tc.l2.state.StateManager;
import com.tc.net.StripeID;
import com.tc.util.State;
import com.tc.util.version.Version;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.terracotta.persistence.IPlatformPersistence;

public class ClusterStatePersistor {
    private static final String MAP_FILE_NAME = "ClusterStatePersistor.map";
    private static final String DB_CLEAN_KEY = "dbclean";
    private static final String L2_STATE_KEY = "l2state";
    private static final String STRIPE_ID_KEY = "stripeid";
    private static final String VERSION_KEY = "version";
    private final IPlatformPersistence storageManager;
    private final HashMap<String, String> map;
    private State initialState;

    public ClusterStatePersistor(IPlatformPersistence storageManager) {
        this.storageManager = storageManager;
        HashMap map = null;
        try {
            map = (HashMap)this.storageManager.loadDataElement(MAP_FILE_NAME);
        }
        catch (IOException e) {
            throw new RuntimeException("Failure reading ClusterStatePersistor map file", e);
        }
        this.map = null != map ? map : new HashMap();
        this.initialState = this.getCurrentL2State();
    }

    public void setStripeID(StripeID stripeID) {
        this.putAndStore(STRIPE_ID_KEY, stripeID.getName());
    }

    public StripeID getStripeID() {
        String s = this.map.get(STRIPE_ID_KEY);
        return s == null ? StripeID.NULL_ID : new StripeID(s);
    }

    public State getInitialState() {
        return this.initialState;
    }

    public void setCurrentL2State(State state) {
        if (!StateManager.STOP_STATE.equals((Object)state)) {
            this.putAndStore(L2_STATE_KEY, state.getName());
        }
    }

    public State getCurrentL2State() {
        String s = this.map.get(L2_STATE_KEY);
        return s == null ? null : new State(s);
    }

    public boolean isDBClean() {
        String s = this.map.get(DB_CLEAN_KEY);
        return s == null || Boolean.valueOf(s) != false;
    }

    public Version getVersion() {
        String v = this.map.get(VERSION_KEY);
        return v == null ? null : new Version(v);
    }

    public void setVersion(Version v) {
        this.putAndStore(VERSION_KEY, v.major() + "." + v.minor() + "." + v.micro());
    }

    public void setDBClean(boolean dbClean) {
        this.putAndStore(DB_CLEAN_KEY, String.valueOf(dbClean));
    }

    public void clear() {
        this.map.clear();
        this.initialState = null;
    }

    void reportStateToMap(Map<String, Object> props) {
        props.put("StripeID", String.valueOf(this.getStripeID()));
        props.put("Version", String.valueOf(this.getVersion()));
        props.put("Initial State", String.valueOf(this.getInitialState()));
        props.put("Current State", String.valueOf(this.getCurrentL2State()));
        props.put("isDBClean", this.isDBClean());
    }

    private synchronized void putAndStore(String key, String value) {
        this.map.put(key, value);
        try {
            this.storageManager.storeDataElement(MAP_FILE_NAME, this.map);
        }
        catch (IOException e) {
            throw new RuntimeException("Failure storing ClusterStatePersistor map file", e);
        }
    }
}

