/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.persistence;

import com.tc.net.ClientID;
import com.tc.net.core.ProductID;
import com.tc.objectserver.api.ClientNotFoundException;
import com.tc.util.Assert;
import com.tc.util.sequence.MutableSequence;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.terracotta.persistence.IPlatformPersistence;

public class ClientStatePersistor {
    private static final String CLIENTS_MAP_FILE_NAME = "clients_map.map";
    private static final String NEXT_CLIENT_ID_FILE_NAME = "next_client_id.dat";
    private final IPlatformPersistence storageManager;
    private final ConcurrentHashMap<ClientID, Boolean> clients;
    private final MutableSequence clientIDSequence;

    public ClientStatePersistor(IPlatformPersistence storageManager) {
        this.storageManager = storageManager;
        ConcurrentHashMap clientsMap = null;
        try {
            clientsMap = (ConcurrentHashMap)this.storageManager.loadDataElement(CLIENTS_MAP_FILE_NAME);
            if (null == clientsMap) {
                clientsMap = new ConcurrentHashMap();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failure reading ClientStatePersistor data", e);
        }
        this.clients = clientsMap;
        this.clientIDSequence = new Sequence(this.storageManager);
        Assert.assertNotNull(this.clients);
    }

    public MutableSequence getConnectionIDSequence() {
        return this.clientIDSequence;
    }

    public Set<ClientID> loadOrphanClientIDs() {
        return this.clients.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(entry -> (ClientID)entry.getKey()).collect(Collectors.toSet());
    }

    public Set<ClientID> loadPermanentClientIDs() {
        return this.clients.entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> (ClientID)entry.getKey()).collect(Collectors.toSet());
    }

    public Set<ClientID> loadAllClientIDs() {
        return this.clients.entrySet().stream().map(entry -> (ClientID)entry.getKey()).collect(Collectors.toSet());
    }

    public boolean containsClient(ClientID id) {
        return this.clients.containsKey(id);
    }

    public void saveClientState(ClientID channelID, ProductID product) {
        this.clients.put(channelID, product.isPermanent());
        this.safeStoreClients();
    }

    public void deleteClientState(ClientID id) throws ClientNotFoundException {
        if (this.clients.remove(id) == null) {
            throw new ClientNotFoundException();
        }
        this.safeStoreClients();
    }

    Map<String, Object> reportStateToMap(Map<String, Object> map) {
        map.put("className", this.getClass().getName());
        ArrayList<String> cs = new ArrayList<String>();
        map.put("clients", cs);
        for (ClientID clientID : this.clients.keySet()) {
            cs.add(clientID.toString());
        }
        map.put("next", this.clientIDSequence.current());
        return map;
    }

    private void safeStoreClients() {
        try {
            this.storageManager.storeDataElement(CLIENTS_MAP_FILE_NAME, this.clients);
        }
        catch (IOException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    private static class Sequence
    implements MutableSequence {
        private final IPlatformPersistence storageManager;
        private long next;

        Sequence(IPlatformPersistence storageManager) {
            this.storageManager = storageManager;
            long nextID = 0L;
            try {
                Long nextInStorage = (Long)this.storageManager.loadDataElement(ClientStatePersistor.NEXT_CLIENT_ID_FILE_NAME);
                if (null != nextInStorage) {
                    nextID = nextInStorage;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failure reading ClientStatePersistor next client ID", e);
            }
            this.next = nextID;
        }

        public synchronized void setNext(long next) {
            if (next < this.next) {
                throw new AssertionError((Object)("next=" + next + " current=" + this.next));
            }
            this.next = next;
            this.storeNextID();
        }

        public synchronized long next() {
            long r = this.next++;
            this.storeNextID();
            return r;
        }

        public synchronized long current() {
            return this.next;
        }

        private void storeNextID() {
            try {
                this.storageManager.storeDataElement(ClientStatePersistor.NEXT_CLIENT_ID_FILE_NAME, (Serializable)Long.valueOf(this.next));
            }
            catch (IOException e) {
                throw new RuntimeException("Failure storing ClientStatePersistor next client ID", e);
            }
        }
    }
}

