/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.management.AbstractTerracottaMBean;
import com.tc.management.beans.L2MBeanNames;
import com.tc.objectserver.impl.Topology;
import com.tc.objectserver.impl.TopologyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.management.NotCompliantMBeanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.server.ServerEnv;

public class TopologyManager {
    private Topology topology;
    private volatile TopologyMbean topologyMbean;
    private final List<TopologyListener> listeners = new ArrayList<TopologyListener>();
    private final Supplier<Integer> voters;

    public TopologyManager(Set<String> servers, Supplier<Integer> voters) {
        this.topology = new Topology(servers);
        this.voters = voters;
        this.initializeMbean();
    }

    public int getExternalVoters() {
        return this.voters.get();
    }

    public boolean isAvailability() {
        return this.voters.get() < 0;
    }

    public synchronized Topology getTopology() {
        return this.topology;
    }

    private void initializeMbean() {
        if (this.topologyMbean != null) {
            return;
        }
        try {
            this.topologyMbean = new TopologyMbeanImpl(this);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized boolean addPassive(String host, int port, int group) {
        Topology old = this.topology;
        HashSet<String> newServers = new HashSet<String>(old.getServers());
        if (newServers.add(host + ":" + port)) {
            this.topology = new Topology(newServers);
            for (TopologyListener listener : this.listeners) {
                listener.nodeAdded(host, port, group);
            }
            return true;
        }
        return false;
    }

    private synchronized boolean removePassive(String host, int port, int group) {
        Topology old = this.topology;
        HashSet<String> newServers = new HashSet<String>(old.getServers());
        if (newServers.remove(host + ":" + port)) {
            this.topology = new Topology(newServers);
            for (TopologyListener listener : this.listeners) {
                listener.nodeRemoved(host, port, group);
            }
            return true;
        }
        return false;
    }

    public synchronized void addListener(TopologyListener listener) {
        this.listeners.add(listener);
    }

    private static class TopologyMbeanImpl
    extends AbstractTerracottaMBean
    implements TopologyMbean {
        private static final Logger LOGGER = LoggerFactory.getLogger(TopologyMbeanImpl.class);
        private final TopologyManager topologyManager;

        TopologyMbeanImpl(TopologyManager topologyManager) throws NotCompliantMBeanException {
            super(TopologyMbean.class, false);
            this.topologyManager = topologyManager;
            try {
                ServerEnv.getServer().getManagement().registerMBean("TopologyMBean", (Object)this);
            }
            catch (Exception e) {
                LOGGER.warn("Problem registering MBean with name " + L2MBeanNames.TOPOLOGY_MBEAN.getCanonicalName(), (Throwable)e);
            }
        }

        @Override
        public boolean addPassive(String host, int port, int group) {
            return this.topologyManager.addPassive(host, port, group);
        }

        @Override
        public boolean addPassive(String hostPortGroup) {
            String[] split = hostPortGroup.split("\\:");
            return this.topologyManager.addPassive(split[0], Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }

        @Override
        public boolean removePassive(String host, int port, int group) {
            return this.topologyManager.removePassive(host, port, group);
        }

        @Override
        public boolean removePassive(String hostPortGroup) {
            String[] split = hostPortGroup.split("\\:");
            return this.topologyManager.removePassive(split[0], Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }

        @Override
        public String getTopology() {
            return String.join((CharSequence)",", this.topologyManager.getTopology().getServers());
        }

        public void reset() {
        }
    }

    public static interface TopologyMbean {
        public boolean addPassive(String var1, int var2, int var3);

        public boolean addPassive(String var1);

        public boolean removePassive(String var1, int var2, int var3);

        public boolean removePassive(String var1);

        public String getTopology();
    }
}

