/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.async.api.ConfigurationContext;
import com.tc.async.api.StageManager;
import com.tc.config.GroupConfiguration;
import com.tc.config.ServerConfigurationManager;
import com.tc.l2.api.L2Coordinator;
import com.tc.l2.ha.L2HACoordinator;
import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.state.ConsistencyManager;
import com.tc.l2.state.StateManager;
import com.tc.net.ServerID;
import com.tc.net.core.BufferManagerFactory;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupManager;
import com.tc.net.groups.StripeIDStateManager;
import com.tc.net.groups.TCGroupManagerImpl;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.object.net.DSOChannelManager;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.core.impl.ServerConfigurationContextImpl;
import com.tc.objectserver.handshakemanager.ServerClientHandshakeManager;
import com.tc.objectserver.impl.ChannelStatsImpl;
import com.tc.objectserver.impl.DistributedObjectServer;
import com.tc.objectserver.impl.ServerBuilder;
import com.tc.objectserver.impl.TopologyManager;
import com.tc.objectserver.persistence.Persistor;
import com.tc.util.Assert;
import org.slf4j.Logger;
import org.terracotta.entity.BasicServiceConfiguration;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceException;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.persistence.IPlatformPersistence;

public class StandardServerBuilder
implements ServerBuilder {
    private final GroupConfiguration groupConfiguration;
    protected final Logger logger;

    public StandardServerBuilder(GroupConfiguration groupConfiguration, Logger logger) {
        this.logger = logger;
        this.groupConfiguration = groupConfiguration;
    }

    @Override
    public GroupManager<AbstractGroupMessage> createGroupCommManager(ServerConfigurationManager configManager, StageManager stageManager, ServerID serverNodeID, StripeIDStateManager stripeStateManager, WeightGeneratorFactory weightGeneratorFactory, BufferManagerFactory bufferManagerFactory, TopologyManager topologyManager) {
        return new TCGroupManagerImpl(configManager, stageManager, serverNodeID, this.groupConfiguration.getCurrentNode(), weightGeneratorFactory, bufferManagerFactory, topologyManager);
    }

    @Override
    public ServerConfigurationContext createServerConfigurationContext(String id, StageManager stageManager, DSOChannelManager channelManager, ChannelStatsImpl channelStats, L2Coordinator coordinator, ServerClientHandshakeManager clientHandshakeManager, ConnectionIDFactory connectionIdFactory, int maxStageSize) {
        return new ServerConfigurationContextImpl(id, stageManager, channelManager, clientHandshakeManager, channelStats, coordinator);
    }

    public void initializeContext(ConfigurationContext context) {
    }

    @Override
    public L2Coordinator createL2HACoordinator(Logger consoleLogger, DistributedObjectServer server, StateManager stateMgr, GroupManager<AbstractGroupMessage> groupCommsManager, Persistor persistor, WeightGeneratorFactory weightGeneratorFactory, StripeIDStateManager stripeStateManager, ConsistencyManager consistencyMgr) {
        return new L2HACoordinator(consoleLogger, server, stateMgr, groupCommsManager, persistor, weightGeneratorFactory, stripeStateManager, consistencyMgr);
    }

    @Override
    public Persistor createPersistor(ServiceRegistry serviceRegistry) {
        IPlatformPersistence platformPersistence = null;
        try {
            platformPersistence = (IPlatformPersistence)serviceRegistry.getService((ServiceConfiguration)new BasicServiceConfiguration(IPlatformPersistence.class));
        }
        catch (ServiceException e) {
            Assert.fail((String)"Multiple IPlatformPersistence implementations found!");
        }
        Assert.assertNotNull(platformPersistence);
        return new Persistor(platformPersistence);
    }
}

