/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.management.TerracottaManagement;
import com.tc.management.beans.L2MBeanNames;
import com.tc.util.StringUtil;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXSubsystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMXSubsystem.class);
    private final MBeanServer server;

    public JMXSubsystem(MBeanServer server) {
        this.server = server;
    }

    public MBeanServer getServer() {
        return this.server;
    }

    private ObjectName getObjectName(String id) throws MalformedObjectNameException {
        ObjectName name = null;
        switch (id) {
            case "Server": {
                name = L2MBeanNames.TC_SERVER_INFO;
                break;
            }
            case "Dumper": {
                name = L2MBeanNames.DUMPER;
                break;
            }
            case "DSO": {
                name = L2MBeanNames.DSO;
                break;
            }
            default: {
                name = new ObjectName(TerracottaManagement.MBeanDomain.PUBLIC + ":" + "name" + "=" + id);
            }
        }
        return name;
    }

    public String get(String target, String attribute) {
        try {
            return this.processReturnType(this.server.getAttribute(this.getObjectName(target), attribute));
        }
        catch (Throwable t) {
            String error = "Invalid JMX attribute:" + target + "." + attribute + " " + t.getMessage();
            this.warn(t, error, target);
            return error;
        }
    }

    public String set(String target, String attribute, String value) {
        try {
            this.server.setAttribute(this.getObjectName(target), new Attribute(attribute, value));
            return "SUCCESS";
        }
        catch (Throwable t) {
            String error = "Invalid JMX attribute:" + target + "." + attribute + " " + t.getMessage();
            this.warn(t, error, target);
            return error;
        }
    }

    public String call(String target, String cmd, String arg) {
        try {
            return this.callMBean(this.getObjectName(target), cmd, arg);
        }
        catch (Throwable t) {
            String error = "Invalid JMX call:" + cmd + " " + t.getMessage();
            this.warn(t, error, target);
            return error;
        }
    }

    public String info(String name) {
        try {
            return this.printInfo(this.getObjectName(name));
        }
        catch (Throwable t) {
            String error = "Invalid JMX object:" + name + " " + t.getMessage();
            this.warn(t, error, name);
            return error;
        }
    }

    /*
     * Exception decompiling
     */
    private String printInfo(ObjectName name) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String processReturnType(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            return StringUtil.toString((Object[])((Object[])value), (String)" ", (String)"", (String)"");
        }
        return value.toString();
    }

    private String callMBean(ObjectName name, String cmd, String arg) throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException {
        Object result = null;
        result = cmd.startsWith("get") ? this.server.getAttribute(name, cmd.substring(3)) : (cmd.startsWith("is") ? this.server.getAttribute(name, cmd.substring(2)) : (arg == null ? this.server.invoke(name, cmd, new Object[0], new String[0]) : this.server.invoke(name, cmd, new Object[]{arg}, new String[]{String.class.getName()})));
        return this.processReturnType(result);
    }

    private void warn(Throwable t, String error, String target) {
        LOGGER.warn(error, t);
        if (t instanceof InstanceNotFoundException) {
            LOGGER.warn("Please check whether {} is configured", (Object)target);
        }
    }
}

