/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.PostInit;
import com.tc.async.api.SEDA;
import com.tc.async.api.Sink;
import com.tc.async.api.Stage;
import com.tc.async.api.StageManager;
import com.tc.async.impl.OrderedSink;
import com.tc.async.impl.StageController;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.config.GroupConfiguration;
import com.tc.config.ServerConfigurationManager;
import com.tc.entity.DiagnosticMessageImpl;
import com.tc.entity.DiagnosticResponseImpl;
import com.tc.entity.LinearVoltronEntityMultiResponse;
import com.tc.entity.NetworkVoltronEntityMessageImpl;
import com.tc.entity.VoltronEntityAppliedResponseImpl;
import com.tc.entity.VoltronEntityMessage;
import com.tc.entity.VoltronEntityReceivedResponseImpl;
import com.tc.entity.VoltronEntityRetiredResponseImpl;
import com.tc.exception.TCRuntimeException;
import com.tc.exception.TCServerRestartException;
import com.tc.exception.TCShutdownServerException;
import com.tc.exception.ZapDirtyDbServerNodeException;
import com.tc.exception.ZapServerNodeException;
import com.tc.handler.CallbackGroupExceptionHandler;
import com.tc.handler.CallbackZapDirtyDbExceptionAdapter;
import com.tc.handler.CallbackZapServerNodeExceptionAdapter;
import com.tc.l2.api.L2Coordinator;
import com.tc.l2.api.ReplicatedClusterStateManager;
import com.tc.l2.context.StateChangedEvent;
import com.tc.l2.ha.BlockTimeWeightGenerator;
import com.tc.l2.ha.ChannelWeightGenerator;
import com.tc.l2.ha.ConnectionIDWeightGenerator;
import com.tc.l2.ha.ConsistencyManagerWeightGenerator;
import com.tc.l2.ha.GenerationWeightGenerator;
import com.tc.l2.ha.HASettingsChecker;
import com.tc.l2.ha.InitialStateWeightGenerator;
import com.tc.l2.ha.RandomWeightGenerator;
import com.tc.l2.ha.SequenceIDWeightGenerator;
import com.tc.l2.ha.ServerUptimeWeightGenerator;
import com.tc.l2.ha.StripeIDStateManagerImpl;
import com.tc.l2.ha.TopologyWeightGenerator;
import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.handler.GroupEvent;
import com.tc.l2.handler.GroupEventsDispatchHandler;
import com.tc.l2.handler.L2StateMessageHandler;
import com.tc.l2.handler.PlatformInfoRequestHandler;
import com.tc.l2.msg.L2StateMessage;
import com.tc.l2.msg.PlatformInfoRequest;
import com.tc.l2.msg.ReplicationMessage;
import com.tc.l2.msg.ReplicationMessageAck;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.l2.state.ConsistencyManager;
import com.tc.l2.state.ConsistencyManagerImpl;
import com.tc.l2.state.DiagnosticModeConsistencyManager;
import com.tc.l2.state.SafeStartupManagerImpl;
import com.tc.l2.state.ServerMode;
import com.tc.l2.state.StateChangeListener;
import com.tc.l2.state.StateManager;
import com.tc.l2.state.StateManagerImpl;
import com.tc.lang.TCThreadGroup;
import com.tc.logging.CallbackOnExitHandler;
import com.tc.logging.TCLogging;
import com.tc.logging.ThreadDumpHandler;
import com.tc.net.AddressChecker;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.BufferManagerFactory;
import com.tc.net.core.CachingClearTextBufferManagerFactory;
import com.tc.net.core.DefaultBufferManagerFactory;
import com.tc.net.core.ProductID;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.TCConnectionManagerImpl;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupEventsListener;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.PlainNetworkStackHarnessFactory;
import com.tc.net.protocol.tcm.ChannelManagerEventListener;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.CommunicationsManagerImpl;
import com.tc.net.protocol.tcm.HydrateContext;
import com.tc.net.protocol.tcm.HydrateHandler;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.MessageMonitorImpl;
import com.tc.net.protocol.tcm.NetworkListener;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.net.protocol.tcm.TCMessageHydrateSink;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageRouterImpl;
import com.tc.net.protocol.tcm.TCMessageSink;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.net.protocol.transport.DisabledHealthCheckerConfigImpl;
import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.net.protocol.transport.NullConnectionIDFactoryImpl;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeErrorNullHandler;
import com.tc.net.utils.L2Utils;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.object.msg.ClientHandshakeAckMessageImpl;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.msg.ClientHandshakeMessageImpl;
import com.tc.object.msg.ClientHandshakeRefusedMessageImpl;
import com.tc.object.msg.ClusterMembershipMessage;
import com.tc.object.net.DSOChannelManager;
import com.tc.object.net.DSOChannelManagerImpl;
import com.tc.object.net.DSOChannelManagerMBean;
import com.tc.objectserver.api.EntityManager;
import com.tc.objectserver.api.ServerEntityAction;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.core.impl.ManagementTopologyEventCollector;
import com.tc.objectserver.core.impl.ServerManagementContext;
import com.tc.objectserver.entity.ActiveToPassiveReplication;
import com.tc.objectserver.entity.ClientEntityStateManager;
import com.tc.objectserver.entity.ClientEntityStateManagerImpl;
import com.tc.objectserver.entity.EntityManagerImpl;
import com.tc.objectserver.entity.LocalPipelineFlushMessage;
import com.tc.objectserver.entity.ReplicationSender;
import com.tc.objectserver.entity.RequestProcessor;
import com.tc.objectserver.entity.VoltronMessageSink;
import com.tc.objectserver.handler.ClientChannelLifeCycleHandler;
import com.tc.objectserver.handler.ClientHandshakeHandler;
import com.tc.objectserver.handler.GenericHandler;
import com.tc.objectserver.handler.ProcessTransactionHandler;
import com.tc.objectserver.handler.ReplicatedTransactionHandler;
import com.tc.objectserver.handler.ReplicationReceivingAction;
import com.tc.objectserver.handler.ReplicationSendingAction;
import com.tc.objectserver.handler.ResponseMessage;
import com.tc.objectserver.handler.VoltronMessageHandler;
import com.tc.objectserver.handshakemanager.ClientHandshakePrettyPrintable;
import com.tc.objectserver.handshakemanager.ServerClientHandshakeManager;
import com.tc.objectserver.impl.ChannelStatsImpl;
import com.tc.objectserver.impl.ConnectionIDFactoryImpl;
import com.tc.objectserver.impl.DiagnosticsHandler;
import com.tc.objectserver.impl.ServerBuilder;
import com.tc.objectserver.impl.ServerPersistenceVersionChecker;
import com.tc.objectserver.impl.StandardServerBuilder;
import com.tc.objectserver.impl.ThisServerNodeId;
import com.tc.objectserver.impl.TopologyManager;
import com.tc.objectserver.persistence.ClientStatePersistor;
import com.tc.objectserver.persistence.EntityPersistor;
import com.tc.objectserver.persistence.NullPersistor;
import com.tc.objectserver.persistence.NullPlatformStorageProviderConfiguration;
import com.tc.objectserver.persistence.NullPlatformStorageServiceProvider;
import com.tc.objectserver.persistence.Persistor;
import com.tc.productinfo.ProductInfo;
import com.tc.productinfo.VersionCompatibility;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.server.TCServer;
import com.tc.services.CommunicatorService;
import com.tc.services.DelegatingServiceRegistry;
import com.tc.services.EntityMessengerProvider;
import com.tc.services.LocalMonitoringProducer;
import com.tc.services.PlatformConfigurationImpl;
import com.tc.services.PlatformServiceProvider;
import com.tc.services.SingleThreadedTimer;
import com.tc.services.TerracottaServiceProviderRegistryImpl;
import com.tc.spi.DiagnosticFormat;
import com.tc.spi.Guardian;
import com.tc.spi.NetworkTranslator;
import com.tc.spi.ProductCapabilities;
import com.tc.stats.counter.CounterManager;
import com.tc.stats.counter.CounterManagerImpl;
import com.tc.text.MapListPrettyPrint;
import com.tc.text.PrettyPrintable;
import com.tc.text.PrettyPrinter;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import com.tc.util.UUID;
import com.tc.util.concurrent.SetOnceFlag;
import com.tc.util.concurrent.ThreadUtil;
import com.tc.util.startuplock.FileNotCreatedException;
import com.tc.util.startuplock.LocationNotCreatedException;
import com.tc.util.version.CollectionVersionCompatibility;
import com.tc.util.version.DefaultVersionCompatibility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.configuration.Configuration;
import org.terracotta.configuration.FailoverBehavior;
import org.terracotta.configuration.ServerConfiguration;
import org.terracotta.entity.BasicServiceConfiguration;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceException;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.monitoring.IMonitoringProducer;
import org.terracotta.monitoring.PlatformServer;
import org.terracotta.persistence.IPlatformPersistence;
import org.terracotta.server.ServerEnv;
import org.terracotta.server.StopAction;

public class DistributedObjectServer {
    private final ConnectionPolicy connectionPolicy;
    private final TCServer server;
    private final ServerBuilder serverBuilder;
    protected final ServerConfigurationManager configSetupManager;
    private static final Logger logger = LoggerFactory.getLogger(DistributedObjectServer.class);
    private static final Logger consoleLogger = TCLogging.getConsoleLogger();
    private final TopologyManager topologyManager;
    private ServerID thisServerNodeID = ServerID.NULL_ID;
    protected NetworkListener l1Listener;
    protected NetworkListener l1Diagnostics;
    private CommunicationsManager communicationsManager;
    private ServerConfigurationContext context;
    private CounterManager sampledCounterManager;
    private ServerManagementContext managementContext;
    private Persistor persistor;
    private L2Coordinator l2Coordinator;
    private TCProperties tcProperties;
    private ConnectionIDFactoryImpl connectionIdFactory;
    private final TCThreadGroup threadGroup;
    private final SEDA seda;
    private GroupManager<AbstractGroupMessage> groupCommManager;
    private StripeIDStateManagerImpl stripeIDStateManager;
    private final SingleThreadedTimer timer;
    private final TerracottaServiceProviderRegistryImpl serviceRegistry;
    private WeightGeneratorFactory globalWeightGeneratorFactory;
    private EntityManagerImpl entityManager;
    private final SetOnceFlag stopping = new SetOnceFlag();
    private final CompletableFuture<Void> stopped = new CompletableFuture();

    public DistributedObjectServer(ServerConfigurationManager configSetupManager, TCThreadGroup threadGroup, ConnectionPolicy connectionPolicy) {
        this(configSetupManager, threadGroup, connectionPolicy, new SEDA(threadGroup), null);
    }

    public DistributedObjectServer(ServerConfigurationManager configSetupManager, TCThreadGroup threadGroup, ConnectionPolicy connectionPolicy, SEDA seda, TCServer server) {
        Assert.assertEquals((Object)threadGroup, (Object)Thread.currentThread().getThreadGroup());
        this.configSetupManager = configSetupManager;
        this.connectionPolicy = connectionPolicy;
        this.threadGroup = threadGroup;
        this.seda = seda;
        this.server = server;
        this.serverBuilder = this.createServerBuilder(configSetupManager.getGroupConfiguration(), logger, server);
        this.timer = new SingleThreadedTimer(null, (ThreadGroup)threadGroup);
        this.serviceRegistry = new TerracottaServiceProviderRegistryImpl();
        this.topologyManager = new TopologyManager(this.configSetupManager.getGroupConfiguration().getHostPorts(), () -> {
            Configuration config = this.configSetupManager.getConfiguration();
            FailoverBehavior consistent = config.getFailoverPriority();
            if (this.configSetupManager.isPartialConfiguration() || consistent == null || consistent.isAvailability()) {
                return -1;
            }
            return consistent.getExternalVoters();
        });
        DefaultBufferManagerFactory.setBufferManagerFactory((BufferManagerFactory)new CachingClearTextBufferManagerFactory());
    }

    protected final ServerBuilder createServerBuilder(GroupConfiguration groupConfiguration, Logger tcLogger, TCServer server) {
        return new StandardServerBuilder(groupConfiguration, tcLogger);
    }

    protected ServerBuilder getServerBuilder() {
        return this.serverBuilder;
    }

    public byte[] getClusterState(Charset set, PrettyPrinter pp) {
        try {
            if (pp == null) {
                pp = (PrettyPrinter)this.serviceRegistry.subRegistry(0L).getService(new BasicServiceConfiguration(PrettyPrinter.class));
            }
        }
        catch (ServiceException se) {
            logger.warn("error getting printer for cluster state", (Throwable)se);
        }
        try {
            DiagnosticFormat format;
            if (pp == null && (format = (DiagnosticFormat)this.serviceRegistry.subRegistry(0L).getService(new BasicServiceConfiguration(DiagnosticFormat.class))) != null) {
                pp = new PrettyPrinter(){

                    public PrettyPrinter println(Object o) {
                        format.print(o);
                        return this;
                    }

                    public void flush() {
                    }

                    public String toString() {
                        return format.toString();
                    }
                };
            }
        }
        catch (ServiceException se) {
            logger.warn("error getting printer for cluster state", (Throwable)se);
        }
        if (pp == null) {
            pp = new MapListPrettyPrint();
        }
        DistributedObjectServer.collectState((PrettyPrintable)this.seda.getStageManager(), pp);
        DistributedObjectServer.collectState(this.persistor, pp);
        DistributedObjectServer.collectState((PrettyPrintable)this.communicationsManager, pp);
        if (this.managementContext != null) {
            DistributedObjectServer.collectState(new ClientHandshakePrettyPrintable(this.managementContext.getChannelManager().getActiveChannels()), pp);
        }
        DistributedObjectServer.collectState(this.groupCommManager, pp);
        DistributedObjectServer.collectState(this.l2Coordinator, pp);
        DistributedObjectServer.collectState(this.entityManager, pp);
        DistributedObjectServer.collectState(this.serviceRegistry, pp);
        DistributedObjectServer.collectState(this.managementContext, pp);
        this.addExtendedConfigState(pp);
        return pp.toString().getBytes(set);
    }

    private static void collectState(PrettyPrintable prettyPrintable, PrettyPrinter prettyPrinter) {
        try {
            if (prettyPrintable != null) {
                prettyPrintable.prettyPrint(prettyPrinter);
            }
        }
        catch (Throwable t) {
            prettyPrinter.println((Object)("unable to collect cluster state for " + prettyPrintable + " : " + t.getLocalizedMessage()));
            StringWriter w = new StringWriter();
            PrintWriter p = new PrintWriter(w);
            t.printStackTrace(p);
            p.close();
            prettyPrinter.println((Object)w.toString());
        }
    }

    public void dumpOnExit() {
        String clusterState = new String(this.getClusterState(Charset.defaultCharset(), null), Charset.defaultCharset());
        TCLogging.getDumpLogger().info(clusterState);
    }

    private void addExtendedConfigState(PrettyPrinter prettyPrinter) {
        try {
            HashMap state = new HashMap();
            state.put("ExtendedConfigs", this.configSetupManager.getStateMap());
            prettyPrinter.println(state);
        }
        catch (Throwable t) {
            prettyPrinter.println((Object)("unable to collect cluster state for ExtendedConfigs : " + t.getLocalizedMessage()));
            StringWriter w = new StringWriter();
            PrintWriter p = new PrintWriter(w);
            t.printStackTrace(p);
            p.close();
            prettyPrinter.println((Object)w.toString());
        }
    }

    public synchronized void start() throws IOException, LocationNotCreatedException, FileNotCreatedException {
        boolean USE_DIRECT;
        String msg;
        this.threadGroup.addCallbackOnExitDefaultHandler((CallbackOnExitHandler)new ThreadDumpHandler());
        this.threadGroup.addCallbackOnExitDefaultHandler(state -> this.dumpOnExit());
        this.threadGroup.addCallbackOnExitExceptionHandler(TCServerRestartException.class, state -> {
            consoleLogger.error("Restarting server: " + state.getThrowable().getMessage());
            state.setRestartNeeded();
        });
        this.threadGroup.addCallbackOnExitExceptionHandler(TCShutdownServerException.class, state -> {
            Throwable t = state.getThrowable();
            if (t.getCause() != null) {
                consoleLogger.error("Server exiting: " + t.getMessage(), t.getCause());
            } else {
                consoleLogger.error("Server exiting: " + t.getMessage());
            }
        });
        this.thisServerNodeID = this.makeServerNodeID(this.configSetupManager.getServerConfiguration());
        ThisServerNodeId.setThisServerNodeId(this.thisServerNodeID);
        ArrayList<PostInit> toInit = new ArrayList<PostInit>();
        ServerConfiguration l2DSOConfig = this.configSetupManager.getServerConfiguration();
        String host = l2DSOConfig.getHost();
        InetAddress ip = AddressChecker.getByName((String)host, (int)3);
        NetworkInterface hostInterface = NetworkInterface.getByInetAddress(ip);
        if (!ip.isLoopbackAddress() && hostInterface == null) {
            String msg2 = "Unable to find local network interface for " + host;
            consoleLogger.error(msg2);
            logger.error(msg2, (Throwable)new TCRuntimeException(msg2));
            ServerEnv.getServer().stop(new StopAction[0]);
        }
        String bindAddress = this.configSetupManager.getServerConfiguration().getTsaPort().getHostString();
        InetAddress tsaBind = AddressChecker.getByName((String)host, (int)3);
        NetworkInterface tsaInterface = NetworkInterface.getByInetAddress(tsaBind);
        if (!tsaBind.isAnyLocalAddress() && !ip.isLoopbackAddress() && tsaInterface == null) {
            msg = "Unable to find local network interface for tsa bind " + bindAddress;
            consoleLogger.error(msg);
            logger.error(msg, (Throwable)new TCRuntimeException(msg));
            ServerEnv.getServer().stop(new StopAction[0]);
        }
        if (tsaInterface != null && !tsaInterface.equals(hostInterface)) {
            msg = "tsa bind interface is not accessible via the hostname of the server";
            consoleLogger.error("tsa bind interface is not accessible via the hostname of the server");
            logger.error("tsa bind interface is not accessible via the hostname of the server", (Throwable)new TCRuntimeException("tsa bind interface is not accessible via the hostname of the server"));
            ServerEnv.getServer().stop(new StopAction[0]);
        }
        this.tcProperties = TCPropertiesImpl.getProperties();
        TCByteBufferFactory.setFixedBufferSize((int)this.tcProperties.getInt("bytebuffer.direct.size", 4096));
        int maxStageSize = this.tcProperties.getInt("l2.seda.stage.sink.capacity");
        int fastStageSize = 1024;
        StageManager stageManager = this.seda.getStageManager();
        this.sampledCounterManager = new CounterManagerImpl();
        Configuration configuration = this.configSetupManager.getConfiguration();
        PlatformConfigurationImpl platformConfiguration = new PlatformConfigurationImpl(this.configSetupManager.getServerConfiguration(), configuration);
        this.serviceRegistry.initialize(platformConfiguration, configuration);
        this.serviceRegistry.registerImplementationProvided(new PlatformServiceProvider(this.server));
        EntityMessengerProvider messengerProvider = new EntityMessengerProvider();
        this.serviceRegistry.registerImplementationProvided(messengerProvider);
        if (!this.serviceRegistry.hasUserProvidedServiceProvider(IPlatformPersistence.class)) {
            NullPlatformStorageServiceProvider nullPlatformStorageServiceProvider = new NullPlatformStorageServiceProvider();
            nullPlatformStorageServiceProvider.initialize(new NullPlatformStorageProviderConfiguration(), platformConfiguration);
            this.serviceRegistry.registerExternal(nullPlatformStorageServiceProvider);
        }
        int serverPort = l2DSOConfig.getTsaPort().getPort();
        ProductInfo pInfo = this.server.productInfo();
        PlatformServer thisServer = new PlatformServer(this.server.getL2Identifier(), host, ip.getHostAddress(), bindAddress, serverPort, l2DSOConfig.getGroupPort().getPort(), pInfo.buildVersion(), pInfo.buildID(), ServerEnv.getServer().getStartTime());
        LocalMonitoringProducer monitoringShimService = new LocalMonitoringProducer(this.configSetupManager.getServiceLocator().getServiceLoader(), this.serviceRegistry, thisServer, this.timer);
        this.serviceRegistry.registerImplementationProvided(monitoringShimService);
        long platformConsumerID = 0L;
        DelegatingServiceRegistry platformServiceRegistry = this.serviceRegistry.subRegistry(platformConsumerID);
        Set<Object> capablities = EnumSet.allOf(ProductID.class);
        if (this.serviceRegistry.hasUserProvidedServiceProvider(ProductCapabilities.class)) {
            try {
                capablities = ((ProductCapabilities)platformServiceRegistry.getService((ServiceConfiguration)new BasicServiceConfiguration(ProductCapabilities.class))).supportedClients();
            }
            catch (ServiceException s) {
                logger.warn("multiple service providers for " + ProductCapabilities.class.getName());
            }
        }
        if (configuration.isPartialConfiguration()) {
            this.persistor = new NullPersistor();
        } else {
            this.persistor = this.serverBuilder.createPersistor(platformServiceRegistry);
            boolean wasZapped = false;
            while (!this.persistor.start(capablities.contains(ProductID.PERMANENT))) {
                wasZapped = true;
                this.persistor.close();
                logger.warn("DB state not clean!  Clearing all ServiceProvider state (ZAP request)");
                this.serviceRegistry.clearServiceProvidersState();
                this.persistor = this.serverBuilder.createPersistor(platformServiceRegistry);
            }
            this.persistor.getClusterStatePersistor().setDBClean(!wasZapped);
        }
        new ServerPersistenceVersionChecker(pInfo).checkAndBumpPersistedVersion(this.persistor.getClusterStatePersistor());
        this.threadGroup.addCallbackOnExitExceptionHandler(ZapDirtyDbServerNodeException.class, (CallbackOnExitHandler)new CallbackZapDirtyDbExceptionAdapter(logger, consoleLogger, this.persistor.getClusterStatePersistor()));
        this.threadGroup.addCallbackOnExitExceptionHandler(ZapServerNodeException.class, (CallbackOnExitHandler)new CallbackZapServerNodeExceptionAdapter(logger, consoleLogger, this.persistor.getClusterStatePersistor()));
        int commWorkerThreadCount = L2Utils.getOptimalCommWorkerThreads();
        PlainNetworkStackHarnessFactory networkStackHarnessFactory = new PlainNetworkStackHarnessFactory();
        MessageMonitor mm = MessageMonitorImpl.createMonitor((TCProperties)this.tcProperties, (Logger)logger);
        TCMessageRouterImpl messageRouter = new TCMessageRouterImpl();
        BufferManagerFactory bufferManagerFactory = this.getBufferManagerFactory(platformServiceRegistry);
        TCConnectionManagerImpl connectionManager = new TCConnectionManagerImpl(this.configSetupManager.getServerConfiguration().getName() + " - " + "L2_L1", commWorkerThreadCount, bufferManagerFactory);
        this.communicationsManager = new CommunicationsManagerImpl(mm, (TCMessageRouter)messageRouter, (NetworkStackHarnessFactory)networkStackHarnessFactory, (TCConnectionManager)connectionManager, this.connectionPolicy, (HealthCheckerConfig)new DisabledHealthCheckerConfigImpl(), this.thisServerNodeID, (TransportHandshakeErrorHandler)new TransportHandshakeErrorNullHandler(), this.getMessageTypeClassMappings(), Collections.emptyMap(), bufferManagerFactory);
        NullConnectionIDFactoryImpl infoConnections = new NullConnectionIDFactoryImpl();
        ClientStatePersistor clientStateStore = this.persistor.getClientStatePersistor();
        this.connectionIdFactory = new ConnectionIDFactoryImpl((ConnectionIDFactory)infoConnections, clientStateStore, capablities);
        int voteCount = ConsistencyManager.parseVoteCount(configuration.getFailoverPriority(), configuration.getServerConfigurations().size());
        int knownPeers = this.configSetupManager.allCurrentlyKnownServers().length - 1;
        if (voteCount >= 0 && (voteCount + knownPeers + 1) % 2 == 0) {
            consoleLogger.warn("It is recommended to keep the total number of servers and external voters to be an odd number");
        }
        if (knownPeers % 2 == 0 && voteCount > 0) {
            consoleLogger.warn("It is not recommended to configure external voters when there is an odd number of servers in the stripe");
        }
        ConsistencyManager consistencyMgr = this.createConsistencyManager(this.configSetupManager, knownPeers, voteCount);
        InetSocketAddress dsoBind = new InetSocketAddress(l2DSOConfig.getTsaPort().getHostString(), l2DSOConfig.getTsaPort().getPort());
        this.l1Listener = this.communicationsManager.createListener(dsoBind, c -> !c.getProductID().isReconnectEnabled() || !this.server.isReconnectWindow(), (ConnectionIDFactory)this.connectionIdFactory, t -> this.getContext().getClientHandshakeManager().isStarting() || t.getConnectionID().getProductId() == ProductID.DIAGNOSTIC || consistencyMgr.requestTransition(this.context.getL2Coordinator().getStateManager().getCurrentMode(), (NodeID)t.getConnectionID().getClientID(), ConsistencyManager.Transition.ADD_CLIENT));
        this.l1Diagnostics = this.createDiagnosticsListener(dsoBind, (ConnectionIDFactory)infoConnections);
        this.stripeIDStateManager = new StripeIDStateManagerImpl(this.persistor.getClusterStatePersistor());
        DSOChannelManagerImpl channelManager = new DSOChannelManagerImpl(this.l1Listener.getChannelManager(), pInfo.version());
        channelManager.addEventListener((ChannelManagerEventListener)this.connectionIdFactory);
        boolean availableMode = voteCount < 0;
        WeightGeneratorFactory weightGeneratorFactory = new WeightGeneratorFactory();
        ConsistencyManagerWeightGenerator consistency = new ConsistencyManagerWeightGenerator(() -> this.l2Coordinator.getStateManager(), availableMode);
        weightGeneratorFactory.add(consistency);
        BlockTimeWeightGenerator blocking = new BlockTimeWeightGenerator();
        weightGeneratorFactory.add(blocking);
        ChannelWeightGenerator connectedClientCountWeightGenerator = new ChannelWeightGenerator(() -> this.l2Coordinator.getStateManager(), (DSOChannelManager)channelManager, availableMode);
        weightGeneratorFactory.add(connectedClientCountWeightGenerator);
        ConnectionIDWeightGenerator connectionsMade = new ConnectionIDWeightGenerator(this.connectionIdFactory);
        weightGeneratorFactory.add(connectionsMade);
        InitialStateWeightGenerator initialState = new InitialStateWeightGenerator(this.persistor.getClusterStatePersistor());
        weightGeneratorFactory.add(initialState);
        TopologyWeightGenerator topoWeight = new TopologyWeightGenerator(this.configSetupManager.getConfiguration());
        weightGeneratorFactory.add(topoWeight);
        SequenceIDWeightGenerator sequenceWeight = new SequenceIDWeightGenerator();
        weightGeneratorFactory.add(sequenceWeight);
        ServerUptimeWeightGenerator serverUptimeWeightGenerator = new ServerUptimeWeightGenerator(availableMode);
        weightGeneratorFactory.add(serverUptimeWeightGenerator);
        RandomWeightGenerator randomWeightGenerator = new RandomWeightGenerator(new SecureRandom(), availableMode);
        weightGeneratorFactory.add(randomWeightGenerator);
        GenerationWeightGenerator generationWeightGenerator = new GenerationWeightGenerator(consistencyMgr);
        weightGeneratorFactory.add(generationWeightGenerator);
        this.globalWeightGeneratorFactory = weightGeneratorFactory.complete();
        ChannelStatsImpl channelStats = new ChannelStatsImpl(this.sampledCounterManager, (DSOChannelManager)channelManager);
        channelManager.addEventListener((ChannelManagerEventListener)channelStats);
        IMonitoringProducer serviceInterface = null;
        try {
            serviceInterface = (IMonitoringProducer)platformServiceRegistry.getService((ServiceConfiguration)new BasicServiceConfiguration(IMonitoringProducer.class));
        }
        catch (ServiceException multi) {
            Assert.fail((String)"Multiple IMonitoringProducer implementations found!");
        }
        boolean bl = USE_DIRECT = !this.tcProperties.getBoolean("l2.seda.stage.sink.disable.direct", false);
        if (!USE_DIRECT) {
            logger.info("disabling the use for direct sinks");
        }
        RequestProcessor processor = new RequestProcessor(stageManager, maxStageSize, USE_DIRECT);
        ManagementTopologyEventCollector eventCollector = new ManagementTopologyEventCollector(serviceInterface);
        ClientEntityStateManagerImpl clientEntityStateManager = new ClientEntityStateManagerImpl();
        this.entityManager = new EntityManagerImpl(this.serviceRegistry, clientEntityStateManager, eventCollector, processor, this::flushLocalPipeline, this.configSetupManager.getServiceLocator());
        ProcessTransactionHandler processTransactionHandler = new ProcessTransactionHandler(this.persistor, (DSOChannelManager)channelManager, this.entityManager);
        stageManager.createStage("voltron_message_stage", VoltronEntityMessage.class, processTransactionHandler.getVoltronMessageHandler(), 1, 1024, USE_DIRECT, true).setSpinningCount(1000);
        stageManager.createStage("respond_to_request_stage", ResponseMessage.class, processTransactionHandler.getMultiResponseSender(), L2Utils.getOptimalCommWorkerThreads(), maxStageSize, false, true);
        CommunicatorService communicatorService = new CommunicatorService(processTransactionHandler.getClientMessageSender());
        channelManager.addEventListener((ChannelManagerEventListener)communicatorService);
        communicatorService.initialized();
        this.serviceRegistry.registerImplementationProvided(communicatorService);
        VoltronMessageHandler voltron = new VoltronMessageHandler((DSOChannelManager)channelManager, USE_DIRECT);
        Stage fast = stageManager.createStage("single_threaded_fastpath", VoltronEntityMessage.class, (EventHandler)voltron, 1, maxStageSize);
        messengerProvider.setMessageSink((Sink<VoltronEntityMessage>)fast.getSink());
        this.entityManager.setMessageSink((Sink<VoltronEntityMessage>)fast.getSink());
        this.groupCommManager = this.serverBuilder.createGroupCommManager(this.configSetupManager, stageManager, this.thisServerNodeID, this.stripeIDStateManager, this.globalWeightGeneratorFactory, bufferManagerFactory, this.topologyManager);
        if (consistencyMgr instanceof GroupEventsListener) {
            this.groupCommManager.registerForGroupEvents((GroupEventsListener)((Object)consistencyMgr));
        }
        Stage clientHandshake = stageManager.createStage("client_handshake_stage", ClientHandshakeMessage.class, (EventHandler)this.createHandShakeHandler(this.entityManager, processTransactionHandler, this.getVersionCompatibility()), 1, maxStageSize);
        Stage hydrator = stageManager.createStage("hydrate_message_stage", HydrateContext.class, (EventHandler)new HydrateHandler(), L2Utils.getOptimalCommWorkerThreads(), maxStageSize);
        Stage diagStage = stageManager.createStage("monitor_stage", TCAction.class, (EventHandler)new DiagnosticsHandler(this, this.server.getJMX()), 1, 1);
        VoltronMessageSink voltronSink = new VoltronMessageSink((Stage<HydrateContext>)hydrator, (Sink<VoltronEntityMessage>)fast.getSink(), this.entityManager);
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_MESSAGE, (TCMessageSink)new TCMessageHydrateSink(clientHandshake.getSink()));
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_MESSAGE, (TCMessageSink)voltronSink);
        messageRouter.routeMessageType(TCMessageType.DIAGNOSTIC_REQUEST, m -> diagStage.getSink().addToSink((Object)m));
        HASettingsChecker haChecker = new HASettingsChecker(this.configSetupManager, this.tcProperties);
        haChecker.validateHealthCheckSettingsForHighAvailability();
        final StateManagerImpl state2 = new StateManagerImpl(consoleLogger, this.groupCommManager, this.createStageController(processTransactionHandler), eventCollector, stageManager, this.configSetupManager.getGroupConfiguration().getMembers().length, this.configSetupManager.getGroupConfiguration().getElectionTimeInSecs(), this.globalWeightGeneratorFactory, consistencyMgr, this.persistor.getClusterStatePersistor(), this.topologyManager);
        Stage replicationResponseStage = stageManager.createStage("passive_outgoing_response_stage", Runnable.class, new GenericHandler(), 1, maxStageSize);
        ReplicatedTransactionHandler replicatedTransactionHandler = new ReplicatedTransactionHandler(state2, (Stage<Runnable>)replicationResponseStage, this.persistor, this.entityManager, this.groupCommManager);
        sequenceWeight.setReplicatedTransactionHandler(replicatedTransactionHandler);
        Stage replicationStage = stageManager.createStage("passive_replication_stage", ReplicationMessage.class, replicatedTransactionHandler.getEventHandler(), 1, maxStageSize);
        ClientChannelLifeCycleHandler channelLifeCycleHandler = new ClientChannelLifeCycleHandler(this.communicationsManager, stageManager, (DSOChannelManager)channelManager, clientEntityStateManager, processTransactionHandler, eventCollector);
        channelManager.addEventListener((ChannelManagerEventListener)channelLifeCycleHandler);
        this.l1Diagnostics.getChannelManager().addEventListener((ChannelManagerEventListener)channelLifeCycleHandler);
        this.l2Coordinator = this.serverBuilder.createL2HACoordinator(consoleLogger, this, state2, this.groupCommManager, this.persistor, this.globalWeightGeneratorFactory, this.stripeIDStateManager, consistencyMgr);
        this.connectServerStateToReplicatedState(monitoringShimService, state2, clientEntityStateManager, this.l2Coordinator.getReplicatedClusterStateManager());
        Sink replicationSenderStage = stageManager.createStage("active_to_passive_driver_stage", ReplicationSendingAction.class, new GenericHandler(), Math.max(3, knownPeers), maxStageSize).getSink();
        ReplicationSender replicationSender = new ReplicationSender((Sink<ReplicationSendingAction>)replicationSenderStage, this.groupCommManager);
        Sink replicationReceivingStage = stageManager.createStage("passive_to_active_driver_stage", ReplicationReceivingAction.class, new GenericHandler(), Math.max(3, knownPeers), maxStageSize).getSink();
        final ActiveToPassiveReplication passives = new ActiveToPassiveReplication(consistencyMgr, processTransactionHandler, this.persistor.getEntityPersistor(), replicationSender, (Sink<ReplicationReceivingAction>)replicationReceivingStage, this.getGroupManager());
        processor.setReplication(passives);
        Stage replicationStageAck = stageManager.createStage("passive_replication_ack_stage", ReplicationMessageAck.class, (EventHandler)new AbstractEventHandler<ReplicationMessageAck>(){

            protected void initialize(ConfigurationContext context) {
                super.initialize(context);
                passives.enterActiveState(state2.getPassiveStandbys());
            }

            public void handleEvent(ReplicationMessageAck context) throws EventHandlerException {
                switch (context.getType()) {
                    case 5: {
                        passives.batchAckReceived(context);
                        break;
                    }
                    case 4: {
                        try {
                            DistributedObjectServer.this.l2Coordinator.getReplicatedClusterStateManager().publishClusterState((NodeID)context.messageFrom());
                        }
                        catch (GroupException ge) {
                            logger.warn("error syncing state", (Throwable)ge);
                        }
                        passives.startPassiveSync(context.messageFrom());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("bad message " + context));
                    }
                }
            }
        }, 1, maxStageSize);
        Sink stateMessageSink = stageManager.createStage("l2_state_message_handler_stage", L2StateMessage.class, (EventHandler)new L2StateMessageHandler(), 1, maxStageSize).getSink();
        this.groupCommManager.routeMessages(L2StateMessage.class, stateMessageSink);
        GroupEventsDispatchHandler dispatchHandler = new GroupEventsDispatchHandler();
        dispatchHandler.addListener(this.l2Coordinator);
        dispatchHandler.addListener(passives);
        Stage groupEvents = stageManager.createStage("group_events_dispatch_stage", GroupEvent.class, (EventHandler)dispatchHandler, 1, maxStageSize);
        this.groupCommManager.registerForGroupEvents(dispatchHandler.createDispatcher((Sink<GroupEvent>)groupEvents.getSink()));
        OrderedSink replication = new OrderedSink(logger, replicationStage.getSink());
        this.groupCommManager.routeMessages(ReplicationMessage.class, replication);
        this.groupCommManager.routeMessages(ReplicationMessageAck.class, replicationStageAck.getSink());
        Sink<PlatformInfoRequest> info = this.createPlatformInformationStages(stageManager, maxStageSize, monitoringShimService);
        dispatchHandler.addListener(this.connectPassiveEvents(info, monitoringShimService));
        ServerClientHandshakeManager clientHandshakeManager = new ServerClientHandshakeManager(LoggerFactory.getLogger(ServerClientHandshakeManager.class), consistencyMgr, (DSOChannelManager)channelManager, new Timer("Reconnect timer", true), () -> (long)l2DSOConfig.getClientReconnectWindow() * 1000L, (Sink<VoltronEntityMessage>)fast.getSink(), pInfo, consoleLogger);
        this.context = this.serverBuilder.createServerConfigurationContext(this.configSetupManager.getServerConfiguration().getName(), stageManager, (DSOChannelManager)channelManager, channelStats, this.l2Coordinator, clientHandshakeManager, this.connectionIdFactory, maxStageSize);
        this.context.addShutdownItem(passives::close);
        toInit.add(this.serverBuilder);
        this.timer.start();
        this.startStages(stageManager, toInit);
        this.managementContext = new ServerManagementContext((DSOChannelManagerMBean)channelManager, (TCConnectionManager)connectionManager, channelStats, this.connectionPolicy, this.getOperationGuardian(platformServiceRegistry, channelLifeCycleHandler), voltron, voltronSink);
        CallbackGroupExceptionHandler handler = new CallbackGroupExceptionHandler(logger, consoleLogger);
        this.threadGroup.addCallbackOnExitExceptionHandler(GroupException.class, (CallbackOnExitHandler)handler);
        if (!configuration.isPartialConfiguration()) {
            this.startGroupManagers();
            this.l2Coordinator.start();
        } else {
            this.l2Coordinator.getStateManager().moveToDiagnosticMode();
            TCLogging.getConsoleLogger().info("Started the server in diagnostic mode");
        }
    }

    public CompletableFuture<Void> destroy(boolean immediate) throws Exception {
        CompletableFuture<Void> finished = new CompletableFuture<Void>();
        if (this.threadGroup.isStoppable()) {
            if (this.stopping.attemptSet()) {
                ThreadUtil.executeInThread((ThreadGroup)this.threadGroup.getParent(), () -> {
                    try {
                        if (!immediate) {
                            try {
                                this.stopped.get(60L, TimeUnit.SECONDS);
                            }
                            catch (TimeoutException to) {
                                logger.warn("Timeout waiting for clean shutdown.");
                            }
                            catch (ExecutionException ee) {
                                logger.warn("stop not complete", ee.getCause());
                            }
                        }
                        this.killThreads(finished, immediate);
                    }
                    catch (InterruptedException ie) {
                        logger.warn("shutdown thread failed", (Throwable)ie);
                        finished.completeExceptionally(ie);
                    }
                }, (String)"server shutdown thread", (boolean)true);
            }
        } else {
            consoleLogger.info("Server Exiting...");
            finished.complete(null);
        }
        return finished;
    }

    private void shutdown() {
        try {
            this.l2Coordinator.shutdown();
            this.groupCommManager.shutdown();
            this.communicationsManager.shutdown();
            this.communicationsManager.getConnectionManager().closeAllConnections(6000L);
            this.persistor.shutdown();
            this.context.shutdown();
            this.entityManager.shutdown();
            this.serviceRegistry.shutdown();
            this.timer.cancelAll();
            this.timer.stop();
            this.configSetupManager.close();
            this.stopped.complete(null);
        }
        catch (InterruptedException in) {
            this.stopped.completeExceptionally(in);
        }
    }

    private void killThreads(CompletableFuture<Void> stopped, boolean immediate) {
        try {
            this.seda.getStageManager().stopAll();
            if (immediate) {
                this.threadGroup.interrupt();
            } else if (!this.threadGroup.retire(TimeUnit.SECONDS.toMillis(30L), e -> L2Utils.handleInterrupted(logger, e))) {
                consoleLogger.warn("unable to retire server threads");
                this.threadGroup.printLiveThreads(arg_0 -> ((Logger)logger).warn(arg_0));
                this.threadGroup.interrupt();
            }
            consoleLogger.info("Server Exiting...");
        }
        finally {
            stopped.complete(null);
        }
    }

    private ConsistencyManager createConsistencyManager(ServerConfigurationManager configSetupManager, int knownPeers, int voteCount) {
        if (configSetupManager.isPartialConfiguration()) {
            if (knownPeers != 0) {
                throw new RuntimeException("Diagnostic mode is not supported with multi-server stripe");
            }
            return new DiagnosticModeConsistencyManager();
        }
        boolean consistentStartup = knownPeers > 0 && (configSetupManager.getConfiguration().isConsistentStartup() || voteCount >= 0);
        return new SafeStartupManagerImpl(consistentStartup, knownPeers, new ConsistencyManagerImpl(this.topologyManager));
    }

    private Guardian getOperationGuardian(ServiceRegistry platformRegistry, ClientChannelLifeCycleHandler handler) {
        Collection userProvided = platformRegistry.getServices(() -> Guardian.class);
        return (o, p) -> {
            try {
                return userProvided.stream().map(g -> g.validate(o, p)).reduce(Boolean.TRUE, Boolean::logicalAnd);
            }
            catch (Throwable t) {
                logger.warn("guardian failed", t);
                return true;
            }
        };
    }

    private BufferManagerFactory getBufferManagerFactory(ServiceRegistry platformRegistry) {
        BufferManagerFactory bufferManagerFactory = null;
        try {
            bufferManagerFactory = (BufferManagerFactory)platformRegistry.getService((ServiceConfiguration)new BasicServiceConfiguration(BufferManagerFactory.class));
        }
        catch (ServiceException e) {
            Assert.fail((String)"Multiple BufferManagerFactory implementations found!");
        }
        if (bufferManagerFactory == null) {
            bufferManagerFactory = DefaultBufferManagerFactory.getBufferManagerFactory();
        }
        return bufferManagerFactory;
    }

    private NetworkListener createDiagnosticsListener(InetSocketAddress address, ConnectionIDFactory idFactoryForInfoConnections) throws UnknownHostException {
        boolean enabled = this.tcProperties.getBoolean("l2.l1redirect.enabled", true);
        NetworkTranslator translator = null;
        try {
            translator = (NetworkTranslator)this.serviceRegistry.subRegistry(0L).getService(new BasicServiceConfiguration(NetworkTranslator.class));
        }
        catch (ServiceException se) {
            logger.warn("error getting printer for cluster state", (Throwable)se);
        }
        NetworkTranslator finalTranslator = translator == null ? (src, redirect) -> redirect : translator;
        return this.communicationsManager.createListener(address, true, idFactoryForInfoConnections, srcOfRequest -> {
            ServerID server1;
            StateManager stateMgr = this.l2Coordinator.getStateManager();
            ServerID serverID = server1 = !stateMgr.isActiveCoordinator() ? (ServerID)stateMgr.getActiveNodeID() : ServerID.NULL_ID;
            if (enabled && !server1.isNull()) {
                return finalTranslator.redirectTo(srcOfRequest, server1.getName());
            }
            return null;
        });
    }

    private Sink<PlatformInfoRequest> createPlatformInformationStages(StageManager stageManager, int maxStageSize, LocalMonitoringProducer monitoringSupport) {
        Stage stage = stageManager.createStage("platform_information_request", PlatformInfoRequest.class, new PlatformInfoRequestHandler(this.groupCommManager, monitoringSupport).getEventHandler(), 1, maxStageSize);
        this.groupCommManager.routeMessages(PlatformInfoRequest.class, stage.getSink());
        return stage.getSink();
    }

    private void startStages(StageManager stageManager, List<PostInit> toInit) {
        stageManager.startAll((ConfigurationContext)this.context, toInit, new String[]{"single_threaded_fastpath", "request_processor_during_sync_stage", "hydrate_message_stage", "voltron_message_stage", "respond_to_request_stage", "active_to_passive_driver_stage", "passive_to_active_driver_stage", "passive_replication_stage", "passive_outgoing_response_stage", "passive_replication_ack_stage"});
    }

    private void flushLocalPipeline(EntityID eid, FetchID fetch, ServerEntityAction action) {
        boolean forDestroy;
        switch (action) {
            case CREATE_ENTITY: 
            case DESTROY_ENTITY: 
            case FETCH_ENTITY: 
            case RECONFIGURE_ENTITY: 
            case RELEASE_ENTITY: {
                logger.info("completed lifecycle " + (Object)((Object)action) + " on " + eid + ":" + fetch);
                break;
            }
            case FAILOVER_FLUSH: {
                return;
            }
            default: {
                logger.debug("completed mgmt " + (Object)((Object)action) + " on " + eid);
            }
        }
        boolean bl = forDestroy = action == ServerEntityAction.DESTROY_ENTITY;
        if (!this.l2Coordinator.getStateManager().isActiveCoordinator()) {
            try {
                this.seda.getStageManager().getStage("passive_replication_stage", ReplicationMessage.class).getSink().addToSink((Object)ReplicationMessage.createLocalContainer((SyncReplicationActivity)SyncReplicationActivity.createFlushLocalPipelineMessage((FetchID)fetch, (SyncReplicationActivity.ActivityType)(action.isReplicated() ? action.replicationType() : SyncReplicationActivity.ActivityType.FLUSH_LOCAL_PIPELINE))));
                return;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.seda.getStageManager().getStage("single_threaded_fastpath", VoltronEntityMessage.class).getSink().addToSink((Object)new LocalPipelineFlushMessage(EntityDescriptor.createDescriptorForInvoke((FetchID)fetch, (ClientInstanceID)ClientInstanceID.NULL_ID), forDestroy));
    }

    private StageController createStageController(ProcessTransactionHandler pth) {
        StageController control = new StageController(this::getContext);
        control.addStageToState(ServerMode.UNINITIALIZED.getState(), "passive_replication_stage");
        control.addStageToState(ServerMode.UNINITIALIZED.getState(), "passive_outgoing_response_stage");
        control.addStageToState(ServerMode.SYNCING.getState(), "passive_replication_stage");
        control.addStageToState(ServerMode.SYNCING.getState(), "passive_outgoing_response_stage");
        control.addStageToState(ServerMode.PASSIVE.getState(), "passive_replication_stage");
        control.addStageToState(ServerMode.PASSIVE.getState(), "passive_outgoing_response_stage");
        control.addStageToState(ServerMode.ACTIVE.getState(), "single_threaded_fastpath");
        control.addStageToState(ServerMode.ACTIVE.getState(), "request_processor_during_sync_stage");
        control.addStageToState(ServerMode.ACTIVE.getState(), "hydrate_message_stage");
        control.addStageToState(ServerMode.ACTIVE.getState(), "voltron_message_stage");
        control.addStageToState(ServerMode.ACTIVE.getState(), "respond_to_request_stage");
        control.addTriggerToState(ServerMode.ACTIVE.getState(), s -> {
            this.startActiveMode(pth, StateManager.convert(s) == ServerMode.PASSIVE);
            this.server.updateActivateTime();
        });
        control.addStageToState(ServerMode.ACTIVE.getState(), "passive_replication_ack_stage");
        control.addStageToState(ServerMode.ACTIVE.getState(), "active_to_passive_driver_stage");
        control.addStageToState(ServerMode.ACTIVE.getState(), "passive_to_active_driver_stage");
        control.addTriggerToState(ServerMode.STOP.getState(), s -> this.shutdown());
        return control;
    }

    private GroupEventsListener connectPassiveEvents(final Sink<PlatformInfoRequest> infoHandler, final LocalMonitoringProducer monitoringShimService) {
        return new GroupEventsListener(){

            @Override
            public void nodeJoined(NodeID nodeID) {
                if (DistributedObjectServer.this.l2Coordinator.getStateManager().isActiveCoordinator()) {
                    if (monitoringShimService.isReadyToReceiveRemoteEvents()) {
                        PlatformInfoRequest req = PlatformInfoRequest.createEmptyRequest();
                        try {
                            DistributedObjectServer.this.groupCommManager.sendTo(nodeID, req);
                        }
                        catch (GroupException g) {
                            logger.error("Failed to send PlatformInfoRequest to new passive", (Throwable)g);
                        }
                    } else {
                        logger.warn("Deferring PlatformInfoRequest to new passive: " + nodeID);
                    }
                }
            }

            @Override
            public void nodeLeft(NodeID nodeID) {
                if (DistributedObjectServer.this.l2Coordinator.getStateManager().isActiveCoordinator()) {
                    PlatformInfoRequest fake = PlatformInfoRequest.createServerInfoRemoveMessage((ServerID)((ServerID)nodeID));
                    fake.setMessageOrginator((ServerID)nodeID);
                    infoHandler.addToSink((Object)fake);
                }
            }
        };
    }

    private void connectServerStateToReplicatedState(final LocalMonitoringProducer monitoringShimService, StateManager mgr, final ClientEntityStateManager clients, final ReplicatedClusterStateManager rcs) {
        mgr.registerForStateChangeEvents(new StateChangeListener(){
            private boolean diagnosticsStarted = false;

            @Override
            public void l2StateChanged(StateChangedEvent sce) {
                rcs.setCurrentState(sce.getCurrentState());
                if (sce.movedToActive()) {
                    monitoringShimService.serverIsActive();
                    PlatformInfoRequest req = PlatformInfoRequest.createEmptyRequest();
                    DistributedObjectServer.this.groupCommManager.sendAll(req);
                    HashSet<ClientID> existingClients = new HashSet<ClientID>(DistributedObjectServer.this.persistor.getClientStatePersistor().loadAllClientIDs());
                    existingClients.addAll(clients.clearClientReferences());
                    Set existingConnections = existingClients.stream().map(cid -> new ConnectionID("ffffffffffffffffffffffffffffffffffffffffffffffff", cid.toLong(), DistributedObjectServer.this.stripeIDStateManager.getStripeID().getName())).collect(Collectors.toSet());
                    DistributedObjectServer.this.getContext().getClientHandshakeManager().setStarting(existingClients);
                    DistributedObjectServer.this.l2Coordinator.getReplicatedClusterStateManager().goActiveAndSyncState();
                    DistributedObjectServer.this.startL1Listener(existingConnections);
                } else if (!this.diagnosticsStarted && StateManager.convert(sce.getCurrentState()) != ServerMode.STOP) {
                    DistributedObjectServer.this.startDiagnosticListener();
                    this.diagnosticsStarted = true;
                }
            }
        });
    }

    public void startGroupManagers() {
        try {
            NodeID myNodeId = this.groupCommManager.join(this.configSetupManager.getGroupConfiguration());
            logger.info("This L2 Node ID = " + myNodeId);
        }
        catch (GroupException e) {
            logger.error("Caught Exception :", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private HashMap<TCMessageType, Class<? extends TCAction>> getMessageTypeClassMappings() {
        HashMap<TCMessageType, Class<? extends TCAction>> messageTypeClassMapping = new HashMap<TCMessageType, Class<? extends TCAction>>();
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_MESSAGE, ClientHandshakeMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE, ClientHandshakeAckMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_REFUSED_MESSAGE, ClientHandshakeRefusedMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLUSTER_MEMBERSHIP_EVENT_MESSAGE, ClusterMembershipMessage.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_MESSAGE, NetworkVoltronEntityMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE, VoltronEntityReceivedResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE, VoltronEntityAppliedResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_RETIRED_RESPONSE, VoltronEntityRetiredResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_MULTI_RESPONSE, LinearVoltronEntityMultiResponse.class);
        messageTypeClassMapping.put(TCMessageType.DIAGNOSTIC_REQUEST, DiagnosticMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.DIAGNOSTIC_RESPONSE, DiagnosticResponseImpl.class);
        return messageTypeClassMapping;
    }

    protected Logger getLogger() {
        return logger;
    }

    private ServerID makeServerNodeID(ServerConfiguration l2DSOConfig) {
        String host = l2DSOConfig.getTsaPort().getHostName();
        if (TCSocketAddress.isWildcardAddress((String)host)) {
            host = l2DSOConfig.getHost();
        }
        ServerID aNodeID = new ServerID(TCSocketAddress.getStringForm((InetSocketAddress)InetSocketAddress.createUnresolved(host, l2DSOConfig.getTsaPort().getPort())), UUID.getUUID().toString().getBytes());
        logger.info("Creating server nodeID: " + aNodeID);
        return aNodeID;
    }

    public ServerID getServerNodeID() {
        return this.thisServerNodeID;
    }

    private void startActiveMode(ProcessTransactionHandler pth, boolean wasStandby) {
        if (!wasStandby) {
            if (this.persistor.getClusterStatePersistor().getInitialState() == null) {
                pth.reconnectComplete();
                Sink msgSink = this.seda.getStageManager().getStage("single_threaded_fastpath", VoltronEntityMessage.class).getSink();
                HashMap<EntityID, VoltronEntityMessage> checkdups = new HashMap<EntityID, VoltronEntityMessage>();
                List<VoltronEntityMessage> annotated = this.entityManager.getEntityLoader().getAnnotatedEntities();
                for (VoltronEntityMessage vem : annotated) {
                    checkdups.put(vem.getEntityDescriptor().getEntityID(), vem);
                }
                for (VoltronEntityMessage vem : checkdups.values()) {
                    msgSink.addToSink((Object)vem);
                }
                EntityPersistor ep = this.persistor.getEntityPersistor();
                for (VoltronEntityMessage vem : checkdups.values()) {
                    try {
                        ep.waitForPermanentEntityCreation(vem.getEntityDescriptor().getEntityID());
                    }
                    catch (RuntimeException e) {
                        this.persistor.getClusterStatePersistor().setDBClean(false);
                        throw new TCServerRestartException("error creating permanent entities", (Throwable)e);
                    }
                    catch (Exception e) {
                        this.persistor.getClusterStatePersistor().setDBClean(false);
                        throw new TCServerRestartException("error creating permanent entities", (Throwable)e);
                    }
                }
            } else {
                pth.loadExistingEntities();
            }
        }
    }

    public boolean isL1Listening() {
        return this.l1Listener.isStarted();
    }

    private void startL1Listener(Set<ConnectionID> existingConnections) {
        while (!this.server.isStopped()) {
            try {
                this.l1Diagnostics.stop(1000L);
            }
            catch (TCTimeoutException to) {
                logger.warn("unable to stop diagnostics listener");
                continue;
            }
            try {
                this.l1Listener.start(existingConnections);
                break;
            }
            catch (BindException bind) {
                logger.warn("client server port not available for binding:", (Throwable)bind);
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException ie) {
                    L2Utils.handleInterrupted(logger, ie);
                    throw new RuntimeException(bind);
                }
            }
            catch (IOException ioe) {
                if (!this.stopping.isSet()) {
                    consoleLogger.info("Unable to start Terracotta Server instance diagnostic listening on {}", (Object)this.l1Diagnostics, (Object)ioe);
                    throw new RuntimeException(ioe);
                }
                logger.debug("cannot start listeners, server shutting down");
            }
        }
        consoleLogger.info("Terracotta Server instance has started up as ACTIVE node on {}", (Object)(this.l1Listener + " successfully, and is now ready for work."));
    }

    private void startDiagnosticListener() {
        try {
            this.l1Diagnostics.start(Collections.emptySet());
            consoleLogger.info("Terracotta Server instance has started diagnostic listening on  {}", (Object)this.l1Diagnostics);
        }
        catch (IOException ioe) {
            if (!this.stopping.isSet()) {
                consoleLogger.info("Unable to start Terracotta Server instance diagnostic listening on {}", (Object)this.l1Diagnostics, (Object)ioe);
                throw new RuntimeException(ioe);
            }
            logger.debug("cannot start listeners, server shutting down");
        }
    }

    public int getListenPort() {
        ServerConfiguration l2DSOConfig = this.configSetupManager.getServerConfiguration();
        int configValue = l2DSOConfig.getTsaPort().getPort();
        if (configValue != 0) {
            return configValue;
        }
        if (this.l1Diagnostics != null) {
            try {
                return this.l1Diagnostics.getBindPort();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (this.l1Listener != null) {
            try {
                return this.l1Listener.getBindPort();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return -1;
    }

    private VersionCompatibility getVersionCompatibility() {
        Collection compat = this.serviceRegistry.subRegistry(0L).getServices(() -> VersionCompatibility.class);
        if (compat == null || compat.isEmpty()) {
            return new DefaultVersionCompatibility();
        }
        if (compat.size() == 1) {
            return (VersionCompatibility)compat.iterator().next();
        }
        return new CollectionVersionCompatibility(compat);
    }

    public int getGroupPort() {
        ServerConfiguration l2DSOConfig = this.configSetupManager.getServerConfiguration();
        int configValue = l2DSOConfig.getGroupPort().getPort();
        if (configValue != 0) {
            return configValue;
        }
        return -1;
    }

    public ConnectionIDFactory getConnectionIdFactory() {
        return this.connectionIdFactory;
    }

    public ServerConfigurationContext getContext() {
        return this.context;
    }

    public ServerManagementContext getManagementContext() {
        return this.managementContext;
    }

    public GroupManager<AbstractGroupMessage> getGroupManager() {
        return this.groupCommManager;
    }

    public ServerConfigurationManager getConfigSetupManager() {
        return this.configSetupManager;
    }

    protected ClientHandshakeHandler createHandShakeHandler(EntityManager entities, ProcessTransactionHandler processTransactionHandler, VersionCompatibility versionCheck) {
        return new ClientHandshakeHandler(entities, processTransactionHandler, versionCheck);
    }

    public CommunicationsManager getCommunicationsManager() {
        return this.communicationsManager;
    }

    public Persistor getPersistor() {
        return this.persistor;
    }
}

