/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.entity.DiagnosticMessage;
import com.tc.entity.DiagnosticResponse;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.objectserver.core.impl.GuardianContext;
import com.tc.objectserver.impl.DistributedObjectServer;
import com.tc.objectserver.impl.JMXSubsystem;
import com.tc.spi.Guardian;
import com.tc.util.State;
import com.tc.util.StringUtil;
import com.tc.util.runtime.ThreadDumpUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.server.ServerEnv;
import org.terracotta.server.StopAction;

public class DiagnosticsHandler
extends AbstractEventHandler<TCAction> {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticsHandler.class);
    private final DistributedObjectServer server;
    private final JMXSubsystem subsystem;

    public DiagnosticsHandler(DistributedObjectServer server, JMXSubsystem subsystem) {
        this.server = server;
        this.subsystem = subsystem;
    }

    public void handleEvent(TCAction context) throws EventHandlerException {
        this.processMessage(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessage(TCAction message) {
        Charset set = Charset.forName("UTF-8");
        MessageChannel channel = message.getChannel();
        try {
            message.hydrate();
        }
        catch (Exception e) {
            logger.warn("trouble with diagnostics", (Throwable)e);
        }
        DiagnosticMessage msg = (DiagnosticMessage)message;
        TCByteBuffer data = msg.getExtendedData();
        String raw = new String(TCByteBufferFactory.unwrap((TCByteBuffer)data), set);
        Object[] cmd = raw.split(" ");
        byte[] result = null;
        long startTime = System.currentTimeMillis();
        ChannelID channelID = message.getChannel().getChannelID();
        try {
            GuardianContext.setCurrentChannelID(channelID);
            switch (cmd[0]) {
                case "getState": {
                    result = this.server.getContext().getL2Coordinator().getStateManager().getCurrentMode().getName().getBytes(set);
                    break;
                }
                case "getInitialState": {
                    State initialState = this.server.getPersistor().getClusterStatePersistor().getInitialState();
                    result = initialState != null ? initialState.getName().getBytes(set) : "".getBytes(set);
                    break;
                }
                case "getClusterState": {
                    if (GuardianContext.validate(Guardian.Op.SERVER_DUMP, "getClusterState")) {
                        result = this.server.getClusterState(set, null);
                        break;
                    }
                    result = "NOT PERMITTED".getBytes(set);
                    break;
                }
                case "getConfig": {
                    result = ServerEnv.getServer().getConfiguration().getBytes(set);
                    break;
                }
                case "getProcessArguments": {
                    result = StringUtil.toString((Object[])ServerEnv.getServer().processArguments(), (String)" ", null, null).getBytes(set);
                    break;
                }
                case "getThreadDump": {
                    result = ThreadDumpUtil.getThreadDump().getBytes(set);
                    break;
                }
                case "terminateServer": {
                    ServerEnv.getServer().stop(new StopAction[0]);
                    result = "".getBytes(set);
                    break;
                }
                case "restartServer": {
                    ServerEnv.getServer().stop(new StopAction[]{StopAction.RESTART});
                    result = "".getBytes(set);
                    break;
                }
                case "forceTerminateServer": {
                    ServerEnv.getServer().stop(new StopAction[0]);
                    result = "".getBytes(set);
                    break;
                }
                case "getJMX": {
                    if (cmd.length != 3) {
                        result = ("Invalid JMX get:" + raw).getBytes(set);
                        break;
                    }
                    result = this.subsystem.get((String)cmd[1], (String)cmd[2]).getBytes(set);
                    break;
                }
                case "setJMX": {
                    if (cmd.length != 4) {
                        result = ("Invalid JMX set:" + raw).getBytes(set);
                        break;
                    }
                    result = this.subsystem.set((String)cmd[1], (String)cmd[2], (String)cmd[3]).getBytes(set);
                    break;
                }
                case "invokeJMX": {
                    if (cmd.length != 3) {
                        result = ("Invalid JMX call:" + raw).getBytes(set);
                        break;
                    }
                    GuardianContext.validate(Guardian.Op.GENERIC_OP, (String)cmd[2]);
                    result = this.subsystem.call((String)cmd[1], (String)cmd[2], null).getBytes(set);
                    break;
                }
                case "invokeWithArgJMX": {
                    if (cmd.length != 4) {
                        result = ("Invalid JMX call:" + raw).getBytes(set);
                        break;
                    }
                    result = this.subsystem.call((String)cmd[1], (String)cmd[2], (String)cmd[3]).getBytes(set);
                    break;
                }
                case "list": {
                    result = this.subsystem.info((String)cmd[1]).getBytes(set);
                    break;
                }
                default: {
                    result = "UNKNOWN CMD".getBytes(set);
                }
            }
            DiagnosticResponse resp = (DiagnosticResponse)channel.createMessage(TCMessageType.DIAGNOSTIC_RESPONSE);
            resp.setResponse(msg.getTransactionID(), result);
            resp.send();
            long end = System.currentTimeMillis();
            if (end - startTime > 500L) {
                logger.warn("command {} took {}ms", (Object)raw, (Object)(end - startTime));
            }
            logger.debug("command {} took {}ms and returned {}", new Object[]{raw, end - startTime, new String(result, set)});
        }
        catch (Throwable t) {
            logger.warn("caught exception while running diagnostic command: " + Arrays.toString(cmd), t);
            DiagnosticResponse resp = (DiagnosticResponse)channel.createMessage(TCMessageType.DIAGNOSTIC_RESPONSE);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, set);
            PrintWriter pw = new PrintWriter(writer);
            t.printStackTrace(pw);
            resp.setResponse(msg.getTransactionID(), out.toByteArray());
            resp.send();
        }
        finally {
            GuardianContext.clearCurrentChannelID(channelID);
        }
    }
}

