/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.net.StripeID;
import com.tc.net.core.ProductID;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ChannelManagerEventListener;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionIDFactoryListener;
import com.tc.objectserver.persistence.ClientStatePersistor;
import com.tc.util.Assert;
import com.tc.util.sequence.MutableSequence;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionIDFactoryImpl
implements ConnectionIDFactory,
ChannelManagerEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionIDFactoryImpl.class);
    private final MutableSequence connectionIDSequence;
    private final ConnectionIDFactory internalClients;
    private StripeID stripe;
    private final Set<ProductID> supported;
    private final List<ConnectionIDFactoryListener> listeners = new CopyOnWriteArrayList<ConnectionIDFactoryListener>();

    public ConnectionIDFactoryImpl(ConnectionIDFactory internals, ClientStatePersistor clientStateStore, Set<ProductID> supported) {
        this.internalClients = internals;
        this.connectionIDSequence = clientStateStore.getConnectionIDSequence();
        this.supported = supported;
    }

    public ConnectionID populateConnectionID(ConnectionID connectionID) {
        StripeID stripeid = this.getStripeID();
        if (stripeid == null || !connectionID.getProductId().isReconnectEnabled()) {
            ConnectionID cid = this.internalClients.populateConnectionID(connectionID);
            return cid;
        }
        if (!new ChannelID(connectionID.getChannelID()).isValid()) {
            return this.nextConnectionId(connectionID.getJvmID(), connectionID.getProductId());
        }
        if (!stripeid.getName().equals(connectionID.getServerID())) {
            return ConnectionID.NULL_ID;
        }
        return this.makeConnectionId(connectionID.getJvmID(), connectionID.getChannelID(), connectionID.getProductId());
    }

    private ConnectionID nextConnectionId(String clientJvmID, ProductID productId) {
        return this.formConnectionId(clientJvmID, this.connectionIDSequence.next(), productId);
    }

    private ConnectionID formConnectionId(String jvmID, long channelID, ProductID productId) {
        Assert.assertNotNull((Object)this.getStripeID());
        productId = this.checkCompatibility(productId);
        if (productId == null) {
            return ConnectionID.NULL_ID;
        }
        ConnectionID rv = new ConnectionID(jvmID, channelID, this.getStripeID().getName(), productId);
        this.fireCreationEvent(rv);
        return rv;
    }

    private ProductID checkCompatibility(ProductID productId) {
        if (!this.supported.contains(productId)) {
            switch (productId) {
                case PERMANENT: {
                    if (this.supported.contains(ProductID.STRIPE)) {
                        productId = ProductID.STRIPE;
                        break;
                    }
                }
                case STRIPE: {
                    if (this.supported.contains(ProductID.SERVER)) {
                        productId = ProductID.SERVER;
                        break;
                    }
                }
                case SERVER: {
                    productId = null;
                }
            }
        }
        return productId;
    }

    private ConnectionID makeConnectionId(String clientJvmID, long channelID, ProductID productId) {
        Assert.assertTrue((channelID != ChannelID.NULL_ID.toLong() ? 1 : 0) != 0);
        return this.formConnectionId(clientJvmID, channelID, productId);
    }

    private void fireCreationEvent(ConnectionID rv) {
        for (ConnectionIDFactoryListener listener : this.listeners) {
            listener.connectionIDCreated(rv);
        }
    }

    private void fireDestroyedEvent(ConnectionID connectionID) {
        for (ConnectionIDFactoryListener listener : this.listeners) {
            listener.connectionIDDestroyed(connectionID);
        }
    }

    public synchronized void activate(StripeID stripeID, long nextAvailChannelID) {
        this.stripe = stripeID;
        LOGGER.info("activating connectionid factory stripe:{} next id: {}", (Object)stripeID, (Object)nextAvailChannelID);
        if (nextAvailChannelID >= 0L) {
            this.connectionIDSequence.setNext(nextAvailChannelID);
        }
    }

    private synchronized StripeID getStripeID() {
        return this.stripe;
    }

    public void registerForConnectionIDEvents(ConnectionIDFactoryListener listener) {
        this.listeners.add(listener);
    }

    public void channelCreated(MessageChannel channel) {
    }

    public void channelRemoved(MessageChannel channel) {
        Assert.assertNotNull((Object)this.getStripeID());
        if (channel.getProductID().isReconnectEnabled()) {
            this.fireDestroyedEvent(channel.getConnectionID());
        }
    }

    public long getCurrentConnectionID() {
        return this.connectionIDSequence.current();
    }
}

