/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.impl;

import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.ChannelManagerEventListener;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.object.net.ChannelStats;
import com.tc.object.net.DSOChannelManager;
import com.tc.object.net.NoSuchChannelException;
import com.tc.stats.StatsConfig;
import com.tc.stats.counter.BoundedCounterConfig;
import com.tc.stats.counter.Counter;
import com.tc.stats.counter.CounterConfig;
import com.tc.stats.counter.CounterManager;
import com.tc.stats.counter.sampled.SampledCounterConfig;
import com.tc.util.Events;

public class ChannelStatsImpl
implements ChannelStats,
ChannelManagerEventListener {
    private static final StatsConfig[] STATS_CONFIG = new StatsConfig[]{new StatsConfig("readRate", (CounterConfig)new SampledCounterConfig(1, 300, true, 0L)), new StatsConfig("writeRate", (CounterConfig)new SampledCounterConfig(1, 300, true, 0L)), new StatsConfig("transactionRate", (CounterConfig)new SampledCounterConfig(1, 300, true, 0L)), new StatsConfig("pendingTransactions", (CounterConfig)new BoundedCounterConfig(0L, 0L, Long.MAX_VALUE))};
    private final CounterManager counterManager;
    private final DSOChannelManager channelManager;

    public ChannelStatsImpl(CounterManager counterManager, DSOChannelManager channelManager) {
        this.counterManager = counterManager;
        this.channelManager = channelManager;
    }

    public Counter getCounter(MessageChannel channel, String name) {
        Counter rv = (Counter)channel.getAttachment(name);
        if (rv == null && (rv = this.createStatsCountersIfNeeded(channel, name)) == null) {
            throw new NullPointerException("StatsCounter : " + name + " not attached to channel " + channel.getChannelID() + " ! Probably not initialized. Check ChannelStats Interface. ");
        }
        return rv;
    }

    private synchronized Counter createStatsCountersIfNeeded(MessageChannel channel, String name) {
        Counter rv = (Counter)channel.getAttachment(name);
        if (rv == null) {
            for (StatsConfig config : STATS_CONFIG) {
                Counter counter = this.counterManager.createCounter(config.getCounterConfig());
                channel.addAttachment(config.getStatsName(), (Object)counter, true);
            }
        }
        return (Counter)channel.getAttachment(name);
    }

    public void channelCreated(MessageChannel channel) {
    }

    public void channelRemoved(MessageChannel channel) {
        for (StatsConfig config : STATS_CONFIG) {
            Counter counter = (Counter)channel.removeAttachment(config.getStatsName());
            if (counter == null) continue;
            this.counterManager.shutdownCounter(counter);
        }
    }

    public void writeOperationEvent(Events.WriteOperationCountChangeEvent event) {
        try {
            MessageChannel channel = this.channelManager.getActiveChannel(event.getSource());
            this.getCounter(channel, "writeRate").increment((long)event.getDelta());
        }
        catch (NoSuchChannelException noSuchChannelException) {
            // empty catch block
        }
    }

    public void notifyReadOperations(MessageChannel channel, int numObjectsRequested) {
        this.getCounter(channel, "readRate").increment((long)numObjectsRequested);
    }

    public void notifyTransaction(NodeID nodeID, int numTxns) {
        try {
            MessageChannel channel = this.channelManager.getActiveChannel(nodeID);
            this.getCounter(channel, "transactionRate").increment((long)numTxns);
        }
        catch (NoSuchChannelException noSuchChannelException) {
            // empty catch block
        }
    }

    public void notifyTransactionBroadcastedTo(NodeID nodeID) {
        try {
            MessageChannel channel = this.channelManager.getActiveChannel(nodeID);
            this.getCounter(channel, "pendingTransactions").increment();
        }
        catch (NoSuchChannelException noSuchChannelException) {
            // empty catch block
        }
    }

    public void notifyTransactionAckedFrom(NodeID nodeID) {
        try {
            MessageChannel channel = this.channelManager.getActiveChannel(nodeID);
            this.getCounter(channel, "pendingTransactions").decrement();
        }
        catch (NoSuchChannelException noSuchChannelException) {
            // empty catch block
        }
    }
}

