/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handshakemanager;

import com.tc.async.api.Sink;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.entity.ResendVoltronEntityMessage;
import com.tc.entity.VoltronEntityMessage;
import com.tc.exception.ServerException;
import com.tc.l2.state.ConsistencyManager;
import com.tc.l2.state.ServerMode;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.utils.L2Utils;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.object.msg.ClientEntityReferenceContext;
import com.tc.object.msg.ClientHandshakeAckMessage;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.net.DSOChannelManager;
import com.tc.objectserver.api.EntityManager;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.entity.LocalPipelineFlushMessage;
import com.tc.objectserver.entity.PlatformEntity;
import com.tc.objectserver.entity.ReconnectListener;
import com.tc.objectserver.entity.ReferenceMessage;
import com.tc.objectserver.handler.ProcessTransactionHandler;
import com.tc.objectserver.handshakemanager.ClientHandshakeException;
import com.tc.objectserver.handshakemanager.ClientHandshakeMonitoringInfo;
import com.tc.productinfo.ProductInfo;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class ServerClientHandshakeManager {
    static final int RECONNECT_WARN_INTERVAL = 15000;
    private static final boolean SHOULD_SEND_STATS = TCPropertiesImpl.getProperties().getBoolean("client.send.stats", false);
    private State state = State.INIT;
    private final List<ReconnectListener> waitingForReconnect = new ArrayList<ReconnectListener>();
    private final Timer timer;
    private final Supplier<Long> reconnectTimeoutSupplier;
    private final DSOChannelManager channelManager;
    private final ConsistencyManager consistency;
    private final Logger logger;
    private final Set<ClientID> unconnectedClients = new HashSet<ClientID>();
    private final Logger consoleLogger;
    private final Sink<VoltronEntityMessage> voltron;
    private final ProductInfo productInfo;

    public ServerClientHandshakeManager(Logger logger, ConsistencyManager consistency, DSOChannelManager channelManager, Timer timer, Supplier<Long> reconnectTimeoutSupplier, Sink<VoltronEntityMessage> voltron, ProductInfo product, Logger consoleLogger) {
        this.logger = logger;
        this.channelManager = channelManager;
        this.reconnectTimeoutSupplier = reconnectTimeoutSupplier;
        this.timer = timer;
        this.voltron = voltron;
        this.consoleLogger = consoleLogger;
        this.consistency = consistency;
        this.productInfo = product;
    }

    public synchronized boolean isStarting() {
        return this.state == State.STARTING;
    }

    public synchronized boolean isStarted() {
        return this.state == State.STARTED;
    }

    private boolean canAcceptStats(String version) {
        return SHOULD_SEND_STATS && version.equals(this.productInfo.version());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClientConnect(ClientHandshakeMessage handshake, EntityManager entityManager, ProcessTransactionHandler transactionHandler) throws ClientHandshakeException {
        ClientID clientID = (ClientID)handshake.getSourceNodeID();
        long save = clientID.toLong();
        ServerClientHandshakeManager serverClientHandshakeManager = this;
        synchronized (serverClientHandshakeManager) {
            this.logger.info("Handling client handshake for " + clientID);
            handshake.getChannel().addAttachment(ClientHandshakeMonitoringInfo.MONITORING_INFO_ATTACHMENT, (Object)new ClientHandshakeMonitoringInfo(handshake.getClientPID(), handshake.getUUID(), handshake.getName(), handshake.getClientVersion(), handshake.getClientRevision(), handshake.getClientAddress()), false);
            if (this.canAcceptStats(handshake.getClientVersion())) {
                handshake.getChannel().addAttachment("SendStats", (Object)true, true);
            }
            this.logger.info("confirming client handshake for " + (Object)((Object)this.state) + " " + save + " " + clientID);
            if (this.state == State.STARTED) {
                Assert.assertEquals((long)save, (long)clientID.toLong());
                this.sendAckMessageFor(clientID);
            } else if (this.state == State.STARTING) {
                this.channelManager.makeChannelActiveNoAck(handshake.getChannel());
                for (ClientEntityReferenceContext referenceContext : handshake.getReconnectReferences()) {
                    Optional<ManagedEntity> entity = null;
                    EntityDescriptor descriptor = EntityDescriptor.createDescriptorForFetch((EntityID)referenceContext.getEntityID(), (long)referenceContext.getEntityVersion(), (ClientInstanceID)referenceContext.getClientInstanceID());
                    try {
                        entity = entityManager.getEntity(descriptor);
                    }
                    catch (ServerException e) {
                        throw Assert.failure((Object)"Unexpected failure to get entity in handshake", (Throwable)e);
                    }
                    if (entity.isPresent()) {
                        byte[] extendedReconnectData = referenceContext.getExtendedReconnectData();
                        ReferenceMessage msg = new ReferenceMessage(clientID, true, descriptor, TCByteBufferFactory.wrap((byte[])extendedReconnectData));
                        transactionHandler.handleResentReferenceMessage(msg);
                        continue;
                    }
                    throw Assert.failure((Object)"entity not found");
                }
                for (ResendVoltronEntityMessage resentMessage : handshake.getResendMessages()) {
                    this.logger.debug("RESENT:" + resentMessage.getVoltronType() + " " + resentMessage.getEntityDescriptor());
                    transactionHandler.handleResentMessage((VoltronEntityMessage)resentMessage);
                }
                this.logger.debug("Removing client " + clientID + " from set of existing unconnected clients.");
                if (this.connectClient(clientID)) {
                    this.consoleLogger.info("Last unconnected client ({}) now connected.  Reconnection starting", (Object)clientID);
                    this.start();
                }
            } else {
                Assert.fail();
            }
        }
    }

    public void notifyClientRefused(ClientHandshakeMessage clientMsg, String message) {
        ClientID clientID = (ClientID)clientMsg.getSourceNodeID();
        this.channelManager.makeChannelRefuse(clientID, message);
    }

    public void notifyDiagnosticClient(ClientHandshakeMessage clientMsg) {
        ClientID clientID = (ClientID)clientMsg.getSourceNodeID();
        clientMsg.getChannel().addAttachment(ClientHandshakeMonitoringInfo.MONITORING_INFO_ATTACHMENT, (Object)new ClientHandshakeMonitoringInfo(clientMsg.getClientPID(), clientMsg.getUUID(), clientMsg.getName(), clientMsg.getClientVersion(), clientMsg.getClientRevision(), clientMsg.getClientAddress()), false);
        ClientHandshakeAckMessage ack = (ClientHandshakeAckMessage)clientMsg.getChannel().createMessage(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE);
        ack.initialize(Collections.emptySet(), clientID, this.productInfo.version());
        ack.send();
    }

    private void sendAckMessageFor(ClientID clientID) {
        this.logger.info("Sending handshake acknowledgement to " + clientID);
        this.channelManager.makeChannelActive(clientID);
    }

    synchronized void notifyTimeout() {
        if (!this.isStarted()) {
            this.logger.info("Reconnect window closing.  Killing any previously connected clients that failed to connect in time: " + this.unconnectedClients);
            this.channelManager.closeAll(this.unconnectedClients);
            this.unconnectedClients.clear();
            this.consoleLogger.info("Reconnect window closed. All dead clients removed.");
            this.start();
        } else {
            this.consoleLogger.info("Reconnect window closed, but server already started.");
        }
    }

    private void start() {
        this.timer.cancel();
        Set<NodeID> cids = Collections.unmodifiableSet(this.channelManager.getAllClientIDs());
        if (!cids.isEmpty()) {
            this.consoleLogger.info("Reconnection with {} clients ", (Object)cids.size());
            if (cids.size() <= 10) {
                this.consoleLogger.info("Reconnected clients - {}", cids);
            }
        }
        while (!cids.isEmpty() && !this.consistency.requestTransition(ServerMode.ACTIVE, (NodeID)ClientID.NULL_ID, ConsistencyManager.Transition.ADD_CLIENT)) {
            this.consoleLogger.info("request to add reconnect clients has been rejected, will try again in 5 seconds");
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException i) {
                L2Utils.handleInterrupted(null, i);
            }
        }
        for (NodeID nid : cids) {
            ClientID clientID = (ClientID)nid;
            if (!this.channelManager.isActiveID((NodeID)clientID)) continue;
            this.sendAckMessageFor(clientID);
        }
        this.state = State.STARTED;
        this.notifyComplete(!cids.isEmpty());
        this.voltron.addToSink((Object)new LocalPipelineFlushMessage(EntityDescriptor.createDescriptorForInvoke((FetchID)PlatformEntity.PLATFORM_FETCH_ID, (ClientInstanceID)ClientInstanceID.NULL_ID), false));
    }

    public void stop() {
        this.timer.cancel();
        this.state = State.INIT;
    }

    private void notifyComplete(boolean log) {
        if (log) {
            this.consoleLogger.info("Reconnection complete");
        }
        this.waitingForReconnect.forEach(ReconnectListener::reconnectComplete);
    }

    public void addReconnectListener(ReconnectListener rl) {
        this.waitingForReconnect.add(rl);
    }

    public synchronized void setStarting(Set<ClientID> existingClients) {
        this.assertInit();
        this.state = State.STARTING;
        if (existingClients.isEmpty()) {
            this.start();
        } else {
            for (ClientID connID : existingClients) {
                this.unconnectedClients.add(connID);
            }
            this.startReconnectWindow();
        }
    }

    private void startReconnectWindow() {
        long reconnectTimeout = this.reconnectTimeoutSupplier.get();
        String message = "Starting reconnect window: " + reconnectTimeout + " ms. Waiting for " + this.getUnconnectedClientsSize() + " clients to connect.";
        if (this.getUnconnectedClientsSize() <= 10) {
            message = message + " Unconnected Clients - " + this.getUnconnectedClients();
        }
        this.consoleLogger.info(message);
        ReconnectTimerTask reconnectTimerTask = new ReconnectTimerTask(reconnectTimeout);
        if (reconnectTimeout < 15000L) {
            this.scheduleTask(reconnectTimerTask, reconnectTimeout);
        } else {
            this.scheduleTask(reconnectTimerTask, 15000L, 15000L);
        }
    }

    private void scheduleTask(ReconnectTimerTask task, long delay) {
        try {
            this.timer.schedule((TimerTask)task, delay);
        }
        catch (IllegalStateException state) {
            this.logger.info("task not scheduled", (Throwable)state);
        }
    }

    private void scheduleTask(ReconnectTimerTask task, long delay, long period) {
        try {
            this.timer.schedule((TimerTask)task, delay, period);
        }
        catch (IllegalStateException state) {
            this.logger.info("task not scheduled", (Throwable)state);
        }
    }

    private void assertInit() {
        if (this.state != State.INIT) {
            throw new AssertionError((Object)("Should be in STARTING state: " + (Object)((Object)this.state)));
        }
    }

    synchronized Collection<ClientID> getUnconnectedClients() {
        return new ArrayList<ClientID>(this.unconnectedClients);
    }

    synchronized int getUnconnectedClientsSize() {
        return this.unconnectedClients.size();
    }

    synchronized boolean connectClient(ClientID cid) {
        this.consoleLogger.info("Connecting client {}", (Object)cid);
        return this.unconnectedClients.remove(cid) && this.unconnectedClients.isEmpty();
    }

    private class ReconnectTimerTask
    extends TimerTask {
        private long timeToWait;

        private ReconnectTimerTask(long timeToWait) {
            this.timeToWait = timeToWait;
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }

        @Override
        public void run() {
            this.timeToWait -= 15000L;
            if (this.timeToWait > 0L && ServerClientHandshakeManager.this.getUnconnectedClientsSize() > 0) {
                String message = "Reconnect window active.  Waiting for " + ServerClientHandshakeManager.this.getUnconnectedClientsSize() + " clients to connect. " + this.timeToWait + " ms remaining.";
                if (ServerClientHandshakeManager.this.getUnconnectedClientsSize() <= 10) {
                    message = message + " Unconnected Clients - " + ServerClientHandshakeManager.this.getUnconnectedClients();
                }
                ServerClientHandshakeManager.this.consoleLogger.info(message);
                if (this.timeToWait < 15000L) {
                    this.cancel();
                    ReconnectTimerTask task = new ReconnectTimerTask(this.timeToWait);
                    ServerClientHandshakeManager.this.scheduleTask(task, this.timeToWait);
                }
            } else {
                ServerClientHandshakeManager.this.notifyTimeout();
            }
        }
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED;

    }
}

