/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handshakemanager;

import com.tc.text.PrettyPrintable;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClientHandshakeMonitoringInfo
implements PrettyPrintable {
    public static String MONITORING_INFO_ATTACHMENT = "client_monitoring_info_attachment";
    private final int pid;
    private final String uuid;
    private final String name;
    private final String version;
    private final String revision;
    private final String address;

    public ClientHandshakeMonitoringInfo(int pid, String uuid, String name, String version, String revision, String address) {
        this.pid = pid;
        this.uuid = uuid;
        this.name = name;
        this.version = version;
        this.revision = revision;
        this.address = address;
    }

    public int getPid() {
        return this.pid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getClientReportedAddress() {
        return this.address;
    }

    public boolean hasClientReportedAddress() {
        return this.address != null && this.address.length() > 0;
    }

    public boolean hasClientVersion() {
        return this.version != null && this.version.length() > 0;
    }

    public boolean hasClientRevision() {
        return this.revision != null && this.revision.length() > 0;
    }

    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("uuid", this.uuid);
        map.put("pid", Integer.toString(this.pid));
        map.put("name", this.name);
        map.put("version", this.version);
        map.put("revision", this.revision);
        map.put("address", this.address);
        return map;
    }

    public String toString() {
        return "ClientHandshakeInfo{pid=" + this.pid + ", uuid=" + this.uuid + ", name=" + this.name + ", version=" + this.version + ", revision=" + this.revision + ", address=" + this.address + '}';
    }
}

