/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.async.api.DirectExecutionMode;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Sink;
import com.tc.async.api.Stage;
import com.tc.async.impl.MonitoringEventCreator;
import com.tc.entity.VoltronEntityMessage;
import com.tc.net.core.ProductID;
import com.tc.net.protocol.tcm.ChannelManagerEventListener;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.utils.L2Utils;
import com.tc.object.net.DSOChannelManager;
import com.tc.properties.TCPropertiesImpl;
import com.tc.text.PrettyPrintable;
import com.tc.util.Assert;
import java.lang.constant.Constable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoltronMessageHandler
extends AbstractEventHandler<VoltronEntityMessage>
implements PrettyPrintable {
    private Sink<VoltronEntityMessage> destSink;
    private final boolean useDirect;
    private Stage<VoltronEntityMessage> fastPath;
    private Stage<VoltronEntityMessage> destPath;
    private Stage<?> requestProcessor;
    private Stage<?> requestProcessorSync;
    private boolean activated = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(VoltronMessageHandler.class);
    private final AtomicInteger clientsConnected = new AtomicInteger();
    private boolean ALWAYS_DIRECT = TCPropertiesImpl.getProperties().getBoolean("l2.seda.stage.single.thread", false);
    private boolean USE_BACKOFF = TCPropertiesImpl.getProperties().getBoolean("l2.seda.stage.voltron.backoff", false);
    private final TimedActivation timer = new TimedActivation();

    public VoltronMessageHandler(DSOChannelManager clients, boolean use_direct) {
        this.useDirect = use_direct;
        clients.addEventListener(new ChannelManagerEventListener(){

            public void channelCreated(MessageChannel channel) {
                if (channel.getProductID() != ProductID.DIAGNOSTIC) {
                    VoltronMessageHandler.this.clientsConnected.incrementAndGet();
                }
            }

            public void channelRemoved(MessageChannel channel) {
                if (channel.getProductID() != ProductID.DIAGNOSTIC) {
                    VoltronMessageHandler.this.clientsConnected.decrementAndGet();
                }
            }
        });
    }

    public void handleEvent(VoltronEntityMessage message) throws EventHandlerException {
        if (this.ALWAYS_DIRECT) {
            if (!this.activated) {
                DirectExecutionMode.activate((boolean)true);
                this.activated = true;
            }
        } else if (this.useDirect) {
            boolean fast = this.fastPath.size() < 2 && this.destPath.isEmpty() && this.requestProcessor.isEmpty() && this.requestProcessorSync.isEmpty() && this.clientsConnected.get() == 1;
            this.timer.update(fast);
            if (this.activated != fast && this.timer.shouldFlip(fast)) {
                this.activated = fast;
                DirectExecutionMode.activate((boolean)this.activated);
                LOGGER.debug("switching to direct sink activated:{} with {}", (Object)this.activated, (Object)this.fastPath.size());
            }
        }
        if (!this.activated && this.USE_BACKOFF) {
            if (this.destPath.size() > 8 && this.fastPath.size() <= 1) {
                this.timer.backoffWait();
            } else {
                this.timer.accelerate();
            }
        }
        if (message.getVoltronType() == VoltronEntityMessage.Type.INVOKE_ACTION) {
            MonitoringEventCreator.start();
        }
        this.destSink.addToSink((Object)message);
    }

    protected void initialize(ConfigurationContext context) {
        super.initialize(context);
        this.fastPath = context.getStage("single_threaded_fastpath", VoltronEntityMessage.class);
        this.destPath = context.getStage("voltron_message_stage", VoltronEntityMessage.class);
        this.requestProcessor = context.getStage("request_processor_stage", Object.class);
        this.requestProcessorSync = context.getStage("request_processor_during_sync_stage", Object.class);
        this.destSink = this.destPath.getSink();
    }

    public int currentBackoff() {
        return (int)this.timer.backoffTime;
    }

    public boolean currentlyDirect() {
        return this.activated;
    }

    public boolean isDirect() {
        return this.ALWAYS_DIRECT;
    }

    public void setDirect(boolean direct) {
        this.ALWAYS_DIRECT = direct;
    }

    public void setUseBackoff(boolean use) {
        this.USE_BACKOFF = use;
    }

    public boolean isUseBackoff() {
        return this.USE_BACKOFF;
    }

    public long backoffCount() {
        return this.timer.backoffCount;
    }

    public long getMaxBackoffTime() {
        return this.timer.maxBackoffTime;
    }

    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Constable> map = new LinkedHashMap<String, Constable>();
        map.put("backoffTime", Long.valueOf(this.timer.backoffTime));
        map.put("backoffCount", Long.valueOf(this.timer.backoffCount));
        map.put("maxBackoffTime", Long.valueOf(this.timer.maxBackoffTime));
        map.put("directMode", Boolean.valueOf(this.activated));
        map.put("clientsConnected", Integer.valueOf(this.clientsConnected.get()));
        return map;
    }

    private static class TimedActivation {
        private long lastChange;
        private boolean state;
        private long backoffTime = 0L;
        private long maxBackoffTime = 0L;
        private long backoffCount = 0L;
        private static final long MAX_BACKOFF = TimeUnit.MICROSECONDS.toNanos(10L);

        private TimedActivation() {
        }

        private void update(boolean activate) {
            if (activate != this.state) {
                this.lastChange = System.currentTimeMillis();
                this.state = activate;
            }
        }

        private boolean shouldFlip(boolean requested) {
            return !requested || System.currentTimeMillis() - this.lastChange > 5000L;
        }

        private void backoffWait() {
            this.backoffTime += 2L;
            if (this.backoffTime > MAX_BACKOFF) {
                this.backoffTime = MAX_BACKOFF;
            }
            try {
                Assert.assertTrue((this.backoffTime < Integer.MAX_VALUE ? 1 : 0) != 0);
                Thread.sleep(0L, (int)this.backoffTime);
                ++this.backoffCount;
                if (this.backoffTime > this.maxBackoffTime) {
                    this.maxBackoffTime = this.backoffTime;
                }
            }
            catch (InterruptedException ie) {
                L2Utils.handleInterrupted(LOGGER, ie);
            }
        }

        private void accelerate() {
            this.backoffTime >>= 1;
        }
    }
}

