/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.objectserver.api.Retiree;
import com.tc.tracing.Trace;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.terracotta.entity.EntityMessage;

public class RetirementManager {
    private final Map<MessageIdentity, LogicalSequence> currentlyRunning = new ConcurrentHashMap<MessageIdentity, LogicalSequence>();
    private final Map<MessageIdentity, EntityMessage> waitingForDeferredRegistration = new ConcurrentHashMap<MessageIdentity, EntityMessage>();
    private final Map<MessageIdentity, EntityMessage> inflightServerMessages = new ConcurrentHashMap<MessageIdentity, EntityMessage>();

    public void registerServerMessage(EntityMessage msg) {
        this.inflightServerMessages.put(RetirementManager.id(msg), msg);
    }

    public boolean hasServerInflightMessages() {
        return !this.inflightServerMessages.isEmpty();
    }

    public boolean isMessageRunning(EntityMessage invokeMessage) {
        return this.currentlyRunning.containsKey(RetirementManager.id(invokeMessage));
    }

    public void holdMessage(EntityMessage invokeMessage) {
        if (this.currentlyRunning.computeIfPresent(RetirementManager.id(invokeMessage), (m, ls) -> ls.hold()) == null) {
            throw new IllegalStateException("message already retired");
        }
    }

    public boolean releaseMessage(EntityMessage invokeMessage) {
        return this.currentlyRunning.get(RetirementManager.id(invokeMessage)).release().isRetireable();
    }

    private void removeMessage(EntityMessage invoke) {
        this.currentlyRunning.remove(RetirementManager.id(invoke));
        this.waitingForDeferredRegistration.remove(RetirementManager.id(invoke));
    }

    public int size() {
        return this.currentlyRunning.size();
    }

    public void registerWithMessage(EntityMessage invokeMessage, int concurrencyKey, Retiree retiree) {
        LogicalSequence newWrapper = new LogicalSequence(invokeMessage, concurrencyKey);
        EntityMessage deferred = this.removeWaitingForDeferred(invokeMessage);
        if (null != deferred) {
            LogicalSequence ls = this.getCurrentlyRunning(deferred);
            ls.retirementDeferredBy(invokeMessage, newWrapper);
        }
        newWrapper.updateWithRetiree(retiree);
        LogicalSequence previous = this.messageIsRunning(invokeMessage, newWrapper);
        Assert.assertNull((Object)previous);
    }

    private void removeInflightServerMessage(EntityMessage msg) {
        this.inflightServerMessages.remove(RetirementManager.id(msg));
    }

    private Deque<LogicalSequence> retireForCompletion(EntityMessage completedMessage) {
        this.removeInflightServerMessage(completedMessage);
        LinkedList<LogicalSequence> toRetire = new LinkedList<LogicalSequence>();
        LogicalSequence ls = this.currentlyRunning.get(RetirementManager.id(completedMessage));
        if (ls.complete()) {
            toRetire.add(ls);
        }
        return toRetire;
    }

    boolean testingIsRetireable(EntityMessage msg) {
        return this.currentlyRunning.get(RetirementManager.id(msg)).isRetireable();
    }

    List<Retiree> testingRetireForCompletion(EntityMessage completedMessage) {
        LogicalSequence seq = this.currentlyRunning.get(RetirementManager.id(completedMessage));
        return this.traverseDependencyGraph(this.retireForCompletion(completedMessage));
    }

    private List<Retiree> traverseDependencyGraph(Deque<LogicalSequence> requestStack) {
        LinkedList<Retiree> toRetire = new LinkedList<Retiree>();
        while (!requestStack.isEmpty()) {
            LogicalSequence currentRequest = requestStack.pop();
            if (!currentRequest.isRetireable()) continue;
            toRetire.add(currentRequest.response);
            this.removeMessage(currentRequest.entityMessage);
            currentRequest.retire();
            if (currentRequest.deferNotify == null) continue;
            currentRequest.deferNotify.entityMessageCompleted(currentRequest.entityMessage);
            requestStack.push(currentRequest.deferNotify);
            currentRequest.deferNotify = null;
        }
        return toRetire;
    }

    private LogicalSequence messageIsRunning(EntityMessage msg, LogicalSequence ls) {
        return this.currentlyRunning.put(RetirementManager.id(msg), ls);
    }

    private LogicalSequence getCurrentlyRunning(EntityMessage msg) {
        return this.currentlyRunning.get(RetirementManager.id(msg));
    }

    private EntityMessage setWaitingForDeferred(EntityMessage toDefer, EntityMessage deferring) {
        return this.waitingForDeferredRegistration.put(RetirementManager.id(toDefer), deferring);
    }

    private EntityMessage removeWaitingForDeferred(EntityMessage invoked) {
        return this.waitingForDeferredRegistration.remove(RetirementManager.id(invoked));
    }

    public void deferRetirement(EntityMessage invokeMessageToDefer, EntityMessage laterMessage) {
        if (Trace.isTraceEnabled()) {
            Trace.activeTrace().log("Deferring retirement for " + invokeMessageToDefer + " until " + laterMessage + " is finished");
        }
        LogicalSequence myRequest = this.getCurrentlyRunning(invokeMessageToDefer);
        LogicalSequence laterRequest = this.getCurrentlyRunning(laterMessage);
        if (laterRequest == null) {
            EntityMessage multiDefer = this.setWaitingForDeferred(laterMessage, invokeMessageToDefer);
            myRequest.retirementDeferredBy(laterMessage, null);
            Assert.assertNull((Object)multiDefer);
        } else {
            myRequest.retirementDeferredBy(laterMessage, laterRequest);
        }
    }

    public void entityWasDestroyed() {
        Assert.assertTrue((boolean)this.currentlyRunning.isEmpty());
        Assert.assertTrue((boolean)this.waitingForDeferredRegistration.isEmpty());
    }

    public Map<String, Object> getState() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("running", this.currentlyRunning.entrySet().stream().collect(Collectors.toMap(entry -> ((MessageIdentity)entry.getKey()).toString(), entry -> ((MessageIdentity)entry.getKey()).toString(), (one, two) -> one, LinkedHashMap::new)));
        map.put("waitingForDeferredRegistration", this.waitingForDeferredRegistration.entrySet().stream().collect(Collectors.toMap(entry -> ((MessageIdentity)entry.getKey()).toString(), entry -> ((MessageIdentity)entry.getKey()).toString(), (one, two) -> one, LinkedHashMap::new)));
        return map;
    }

    public void retireMessage(EntityMessage message) {
        Deque<LogicalSequence> sequence = this.retireForCompletion(message);
        List<Retiree> readyToRetire = this.traverseDependencyGraph(sequence);
        CompletionStage<Object> chain = CompletableFuture.completedFuture(null);
        for (Retiree toRetire : readyToRetire) {
            if (null == toRetire) continue;
            if (Trace.isTraceEnabled()) {
                Trace.activeTrace().log("Retiring message with trace id " + toRetire.getTraceID());
            }
            chain = chain.thenCompose(t -> toRetire.retired());
        }
    }

    private static MessageIdentity id(EntityMessage target) {
        return new MessageIdentity(target);
    }

    private static class MessageIdentity {
        private final EntityMessage target;

        public MessageIdentity(EntityMessage target) {
            this.target = target;
        }

        public boolean equals(Object obj) {
            return obj instanceof MessageIdentity ? this.target == ((MessageIdentity)obj).target : false;
        }

        public int hashCode() {
            return System.identityHashCode(this.target);
        }

        public String toString() {
            return this.target.toString();
        }
    }

    private static class LogicalSequence {
        public final EntityMessage entityMessage;
        public final int concurrencyKey;
        private Retiree response;
        private LogicalSequence deferNotify;
        private final SetOnceFlag isCompleted = new SetOnceFlag();
        private final SetOnceFlag isRetired = new SetOnceFlag();
        private int heldCount = 0;
        private final Map<EntityMessage, LogicalSequence> entityMessagesDeferringRetirement = new IdentityHashMap<EntityMessage, LogicalSequence>();

        public LogicalSequence(EntityMessage entityMessage, int concurrency) {
            this.entityMessage = entityMessage;
            this.concurrencyKey = concurrency;
        }

        public LogicalSequence updateWithRetiree(Retiree response) {
            this.response = response;
            return this;
        }

        public synchronized void retirementDeferredBy(EntityMessage entityMessage, LogicalSequence ls) {
            this.entityMessagesDeferringRetirement.put(entityMessage, ls);
            if (ls != null) {
                Assert.assertNull((Object)ls.deferNotify);
                ls.deferNotify = this;
            }
        }

        public synchronized void entityMessageCompleted(EntityMessage entityMessage) {
            this.entityMessagesDeferringRetirement.remove(entityMessage);
        }

        public synchronized boolean isWaitingForExplicitDefer() {
            boolean messagesWaiting = !this.entityMessagesDeferringRetirement.isEmpty();
            return messagesWaiting || this.heldCount > 0;
        }

        public synchronized boolean isWaitingForExplicitDeferOf(EntityMessage entityMessage) {
            return this.entityMessagesDeferringRetirement.containsKey(entityMessage);
        }

        public LogicalSequence hold() {
            ++this.heldCount;
            return this;
        }

        public LogicalSequence release() {
            --this.heldCount;
            Assert.assertTrue((this.heldCount >= 0 ? 1 : 0) != 0);
            return this;
        }

        public void retire() {
            this.isRetired.attemptSet();
        }

        public boolean complete() {
            this.isCompleted.attemptSet();
            return !this.isWaitingForExplicitDefer();
        }

        public boolean isRetireable() {
            return this.isCompleted.isSet() && !this.isWaitingForExplicitDefer();
        }

        public String toString() {
            return "LogicalSequence{response=" + this.response + ", entityMessage=" + this.entityMessage + ", deferNotify=" + this.deferNotify + ", isCompleted=" + this.isCompleted + ", isRetired=" + this.isRetired + ", entityMessagesDeferringRetirement=" + this.entityMessagesDeferringRetirement + ", heldCount=" + this.heldCount + '}';
        }
    }
}

