/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.async.api.DirectExecutionMode;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Stage;
import com.tc.async.impl.MonitoringEventCreator;
import com.tc.bytes.TCByteBuffer;
import com.tc.entity.VoltronEntityAppliedResponse;
import com.tc.entity.VoltronEntityMessage;
import com.tc.entity.VoltronEntityMultiResponse;
import com.tc.entity.VoltronEntityResponse;
import com.tc.exception.ServerException;
import com.tc.exception.ServerExceptionType;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.utils.L2Utils;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.StatType;
import com.tc.object.net.DSOChannelManager;
import com.tc.object.net.NoSuchChannelException;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.EntityManager;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.api.ResultCapture;
import com.tc.objectserver.api.ServerEntityAction;
import com.tc.objectserver.api.ServerEntityRequest;
import com.tc.objectserver.api.StatisticsCapture;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.entity.AbstractServerEntityRequestResponse;
import com.tc.objectserver.entity.ActivePassiveAckWaiter;
import com.tc.objectserver.entity.ClientDisconnectMessage;
import com.tc.objectserver.entity.MessagePayload;
import com.tc.objectserver.entity.ReconnectListener;
import com.tc.objectserver.entity.ReferenceMessage;
import com.tc.objectserver.entity.ServerEntityRequestImpl;
import com.tc.objectserver.entity.ServerEntityRequestResponse;
import com.tc.objectserver.handler.EntityExistenceHelpers;
import com.tc.objectserver.handler.ResponseMessage;
import com.tc.objectserver.persistence.EntityData;
import com.tc.objectserver.persistence.Persistor;
import com.tc.services.ClientMessageSender;
import com.tc.services.EntityMessengerService;
import com.tc.tracing.Trace;
import com.tc.util.Assert;
import com.tc.util.SparseList;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.EntityMessage;

public class ProcessTransactionHandler
implements ReconnectListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTransactionHandler.class);
    private final Persistor persistor;
    private final EntityManager entityManager;
    private final DSOChannelManager dsoChannelManager;
    private List<ReferenceMessage> references;
    private List<VoltronEntityMessage> reconnectDone;
    private SparseList<VoltronEntityMessage> resendReplayList;
    private List<VoltronEntityMessage> resendNewList;
    private boolean reconnecting = true;
    private Stage<ResponseMessage> multiSend;
    private final ConcurrentHashMap<ClientID, VoltronEntityMultiResponse> invokeReturn = new ConcurrentHashMap();
    private final ConcurrentHashMap<ClientID, Integer> inflightFetch = new ConcurrentHashMap();
    private final ConcurrentHashMap<TransactionID, Future<Void>> transactionOrderPersistenceFutures = new ConcurrentHashMap();
    private final AbstractEventHandler<ResponseMessage> multiSender = new AbstractEventHandler<ResponseMessage>(){

        public void handleEvent(ResponseMessage context) throws EventHandlerException {
            NodeID destinationID = context.getResponse().getDestinationNodeID();
            TCAction response = context.getResponse();
            if (response instanceof VoltronEntityMultiResponse) {
                VoltronEntityMultiResponse voltronEntityMultiResponse = (VoltronEntityMultiResponse)response;
                VoltronEntityMultiResponse sub = (VoltronEntityMultiResponse)response.getChannel().createMessage(TCMessageType.VOLTRON_ENTITY_MULTI_RESPONSE);
                ProcessTransactionHandler.this.invokeReturn.put((ClientID)destinationID, sub);
                voltronEntityMultiResponse.stopAdding();
                if (!ProcessTransactionHandler.this.transactionOrderPersistenceFutures.isEmpty()) {
                    ProcessTransactionHandler.this.waitForTransactions(voltronEntityMultiResponse);
                }
            } else if (response instanceof VoltronEntityAppliedResponse) {
                ProcessTransactionHandler.this.waitForTransactionOrderPersistenceFuture(((VoltronEntityAppliedResponse)response).getTransactionID());
            }
            boolean didSend = response.send();
            if (!didSend) {
                LOGGER.warn("Failed to send message to: " + destinationID);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("sent " + response);
            }
        }
    };
    private final AbstractEventHandler<VoltronEntityMessage> voltronHandler = new AbstractEventHandler<VoltronEntityMessage>(){

        public void handleEvent(VoltronEntityMessage message) throws EventHandlerException {
            ProcessTransactionHandler.this.processAllResends(message);
            ClientID sourceNodeID = message.getSource();
            EntityDescriptor descriptor = message.getEntityDescriptor();
            ServerEntityAction action = ProcessTransactionHandler.decodeMessageType(message.getVoltronType());
            EntityMessage entityMessage = message.getEntityMessage();
            TCByteBuffer extendedData = message.getExtendedData();
            TransactionID transactionID = message.getTransactionID();
            boolean doesRequireReplication = message.doesRequireReplication();
            TransactionID oldestTransactionOnClient = message.getOldestTransactionOnClient();
            boolean requestedReceived = message.doesRequestReceived();
            boolean requestedRetired = message.doesRequestRetired();
            boolean canBeBusy = !sourceNodeID.isNull();
            Consumer<Object> completion = null;
            Consumer<Object> exception = null;
            switch (message.getVoltronType()) {
                case DISCONNECT_CLIENT: {
                    ProcessTransactionHandler.this.invokeReturn.remove(message.getSource());
                    ClientDisconnectMessage disconnect = (ClientDisconnectMessage)message;
                    completion = raw -> disconnect.run();
                    exception = disconnect::disconnectException;
                    break;
                }
                case FETCH_ENTITY: {
                    ProcessTransactionHandler.this.inflightFetch.compute(sourceNodeID, (client, count) -> count == null ? 1 : count + 1);
                    Assert.assertNull(completion);
                    Consumer<Object> var = raw -> ProcessTransactionHandler.this.inflightFetch.compute(sourceNodeID, (client, count) -> count == 1 ? null : Integer.valueOf(count - 1));
                    completion = var;
                    exception = var;
                    break;
                }
                case INVOKE_ACTION: {
                    if (!(message instanceof EntityMessengerService.FakeEntityMessage)) break;
                    completion = ((EntityMessengerService.FakeEntityMessage)message).getCompletionHandler();
                    exception = ((EntityMessengerService.FakeEntityMessage)message).getExceptionHandler();
                    break;
                }
                default: {
                    if (!(message instanceof Runnable)) break;
                    completion = raw -> ((Runnable)message).run();
                }
            }
            MessagePayload payload = MessagePayload.commonMessagePayload(extendedData, entityMessage, doesRequireReplication, canBeBusy);
            ProcessTransactionHandler.this.addMessage(sourceNodeID, descriptor, action, payload, transactionID, oldestTransactionOnClient, completion, exception, requestedReceived, requestedRetired);
        }

        protected void initialize(ConfigurationContext context) {
            super.initialize(context);
            ServerConfigurationContext server = (ServerConfigurationContext)context;
            ProcessTransactionHandler.this.multiSend = server.getStage("respond_to_request_stage", ResponseMessage.class);
            ProcessTransactionHandler.this.reconnectDone = ProcessTransactionHandler.this.entityManager.enterActiveState();
            server.getClientHandshakeManager().addReconnectListener(ProcessTransactionHandler.this);
        }
    };
    private final ClientMessageSender sender = new ClientMessageSender(){

        @Override
        public void send(ClientID client, ClientInstanceID clientInstance, byte[] payload) {
            ProcessTransactionHandler.this.addSequentially(client, msg -> msg.addServerMessage(clientInstance, payload));
        }

        @Override
        public void send(ClientID client, TransactionID transaction, byte[] payload) {
            ProcessTransactionHandler.this.addSequentially(client, msg -> msg.addServerMessage(transaction, payload));
        }
    };

    @Override
    public synchronized void reconnectComplete() {
        this.reconnecting = false;
        this.notify();
    }

    public AbstractEventHandler<ResponseMessage> getMultiResponseSender() {
        return this.multiSender;
    }

    private void waitForTransactions(VoltronEntityMultiResponse vmr) {
        vmr.replay(new VoltronEntityMultiResponse.ReplayReceiver(){

            public void received(TransactionID tid) {
                ProcessTransactionHandler.this.waitForTransactionOrderPersistenceFuture(tid);
            }

            public void retired(TransactionID tid) {
                ProcessTransactionHandler.this.waitForTransactionOrderPersistenceFuture(tid);
            }

            public void result(TransactionID tid, byte[] result) {
                ProcessTransactionHandler.this.waitForTransactionOrderPersistenceFuture(tid);
            }

            public void message(ClientInstanceID cid, byte[] message) {
            }

            public void message(TransactionID tid, byte[] message) {
            }

            public void stats(TransactionID tid, long[] message) {
            }
        });
    }

    public AbstractEventHandler<VoltronEntityMessage> getVoltronMessageHandler() {
        return this.voltronHandler;
    }

    public ClientMessageSender getClientMessageSender() {
        return this.sender;
    }

    public ProcessTransactionHandler(Persistor persistor, DSOChannelManager channelManager, EntityManager entityManager) {
        this.persistor = persistor;
        this.dsoChannelManager = channelManager;
        this.entityManager = entityManager;
        this.references = new LinkedList<ReferenceMessage>();
        this.resendReplayList = new SparseList();
        this.resendNewList = new LinkedList<VoltronEntityMessage>();
    }

    public Iterable<ManagedEntity> snapshotEntityList(Predicate<ManagedEntity> runFirst) {
        return this.entityManager.snapshot(runFirst);
    }

    boolean removeClient(ClientID target) {
        return !this.inflightFetch.containsKey(target);
    }

    private void insertMessageInStream(VoltronEntityResponse msg) {
        if (!msg.getDestinationNodeID().isNull() && !msg.getTransactionID().isNull()) {
            VoltronEntityMultiResponse vmr = this.invokeReturn.remove((ClientID)msg.getDestinationNodeID());
            if (vmr != null) {
                vmr.stopAdding();
            }
            this.multiSend.getSink().addToSink((Object)new ResponseMessage((TCAction)msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSequentially(ClientID target, Predicate<VoltronEntityMultiResponse> adder) {
        VoltronEntityMultiResponse vmr;
        while (!target.isNull() && (vmr = this.invokeReturn.computeIfAbsent(target, client -> {
            Optional<MessageChannel> channel = this.safeGetChannel((NodeID)client);
            if (channel.isPresent()) {
                VoltronEntityMultiResponse msg = (VoltronEntityMultiResponse)channel.get().createMessage(TCMessageType.VOLTRON_ENTITY_MULTI_RESPONSE);
                if (DirectExecutionMode.isActivated() && msg.shouldSend() && this.multiSend.isEmpty()) {
                    msg.startAdding();
                    Assert.assertTrue((boolean)adder.test(msg));
                    msg.stopAdding();
                    msg.send();
                    return null;
                }
                return msg;
            }
            return null;
        })) != null) {
            boolean enqueue = vmr.startAdding();
            try {
                if (!adder.test(vmr)) continue;
                break;
            }
            finally {
                if (!enqueue) continue;
                this.multiSend.getSink().addToSink((Object)new ResponseMessage((TCAction)vmr));
            }
        }
    }

    private void addMessage(ClientID sourceNodeID, EntityDescriptor descriptor, ServerEntityAction action, MessagePayload entityMessage, TransactionID transactionID, TransactionID oldestTransactionOnClient, Consumer<byte[]> chaincomplete, Consumer<ServerException> chainfail, boolean requiresReceived, boolean requiresRetired) {
        boolean isReplicatedMessage = false;
        Future<Void> transactionOrderPersistenceFuture = null;
        ServerEntityRequestImpl request = new ServerEntityRequestImpl(descriptor.getClientInstanceID(), action, sourceNodeID, transactionID, oldestTransactionOnClient, requiresReceived);
        if (sourceNodeID != null && !sourceNodeID.isNull() && transactionID.isValid()) {
            Assert.assertTrue((boolean)oldestTransactionOnClient.isValid());
            transactionOrderPersistenceFuture = this.persistor.getTransactionOrderPersistor().updateWithNewMessage(sourceNodeID, transactionID, oldestTransactionOnClient);
        }
        Trace trace = null;
        if (Trace.isTraceEnabled()) {
            trace = new Trace(request.getTraceID(), "ProcessTransactionHandler.AddMessage");
            trace.start();
            trace.log("Handling " + (Object)((Object)action));
        }
        if (ServerEntityAction.CREATE_ENTITY == action) {
            long consumerID = this.persistor.getEntityPersistor().getNextConsumerID();
            LifecycleResultsCapture capture = new LifecycleResultsCapture(descriptor.getEntityID(), descriptor.getClientSideVersion(), consumerID, request, this::insertMessageInStream, chaincomplete, chainfail, entityMessage.getRawPayload(), isReplicatedMessage);
            capture.setTransactionOrderPersistenceFuture(transactionOrderPersistenceFuture);
            try {
                EntityID entityID = descriptor.getEntityID();
                ManagedEntity temp = this.entityManager.createEntity(entityID, descriptor.getClientSideVersion(), consumerID);
                temp.addRequestMessage(capture, entityMessage, capture);
            }
            catch (ServerException ee) {
                capture.failure(ee);
            }
        } else {
            Optional<ManagedEntity> optionalEntity = null;
            try {
                optionalEntity = this.entityManager.getEntity(descriptor);
            }
            catch (ServerException ee) {
                ServerEntityRequestResponse rr = new ServerEntityRequestResponse(request, this::insertMessageInStream, () -> this.safeGetChannel((NodeID)sourceNodeID), chaincomplete, chainfail, isReplicatedMessage);
                rr.failure(ee);
                return;
            }
            if (!optionalEntity.isPresent()) {
                if (!descriptor.isIndexed()) {
                    ServerEntityRequestResponse rr = new ServerEntityRequestResponse(request, this::insertMessageInStream, () -> this.safeGetChannel((NodeID)sourceNodeID), chaincomplete, chainfail, isReplicatedMessage);
                    rr.failure(ServerException.createNotFoundException((EntityID)descriptor.getEntityID()));
                    return;
                }
                if (descriptor.getClientInstanceID() != ClientInstanceID.NULL_ID) {
                    throw new AssertionError((Object)("fetched entity not found " + descriptor + " action:" + (Object)((Object)action) + " " + sourceNodeID));
                }
                LOGGER.error("fetched entity not found " + descriptor + " action:" + (Object)((Object)action) + " " + sourceNodeID);
                return;
            }
            ManagedEntity entity = optionalEntity.get();
            if (ServerEntityAction.INVOKE_ACTION == action) {
                InvokeHandler handler = new InvokeHandler(request, this::insertMessageInStream, chaincomplete, chainfail, requiresReceived, requiresRetired);
                handler.addMessage();
                if (transactionOrderPersistenceFuture != null) {
                    this.transactionOrderPersistenceFutures.put(transactionID, transactionOrderPersistenceFuture);
                }
                entity.addRequestMessage(handler, entityMessage, handler);
            } else if (action.isLifecycle()) {
                EntityID eid;
                long version;
                long consumerID;
                if (descriptor.isIndexed()) {
                    consumerID = descriptor.getFetchID().toLong();
                    version = entity.getVersion();
                    eid = entity.getID();
                } else {
                    eid = descriptor.getEntityID();
                    version = descriptor.getClientSideVersion();
                    consumerID = entity.getConsumerID();
                }
                LifecycleResultsCapture capture = new LifecycleResultsCapture(eid, version, consumerID, request, this::insertMessageInStream, chaincomplete, chainfail, entityMessage.getRawPayload(), isReplicatedMessage);
                capture.setTransactionOrderPersistenceFuture(transactionOrderPersistenceFuture);
                entity.addRequestMessage(capture, entityMessage, capture);
            } else if (action == ServerEntityAction.MANAGED_ENTITY_GC && entity.isRemoveable()) {
                LOGGER.debug("removing " + entity.getID());
                this.entityManager.removeDestroyed(descriptor.getFetchID());
            } else {
                ServerEntityRequestResponse rr = new ServerEntityRequestResponse(request, this::insertMessageInStream, () -> this.safeGetChannel((NodeID)sourceNodeID), chaincomplete, chainfail, isReplicatedMessage);
                rr.setTransactionOrderPersistenceFuture(transactionOrderPersistenceFuture);
                entity.addRequestMessage(rr, entityMessage, rr);
            }
            if (trace != null) {
                trace.end();
            }
        }
    }

    private void waitForTransactionOrderPersistenceFuture(TransactionID transactionID) {
        Future<Void> future;
        if (!this.transactionOrderPersistenceFutures.isEmpty() && (future = this.transactionOrderPersistenceFutures.remove(transactionID)) != null) {
            try {
                future.get();
            }
            catch (InterruptedException ie) {
                L2Utils.handleInterrupted(LOGGER, ie);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void disconnectClientDueToFailure(ClientID clientID, Exception exp) {
        LOGGER.info("disconnecting " + clientID + " due to an error", (Throwable)exp);
        this.safeGetChannel((NodeID)clientID).ifPresent(channel -> channel.close());
    }

    public void loadExistingEntities() {
        ArrayList<EntityData.Value> sortingList = new ArrayList<EntityData.Value>(this.persistor.getEntityPersistor().loadEntityData());
        Collections.sort(sortingList, new Comparator<EntityData.Value>(){

            @Override
            public int compare(EntityData.Value o1, EntityData.Value o2) {
                long firstID = o1.consumerID;
                long secondID = o2.consumerID;
                Assert.assertTrue((firstID != secondID ? 1 : 0) != 0);
                return firstID > secondID ? 1 : -1;
            }
        });
        for (EntityData.Value entityValue : sortingList) {
            Assert.assertTrue((entityValue.version > 0L ? 1 : 0) != 0);
            Assert.assertTrue((entityValue.consumerID > 0L ? 1 : 0) != 0);
            EntityID entityID = new EntityID(entityValue.className, entityValue.entityName);
            try {
                this.entityManager.loadExisting(entityID, entityValue.version, entityValue.consumerID, entityValue.canDelete, entityValue.configuration);
            }
            catch (ServerException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void handleResentReferenceMessage(ReferenceMessage msg) {
        this.references.add(msg);
    }

    public void handleResentMessage(VoltronEntityMessage resentMessage) {
        boolean cached = false;
        ServerEntityAction cachedType = null;
        byte[] result = null;
        int index = -1;
        try {
            switch (resentMessage.getVoltronType()) {
                case CREATE_ENTITY: {
                    cached = this.persistor.getEntityPersistor().wasEntityCreatedInJournal(resentMessage.getEntityDescriptor().getEntityID(), resentMessage.getSource(), resentMessage.getTransactionID().toLong());
                    cachedType = ServerEntityAction.CREATE_ENTITY;
                    break;
                }
                case DESTROY_ENTITY: {
                    cached = this.persistor.getEntityPersistor().wasEntityDestroyedInJournal(resentMessage.getEntityDescriptor().getEntityID(), resentMessage.getSource(), resentMessage.getTransactionID().toLong());
                    cachedType = ServerEntityAction.DESTROY_ENTITY;
                    break;
                }
                case RECONFIGURE_ENTITY: {
                    result = this.persistor.getEntityPersistor().reconfiguredResultInJournal(resentMessage.getEntityDescriptor().getEntityID(), resentMessage.getSource(), resentMessage.getTransactionID().toLong());
                    if (result == null) break;
                    cached = true;
                    cachedType = ServerEntityAction.RECONFIGURE_ENTITY;
                    break;
                }
                case FETCH_ENTITY: {
                    cached = true;
                    cachedType = ServerEntityAction.FETCH_ENTITY;
                    throw ServerException.createBusyException((EntityID)resentMessage.getEntityDescriptor().getEntityID());
                }
                case RELEASE_ENTITY: {
                    cached = true;
                    cachedType = ServerEntityAction.RELEASE_ENTITY;
                    throw ServerException.createBusyException((EntityID)resentMessage.getEntityDescriptor().getEntityID());
                }
                default: {
                    index = this.persistor.getTransactionOrderPersistor().getIndexToReplay(resentMessage.getSource(), resentMessage.getTransactionID());
                }
            }
            if (cached) {
                ServerEntityRequestImpl request = new ServerEntityRequestImpl(resentMessage.getEntityDescriptor().getClientInstanceID(), cachedType, resentMessage.getSource(), resentMessage.getTransactionID(), resentMessage.getOldestTransactionOnClient(), true);
                ServerEntityRequestResponse response = new ServerEntityRequestResponse(request, this::insertMessageInStream, () -> this.safeGetChannel((NodeID)resentMessage.getSource()), null, null, false);
                response.received();
                if (result != null) {
                    response.complete(result);
                } else {
                    response.complete();
                }
                response.retired();
            } else if (index >= 0) {
                this.resendReplayList.insert(index, resentMessage);
            } else {
                this.resendNewList.add(resentMessage);
            }
        }
        catch (ServerException ee) {
            ServerEntityRequestImpl request = new ServerEntityRequestImpl(resentMessage.getEntityDescriptor().getClientInstanceID(), cachedType, resentMessage.getSource(), resentMessage.getTransactionID(), resentMessage.getOldestTransactionOnClient(), true);
            ServerEntityRequestResponse response = new ServerEntityRequestResponse(request, this::insertMessageInStream, () -> this.safeGetChannel((NodeID)resentMessage.getSource()), null, null, false);
            response.received();
            response.failure(ee);
            response.retired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAllResends(VoltronEntityMessage trigger) {
        if (this.references == null && this.resendReplayList == null && this.resendNewList == null) {
            return;
        }
        LOGGER.debug("RESENDS:START");
        Iterator<VoltronEntityMessage> iterator = this;
        synchronized (iterator) {
            while (this.reconnecting) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
        }
        this.persistor.getTransactionOrderPersistor().clearAllRecords();
        for (ReferenceMessage referenceMessage : this.references) {
            LOGGER.debug("RESENDS:" + referenceMessage);
            try {
                EntityID eid = this.entityManager.getEntity(referenceMessage.getEntityDescriptor()).get().getID();
                Assert.assertEquals((Object)eid, (Object)referenceMessage.getEntityDescriptor().getEntityID());
            }
            catch (ServerException ee) {
                throw new RuntimeException(ee);
            }
            this.executeResend(referenceMessage);
        }
        this.references = null;
        for (VoltronEntityMessage voltronEntityMessage : this.reconnectDone) {
            LOGGER.debug("RECONNECT DONE:" + voltronEntityMessage);
            this.executeResend(voltronEntityMessage);
        }
        this.reconnectDone = null;
        for (VoltronEntityMessage voltronEntityMessage : this.resendReplayList) {
            LOGGER.debug("RESENDS:" + voltronEntityMessage);
            this.executeResend(voltronEntityMessage);
        }
        this.resendReplayList = null;
        for (VoltronEntityMessage voltronEntityMessage : this.resendNewList) {
            LOGGER.debug("RESENDS:" + voltronEntityMessage);
            this.executeResend(voltronEntityMessage);
        }
        this.persistor.getEntityPersistor().removeTrackingForClient(ClientID.NULL_ID);
        LOGGER.debug("RESENDS:END");
        this.resendNewList = null;
    }

    private Optional<MessageChannel> safeGetChannel(NodeID id) {
        try {
            if (!id.isNull()) {
                return Optional.of(this.dsoChannelManager.getActiveChannel(id));
            }
        }
        catch (NoSuchChannelException noSuchChannelException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private void executeResend(VoltronEntityMessage message) {
        ClientID sourceNodeID = message.getSource();
        EntityDescriptor descriptor = message.getEntityDescriptor();
        ServerEntityAction action = ProcessTransactionHandler.decodeMessageType(message.getVoltronType());
        EntityMessage entityMessage = message.getEntityMessage();
        Assert.assertNull((Object)entityMessage);
        TCByteBuffer extendedData = message.getExtendedData();
        TransactionID transactionID = message.getTransactionID();
        boolean doesRequireReplication = message.doesRequireReplication();
        TransactionID oldestTransactionOnClient = message.getOldestTransactionOnClient();
        MessagePayload payload = MessagePayload.commonMessagePayloadNotBusy(extendedData, entityMessage, doesRequireReplication);
        payload.setDebugId(message.toString());
        boolean requestedReceived = message.doesRequestReceived();
        boolean requestedRetired = message.doesRequestRetired();
        Consumer<byte[]> completion = null;
        if (message instanceof Runnable) {
            completion = r -> ((Runnable)message).run();
        }
        this.addMessage(sourceNodeID, descriptor, action, payload, transactionID, oldestTransactionOnClient, completion, null, requestedReceived, requestedRetired);
    }

    private static ServerEntityAction decodeMessageType(VoltronEntityMessage.Type type) {
        ServerEntityAction action = null;
        switch (type) {
            case FETCH_ENTITY: {
                action = ServerEntityAction.FETCH_ENTITY;
                break;
            }
            case RELEASE_ENTITY: {
                action = ServerEntityAction.RELEASE_ENTITY;
                break;
            }
            case CREATE_ENTITY: {
                action = ServerEntityAction.CREATE_ENTITY;
                break;
            }
            case RECONFIGURE_ENTITY: {
                action = ServerEntityAction.RECONFIGURE_ENTITY;
                break;
            }
            case DESTROY_ENTITY: {
                action = ServerEntityAction.DESTROY_ENTITY;
                break;
            }
            case INVOKE_ACTION: {
                action = ServerEntityAction.INVOKE_ACTION;
                break;
            }
            case LOCAL_PIPELINE_FLUSH: {
                action = ServerEntityAction.LOCAL_FLUSH;
                break;
            }
            case LOCAL_ENTITY_GC: {
                action = ServerEntityAction.MANAGED_ENTITY_GC;
                break;
            }
            case DISCONNECT_CLIENT: {
                action = ServerEntityAction.DISCONNECT_CLIENT;
                break;
            }
            default: {
                Assert.fail();
            }
        }
        return action;
    }

    private class LifecycleResultsCapture
    extends AbstractServerEntityRequestResponse
    implements ResultCapture {
        private final EntityID eid;
        private final long version;
        private final long consumerID;
        private final byte[] config;
        private Supplier<ActivePassiveAckWaiter> setOnce;

        public LifecycleResultsCapture(EntityID eid, long version, long consumerID, ServerEntityRequest request, Consumer<VoltronEntityResponse> sender, Consumer<byte[]> complete, Consumer<ServerException> fail, byte[] config, boolean isReplicatedMessage) {
            super(request, sender, complete, fail);
            this.eid = eid;
            this.version = version;
            this.consumerID = consumerID;
            this.config = config;
        }

        @Override
        public Optional<MessageChannel> getReturnChannel() {
            return ProcessTransactionHandler.this.safeGetChannel((NodeID)this.getNodeID());
        }

        @Override
        public boolean requiresReceived() {
            return true;
        }

        @Override
        public CompletionStage<Void> retired() {
            throw new AssertionError((Object)"retired should never be called on a lifecycle operation");
        }

        @Override
        public void message(byte[] message) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setWaitFor(Supplier<ActivePassiveAckWaiter> waiter) {
            this.setOnce = waiter;
        }

        @Override
        public void waitForReceived() {
            this.setOnce.get().waitForReceived();
        }

        @Override
        public void failure(ServerException e) {
            switch (this.getAction()) {
                case CREATE_ENTITY: {
                    ProcessTransactionHandler.this.persistor.getEntityPersistor().entityCreateFailed(this.eid, this.getNodeID(), this.getTransaction().toLong(), this.getOldestTransactionOnClient().toLong(), e);
                    break;
                }
                case RECONFIGURE_ENTITY: {
                    EntityExistenceHelpers.recordReconfigureEntity(ProcessTransactionHandler.this.persistor.getEntityPersistor(), ProcessTransactionHandler.this.entityManager, this.getNodeID(), this.getTransaction(), this.getOldestTransactionOnClient(), this.eid, this.version, null, e);
                    break;
                }
                case DESTROY_ENTITY: {
                    EntityExistenceHelpers.recordDestroyEntity(ProcessTransactionHandler.this.persistor.getEntityPersistor(), ProcessTransactionHandler.this.entityManager, this.getNodeID(), this.getTransaction(), this.getOldestTransactionOnClient(), this.eid, e);
                    break;
                }
                case FETCH_ENTITY: {
                    if (e.getType() == ServerExceptionType.ENTITY_NOT_FOUND || e.getType() == ServerExceptionType.ENTITY_BUSY_EXCEPTION) break;
                    ProcessTransactionHandler.this.disconnectClientDueToFailure(this.getNodeID(), (Exception)((Object)e));
                    break;
                }
                case RELEASE_ENTITY: {
                    break;
                }
            }
            if (this.setOnce != null) {
                ActivePassiveAckWaiter waiter = this.setOnce.get();
                waiter.waitForCompleted();
                if (waiter.verifyLifecycleResult(false)) {
                    LOGGER.warn("ZAP occurred while processing " + (Object)((Object)this.getAction()) + " on " + this.eid);
                }
            }
            super.failure(e);
        }

        @Override
        public void complete() {
            switch (this.getAction()) {
                case CREATE_ENTITY: {
                    if (!this.getNodeID().isNull()) {
                        ProcessTransactionHandler.this.persistor.getEntityPersistor().entityCreated(this.getNodeID(), this.getTransaction().toLong(), this.getOldestTransactionOnClient().toLong(), this.eid, this.version, this.consumerID, true, this.config);
                        break;
                    }
                    ProcessTransactionHandler.this.persistor.getEntityPersistor().entityCreatedNoJournal(this.eid, this.version, this.consumerID, ProcessTransactionHandler.this.entityManager.canDelete(this.eid), this.config);
                    break;
                }
                case RECONFIGURE_ENTITY: {
                    EntityExistenceHelpers.recordReconfigureEntity(ProcessTransactionHandler.this.persistor.getEntityPersistor(), ProcessTransactionHandler.this.entityManager, this.getNodeID(), this.getTransaction(), this.getOldestTransactionOnClient(), this.eid, this.version, this.config, null);
                    break;
                }
                case DESTROY_ENTITY: {
                    EntityExistenceHelpers.recordDestroyEntity(ProcessTransactionHandler.this.persistor.getEntityPersistor(), ProcessTransactionHandler.this.entityManager, this.getNodeID(), this.getTransaction(), this.getOldestTransactionOnClient(), this.eid, null);
                    break;
                }
            }
            if (this.setOnce != null) {
                ActivePassiveAckWaiter waiter = this.setOnce.get();
                waiter.waitForCompleted();
                if (waiter.verifyLifecycleResult(true)) {
                    LOGGER.warn("ZAP occurred while processing " + (Object)((Object)this.getAction()) + " on " + this.eid);
                }
            }
            super.complete();
        }

        @Override
        public void complete(byte[] value) {
            switch (this.getAction()) {
                case CREATE_ENTITY: {
                    if (!this.getNodeID().isNull()) {
                        ProcessTransactionHandler.this.persistor.getEntityPersistor().entityCreated(this.getNodeID(), this.getTransaction().toLong(), this.getOldestTransactionOnClient().toLong(), this.eid, this.version, this.consumerID, true, this.config);
                        break;
                    }
                    ProcessTransactionHandler.this.persistor.getEntityPersistor().entityCreatedNoJournal(this.eid, this.version, this.consumerID, ProcessTransactionHandler.this.entityManager.canDelete(this.eid), this.config);
                    break;
                }
                case RECONFIGURE_ENTITY: {
                    EntityExistenceHelpers.recordReconfigureEntity(ProcessTransactionHandler.this.persistor.getEntityPersistor(), ProcessTransactionHandler.this.entityManager, this.getNodeID(), this.getTransaction(), this.getOldestTransactionOnClient(), this.eid, this.version, this.config, null);
                    break;
                }
                case DESTROY_ENTITY: {
                    EntityExistenceHelpers.recordDestroyEntity(ProcessTransactionHandler.this.persistor.getEntityPersistor(), ProcessTransactionHandler.this.entityManager, this.getNodeID(), this.getTransaction(), this.getOldestTransactionOnClient(), this.eid, null);
                    break;
                }
                case FETCH_ENTITY: 
                case RELEASE_ENTITY: {
                    break;
                }
            }
            if (this.setOnce != null) {
                ActivePassiveAckWaiter waiter = this.setOnce.get();
                waiter.waitForCompleted();
                if (waiter.verifyLifecycleResult(true)) {
                    LOGGER.warn("ZAP occurred while processing " + (Object)((Object)this.getAction()) + " on " + this.eid);
                }
            }
            super.complete(value);
        }
    }

    private class InvokeHandler
    extends AbstractServerEntityRequestResponse
    implements ResultCapture,
    StatisticsCapture {
        private Supplier<ActivePassiveAckWaiter> waiter;
        private final SetOnceFlag lastSent;
        private final boolean sendReceived;
        private final boolean holdResultForRetired;
        private byte[] heldResult;
        private final long[] stats;

        InvokeHandler(ServerEntityRequest request, Consumer<VoltronEntityResponse> sender, Consumer<byte[]> complete, Consumer<ServerException> failure, boolean reqReceived, boolean reqRetired) {
            super(request, sender, complete, failure);
            this.lastSent = new SetOnceFlag();
            this.stats = new long[StatType.SERVER_RETIRED.serverSpot() + 1];
            this.sendReceived = reqReceived;
            this.holdResultForRetired = reqRetired;
        }

        @Override
        public Optional<MessageChannel> getReturnChannel() {
            return ProcessTransactionHandler.this.safeGetChannel((NodeID)this.getNodeID());
        }

        @Override
        public void received() {
            this.stats[StatType.SERVER_RECEIVED.serverSpot()] = System.nanoTime();
            if (this.sendReceived) {
                ProcessTransactionHandler.this.addSequentially(this.getNodeID(), adder -> adder.addReceived(this.getTransaction()));
            }
        }

        @Override
        public void failure(ServerException cause) {
            this.stats[StatType.SERVER_COMPLETE.serverSpot()] = System.nanoTime();
            this.sendFailure(cause);
        }

        @Override
        public void complete(byte[] result) {
            this.stats[StatType.SERVER_COMPLETE.serverSpot()] = System.nanoTime();
            this.sendResponse(result);
        }

        @Override
        public void complete() {
            this.stats[StatType.SERVER_COMPLETE.serverSpot()] = System.nanoTime();
            this.sendResponse(new byte[0]);
        }

        @Override
        public void message(byte[] msg) {
            if (this.getNodeID().isNull()) {
                super.complete(msg);
            } else {
                ProcessTransactionHandler.this.addSequentially(this.getNodeID(), addTo -> addTo.addServerMessage(this.getTransaction(), msg));
            }
        }

        @Override
        public void setWaitFor(Supplier<ActivePassiveAckWaiter> waiter) {
            this.waiter = waiter;
        }

        @Override
        public void waitForReceived() {
            this.waiter.get().waitForReceived();
        }

        private void sendResponse(byte[] result) {
            if (this.lastSent.attemptSet()) {
                if (this.getNodeID().isNull()) {
                    super.complete(result);
                } else if (!this.holdResultForRetired) {
                    ProcessTransactionHandler.this.addSequentially(this.getNodeID(), addTo -> addTo.addResult(this.getTransaction(), result));
                } else {
                    this.heldResult = result;
                }
            }
        }

        private void sendFailure(ServerException e) {
            if (!this.lastSent.attemptSet()) {
                if (this.heldResult == null) {
                    return;
                }
                this.heldResult = null;
            }
            super.failure(e);
            MonitoringEventCreator.finish();
        }

        @Override
        public CompletionStage<Void> retired() {
            CompletableFuture<Void> complete = new CompletableFuture<Void>();
            this.waiter.get().runWhenCompleted(() -> {
                if (!this.getNodeID().isNull()) {
                    this.stats[StatType.SERVER_RETIRED.serverSpot()] = System.nanoTime();
                    Assert.assertTrue((boolean)this.lastSent.isSet());
                    ProcessTransactionHandler.this.safeGetChannel((NodeID)this.getNodeID()).ifPresent(c -> {
                        if (c.getAttachment("SendStats") != null) {
                            ProcessTransactionHandler.this.addSequentially(this.getNodeID(), addTo -> addTo.addStats(this.getTransaction(), this.stats));
                        }
                    });
                    ProcessTransactionHandler.this.addSequentially(this.getNodeID(), addTo -> {
                        if (this.heldResult != null) {
                            return addTo.addResultAndRetire(this.getTransaction(), this.heldResult);
                        }
                        return addTo.addRetired(this.getTransaction());
                    });
                }
                MonitoringEventCreator.finish();
                complete.complete(null);
            });
            return complete;
        }

        @Override
        public void addMessage() {
            this.stats[StatType.SERVER_ADD.serverSpot()] = System.nanoTime();
        }

        @Override
        public void schedule() {
            this.stats[StatType.SERVER_SCHEDULE.serverSpot()] = System.nanoTime();
        }

        @Override
        public void beginInvoke() {
            this.stats[StatType.SERVER_BEGININVOKE.serverSpot()] = System.nanoTime();
        }

        @Override
        public void endInvoke() {
            this.stats[StatType.SERVER_ENDINVOKE.serverSpot()] = System.nanoTime();
        }
    }
}

