/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.l2.msg.IBatchableGroupMessage;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.net.utils.L2Utils;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupMessageBatchContext<M extends IBatchableGroupMessage<E>, E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupMessageBatchContext.class);
    private static final long THRESHOLD = 0x1000000L;
    private final Function<E, M> messageFactory;
    private final GroupManager<AbstractGroupMessage> groupManager;
    private final ServerID target;
    private final int maximumBatchSize;
    private final int idealMessagesInFlight;
    private final Consumer<ServerID> networkDoneTarget;
    private int messagesInFlight;
    private M cachedMessage;
    private long nextReplicationID;

    public GroupMessageBatchContext(Function<E, M> messageFactory, GroupManager<AbstractGroupMessage> groupManager, ServerID target, int maximumBatchSize, int idealMessagesInFlight, Consumer<ServerID> networkDoneTarget) {
        this.messageFactory = messageFactory;
        this.groupManager = groupManager;
        this.target = target;
        this.maximumBatchSize = maximumBatchSize;
        this.idealMessagesInFlight = idealMessagesInFlight;
        this.networkDoneTarget = networkDoneTarget;
    }

    public synchronized boolean batchMessage(E activity) {
        boolean didCreateNewBatch = false;
        try {
            while (this.cachedMessage != null && this.cachedMessage.getBatchSize() >= this.maximumBatchSize) {
                this.wait();
            }
        }
        catch (InterruptedException ie) {
            L2Utils.handleInterrupted(LOGGER, ie);
            throw new RuntimeException(ie);
        }
        if (null != this.cachedMessage) {
            this.cachedMessage.addToBatch(activity);
        } else {
            this.cachedMessage = (IBatchableGroupMessage)this.messageFactory.apply(activity);
            this.notifyAll();
            this.cachedMessage.setSequenceID(this.nextReplicationID++);
            didCreateNewBatch = true;
        }
        return didCreateNewBatch;
    }

    public void flushBatch() throws GroupException {
        IBatchableGroupMessage<E> messageToSend = this.getMessageToSend();
        while (messageToSend != null) {
            try {
                AbstractGroupMessage msg = messageToSend.asAbstractGroupMessage();
                this.groupManager.sendToWithSentCallback((NodeID)this.target, msg, this::handleNetworkDone);
                if (messageToSend.getPayloadSize() > 0x1000000L) {
                    this.waitForFlush();
                }
                messageToSend = this.getMessageToSend();
            }
            catch (GroupException e) {
                LOGGER.warn("replication message failed", (Throwable)e);
                this.handleNetworkDone();
                throw e;
            }
        }
    }

    private synchronized IBatchableGroupMessage<E> getMessageToSend() {
        IBatchableGroupMessage<E> messageToSend = null;
        if (null != this.cachedMessage && (0 == this.idealMessagesInFlight || this.messagesInFlight < this.idealMessagesInFlight || this.cachedMessage.getBatchSize() >= this.maximumBatchSize || this.cachedMessage.getPayloadSize() > 0x1000000L)) {
            messageToSend = (IBatchableGroupMessage<E>)this.cachedMessage;
            this.cachedMessage = null;
            this.notifyAll();
            ++this.messagesInFlight;
        }
        return messageToSend;
    }

    private synchronized void waitForFlush() {
        try {
            while (this.messagesInFlight > 0) {
                this.wait();
            }
        }
        catch (InterruptedException ie) {
            L2Utils.handleInterrupted(LOGGER, ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNetworkDone() {
        GroupMessageBatchContext groupMessageBatchContext = this;
        synchronized (groupMessageBatchContext) {
            --this.messagesInFlight;
            this.notifyAll();
        }
        if (this.networkDoneTarget != null) {
            this.networkDoneTarget.accept(this.target);
        }
    }
}

