/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.exception.ServerException;
import com.tc.net.ClientID;
import com.tc.object.EntityID;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.EntityManager;
import com.tc.objectserver.persistence.EntityPersistor;
import com.tc.util.Assert;

public class EntityExistenceHelpers {
    public static boolean createEntityReturnWasCached(EntityPersistor entityPersistor, EntityManager entityManager, ClientID clientID, TransactionID transactionIDObject, TransactionID oldestTransactionOnClientObject, EntityID entityID, long version, long consumerID, byte[] configuration) throws ServerException {
        boolean resultWasCached = false;
        Assert.assertNotNull((Object)clientID);
        Assert.assertNotNull((Object)transactionIDObject);
        Assert.assertNotNull((Object)oldestTransactionOnClientObject);
        long transactionID = transactionIDObject.toLong();
        if (!clientID.isNull() && entityPersistor.wasEntityCreatedInJournal(entityID, clientID, transactionID)) {
            resultWasCached = true;
        } else {
            entityManager.createEntity(entityID, version, consumerID);
        }
        return resultWasCached;
    }

    public static boolean destroyEntityReturnWasCached(EntityPersistor entityPersistor, EntityManager entityManager, ClientID clientID, TransactionID transactionIDObject, TransactionID oldestTransactionOnClientObject, EntityID entityID) throws ServerException {
        Assert.assertNotNull((Object)clientID);
        Assert.assertFalse((boolean)clientID.isNull());
        Assert.assertNotNull((Object)transactionIDObject);
        Assert.assertNotNull((Object)oldestTransactionOnClientObject);
        long transactionID = transactionIDObject.toLong();
        return entityPersistor.wasEntityDestroyedInJournal(entityID, clientID, transactionID);
    }

    public static void recordDestroyEntity(EntityPersistor entityPersistor, EntityManager entityManager, ClientID clientID, TransactionID transactionIDObject, TransactionID oldestTransactionOnClientObject, EntityID entityID, ServerException exception) {
        Assert.assertNotNull((Object)clientID);
        Assert.assertNotNull((Object)transactionIDObject);
        Assert.assertNotNull((Object)oldestTransactionOnClientObject);
        long transactionID = transactionIDObject.toLong();
        long oldestTransactionOnClient = oldestTransactionOnClientObject.toLong();
        if (exception == null) {
            entityPersistor.entityDestroyed(clientID, transactionID, oldestTransactionOnClient, entityID);
        } else {
            entityPersistor.entityDestroyFailed(clientID, transactionID, oldestTransactionOnClient, exception);
        }
    }

    public static void recordReconfigureEntity(EntityPersistor entityPersistor, EntityManager entityManager, ClientID clientID, TransactionID transactionIDObject, TransactionID oldestTransactionOnClientObject, EntityID entityID, long version, byte[] configuration, ServerException exception) {
        Assert.assertNotNull((Object)clientID);
        Assert.assertNotNull((Object)transactionIDObject);
        Assert.assertNotNull((Object)oldestTransactionOnClientObject);
        long transactionID = transactionIDObject.toLong();
        long oldestTransactionOnClient = oldestTransactionOnClientObject.toLong();
        if (exception == null) {
            entityPersistor.entityReconfigureSucceeded(clientID, transactionID, oldestTransactionOnClient, entityID, version, configuration);
        } else {
            entityPersistor.entityReconfigureFailed(clientID, transactionID, oldestTransactionOnClient, exception);
        }
    }

    public static byte[] reconfigureEntityReturnCachedResult(EntityPersistor entityPersistor, EntityManager entityManager, ClientID clientID, TransactionID transactionIDObject, TransactionID oldestTransactionOnClientObject, EntityID entityID, long version, byte[] configuration) throws ServerException {
        Assert.assertNotNull((Object)clientID);
        Assert.assertFalse((boolean)clientID.isNull());
        Assert.assertNotNull((Object)transactionIDObject);
        Assert.assertNotNull((Object)oldestTransactionOnClientObject);
        long transactionID = transactionIDObject.toLong();
        return entityPersistor.reconfiguredResultInJournal(entityID, clientID, transactionID);
    }
}

