/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.handler;

import com.tc.async.api.Sink;
import com.tc.async.api.StageManager;
import com.tc.entity.VoltronEntityMessage;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.core.ProductID;
import com.tc.net.protocol.tcm.ChannelManagerEventListener;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.FetchID;
import com.tc.object.net.DSOChannelManager;
import com.tc.objectserver.core.impl.GuardianContext;
import com.tc.objectserver.core.impl.ManagementTopologyEventCollector;
import com.tc.objectserver.entity.ClientDisconnectMessage;
import com.tc.objectserver.entity.ClientEntityStateManager;
import com.tc.objectserver.entity.PlatformEntity;
import com.tc.objectserver.handler.ProcessTransactionHandler;
import com.tc.objectserver.handshakemanager.ClientHandshakeMonitoringInfo;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientChannelLifeCycleHandler
implements ChannelManagerEventListener {
    private final CommunicationsManager commsManager;
    private final DSOChannelManager channelMgr;
    private final ClientEntityStateManager clientEvents;
    private final ProcessTransactionHandler pth;
    private final ManagementTopologyEventCollector collector;
    private final Set<ClientID> knownClients = new HashSet<ClientID>();
    private static final Logger logger = LoggerFactory.getLogger(ClientChannelLifeCycleHandler.class);
    private final Sink<VoltronEntityMessage> voltronSink;

    public ClientChannelLifeCycleHandler(CommunicationsManager commsManager, StageManager stageManager, DSOChannelManager channelManager, ClientEntityStateManager chain, ProcessTransactionHandler handler, ManagementTopologyEventCollector collector) {
        this.commsManager = commsManager;
        this.channelMgr = channelManager;
        this.clientEvents = chain;
        this.collector = collector;
        this.pth = handler;
        this.voltronSink = stageManager.getStage("single_threaded_fastpath", VoltronEntityMessage.class).getSink();
    }

    private void nodeDisconnected(NodeID nodeID, ProductID productId, InetSocketAddress address, Object clientInfo) {
        if (1 == nodeID.getNodeType()) {
            ClientID clientID = (ClientID)nodeID;
            this.voltronSink.addToSink((Object)this.createClientDisconnectMessage(clientID));
        }
        if (this.commsManager.isInShutdown()) {
            logger.info("Ignoring transport disconnect for " + nodeID + " while shutting down.");
        } else {
            logger.info("Channel Management : Received transport disconnect.  Shutting down client " + nodeID + ":" + address + ":" + productId + ":" + clientInfo);
        }
    }

    private VoltronEntityMessage createClientDisconnectMessage(ClientID clientID) {
        return new ClientDisconnectMessage(clientID, EntityDescriptor.createDescriptorForInvoke((FetchID)PlatformEntity.PLATFORM_FETCH_ID, (ClientInstanceID)ClientInstanceID.NULL_ID), () -> {
            if (this.pth.removeClient(clientID)) {
                this.notifyEnitiesOfDisconnect(clientID);
            } else {
                this.voltronSink.addToSink((Object)this.createClientDisconnectMessage(clientID));
            }
        }, e -> this.voltronSink.addToSink((Object)this.createClientDisconnectMessage(clientID)));
    }

    private void notifyEnitiesOfDisconnect(ClientID clientID) {
        List<FetchID> msg = this.clientEvents.clientDisconnected(clientID);
        this.collector.expectedDisconnects(clientID, msg);
        if (msg.isEmpty()) {
            this.notifyClientRemoved(clientID);
        } else {
            CountDownLatch latch = new CountDownLatch(msg.size());
            msg.forEach(m -> this.voltronSink.addToSink((Object)this.createMessageForEntityDisconnect(clientID, (FetchID)m, latch)));
        }
    }

    private ClientDisconnectMessage createMessageForEntityDisconnect(ClientID clientID, FetchID target, CountDownLatch latch) {
        return new ClientDisconnectMessage(clientID, EntityDescriptor.createDescriptorForInvoke((FetchID)target, (ClientInstanceID)ClientInstanceID.NULL_ID), () -> {
            latch.countDown();
            if (latch.getCount() == 0L) {
                this.notifyClientRemoved(clientID);
            }
        }, e -> this.voltronSink.addToSink((Object)this.createMessageForEntityDisconnect(clientID, target, latch)));
    }

    private void nodeConnected(NodeID nodeID, InetSocketAddress address, ProductID productId, Object clientInfo) {
        logger.info("Channel Management : Received transport connect.  Starting client " + nodeID + ":" + address + ":" + productId + ":" + clientInfo);
    }

    public void channelCreated(MessageChannel channel) {
        ClientID clientID = (ClientID)channel.getRemoteNodeID();
        if (this.channelMgr.isActiveID((NodeID)clientID)) {
            this.nodeConnected((NodeID)clientID, channel.getRemoteAddress(), channel.getProductID(), channel.getAttachment(ClientHandshakeMonitoringInfo.MONITORING_INFO_ATTACHMENT));
            this.notifyClientAdded(channel, clientID);
        }
        GuardianContext.channelCreated(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientAdded(MessageChannel channel, ClientID clientID) {
        Set<ClientID> set = this.knownClients;
        synchronized (set) {
            this.collector.clientDidConnect(channel, clientID);
            this.knownClients.add(clientID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClientRemoved(ClientID clientID) {
        Set<ClientID> set = this.knownClients;
        synchronized (set) {
            if (this.knownClients.contains(clientID)) {
                GuardianContext.clientRemoved(clientID);
                this.knownClients.remove(clientID);
            }
        }
    }

    private void channelRemoved(MessageChannel channel, boolean wasActive) {
        ClientID clientID = (ClientID)channel.getRemoteNodeID();
        ProductID product = channel.getProductID();
        InetSocketAddress address = channel.getRemoteAddress();
        if (wasActive) {
            this.nodeDisconnected((NodeID)clientID, product, address, channel.getAttachment(ClientHandshakeMonitoringInfo.MONITORING_INFO_ATTACHMENT));
        } else {
            GuardianContext.channelRemoved(channel);
        }
    }

    public void channelRemoved(MessageChannel channel) {
        this.channelRemoved(channel, this.channelMgr.isActiveID(channel.getRemoteNodeID()));
    }
}

