/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.async.api.Sink;
import com.tc.async.api.Stage;
import com.tc.entity.MessageCodecSupplier;
import com.tc.entity.NetworkVoltronEntityMessage;
import com.tc.entity.VoltronEntityMessage;
import com.tc.net.core.TCComm;
import com.tc.net.protocol.tcm.HydrateContext;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.net.protocol.tcm.TCMessageHydrateSink;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoltronMessageSink
extends TCMessageHydrateSink<VoltronEntityMessage> {
    private final MessageCodecSupplier codecSupplier;
    private final Stage<HydrateContext> helper;
    private final Sink<VoltronEntityMessage> dest;
    private static final Logger LOGGER = LoggerFactory.getLogger(VoltronMessageSink.class);
    private boolean always_hydrate = TCPropertiesImpl.getProperties().getBoolean("l2.seda.stage.always.hydrate", false);

    public VoltronMessageSink(Stage<HydrateContext> helper, Sink<VoltronEntityMessage> destSink, MessageCodecSupplier codecSupplier) {
        super(destSink);
        this.helper = helper;
        this.codecSupplier = codecSupplier;
        this.dest = destSink;
    }

    public void putMessage(TCAction message) {
        if (message instanceof NetworkVoltronEntityMessage) {
            ((NetworkVoltronEntityMessage)message).setMessageCodecSupplier(this.codecSupplier);
            if (this.always_hydrate || TCComm.hasPendingRead() || !this.helper.isEmpty()) {
                this.helper.getSink().addToSink((Object)new HydrateContext(message, this.dest));
            } else {
                super.putMessage(message);
            }
        } else {
            Assert.fail();
        }
    }

    public void setAlwaysHydrate(boolean hydrate) {
        this.always_hydrate = hydrate;
    }

    public boolean isAlwaysHydrate() {
        return this.always_hydrate;
    }
}

