/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.classloader.PermanentEntity;
import com.tc.classloader.PermanentEntityType;
import com.tc.classloader.ServiceLocator;
import com.tc.entity.VoltronEntityMessage;
import com.tc.object.EntityID;
import com.tc.objectserver.entity.CreateSystemEntityMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.EntityServerService;
import org.terracotta.entity.PassiveServerEntity;

public class ServerEntityFactory {
    private final ServiceLocator locator;
    private List<VoltronEntityMessage> entityMessages;

    public ServerEntityFactory(ServiceLocator loader) {
        this.locator = loader;
    }

    public <T extends EntityServerService<? extends ActiveServerEntity, ? extends PassiveServerEntity>> T getService(String typeName) throws ClassNotFoundException {
        List<Class<EntityServerService>> serviceLoader = this.locator.getImplementations(EntityServerService.class);
        for (Class<EntityServerService> serverService : serviceLoader) {
            try {
                EntityServerService instance = serverService.newInstance();
                if (!instance.handlesEntityType(typeName)) continue;
                return (T)instance;
            }
            catch (IllegalAccessException | InstantiationException i) {
                throw new RuntimeException(i);
            }
        }
        throw new ClassNotFoundException(typeName);
    }

    public synchronized List<VoltronEntityMessage> getAnnotatedEntities() {
        if (this.entityMessages == null) {
            this.entityMessages = new ArrayList<VoltronEntityMessage>();
            List<Class<EntityServerService>> serviceLoader = this.locator.getImplementations(EntityServerService.class);
            for (Class<EntityServerService> serverService : serviceLoader) {
                for (PermanentEntity permanentEntity : (PermanentEntity[])serverService.getAnnotationsByType(PermanentEntity.class)) {
                    this.entityMessages.add(ServerEntityFactory.createMessage(permanentEntity.type(), permanentEntity.name(), permanentEntity.version(), TCByteBufferFactory.getInstance((int)0)));
                }
                for (PermanentEntity permanentEntity : (PermanentEntityType[])serverService.getAnnotationsByType(PermanentEntityType.class)) {
                    this.entityMessages.add(ServerEntityFactory.createMessage(permanentEntity.type().getName(), permanentEntity.name(), permanentEntity.version(), TCByteBufferFactory.getInstance((int)0)));
                }
            }
        }
        return this.entityMessages;
    }

    public boolean isPermanentEntity(EntityID entity) {
        Predicate<EntityID> sameName = e -> e.getEntityName().equals(entity.getEntityName());
        Predicate<EntityID> sameClass = e -> e.getClassName().equals(entity.getClassName());
        return this.getAnnotatedEntities().stream().map(p -> p.getEntityDescriptor().getEntityID()).anyMatch(sameName.and(sameClass));
    }

    public static VoltronEntityMessage createMessage(String type, String name, int version, TCByteBuffer data) {
        return new CreateSystemEntityMessage(new EntityID(type, name), version, data);
    }
}

