/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.exception.ServerException;
import com.tc.objectserver.api.ResultCapture;
import com.tc.objectserver.entity.ActivePassiveAckWaiter;
import com.tc.tracing.Trace;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultCaptureImpl
implements ResultCapture {
    private final Runnable received;
    private final Consumer<byte[]> result;
    private final Consumer<byte[]> message;
    private final Consumer<ServerException> error;
    private final SetOnceFlag receivedSent = new SetOnceFlag();
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultCaptureImpl.class);
    Supplier<ActivePassiveAckWaiter> setOnce;

    public ResultCaptureImpl(Runnable received, Consumer<byte[]> result, Consumer<byte[]> message, Consumer<ServerException> error) {
        this.received = received;
        this.result = result;
        this.error = error;
        this.message = message;
    }

    @Override
    public void setWaitFor(Supplier<ActivePassiveAckWaiter> waitFor) {
        Assert.assertNull(this.setOnce);
        this.setOnce = waitFor;
    }

    @Override
    public void waitForReceived() {
        if (this.setOnce != null) {
            ActivePassiveAckWaiter waiter = this.setOnce.get();
            waiter.waitForReceived();
        }
    }

    @Override
    public void received() {
        Trace.activeTrace().log("received ");
        this.receivedSent.set();
        if (this.received != null) {
            this.received.run();
        }
    }

    @Override
    public void complete() {
        Trace.activeTrace().log("Completed without result ");
        if (!this.receivedSent.isSet()) {
            this.received();
        }
        if (this.result != null) {
            this.result.accept(null);
        }
    }

    @Override
    public void complete(byte[] value) {
        if (Trace.isTraceEnabled()) {
            Trace.activeTrace().log("Completed with result: " + value);
        }
        if (!this.receivedSent.isSet()) {
            this.received();
        }
        if (this.result != null) {
            this.result.accept(value);
        }
    }

    @Override
    public void failure(ServerException ee) {
        if (Trace.isTraceEnabled()) {
            Trace.activeTrace().log("Failure - exception: " + ee.getLocalizedMessage());
        }
        if (!this.receivedSent.isSet()) {
            this.received();
        }
        if (this.error != null) {
            this.error.accept(ee);
        }
    }

    @Override
    public void message(byte[] m) {
        this.message.accept(m);
    }

    @Override
    public CompletionStage<Void> retired() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

