/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.async.api.EventHandler;
import com.tc.async.api.MultiThreadedEventContext;
import com.tc.async.api.Sink;
import com.tc.async.api.StageManager;
import com.tc.bytes.TCByteBuffer;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.net.ClientID;
import com.tc.net.utils.L2Utils;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.ServerEntityAction;
import com.tc.objectserver.api.ServerEntityRequest;
import com.tc.objectserver.entity.ActivePassiveAckWaiter;
import com.tc.objectserver.entity.MessagePayload;
import com.tc.objectserver.entity.NoReplicationBroker;
import com.tc.objectserver.entity.PassiveReplicationBroker;
import com.tc.objectserver.entity.RequestProcessorHandler;
import com.tc.objectserver.entity.SyncRequestProcessorHandler;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessor {
    private PassiveReplicationBroker passives;
    private final Sink<EntityRequest> requestExecution;
    private final Sink<EntityRequest> syncExecution;
    private boolean isActive = false;
    private static final Logger PLOGGER = LoggerFactory.getLogger(MessagePayload.class);

    public RequestProcessor(StageManager stageManager, int maxQueueSize, boolean use_direct) {
        int MIN_NUM_PROCESSORS = TCPropertiesImpl.getProperties().getInt("server.entity.processor.minthreads");
        int numOfProcessors = L2Utils.getOptimalApplyStageWorkerThreads(true);
        numOfProcessors = Math.max(MIN_NUM_PROCESSORS, numOfProcessors);
        this.requestExecution = stageManager.createStage("request_processor_stage", EntityRequest.class, (EventHandler)new RequestProcessorHandler(), numOfProcessors, maxQueueSize, use_direct, true).getSink();
        this.syncExecution = stageManager.createStage("request_processor_during_sync_stage", EntityRequest.class, (EventHandler)new SyncRequestProcessorHandler(), MIN_NUM_PROCESSORS, maxQueueSize, use_direct, true).getSink();
    }

    RequestProcessor(Sink<EntityRequest> requestExecution) {
        this(requestExecution, requestExecution);
    }

    RequestProcessor(Sink<EntityRequest> requestExecution, Sink<EntityRequest> syncExecution) {
        this.requestExecution = requestExecution;
        this.syncExecution = requestExecution;
    }

    public void enterActiveState() {
        this.isActive = true;
    }

    public ActivePassiveAckWaiter scheduleSync(SyncReplicationActivity activity, SessionID passive) {
        return this.passives.replicateActivity(activity, Collections.singleton(passive));
    }

    public void setReplication(PassiveReplicationBroker passives) {
        Assert.assertNull((Object)this.passives);
        this.passives = passives;
    }

    public synchronized void scheduleRequest(boolean inSync, EntityID eid, long version, FetchID fetchID, ServerEntityRequest request, MessagePayload payload, Consumer<ActivePassiveAckWaiter> call, boolean replicate, int concurrencyKey) {
        ServerEntityAction requestAction = !replicate && request.requiresReceived() ? ServerEntityAction.ORDER_PLACEHOLDER_ONLY : request.getAction();
        boolean isActionReplicated = requestAction.isReplicated();
        Supplier<ActivePassiveAckWaiter> token = () -> {
            Set<SessionID> replicateTo;
            Set<SessionID> set = replicateTo = this.isActive && isActionReplicated && this.passives != null ? request.replicateTo(this.passives.passives()) : Collections.emptySet();
            if (!(replicateTo.isEmpty() || replicate || request.requiresReceived())) {
                replicateTo.clear();
            }
            if (PLOGGER.isDebugEnabled()) {
                PLOGGER.debug("SCHEDULING:{} {} on {} with concurrency:{} replicatedTo: {}", new Object[]{requestAction, payload.getDebugId(), eid, concurrencyKey, replicateTo});
            }
            return !replicateTo.isEmpty() ? this.passives.replicateActivity(RequestProcessor.createReplicationActivity(eid, version, fetchID, request.getNodeID(), request.getClientInstance(), requestAction, request.getTransaction(), request.getOldestTransactionOnClient(), payload, concurrencyKey), replicateTo) : NoReplicationBroker.NOOP_WAITER;
        };
        EntityRequest entityRequest = new EntityRequest(eid, call, token, concurrencyKey, payload);
        if (inSync) {
            this.syncExecution.addToSink((Object)entityRequest);
        } else {
            this.requestExecution.addToSink((Object)entityRequest);
        }
    }

    private static SyncReplicationActivity createReplicationActivity(EntityID id, long version, FetchID fetchID, ClientID src, ClientInstanceID instance, ServerEntityAction type, TransactionID tid, TransactionID oldest, MessagePayload payload, int concurrency) {
        SyncReplicationActivity.ActivityType actionCode = type.replicationType();
        Assert.assertNotNull((Object)actionCode);
        SyncReplicationActivity activity = null;
        switch (actionCode) {
            case SYNC_ENTITY_CONCURRENCY_BEGIN: {
                activity = SyncReplicationActivity.createStartEntityKeyMessage((EntityID)id, (long)version, (FetchID)fetchID, (int)concurrency);
                break;
            }
            case ORDERING_PLACEHOLDER: {
                activity = SyncReplicationActivity.createOrderingPlaceholder((FetchID)fetchID, (ClientID)src, (ClientInstanceID)instance, (TransactionID)tid, (TransactionID)oldest, (String)payload.getDebugId());
                break;
            }
            case INVOKE_ACTION: {
                activity = SyncReplicationActivity.createInvokeMessage((FetchID)fetchID, (ClientID)src, (ClientInstanceID)instance, (TransactionID)tid, (TransactionID)oldest, (SyncReplicationActivity.ActivityType)actionCode, (TCByteBuffer)payload.getByteBufferPayload(), (int)concurrency, (String)payload.getDebugId());
                break;
            }
            default: {
                activity = SyncReplicationActivity.createLifecycleMessage((EntityID)id, (long)version, (FetchID)fetchID, (ClientID)src, (ClientInstanceID)instance, (TransactionID)tid, (TransactionID)oldest, (SyncReplicationActivity.ActivityType)actionCode, (TCByteBuffer)payload.getByteBufferPayload());
            }
        }
        return activity;
    }

    public static class EntityRequest
    implements MultiThreadedEventContext,
    Runnable {
        private final EntityID entity;
        private final Consumer<ActivePassiveAckWaiter> invoke;
        private final int key;
        private final Supplier<ActivePassiveAckWaiter> waiter;
        private final MessagePayload debug;

        EntityRequest(EntityID entity, Consumer<ActivePassiveAckWaiter> runnable, Supplier<ActivePassiveAckWaiter> waiter, int key, MessagePayload debug) {
            this.entity = entity;
            this.invoke = runnable;
            this.key = key;
            this.waiter = waiter;
            this.debug = debug;
        }

        public Object getSchedulingKey() {
            if (this.key == Integer.MIN_VALUE) {
                return null;
            }
            return this.key ^ this.entity.hashCode();
        }

        @Override
        public void run() {
            this.invoke();
        }

        ActivePassiveAckWaiter invoke() {
            ActivePassiveAckWaiter token = this.waiter.get();
            this.invoke.accept(token);
            return token;
        }

        public boolean flush() {
            return this.key == 0;
        }

        public String toString() {
            return "EntityRequest{entity=" + this.entity + ", key=" + this.key + ", debug=" + this.debug.getDebugId() + '}';
        }
    }
}

