/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.exception.ServerException;
import com.tc.objectserver.api.ResultCapture;
import com.tc.objectserver.entity.ActivePassiveAckWaiter;
import com.tc.tracing.Trace;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassiveResultCapture
implements ResultCapture {
    private final Runnable received;
    private final Consumer<byte[]> result;
    private final Consumer<ServerException> error;
    private final SetOnceFlag receivedSent = new SetOnceFlag();
    private static final Logger LOGGER = LoggerFactory.getLogger(PassiveResultCapture.class);

    public PassiveResultCapture(Runnable received, Consumer<byte[]> result, Consumer<ServerException> error) {
        this.received = received;
        this.result = result;
        this.error = error;
    }

    @Override
    public void setWaitFor(Supplier<ActivePassiveAckWaiter> waitFor) {
    }

    @Override
    public void waitForReceived() {
    }

    @Override
    public void received() {
        Trace.activeTrace().log("received ");
        this.receivedSent.set();
        if (this.received != null) {
            this.received.run();
        }
    }

    @Override
    public void complete() {
        Trace.activeTrace().log("Completed without result ");
        if (!this.receivedSent.isSet()) {
            this.received();
        }
        if (this.result != null) {
            this.result.accept(null);
        }
    }

    @Override
    public void complete(byte[] value) {
        if (Trace.isTraceEnabled()) {
            Trace.activeTrace().log("Completed with result: " + value);
        }
        if (!this.receivedSent.isSet()) {
            this.received();
        }
        if (this.result != null) {
            this.result.accept(value);
        }
    }

    @Override
    public void failure(ServerException ee) {
        if (Trace.isTraceEnabled()) {
            Trace.activeTrace().log("Failure - exception: " + ee.getLocalizedMessage());
        }
        if (!this.receivedSent.isSet()) {
            this.received();
        }
        if (this.error != null) {
            this.error.accept(ee);
        }
    }

    @Override
    public void message(byte[] message) {
    }

    @Override
    public CompletionStage<Void> retired() {
        return CompletableFuture.completedFuture(null);
    }
}

