/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.exception.ServerException;
import com.tc.objectserver.api.ResultCapture;
import com.tc.objectserver.entity.ActivePassiveAckWaiter;
import com.tc.tracing.Trace;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class NoopResultCapture
implements ResultCapture {
    @Override
    public void setWaitFor(Supplier<ActivePassiveAckWaiter> waitFor) {
    }

    @Override
    public void waitForReceived() {
    }

    @Override
    public void received() {
        Trace.activeTrace().log("Received");
    }

    @Override
    public void complete() {
        Trace.activeTrace().log("Completed without result ");
    }

    @Override
    public void complete(byte[] value) {
        if (Trace.isTraceEnabled()) {
            Trace.activeTrace().log("Completed with result of length " + value.length);
        }
    }

    @Override
    public void failure(ServerException ee) {
        if (Trace.isTraceEnabled()) {
            Trace.activeTrace().log("Failure - exception: " + ee.getLocalizedMessage());
        }
    }

    @Override
    public void message(byte[] message) {
    }

    @Override
    public CompletionStage<Void> retired() {
        Trace.activeTrace().log("Retired");
        return CompletableFuture.completedFuture(null);
    }
}

