/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.objectserver.entity.MessageDecoder;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.MessageCodecException;

public class MessagePayload {
    private final TCByteBuffer raw;
    private EntityMessage message;
    private MessageCodecException exception;
    private final int concurrency;
    private final int referenceCount;
    private final boolean replicate;
    private final boolean canBeBusy;
    private String debugId;

    public static final MessagePayload emptyPayload() {
        MessagePayload payload = new MessagePayload(TCByteBufferFactory.getInstance((int)0), null, 0, 0, true, true);
        payload.setDebugId("EMPTY");
        return payload;
    }

    public static final MessagePayload rawDataOnly(TCByteBuffer raw) {
        MessagePayload payload = new MessagePayload(raw, null, 0, 0, false, false);
        payload.setDebugId("RAW");
        return payload;
    }

    public static final MessagePayload commonMessagePayload(TCByteBuffer raw, EntityMessage message, boolean replicate, boolean allowBusy) {
        return new MessagePayload(raw, message, 0, 0, replicate, allowBusy);
    }

    public static final MessagePayload commonMessagePayloadBusy(TCByteBuffer raw, EntityMessage message, boolean replicate) {
        return new MessagePayload(raw, message, 0, 0, replicate, true);
    }

    public static final MessagePayload commonMessagePayloadNotBusy(TCByteBuffer raw, EntityMessage message, boolean replicate) {
        return new MessagePayload(raw, message, 0, 0, replicate, false);
    }

    public static final MessagePayload syncPayloadNormal(TCByteBuffer raw, int concurrencyKey) {
        return new MessagePayload(raw, null, concurrencyKey, 0, false, false);
    }

    public static final MessagePayload syncPayloadCreation(TCByteBuffer raw, int referenceCount) {
        return new MessagePayload(raw, null, 0, referenceCount, false, false);
    }

    private MessagePayload(TCByteBuffer raw, EntityMessage message, int concurrency, int referenceCount, boolean replicate, boolean canBeBusy) {
        this.raw = raw == null || raw.isReadOnly() ? raw : raw.asReadOnlyBuffer();
        this.message = message;
        this.debugId = null;
        this.concurrency = concurrency;
        this.referenceCount = referenceCount;
        this.replicate = replicate;
        this.canBeBusy = canBeBusy;
    }

    private byte[] convertRawToBytes() {
        return TCByteBufferFactory.unwrap((TCByteBuffer)this.raw);
    }

    public byte[] getRawPayload() {
        return this.convertRawToBytes();
    }

    public TCByteBuffer getByteBufferPayload() {
        return this.raw.duplicate();
    }

    public void setDebugId(String debugId) {
        this.debugId = debugId;
    }

    public String getDebugId() {
        if (this.debugId == null && this.message != null) {
            this.debugId = this.message.toString();
        }
        return this.debugId;
    }

    public boolean canBeBusy() {
        return this.canBeBusy;
    }

    public EntityMessage decodeMessage(MessageDecoder codec) throws MessageCodecException {
        if (this.exception != null) {
            throw this.exception;
        }
        try {
            if (this.message == null) {
                this.message = codec.decode(this.convertRawToBytes());
            }
            return this.message;
        }
        catch (MessageCodecException ce) {
            this.exception = ce;
            throw this.exception;
        }
        catch (Exception e) {
            this.exception = new MessageCodecException("error decoding message", (Throwable)e);
            throw this.exception;
        }
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public Class<?> getType() {
        return this.message != null ? this.message.getClass() : null;
    }

    public boolean shouldReplicate() {
        return this.replicate;
    }

    public String toString() {
        return "MessagePayload{debugId=" + this.getDebugId() + '}';
    }
}

