/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.async.api.DirectExecutionMode;
import com.tc.async.api.Sink;
import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.classloader.TemporaryEntity;
import com.tc.entity.VoltronEntityMessage;
import com.tc.exception.ServerException;
import com.tc.exception.ServerRuntimeException;
import com.tc.exception.TCServerRestartException;
import com.tc.exception.TCShutdownServerException;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.net.ClientID;
import com.tc.net.utils.L2Utils;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.api.ManagementKeyCallback;
import com.tc.objectserver.api.ResultCapture;
import com.tc.objectserver.api.Retiree;
import com.tc.objectserver.api.ServerEntityAction;
import com.tc.objectserver.api.ServerEntityRequest;
import com.tc.objectserver.api.StatisticsCapture;
import com.tc.objectserver.core.impl.GuardianContext;
import com.tc.objectserver.core.impl.ManagementTopologyEventCollector;
import com.tc.objectserver.entity.ActiveInvokeContextImpl;
import com.tc.objectserver.entity.ActivePassiveAckWaiter;
import com.tc.objectserver.entity.BarrierCompletion;
import com.tc.objectserver.entity.ClientDescriptorImpl;
import com.tc.objectserver.entity.ClientEntityStateManager;
import com.tc.objectserver.entity.ClientSourceIdImpl;
import com.tc.objectserver.entity.DestroyMessage;
import com.tc.objectserver.entity.InvokeContextImpl;
import com.tc.objectserver.entity.LocalPipelineFlushMessage;
import com.tc.objectserver.entity.ManagedEntitySyncInterop;
import com.tc.objectserver.entity.MessagePayload;
import com.tc.objectserver.entity.ReferenceMessage;
import com.tc.objectserver.entity.RequestProcessor;
import com.tc.objectserver.entity.ResultCaptureImpl;
import com.tc.objectserver.entity.ServerEntityRequestImpl;
import com.tc.objectserver.handler.RetirementManager;
import com.tc.properties.TCPropertiesImpl;
import com.tc.services.InternalServiceRegistry;
import com.tc.services.MappedStateCollector;
import com.tc.spi.Guardian;
import com.tc.tracing.Trace;
import com.tc.util.Assert;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.ClientSourceId;
import org.terracotta.entity.ConcurrencyStrategy;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.EntityServerService;
import org.terracotta.entity.EntityUserException;
import org.terracotta.entity.ExecutionStrategy;
import org.terracotta.entity.InvokeContext;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.entity.PassiveServerEntity;
import org.terracotta.entity.PassiveSynchronizationChannel;
import org.terracotta.entity.ReconnectRejectedException;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.entity.StateDumpCollector;
import org.terracotta.entity.SyncMessageCodec;
import org.terracotta.tripwire.Event;
import org.terracotta.tripwire.TripwireFactory;

public class ManagedEntityImpl
implements ManagedEntity {
    private static final Logger logger = LoggerFactory.getLogger(ManagedEntityImpl.class);
    private final RequestProcessor executor;
    private final RetirementManager retirementManager;
    private final EntityID id;
    private final FetchID fetchID;
    private final long version;
    private final long consumerID;
    private final InternalServiceRegistry registry;
    private final Sink<VoltronEntityMessage> messageSelf;
    private final ClientEntityStateManager clientEntityStateManager;
    private final ManagementTopologyEventCollector eventCollector;
    private final EntityServerService<EntityMessage, EntityResponse> factory;
    private final ManagementKeyCallback flushLocalPipeline;
    private boolean isInActiveState;
    private int clientReferenceCount = 0;
    private final boolean canDelete;
    private final boolean isTemp;
    private volatile boolean isDestroyed;
    private final List<ManagedEntity.LifecycleListener> createListener = new CopyOnWriteArrayList<ManagedEntity.LifecycleListener>();
    private final MessageCodec<EntityMessage, EntityResponse> codec;
    private final SyncMessageCodec<EntityMessage> syncCodec;
    private volatile ActiveServerEntity<EntityMessage, EntityResponse> activeServerEntity;
    private volatile ConcurrencyStrategy<EntityMessage> concurrencyStrategy;
    private volatile ExecutionStrategy<EntityMessage> executionStrategy;
    private volatile ActiveServerEntity.ReconnectHandler reconnect;
    private final DefermentQueue<SchedulingRunnable> runnables = new DefermentQueue(TCPropertiesImpl.getProperties().getInt("server.entity.deferment.queue.size", 1024));
    private volatile PassiveServerEntity<EntityMessage, EntityResponse> passiveServerEntity;
    private final ReadWriteLock reconnectAccessLock = new ReentrantReadWriteLock();
    private final ManagedEntitySyncInterop interop = new ManagedEntitySyncInterop();
    private byte[] constructorInfo;

    ManagedEntityImpl(EntityID id, long version, long consumerID, ManagementKeyCallback flushLocalPipeline, InternalServiceRegistry registry, ClientEntityStateManager clientEntityStateManager, ManagementTopologyEventCollector eventCollector, Sink<VoltronEntityMessage> msg, RequestProcessor process, EntityServerService<EntityMessage, EntityResponse> factory, boolean isInActiveState, boolean canDelete) {
        this.id = id;
        this.isDestroyed = true;
        this.version = version;
        this.consumerID = consumerID;
        this.fetchID = new FetchID(consumerID);
        this.flushLocalPipeline = flushLocalPipeline;
        this.registry = registry;
        this.messageSelf = msg;
        Assert.assertNotNull(this.messageSelf);
        this.clientEntityStateManager = clientEntityStateManager;
        this.eventCollector = eventCollector;
        this.factory = factory;
        this.isTemp = this.factory.getClass().isAnnotationPresent(TemporaryEntity.class);
        this.executor = process;
        this.retirementManager = new RetirementManager();
        this.isInActiveState = isInActiveState;
        this.canDelete = canDelete;
        this.clientReferenceCount = canDelete ? 0 : -1;
        registry.setOwningEntity(this);
        this.codec = factory.getMessageCodec();
        this.syncCodec = factory.getSyncMessageCodec();
    }

    @Override
    public EntityID getID() {
        return this.id;
    }

    @Override
    public boolean isCompatibleEntity(EntityID type) {
        return this.factory.handlesEntityType(type.getClassName()) && type.getEntityName().equals(this.id.getEntityName());
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    private void notifyEntityCreated() {
        ActiveServerEntity<EntityMessage, EntityResponse> entity = this.isInActiveState ? this.activeServerEntity : this.passiveServerEntity;
        this.createListener.forEach(l -> l.entityCreated(this));
    }

    private void notifyEntityDestroyed() {
        ActiveServerEntity<EntityMessage, EntityResponse> entity = this.isInActiveState ? this.activeServerEntity : this.passiveServerEntity;
        this.createListener.forEach(l -> l.entityDestroyed(this));
        this.createListener.clear();
    }

    @Override
    public void addRequestMessage(ServerEntityRequest request, MessagePayload data, ResultCapture resp) {
        if (logger.isDebugEnabled()) {
            logger.debug("add req: {} id: {} fetch: {} client:{}-{}", new Object[]{request.getAction(), this.id, this.fetchID, request.getNodeID(), request.getTransaction()});
        }
        Trace.activeTrace().log("ManagedEntityImpl.addRequestMessage");
        switch (request.getAction()) {
            case LOCAL_FLUSH: 
            case ORDER_PLACEHOLDER_ONLY: 
            case MANAGED_ENTITY_GC: 
            case FAILOVER_FLUSH: {
                this.processLegacyNoopMessage(request, resp);
                break;
            }
            case LOCAL_FLUSH_AND_SYNC: {
                Assert.fail((String)((Object)((Object)request.getAction()) + " should be filtered before reaching this point"));
                resp = null;
                break;
            }
            case CREATE_ENTITY: 
            case DESTROY_ENTITY: 
            case FETCH_ENTITY: 
            case RECONFIGURE_ENTITY: 
            case RELEASE_ENTITY: 
            case DISCONNECT_CLIENT: {
                this.processLifecycleEntity(request, data, resp);
                break;
            }
            case INVOKE_ACTION: {
                this.processInvokeRequest(request, resp, data, data.getConcurrency());
                break;
            }
            case RECEIVE_SYNC_CREATE_ENTITY: {
                Assert.assertTrue((!this.isInActiveState ? 1 : 0) != 0);
                this.processSyncCreateMessage(request, resp, data);
                break;
            }
            case RECEIVE_SYNC_ENTITY_START_SYNCING: 
            case RECEIVE_SYNC_ENTITY_END: {
                Assert.assertTrue((!this.isInActiveState ? 1 : 0) != 0);
                this.processSyncStartEndMessage(request, resp, data);
                break;
            }
            case RECEIVE_SYNC_ENTITY_KEY_START: 
            case RECEIVE_SYNC_ENTITY_KEY_END: 
            case RECEIVE_SYNC_PAYLOAD: {
                Assert.assertTrue((!this.isInActiveState ? 1 : 0) != 0);
                this.processSyncPayloadOtherMessage(request, resp, data, data.getConcurrency());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown request " + request);
            }
        }
    }

    private void processLifecycleEntity(ServerEntityRequest create, MessagePayload data, ResultCapture resp) {
        Trace.activeTrace().log("ManagedEntityImpl.processLifecycleEntity");
        boolean schedule = true;
        if (this.isInActiveState) {
            switch (create.getAction()) {
                case CREATE_ENTITY: 
                case DESTROY_ENTITY: 
                case RECONFIGURE_ENTITY: {
                    if (data.canBeBusy()) {
                        schedule = this.interop.tryStartLifecycle();
                        break;
                    }
                    this.interop.startLifecycle();
                    break;
                }
                case FETCH_ENTITY: 
                case RELEASE_ENTITY: 
                case DISCONNECT_CLIENT: {
                    if (data.canBeBusy()) {
                        schedule = this.interop.tryStartReference();
                        break;
                    }
                    this.interop.startReference();
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unexpected");
                }
            }
        }
        if (schedule) {
            this.scheduleInOrder(create, resp, data, () -> this.invokeLifecycleOperation(create, data, resp), 0);
        } else {
            if (!this.isActive()) {
                throw new AssertionError();
            }
            resp.failure(ServerException.createBusyException((EntityID)this.id));
        }
    }

    private void processLegacyNoopMessage(ServerEntityRequest request, ResultCapture resp) {
        int key = request.getAction() == ServerEntityAction.FAILOVER_FLUSH ? 0 : Integer.MIN_VALUE;
        this.scheduleInOrder(request, resp, MessagePayload.emptyPayload(), resp::complete, key);
    }

    private synchronized SchedulingRunnable scheduleInOrder(ServerEntityRequest request, ResultCapture results, MessagePayload payload, Runnable r, int ckey) {
        Trace.activeTrace().log("ManagedEntityImpl.scheduleInOrder");
        if (!DirectExecutionMode.isActivated()) {
            if (this.isInActiveState) {
                Assert.assertTrue((boolean)Thread.currentThread().getName().contains("voltron_message_stage"));
            } else {
                Assert.assertTrue((Thread.currentThread().getName().contains("passive_replication_stage") || Thread.currentThread().getName().contains("l2_state_change_stage") ? 1 : 0) != 0);
            }
        }
        SchedulingRunnable next = new SchedulingRunnable(request, payload, r, ckey);
        if (logger.isDebugEnabled()) {
            logger.debug("Scheduling action: {} entity: {}-{} from {}-{} ({})", new Object[]{next.request.getAction(), this.getID(), this.getConsumerID(), request.getNodeID(), request.getTransaction(), request.getTraceID()});
        }
        if (this.isActive()) {
            results.setWaitFor(() -> next.waitForPassives());
        }
        for (SchedulingRunnable msg : this.runnables) {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting action: {} entity: {}-{} from {}-{} ({})", new Object[]{next.request.getAction(), this.getID(), this.getConsumerID(), request.getNodeID(), request.getTransaction(), request.getTraceID()});
            }
            msg.start();
        }
        if (!this.runnables.offer(next)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting Offered action: {} entity: {}-{} from {}-{} ({})", new Object[]{next.request.getAction(), this.getID(), this.getConsumerID(), request.getNodeID(), request.getTransaction(), request.getTraceID()});
            }
            Assert.assertTrue((Object)next, (this.runnables.isEmpty() && ((DefermentQueue)this.runnables).deferCleared ? 1 : 0) != 0);
            next.start();
        }
        return next;
    }

    @Override
    public synchronized boolean clearQueue() {
        while (!this.runnables.isEmpty()) {
            SchedulingRunnable sr = this.runnables.checkDeferred();
            if (sr != null) {
                sr.start();
            }
            ((DefermentQueue)this.runnables).pause();
        }
        return true;
    }

    private void processInvokeRequest(ServerEntityRequest request, ResultCapture response, MessagePayload message, int key) {
        Trace.activeTrace().log("ManagedEntityImpl.processInvokeRequest");
        if (this.isInActiveState) {
            try {
                key = this.concurrencyStrategy.concurrencyKey(message.decodeMessage(raw -> this.codec.decodeMessage(raw)));
            }
            catch (MessageCodecException codec) {
                key = Integer.MIN_VALUE;
            }
        }
        int locked = key;
        if (response instanceof StatisticsCapture) {
            ((StatisticsCapture)((Object)response)).schedule();
        }
        this.scheduleInOrder(request, response, message, () -> this.invoke(request, response, message, locked), locked);
    }

    private void processSyncCreateMessage(ServerEntityRequest sync, ResultCapture response, MessagePayload syncPayload) {
        ServerEntityAction action = sync.getAction();
        Assert.assertTrue((action == ServerEntityAction.RECEIVE_SYNC_CREATE_ENTITY ? 1 : 0) != 0);
        this.scheduleInOrder(sync, response, syncPayload, () -> this.invokeLifecycleOperation(sync, syncPayload, response), 0);
    }

    private void processSyncStartEndMessage(ServerEntityRequest sync, ResultCapture response, MessagePayload syncPayload) {
        ServerEntityAction action = sync.getAction();
        Assert.assertTrue((action == ServerEntityAction.RECEIVE_SYNC_ENTITY_START_SYNCING || action == ServerEntityAction.RECEIVE_SYNC_ENTITY_END ? 1 : 0) != 0);
        this.scheduleInOrder(sync, response, syncPayload, () -> this.invokeLifecycleOperation(sync, syncPayload, response), 0);
    }

    private void processSyncPayloadOtherMessage(ServerEntityRequest sync, ResultCapture response, MessagePayload syncPayload, int concurrencyKey) {
        ServerEntityAction action = sync.getAction();
        Assert.assertTrue((action != ServerEntityAction.RECEIVE_SYNC_CREATE_ENTITY ? 1 : 0) != 0);
        Assert.assertTrue((action != ServerEntityAction.RECEIVE_SYNC_ENTITY_START_SYNCING ? 1 : 0) != 0);
        Assert.assertTrue((action != ServerEntityAction.RECEIVE_SYNC_ENTITY_END ? 1 : 0) != 0);
        if (action == ServerEntityAction.RECEIVE_SYNC_PAYLOAD) {
            this.scheduleInOrder(sync, response, syncPayload, () -> this.invoke(sync, response, syncPayload, concurrencyKey), concurrencyKey);
        } else {
            this.scheduleInOrder(sync, response, syncPayload, () -> this.invoke(sync, response, null, concurrencyKey), concurrencyKey);
        }
    }

    @Override
    public Map<String, Object> getState() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("fetchID", this.fetchID.toString());
        props.put("entityID", this.id.toString());
        props.put("consumerID", this.consumerID);
        props.put("referenceCount", this.clientReferenceCount);
        props.put("waitForExclusive", ((DefermentQueue)this.runnables).getState());
        props.put("retirement", this.retirementManager.getState());
        props.put("destroyed", this.isDestroyed);
        props.put("active", this.isInActiveState);
        props.put("removeable", this.isRemoveable());
        MappedStateCollector mapped = new MappedStateCollector(this.id.getEntityName());
        try {
            if (this.activeServerEntity != null) {
                this.activeServerEntity.addStateTo((StateDumpCollector)mapped);
            }
            if (this.passiveServerEntity != null) {
                this.passiveServerEntity.addStateTo((StateDumpCollector)mapped);
            }
        }
        catch (Throwable t) {
            logger.warn("unable to collect state for " + this.getID(), t);
            props.put("unable to collect state for " + this.getID(), t.getLocalizedMessage());
        }
        props.put("entityState", mapped.getMap());
        return props;
    }

    private byte[] encodeResponse(EntityResponse payload, ResultCapture capture) {
        try {
            return payload == null ? new byte[]{} : this.codec.encodeResponse(payload);
        }
        catch (MessageCodecException ce) {
            capture.failure(ServerException.createMessageCodecException((EntityID)this.id, (MessageCodecException)ce));
            return null;
        }
    }

    private EntityMessage decodeMessage(MessagePayload payload, ResultCapture capture) {
        try {
            return payload.decodeMessage(r -> this.codec.decodeMessage(r));
        }
        catch (MessageCodecException ce) {
            capture.failure(ServerException.createMessageCodecException((EntityID)this.id, (MessageCodecException)ce));
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void invokeLifecycleOperation(ServerEntityRequest request, MessagePayload payload, ResultCapture resp) {
        trace = new Trace(request.getTraceID(), "ManagedEntityImpl.invokeLifecycleOperation");
        trace.start();
        read = this.reconnectAccessLock.readLock();
        ManagedEntityImpl.logger.info("Client:" + request.getNodeID() + ":" + request.getClientInstance() + " Invoking lifecycle " + (Object)request.getAction() + " on " + this.getID() + ":" + this.fetchID);
        GuardianContext.setCurrentChannelID(request.getNodeID().getChannelID());
        read.lock();
        try {
            switch (2.$SwitchMap$com$tc$objectserver$api$ServerEntityAction[request.getAction().ordinal()]) {
                case 6: {
                    if (!GuardianContext.validate(Guardian.Op.ENTITY_CREATE, this.getID().getClassName() + ":" + this.getID().getEntityName())) {
                        resp.failure(ServerException.createPermissionDenied((EntityID)this.getID()));
                        ** break;
lbl13:
                        // 1 sources

                    } else {
                        this.createEntity(resp, payload.getRawPayload());
                        ** break;
                    }
lbl16:
                    // 1 sources

                    break;
                }
                case 8: {
                    if (!GuardianContext.validate(Guardian.Op.ENTITY_FETCH, this.getID().getClassName() + ":" + this.getID().getEntityName())) {
                        resp.failure(ServerException.createPermissionDenied((EntityID)this.getID()));
                        ** break;
lbl21:
                        // 1 sources

                    } else {
                        this.getEntity(request, resp, payload.getRawPayload());
                        ** break;
                    }
lbl24:
                    // 1 sources

                    break;
                }
                case 10: {
                    this.releaseEntity(request, resp);
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                case 9: {
                    if (!GuardianContext.validate(Guardian.Op.ENTITY_RECONFIGURE, this.getID().getClassName() + ":" + this.getID().getEntityName())) {
                        resp.failure(ServerException.createPermissionDenied((EntityID)this.getID()));
                        ** break;
lbl33:
                        // 1 sources

                    } else {
                        this.reconfigureEntity(resp, payload.getRawPayload());
                        ** break;
                    }
lbl36:
                    // 1 sources

                    break;
                }
                case 7: {
                    if (!GuardianContext.validate(Guardian.Op.ENTITY_DESTROY, this.getID().getClassName() + ":" + this.getID().getEntityName())) {
                        resp.failure(ServerException.createPermissionDenied((EntityID)this.getID()));
                        ** break;
lbl41:
                        // 1 sources

                    } else {
                        this.destroyEntity(request, resp);
                        ** break;
                    }
lbl44:
                    // 1 sources

                    break;
                }
                case 13: {
                    this.resetReferences(payload.getReferenceCount());
                    this.receiveSyncCreateEntity(resp, payload.getRawPayload());
                    ** break;
lbl49:
                    // 1 sources

                    break;
                }
                case 14: {
                    resp.complete();
                    this.receiveSyncEntityStartSyncing();
                    ** break;
lbl54:
                    // 1 sources

                    break;
                }
                case 15: {
                    this.receiveSyncEntityEnd(resp);
                    ** break;
lbl58:
                    // 1 sources

                    break;
                }
                case 11: {
                    this.disconnectClientFromEntity(request.getNodeID());
                    resp.complete();
                    ** break;
lbl63:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown request " + request);
                }
            }
        }
        catch (ConfigurationException ce) {
            ManagedEntityImpl.logger.error("configuration error during a lifecyle operation ", (Throwable)ce);
            resp.failure(ServerException.createConfigurationException((EntityID)this.id, (Exception)ce));
        }
        catch (TCServerRestartException | TCShutdownServerException shutdown) {
            throw shutdown;
        }
        catch (RuntimeException rt) {
            throw rt;
        }
        catch (Exception e) {
            uncaught = ServerRuntimeException.createServerUncaught((EntityID)this.getID(), (Exception)e);
            ManagedEntityImpl.logger.error("caught exception during invoke ", (Throwable)uncaught);
            throw uncaught;
        }
        finally {
            read.unlock();
            GuardianContext.clearCurrentChannelID(request.getNodeID().getChannelID());
            if (this.isInActiveState) {
                this.interop.finishLifecycle();
            }
        }
        trace.end();
    }

    private void disconnectClientFromEntity(ClientID cid) {
        if (this.isActive()) {
            this.activeServerEntity.notifyDestroyed((ClientSourceId)new ClientSourceIdImpl(cid.toLong()));
            List<EntityDescriptor> eds = this.clientEntityStateManager.clientDisconnectedFromEntity(cid, this.fetchID);
            this.eventCollector.clientDisconnectedFromEntity(cid, this.fetchID, eds);
            eds.forEach(ed -> this.messageSelf.addToSink((Object)new ReferenceMessage(cid, false, (EntityDescriptor)ed, TCByteBufferFactory.getInstance((int)0))));
        } else {
            this.passiveServerEntity.notifyDestroyed((ClientSourceId)new ClientSourceIdImpl(cid.toLong()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void invoke(ServerEntityRequest request, ResultCapture response, MessagePayload message, int concurrencyKey) {
        trace = new Trace(request.getTraceID(), "ManagedEntityImpl.invoke");
        trace.start();
        response.received();
        GuardianContext.setCurrentChannelID(request.getNodeID().getChannelID());
        read = this.reconnectAccessLock.readLock();
        try {
            read.lock();
            if (ManagedEntityImpl.logger.isDebugEnabled()) {
                ManagedEntityImpl.logger.debug((Object)request.getAction() + " on " + this.getID() + "/" + concurrencyKey + " with " + message);
            }
            switch (2.$SwitchMap$com$tc$objectserver$api$ServerEntityAction[request.getAction().ordinal()]) {
                case 12: {
                    Optional.ofNullable(this.decodeMessage(message, response)).ifPresent((Consumer<EntityMessage>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$invoke$12(com.tc.objectserver.api.ServerEntityRequest com.tc.objectserver.api.ResultCapture int org.terracotta.entity.EntityMessage ), (Lorg/terracotta/entity/EntityMessage;)V)((ManagedEntityImpl)this, (ServerEntityRequest)request, (ResultCapture)response, (int)concurrencyKey));
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                case 19: {
                    this.performSync(response, request.replicateTo(Collections.emptySet()), concurrencyKey);
                    ** break;
lbl18:
                    // 1 sources

                    break;
                }
                case 16: {
                    this.receiveSyncEntityKeyStart(response, concurrencyKey);
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                case 17: {
                    this.receiveSyncEntityKeyEnd(response, concurrencyKey);
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                case 18: {
                    this.receiveSyncEntityPayload(response, message);
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    throw new IllegalArgumentException("Flow-only request observed in invoke path: " + request);
                }
                default: {
                    throw new IllegalArgumentException("Unknown request " + request);
                }
            }
        }
        catch (RuntimeException rt) {
            throw rt;
        }
        catch (Exception e) {
            ManagedEntityImpl.logger.error("caught exception during invoke ", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            read.unlock();
            GuardianContext.clearCurrentChannelID(request.getNodeID().getChannelID());
        }
        trace.end();
    }

    private void receiveSyncCreateEntity(ResultCapture response, byte[] constructor) {
        Assert.assertNull((Object)("passiveServerEntity should be null for entity " + this.getID()), this.passiveServerEntity);
        try {
            this.createEntity(response, constructor);
        }
        catch (ConfigurationException ce) {
            String errMsg = "unable to create an entity " + this.getID() + " on passive sync ";
            logger.error(errMsg, (Throwable)ce);
            throw new TCShutdownServerException(errMsg, (Throwable)ce);
        }
    }

    private void receiveSyncEntityStartSyncing() {
        Assert.assertNotNull(this.passiveServerEntity);
        this.passiveServerEntity.startSyncEntity();
    }

    private void receiveSyncEntityEnd(ResultCapture response) {
        Assert.assertNotNull(this.passiveServerEntity);
        this.passiveServerEntity.endSyncEntity();
        response.complete();
        Assert.assertFalse((boolean)this.isInActiveState);
    }

    private void receiveSyncEntityKeyStart(ResultCapture response, int concurrencyKey) {
        Assert.assertNotNull(this.passiveServerEntity);
        this.passiveServerEntity.startSyncConcurrencyKey(concurrencyKey);
        response.complete();
        Assert.assertFalse((boolean)this.isInActiveState);
    }

    private void receiveSyncEntityKeyEnd(ResultCapture response, int concurrencyKey) {
        Assert.assertNotNull(this.passiveServerEntity);
        this.passiveServerEntity.endSyncConcurrencyKey(concurrencyKey);
        response.complete();
        Assert.assertFalse((boolean)this.isInActiveState);
    }

    private void receiveSyncEntityPayload(ResultCapture response, MessagePayload message) {
        Assert.assertNotNull(this.passiveServerEntity);
        try {
            this.passiveServerEntity.invokePassive((InvokeContext)new InvokeContextImpl(message.getConcurrency()), message.decodeMessage(raw -> this.syncCodec.decode(message.getConcurrency(), raw)));
        }
        catch (EntityUserException | MessageCodecException e) {
            logger.error("Caught EntityUserException during sync invoke", e);
            throw new RuntimeException("Caught EntityUserException during sync invoke", e);
        }
        response.complete();
        Assert.assertFalse((boolean)this.isInActiveState);
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    @Override
    public boolean isActive() {
        return this.isInActiveState;
    }

    @Override
    public synchronized boolean isRemoveable() {
        return this.isDestroyed && this.runnables.isEmpty() && ((DefermentQueue)this.runnables).deferCleared;
    }

    @Override
    public boolean canDelete() {
        return this.canDelete;
    }

    private void destroyEntity(ServerEntityRequest request, ResultCapture response) throws ConfigurationException {
        ActiveServerEntity<EntityMessage, EntityResponse> commonServerEntity = this.isInActiveState ? this.activeServerEntity : this.passiveServerEntity;
        EntityDescriptor entityDescriptor = EntityDescriptor.createDescriptorForLifecycle((EntityID)this.id, (long)this.version);
        if (this.isDestroyed) {
            response.failure(ServerException.createNotFoundException((EntityID)this.id));
        } else if (null != commonServerEntity) {
            if (!this.canDelete) {
                Assert.assertTrue((this.clientReferenceCount < 0 ? 1 : 0) != 0);
                response.failure(ServerException.createPermanentException((EntityID)this.id));
            } else if (this.clientReferenceCount == 0 && !this.retirementManager.hasServerInflightMessages()) {
                Assert.assertTrue((!this.isInActiveState || this.clientEntityStateManager.verifyNoEntityReferences(this.fetchID) ? 1 : 0) != 0);
                Assert.assertFalse((boolean)this.isDestroyed);
                try {
                    commonServerEntity.destroy();
                }
                catch (RuntimeException re) {
                    response.failure(ServerException.createEntityUserException((EntityID)this.id, (EntityUserException)new EntityUserException("error during destroy", (Throwable)re)));
                    return;
                }
                this.retirementManager.entityWasDestroyed();
                this.notifyEntityDestroyed();
                if (this.isInActiveState) {
                    this.activeServerEntity = null;
                } else {
                    this.passiveServerEntity = null;
                }
                this.isDestroyed = true;
                this.eventCollector.entityWasDestroyed(this.id, this.consumerID);
                response.complete();
            } else {
                if (this.isInActiveState) {
                    Assert.assertTrue((Object)("retirementManager:" + this.retirementManager.hasServerInflightMessages() + " references:" + this.clientEntityStateManager.verifyNoEntityReferences(this.fetchID)), (this.clientReferenceCount > 0 || this.retirementManager.hasServerInflightMessages() || !this.clientEntityStateManager.verifyNoEntityReferences(this.fetchID) ? 1 : 0) != 0);
                }
                response.failure(ServerException.createReferencedException((EntityID)this.id));
            }
        }
    }

    private void reconfigureEntity(ResultCapture reconfigureEntityRequest, byte[] constructorInfo) throws ConfigurationException {
        byte[] oldconfig = this.constructorInfo;
        if (this.isDestroyed || this.activeServerEntity == null && this.passiveServerEntity == null) {
            reconfigureEntityRequest.failure(ServerException.createNotFoundException((EntityID)this.id));
            return;
        }
        this.notifyEntityDestroyed();
        if (this.isInActiveState) {
            if (null == this.activeServerEntity) {
                throw new IllegalStateException("Active entity " + this.id + " does not exists.");
            }
            this.activeServerEntity = (ActiveServerEntity)this.factory.reconfigureEntity((ServiceRegistry)this.registry, this.activeServerEntity, constructorInfo);
            this.concurrencyStrategy = this.factory.getConcurrencyStrategy(constructorInfo);
            this.executionStrategy = this.factory.getExecutionStrategy(constructorInfo);
        } else {
            if (null == this.passiveServerEntity) {
                throw new IllegalStateException("Passive entity " + this.id + " does not exists.");
            }
            this.passiveServerEntity = (PassiveServerEntity)this.factory.reconfigureEntity((ServiceRegistry)this.registry, this.passiveServerEntity, constructorInfo);
            Assert.assertNull(this.concurrencyStrategy);
            Assert.assertNull(this.executionStrategy);
        }
        this.constructorInfo = constructorInfo;
        this.notifyEntityCreated();
        reconfigureEntityRequest.complete(oldconfig);
        this.eventCollector.entityWasReloaded(this.getID(), this.consumerID, this.isInActiveState);
    }

    private void createEntity(ResultCapture response, byte[] constructorInfo) throws ConfigurationException {
        Trace.activeTrace().log("ManagedEntityImpl.createEntity");
        if (!(this.isDestroyed || this.activeServerEntity == null && this.passiveServerEntity == null)) {
            response.failure(ServerException.createEntityExists((EntityID)this.id));
            return;
        }
        this.constructorInfo = constructorInfo;
        if (this.isInActiveState) {
            if (null != this.activeServerEntity) {
                throw new IllegalStateException("Active entity " + this.id + " already exists.");
            }
            ActiveServerEntity tmpEntity = this.factory.createActiveEntity((ServiceRegistry)this.registry, this.constructorInfo);
            tmpEntity.createNew();
            this.activeServerEntity = tmpEntity;
            this.concurrencyStrategy = this.factory.getConcurrencyStrategy(constructorInfo);
            this.executionStrategy = this.factory.getExecutionStrategy(constructorInfo);
        } else {
            if (null != this.passiveServerEntity) {
                throw new IllegalStateException("Passive entity " + this.id + " already exists.");
            }
            PassiveServerEntity tmpEntity = this.factory.createPassiveEntity((ServiceRegistry)this.registry, this.constructorInfo);
            tmpEntity.createNew();
            this.passiveServerEntity = tmpEntity;
            Assert.assertNull(this.concurrencyStrategy);
        }
        this.notifyEntityCreated();
        this.isDestroyed = false;
        this.eventCollector.entityWasCreated(this.id, this.consumerID, this.isInActiveState);
        response.complete();
    }

    private void performSync(ResultCapture response, Set<SessionID> passives, int concurrencyKey) {
        if (!this.isDestroyed) {
            if (this.isInActiveState) {
                if (null == this.activeServerEntity) {
                    throw new IllegalStateException("Actions on a non-existent entity.");
                }
                EntityMessagePassiveSynchronizationChannelImpl syncChannel = new EntityMessagePassiveSynchronizationChannelImpl(passives, concurrencyKey, false);
                this.activeServerEntity.synchronizeKeyToPassive((PassiveSynchronizationChannel)syncChannel, concurrencyKey);
            } else {
                throw new IllegalStateException("syncing a passive entity");
            }
        }
        response.complete();
    }

    private void performAction(final ServerEntityRequest wrappedRequest, EntityMessage message, final ResultCapture response, int concurrencyKey) {
        block14: {
            Trace.activeTrace().log("ManagedEntityImpl.performAction");
            Assert.assertNotNull((Object)message);
            ClientDescriptorImpl clientDescriptor = new ClientDescriptorImpl(wrappedRequest.getNodeID(), wrappedRequest.getClientInstance());
            long currentId = wrappedRequest.getTransaction().toLong();
            long oldestId = wrappedRequest.getOldestTransactionOnClient().toLong();
            if (Trace.isTraceEnabled()) {
                Trace.activeTrace().log("invoking " + message);
            }
            if (this.isInActiveState) {
                if (null == this.activeServerEntity) {
                    throw new IllegalStateException("Actions on a non-existent entity. active:" + this.isActive() + " " + message.toString());
                }
                this.retirementManager.registerWithMessage(message, concurrencyKey, new Retiree(){

                    @Override
                    public CompletionStage<Void> retired() {
                        return response.retired();
                    }

                    @Override
                    public TransactionID getTransaction() {
                        return wrappedRequest.getTransaction();
                    }

                    @Override
                    public String getTraceID() {
                        return wrappedRequest.getTraceID();
                    }
                });
                try {
                    ExecutionStrategy.Location loc = this.executionStrategy.getExecutionLocation(message);
                    if (loc.runOnActive()) {
                        if (wrappedRequest.requiresReceived()) {
                            response.waitForReceived();
                        }
                        if (response instanceof StatisticsCapture) {
                            ((StatisticsCapture)((Object)response)).beginInvoke();
                        }
                        Trace trace = Trace.activeTrace().subTrace("invokeActive");
                        trace.start();
                        EntityResponse resp = this.activeServerEntity.invokeActive(new ActiveInvokeContextImpl<EntityResponse>(clientDescriptor, concurrencyKey, oldestId, currentId, () -> this.retirementManager.holdMessage(message), r -> response.message(this.decodeResponse((EntityResponse)r)), e -> response.failure(this.convertException(this.getID(), (Exception)e)), () -> {
                            if (this.retirementManager.releaseMessage(message)) {
                                this.retirementManager.retireMessage(message);
                            }
                        }), message);
                        byte[] er = this.encodeResponse(resp, response);
                        trace.end();
                        if (er != null) {
                            response.complete(er);
                        }
                        if (response instanceof StatisticsCapture) {
                            ((StatisticsCapture)((Object)response)).endInvoke();
                        }
                        this.retirementManager.retireMessage(message);
                        break block14;
                    }
                    response.complete(new byte[0]);
                    this.retirementManager.retireMessage(message);
                }
                catch (EntityUserException e2) {
                    logger.error("Caught EntityUserException during invoke", (Throwable)e2);
                    response.failure(ServerException.createEntityUserException((EntityID)this.id, (EntityUserException)e2));
                    this.retirementManager.retireMessage(message);
                }
            } else {
                if (null == this.passiveServerEntity) {
                    throw new IllegalStateException("Actions on a non-existent entity. active:" + this.isActive() + " " + message.toString());
                }
                try {
                    Trace trace = Trace.activeTrace().subTrace("invokePassive");
                    trace.start();
                    this.passiveServerEntity.invokePassive((InvokeContext)new InvokeContextImpl(new ClientSourceIdImpl(wrappedRequest.getNodeID().toLong()), concurrencyKey, oldestId, currentId), message);
                    trace.end();
                }
                catch (EntityUserException e3) {
                    logger.error("Caught EntityUserException during invoke", (Throwable)e3);
                }
                response.complete();
                Assert.assertFalse((boolean)this.isInActiveState);
            }
        }
    }

    public MessageCodec<?, ?> getCodec() {
        return this.codec;
    }

    @Override
    public RetirementManager getRetirementManager() {
        return this.retirementManager;
    }

    private ServerException convertException(EntityID eid, Exception e) {
        if (e instanceof ServerException) {
            return (ServerException)((Object)e);
        }
        return ServerException.wrapException((EntityID)this.id, (Exception)e);
    }

    private byte[] decodeResponse(EntityResponse response) {
        try {
            return this.codec.encodeResponse(response);
        }
        catch (MessageCodecException ce) {
            throw new RuntimeException(ce);
        }
    }

    @Override
    public void loadEntity(byte[] configuration) throws ConfigurationException {
        this.loadExisting(configuration);
    }

    private void getEntity(ServerEntityRequest getEntityRequest, ResultCapture response, byte[] extendedData) {
        if (this.isDestroyed) {
            response.failure(ServerException.createNotFoundException((EntityID)this.getID()));
        } else {
            if (this.canDelete) {
                ++this.clientReferenceCount;
                Assert.assertTrue((this.clientReferenceCount > 0 ? 1 : 0) != 0);
            }
            ClientID clientID = getEntityRequest.getNodeID();
            ClientDescriptorImpl descriptor = new ClientDescriptorImpl(clientID, getEntityRequest.getClientInstance());
            boolean added = this.clientEntityStateManager.addReference(descriptor, this.fetchID);
            if (this.isInActiveState) {
                Assert.assertTrue((boolean)added);
                this.eventCollector.clientDidFetchEntity(clientID, this.id, this.consumerID, getEntityRequest.getClientInstance());
                try {
                    this.activeServerEntity.connected((ClientDescriptor)descriptor);
                }
                catch (RuntimeException runtime) {
                    logger.warn("unexpected exception.  rejecting reconnection of " + descriptor.getNodeID() + " to " + this.id, (Throwable)runtime);
                    response.failure(ServerException.createClosedException((EntityID)this.id));
                    return;
                }
                if (getEntityRequest.getTransaction().equals((Object)TransactionID.NULL_ID)) {
                    try {
                        ActiveServerEntity.ReconnectHandler handler = this.reconnect;
                        if (handler == null) {
                            throw new ReconnectRejectedException("no reconnect handler registered");
                        }
                        handler.handleReconnect((ClientDescriptor)descriptor, extendedData);
                    }
                    catch (ReconnectRejectedException rejected) {
                        response.failure(ServerException.createReconnectRejected((EntityID)this.getID(), (Exception)((Object)rejected)));
                        return;
                    }
                    catch (Exception e) {
                        logger.warn("unexpected exception.  rejecting reconnection of " + descriptor.getNodeID() + " to " + this.id, (Throwable)e);
                        response.failure(ServerException.createReconnectRejected((EntityID)this.getID(), (Exception)((Object)new ReconnectRejectedException(e.getMessage(), (Throwable)e))));
                        return;
                    }
                }
            }
            ByteBuffer buffer = ByteBuffer.allocate(this.constructorInfo.length + 8);
            buffer.putLong(this.consumerID);
            buffer.put(this.constructorInfo);
            response.complete(buffer.array());
        }
    }

    private void releaseEntity(ServerEntityRequest request, ResultCapture response) {
        if (this.isDestroyed) {
            response.failure(ServerException.createNotFoundException((EntityID)this.getID()));
        } else {
            if (this.canDelete) {
                --this.clientReferenceCount;
                Assert.assertTrue((this.clientReferenceCount >= 0 ? 1 : 0) != 0);
            }
            ClientID clientID = request.getNodeID();
            ClientDescriptorImpl clientInstance = new ClientDescriptorImpl(clientID, request.getClientInstance());
            boolean removed = this.clientEntityStateManager.removeReference(clientInstance);
            if (this.isInActiveState) {
                Assert.assertTrue((boolean)removed);
                this.activeServerEntity.disconnected((ClientDescriptor)clientInstance);
                this.eventCollector.clientDidReleaseEntity(clientID, this.id, this.consumerID, request.getClientInstance());
                if (this.isTemp && this.clientReferenceCount == 0) {
                    this.messageSelf.addToSink((Object)new DestroyMessage(EntityDescriptor.createDescriptorForLifecycle((EntityID)this.id, (long)this.version)));
                }
            }
            response.complete();
        }
    }

    @Override
    public void resetReferences(int count) {
        if (this.canDelete) {
            this.clientReferenceCount = count;
        } else {
            Assert.assertEquals((int)this.clientReferenceCount, (int)-1);
        }
    }

    @Override
    public Runnable promoteEntity() throws ConfigurationException {
        Assert.assertFalse((boolean)this.isInActiveState);
        Assert.assertNull(this.activeServerEntity);
        this.isInActiveState = true;
        if (this.canDelete) {
            this.clientReferenceCount = 0;
        } else {
            Assert.assertEquals((int)this.clientReferenceCount, (int)-1);
        }
        if (!this.isDestroyed) {
            logger.info("Promoting " + this.getID() + " to active entity");
            if (null != this.passiveServerEntity) {
                this.notifyEntityDestroyed();
                this.passiveServerEntity = null;
                this.activeServerEntity = this.factory.createActiveEntity((ServiceRegistry)this.registry, this.constructorInfo);
                this.concurrencyStrategy = this.factory.getConcurrencyStrategy(this.constructorInfo);
                this.executionStrategy = this.factory.getExecutionStrategy(this.constructorInfo);
                this.activeServerEntity.loadExisting();
                this.notifyEntityCreated();
                this.eventCollector.entityWasReloaded(this.getID(), this.consumerID, true);
                this.reconnect = this.activeServerEntity.startReconnect();
                if (this.reconnect != null) {
                    return () -> {
                        if (this.reconnect != null) {
                            this.reconnect.close();
                            this.reconnect = null;
                        }
                    };
                }
            } else {
                throw new IllegalStateException("no entity to promote");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(SessionID passive) {
        PassiveSyncServerEntityRequest req = new PassiveSyncServerEntityRequest(passive);
        BarrierCompletion syncStart = new BarrierCompletion();
        this.executor.scheduleRequest(this.interop.isSyncing(), this.id, this.version, this.fetchID, new ServerEntityRequestImpl(ClientInstanceID.NULL_ID, ServerEntityAction.LOCAL_FLUSH_AND_SYNC, ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, false), MessagePayload.emptyPayload(), w -> {
            Assert.assertTrue((boolean)this.isInActiveState);
            if (!this.isDestroyed) {
                this.executor.scheduleSync(SyncReplicationActivity.createStartEntityMessage((EntityID)this.id, (long)this.version, (FetchID)this.fetchID, (TCByteBuffer)TCByteBufferFactory.wrap((byte[])this.constructorInfo), (int)(this.canDelete ? this.clientReferenceCount : -1)), passive).waitForCompleted();
            }
            this.interop.syncStarted();
            syncStart.complete();
        }, true, 0);
        syncStart.waitForCompletion();
        try {
            if (!this.isDestroyed) {
                for (Integer concurrency : this.concurrencyStrategy.getKeysForSynchronization()) {
                    Assert.assertTrue((concurrency > 0 ? 1 : 0) != 0);
                    if (this.activeServerEntity != null) {
                        this.activeServerEntity.prepareKeyForSynchronizeOnPassive((PassiveSynchronizationChannel)new EntityMessagePassiveSynchronizationChannelImpl(Collections.singleton(passive), concurrency, true), concurrency.intValue());
                    }
                    BarrierCompletion sectionComplete = new BarrierCompletion();
                    this.executor.scheduleRequest(this.interop.isSyncing(), this.id, this.version, this.fetchID, req, MessagePayload.emptyPayload(), w -> this.invoke(req, new ResultCaptureImpl(null, result -> sectionComplete.complete(), null, exception -> {
                        throw new RuntimeException("bad message", (Throwable)exception);
                    }), MessagePayload.emptyPayload(), concurrency), true, concurrency);
                    sectionComplete.waitForCompletion();
                    this.executor.scheduleSync(SyncReplicationActivity.createEndEntityKeyMessage((EntityID)this.id, (long)this.version, (FetchID)this.fetchID, (int)concurrency), passive).waitForCompleted();
                }
                this.executor.scheduleSync(SyncReplicationActivity.createEndEntityMessage((EntityID)this.id, (long)this.version, (FetchID)this.fetchID), passive).waitForCompleted();
            }
        }
        finally {
            this.interop.syncFinishing();
            this.messageSelf.addToSink((Object)new LocalPipelineFlushMessage(EntityDescriptor.createDescriptorForInvoke((FetchID)new FetchID(this.getConsumerID()), (ClientInstanceID)ClientInstanceID.NULL_ID), () -> this.interop.syncFinished()));
        }
    }

    @Override
    public SyncReplicationActivity.EntityCreationTuple startSync() {
        this.interop.startSync();
        this.clearQueue();
        if (!this.isDestroyed) {
            return new SyncReplicationActivity.EntityCreationTuple(this.id, this.version, this.consumerID, this.constructorInfo, this.canDelete);
        }
        this.interop.abortSync();
        return null;
    }

    @Override
    public long getConsumerID() {
        return this.consumerID;
    }

    @Override
    public void addLifecycleListener(ManagedEntity.LifecycleListener listener) {
        this.createListener.add(listener);
    }

    private void loadExisting(byte[] constructorInfo) throws ConfigurationException {
        logger.info("loadExisting entity: " + this.getID());
        this.constructorInfo = constructorInfo;
        if (this.isInActiveState) {
            if (null != this.activeServerEntity) {
                throw new IllegalStateException("Active entity " + this.id + " already exists.");
            }
            this.activeServerEntity = this.factory.createActiveEntity((ServiceRegistry)this.registry, constructorInfo);
            this.concurrencyStrategy = this.factory.getConcurrencyStrategy(constructorInfo);
            this.executionStrategy = this.factory.getExecutionStrategy(constructorInfo);
            this.activeServerEntity.loadExisting();
            this.notifyEntityCreated();
            this.eventCollector.entityWasReloaded(this.getID(), this.consumerID, this.isInActiveState);
        } else {
            if (null != this.passiveServerEntity) {
                throw new IllegalStateException("Passive entity " + this.id + " already exists.");
            }
            this.passiveServerEntity = this.factory.createPassiveEntity((ServiceRegistry)this.registry, constructorInfo);
            this.notifyEntityCreated();
            Assert.assertNull(this.concurrencyStrategy);
        }
        this.isDestroyed = false;
    }

    private /* synthetic */ void lambda$invoke$12(ServerEntityRequest request, ResultCapture response, int concurrencyKey, EntityMessage em) {
        this.performAction(request, em, response, concurrencyKey);
    }

    private class EntityMessagePassiveSynchronizationChannelImpl
    implements PassiveSynchronizationChannel<EntityMessage> {
        private final List<SessionID> passives;
        private final int concurrencyKey;
        private final boolean prepare;

        public EntityMessagePassiveSynchronizationChannelImpl(Collection<SessionID> passives, int concurrencyKey, boolean prepare) {
            this.passives = new ArrayList<SessionID>(passives);
            Collections.sort(this.passives);
            this.concurrencyKey = concurrencyKey;
            this.prepare = prepare;
        }

        public void synchronizeToPassive(EntityMessage payload) {
            for (SessionID passive : this.passives) {
                try {
                    byte[] message = ManagedEntityImpl.this.syncCodec.encode(this.concurrencyKey, payload);
                    ActivePassiveAckWaiter waiter = ManagedEntityImpl.this.executor.scheduleSync(SyncReplicationActivity.createPayloadMessage((EntityID)ManagedEntityImpl.this.id, (long)ManagedEntityImpl.this.version, (FetchID)ManagedEntityImpl.this.fetchID, (int)this.concurrencyKey, (TCByteBuffer)TCByteBufferFactory.wrap((byte[])message), (String)""), passive);
                    waiter.waitForReceived();
                }
                catch (MessageCodecException ce) {
                    throw new RuntimeException(ce);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityMessagePassiveSynchronizationChannelImpl channel = (EntityMessagePassiveSynchronizationChannelImpl)o;
            return this.passives.equals(channel.passives);
        }

        public int hashCode() {
            int result = this.passives.hashCode();
            return result;
        }
    }

    private static class DefermentQueue<T>
    implements Iterable<T> {
        private final LinkedList<T> queue = new LinkedList();
        private final int limit;
        private volatile boolean deferCleared = true;

        public DefermentQueue(int limit) {
            this.limit = limit;
        }

        T checkDeferred() {
            if (this.deferCleared && !this.queue.isEmpty()) {
                return this.queue.pop();
            }
            return null;
        }

        boolean isEmpty() {
            return this.queue.isEmpty();
        }

        boolean activate() {
            try {
                boolean bl = this.deferCleared;
                return bl;
            }
            finally {
                this.deferCleared = false;
            }
        }

        synchronized boolean clear() {
            try {
                this.notifyAll();
                boolean bl = this.deferCleared;
                return bl;
            }
            finally {
                this.deferCleared = true;
            }
        }

        boolean offer(T msg) {
            if (!this.deferCleared || !this.queue.isEmpty()) {
                this.queue.add(msg);
                if (this.queue.size() == this.limit) {
                    this.pause();
                }
                return true;
            }
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                T msg;

                @Override
                public boolean hasNext() {
                    this.msg = this.checkDeferred();
                    return this.msg != null;
                }

                @Override
                public T next() {
                    return this.msg;
                }
            };
        }

        private synchronized void pause() {
            while (!this.deferCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    L2Utils.handleInterrupted(logger, ie);
                }
            }
        }

        private Map<String, Object> getState() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("deferring", !this.deferCleared);
            map.put("queue", this.queue.stream().map(String::valueOf).collect(Collectors.toList()));
            return map;
        }
    }

    private class SchedulingRunnable
    implements Consumer<ActivePassiveAckWaiter> {
        private final ServerEntityRequest request;
        private final MessagePayload payload;
        private final Runnable original;
        private final int concurrency;
        private final Event event;
        private ActivePassiveAckWaiter waitFor;

        public SchedulingRunnable(ServerEntityRequest request, MessagePayload payload, Runnable r, int concurrency) {
            this.request = request;
            this.payload = payload;
            this.original = r;
            this.concurrency = concurrency;
            this.event = TripwireFactory.createMessageEvent((String)ManagedEntityImpl.this.id.toString(), (int)concurrency, (String)request.getAction().toString(), (long)request.getNodeID().toLong(), (String)request.getClientInstance().toString(), (long)request.getTransaction().toLong(), (String)request.getTraceID());
        }

        private void start() {
            if (this.concurrency == 0) {
                if (logger.isDebugEnabled()) {
                    try {
                        if (this.request.getAction() == ServerEntityAction.INVOKE_ACTION) {
                            this.payload.decodeMessage(raw -> ManagedEntityImpl.this.codec.decodeMessage(raw));
                        }
                    }
                    catch (MessageCodecException messageCodecException) {
                        // empty catch block
                    }
                    logger.debug("deferring actions in {} based on {} as a {}", new Object[]{ManagedEntityImpl.this.getID(), this.payload.getDebugId(), this.request.getAction()});
                }
                ManagedEntityImpl.this.runnables.activate();
            }
            boolean replicate = this.payload.shouldReplicate();
            switch (this.request.getAction()) {
                case CREATE_ENTITY: 
                case DESTROY_ENTITY: 
                case FETCH_ENTITY: 
                case RECONFIGURE_ENTITY: 
                case RELEASE_ENTITY: {
                    if (!replicate && ManagedEntityImpl.this.isInActiveState) {
                        logger.warn("Ignoring replication flag. All lifecycle operations are replicated " + (Object)((Object)this.request.getAction()));
                    }
                    replicate = true;
                    break;
                }
            }
            if (ManagedEntityImpl.this.isActive() && this.request.getAction() == ServerEntityAction.INVOKE_ACTION) {
                try {
                    ExecutionStrategy.Location loc = ManagedEntityImpl.this.executionStrategy.getExecutionLocation(this.payload.decodeMessage(raw -> ManagedEntityImpl.this.codec.decodeMessage(raw)));
                    if (loc != ExecutionStrategy.Location.IGNORE) {
                        replicate = loc.runOnPassive();
                    }
                }
                catch (MessageCodecException codec) {
                    replicate = false;
                }
            }
            ManagedEntityImpl.this.executor.scheduleRequest(ManagedEntityImpl.this.interop.isSyncing(), ManagedEntityImpl.this.id, ManagedEntityImpl.this.version, ManagedEntityImpl.this.fetchID, this.request, this.payload, this, replicate, this.concurrency);
        }

        private synchronized void setWaitFor(ActivePassiveAckWaiter waiter) {
            this.waitFor = waiter;
            this.notifyAll();
        }

        @Override
        public void accept(ActivePassiveAckWaiter waiter) {
            try {
                this.setWaitFor(waiter);
                this.event.begin();
                this.original.run();
            }
            finally {
                this.end();
            }
        }

        private void end() {
            if (this.concurrency == 0) {
                ManagedEntityImpl.this.runnables.clear();
                ServerEntityAction action = this.request.getAction();
                if (this.request.getAction() == ServerEntityAction.CREATE_ENTITY && ManagedEntityImpl.this.isDestroyed()) {
                    action = ServerEntityAction.DESTROY_ENTITY;
                }
                ManagedEntityImpl.this.flushLocalPipeline.completed(ManagedEntityImpl.this.id, ManagedEntityImpl.this.fetchID, action);
            }
            this.event.setDescription(this.payload.getDebugId());
            this.event.end();
            this.event.commit();
        }

        private synchronized ActivePassiveAckWaiter waitForPassives() {
            while (this.waitFor == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    L2Utils.handleInterrupted(logger, e);
                }
            }
            return this.waitFor;
        }

        public String toString() {
            return "SchedulingRunnable{request=" + this.request + ", payload=" + this.payload.getDebugId() + ", concurrency=" + this.concurrency + ", waitFor=" + this.waitFor + '}';
        }
    }

    private static class PassiveSyncServerEntityRequest
    implements ServerEntityRequest {
        private final SessionID passive;
        private final ServerEntityAction action = ServerEntityAction.REQUEST_SYNC_ENTITY;

        public PassiveSyncServerEntityRequest(SessionID passive) {
            this.passive = passive;
        }

        @Override
        public ClientID getNodeID() {
            return ClientID.NULL_ID;
        }

        @Override
        public boolean requiresReceived() {
            return false;
        }

        @Override
        public Set<SessionID> replicateTo(Set<SessionID> passives) {
            return this.passive == null ? Collections.emptySet() : Collections.singleton(this.passive);
        }

        @Override
        public ClientInstanceID getClientInstance() {
            return ClientInstanceID.NULL_ID;
        }

        @Override
        public ServerEntityAction getAction() {
            return this.action;
        }

        @Override
        public TransactionID getTransaction() {
            return TransactionID.NULL_ID;
        }

        @Override
        public TransactionID getOldestTransactionOnClient() {
            return TransactionID.NULL_ID;
        }
    }
}

