/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.object.tx.TransactionID;
import com.tc.objectserver.entity.ClientSourceIdImpl;
import org.terracotta.entity.ClientSourceId;
import org.terracotta.entity.InvokeContext;

public class InvokeContextImpl
implements InvokeContext {
    private static ThreadLocal<InvokeContext> INHERITED = new InheritableThreadLocal<InvokeContext>();
    public static InvokeContext NULL_CONTEXT = new InvokeContextImpl();
    private final long oldestid;
    private final long currentId;
    private final ClientSourceId sourceId;
    private final int concurrencyKey;

    private InvokeContextImpl() {
        this(ClientSourceIdImpl.NULL_ID, -1, TransactionID.NULL_ID.toLong(), TransactionID.NULL_ID.toLong());
    }

    public InvokeContextImpl(int concurrencyKey) {
        this(ClientSourceIdImpl.NULL_ID, concurrencyKey, TransactionID.NULL_ID.toLong(), TransactionID.NULL_ID.toLong());
    }

    public InvokeContextImpl(ClientSourceId sourceId, int concurrencyKey, long oldestid, long currentId) {
        this.sourceId = sourceId;
        this.concurrencyKey = concurrencyKey;
        this.oldestid = oldestid;
        this.currentId = currentId;
        this.setThreadLocal();
    }

    private void setThreadLocal() {
        if (this.sourceId.isValidClient()) {
            INHERITED.set(this);
        }
    }

    public static InvokeContext getCurrentContext() {
        return INHERITED.get();
    }

    public ClientSourceId getClientSource() {
        return this.sourceId;
    }

    public long getCurrentTransactionId() {
        return this.currentId;
    }

    public long getOldestTransactionId() {
        return this.oldestid;
    }

    public boolean isValidClientInformation() {
        return this.currentId >= 0L && this.sourceId.toLong() >= 0L;
    }

    public ClientSourceId makeClientSourceId(long l) {
        return new ClientSourceIdImpl(l);
    }

    public int getConcurrencyKey() {
        return this.concurrencyKey;
    }

    public String toString() {
        return "InvokeContextImpl{oldestid=" + this.oldestid + ", currentId=" + this.currentId + ", sourceId=" + this.sourceId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvokeContextImpl context = (InvokeContextImpl)o;
        if (this.oldestid != context.oldestid) {
            return false;
        }
        if (this.currentId != context.currentId) {
            return false;
        }
        return this.sourceId != null ? this.sourceId.equals(context.sourceId) : context.sourceId == null;
    }

    public int hashCode() {
        int result = (int)(this.oldestid ^ this.oldestid >>> 32);
        result = 31 * result + (int)(this.currentId ^ this.currentId >>> 32);
        result = 31 * result + (this.sourceId != null ? this.sourceId.hashCode() : 0);
        return result;
    }
}

