/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.async.api.Sink;
import com.tc.classloader.ServiceLocator;
import com.tc.entity.VoltronEntityMessage;
import com.tc.exception.ServerException;
import com.tc.exception.TCShutdownServerException;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.objectserver.api.EntityManager;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.api.ManagementKeyCallback;
import com.tc.objectserver.core.impl.ManagementTopologyEventCollector;
import com.tc.objectserver.entity.ClientEntityStateManager;
import com.tc.objectserver.entity.LocalPipelineFlushMessage;
import com.tc.objectserver.entity.ManagedEntityImpl;
import com.tc.objectserver.entity.PlatformEntity;
import com.tc.objectserver.entity.RequestProcessor;
import com.tc.objectserver.entity.ServerEntityFactory;
import com.tc.services.TerracottaServiceProviderRegistry;
import com.tc.util.Assert;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.EntityServerService;
import org.terracotta.entity.MessageCodec;

public class EntityManagerImpl
implements EntityManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityManagerImpl.class);
    private final ConcurrentMap<EntityID, FetchID> entities = new ConcurrentHashMap<EntityID, FetchID>();
    private final ConcurrentMap<FetchID, ManagedEntity> entityIndex = new ConcurrentHashMap<FetchID, ManagedEntity>();
    private final ConcurrentMap<String, EntityServerService<EntityMessage, EntityResponse>> entityServices = new ConcurrentHashMap<String, EntityServerService<EntityMessage, EntityResponse>>();
    private final ServerEntityFactory creationLoader;
    private final TerracottaServiceProviderRegistry serviceRegistry;
    private final ClientEntityStateManager clientEntityStateManager;
    private final ManagementTopologyEventCollector eventCollector;
    private final ManagementKeyCallback flushLocalPipeline;
    private Sink<VoltronEntityMessage> messageSelf;
    private final RequestProcessor processorPipeline;
    private boolean shouldCreateActiveEntities;
    private final Semaphore snapshotLock = new Semaphore(1);
    private final Comparator<ManagedEntity> consumerIdSorter = new Comparator<ManagedEntity>(){

        @Override
        public int compare(ManagedEntity o1, ManagedEntity o2) {
            long secondID;
            long firstID = o1.getConsumerID();
            Assert.assertTrue((firstID != (secondID = o2.getConsumerID()) ? 1 : 0) != 0);
            return firstID > secondID ? 1 : -1;
        }
    };

    public EntityManagerImpl(TerracottaServiceProviderRegistry serviceRegistry, ClientEntityStateManager clientEntityStateManager, ManagementTopologyEventCollector eventCollector, RequestProcessor processor, ManagementKeyCallback flushLocalPipeline, ServiceLocator locator) {
        this.serviceRegistry = serviceRegistry;
        this.clientEntityStateManager = clientEntityStateManager;
        this.eventCollector = eventCollector;
        this.processorPipeline = processor;
        this.shouldCreateActiveEntities = false;
        this.creationLoader = new ServerEntityFactory(locator);
        this.flushLocalPipeline = flushLocalPipeline;
        ManagedEntity platform = this.createPlatformEntity();
        this.entities.put(platform.getID(), PlatformEntity.PLATFORM_FETCH_ID);
        this.entityIndex.put(PlatformEntity.PLATFORM_FETCH_ID, platform);
    }

    public void setMessageSink(Sink<VoltronEntityMessage> sink) {
        this.messageSelf = sink;
    }

    private ManagedEntity createPlatformEntity() {
        return new PlatformEntity(this.messageSelf, this.processorPipeline);
    }

    @Override
    public ServerEntityFactory getEntityLoader() {
        return this.creationLoader;
    }

    @Override
    public boolean canDelete(EntityID entityID) {
        return !this.creationLoader.isPermanentEntity(entityID);
    }

    public void shutdown() {
        for (EntityServerService service : this.entityServices.values()) {
            try {
                if (service instanceof Closeable) {
                    ((Closeable)service).close();
                }
                if (!(service instanceof AutoCloseable)) continue;
                ((AutoCloseable)service).close();
            }
            catch (Exception e) {
                LOGGER.warn("error closing entity service", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VoltronEntityMessage> enterActiveState() {
        Assert.assertFalse((boolean)this.shouldCreateActiveEntities);
        this.snapshotLock.acquireUninterruptibly();
        try {
            this.serviceRegistry.notifyServerDidBecomeActive();
            this.shouldCreateActiveEntities = true;
            ArrayList sortingList = new ArrayList(this.entityIndex.values());
            ArrayList<LocalPipelineFlushMessage> reconnectDone = new ArrayList<LocalPipelineFlushMessage>(this.entityIndex.size());
            Collections.sort(sortingList, this.consumerIdSorter);
            for (ManagedEntity entity : sortingList) {
                try {
                    reconnectDone.add(new LocalPipelineFlushMessage(EntityDescriptor.createDescriptorForInvoke((FetchID)new FetchID(entity.getConsumerID()), (ClientInstanceID)ClientInstanceID.NULL_ID), entity.promoteEntity()));
                }
                catch (ConfigurationException ce) {
                    String errMsg = "failure to promote entity: " + entity.getID();
                    LOGGER.error(errMsg, (Throwable)ce);
                    throw new TCShutdownServerException(errMsg, (Throwable)ce);
                }
            }
            this.processorPipeline.enterActiveState();
            ArrayList<LocalPipelineFlushMessage> arrayList = reconnectDone;
            return arrayList;
        }
        finally {
            this.snapshotLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedEntity createEntity(EntityID id, long version, long consumerID) throws ServerException {
        EntityServerService<EntityMessage, EntityResponse> service = this.getVersionCheckedService(id, version);
        this.snapshotLock.acquireUninterruptibly();
        try {
            ManagedEntity temp;
            FetchID current = this.entities.compute(id, (eid, fetch) -> this.shouldCreateActiveEntities ? Optional.ofNullable(fetch).orElse(new FetchID(consumerID)) : new FetchID(consumerID));
            ManagedEntity managedEntity = temp = this.entityIndex.computeIfAbsent(current, fetch -> new ManagedEntityImpl(id, version, consumerID, this.flushLocalPipeline, this.serviceRegistry.subRegistry(consumerID), this.clientEntityStateManager, this.eventCollector, this.messageSelf, this.processorPipeline, service, this.shouldCreateActiveEntities, this.canDelete(id)));
            return managedEntity;
        }
        finally {
            this.snapshotLock.release();
        }
    }

    @Override
    public void loadExisting(EntityID entityID, long recordedVersion, long consumerID, boolean canDelete, byte[] configuration) throws ServerException {
        Assert.assertTrue((recordedVersion > 0L ? 1 : 0) != 0);
        EntityServerService<EntityMessage, EntityResponse> service = this.getVersionCheckedService(entityID, recordedVersion);
        FetchID set = new FetchID(consumerID);
        Object checkNull = this.entities.put(entityID, set);
        Assert.assertNull((Object)checkNull);
        ManagedEntityImpl temp = new ManagedEntityImpl(entityID, recordedVersion, consumerID, this.flushLocalPipeline, this.serviceRegistry.subRegistry(consumerID), this.clientEntityStateManager, this.eventCollector, this.messageSelf, this.processorPipeline, service, this.shouldCreateActiveEntities, canDelete);
        checkNull = this.entityIndex.put(set, temp);
        Assert.assertNull((Object)checkNull);
        try {
            temp.loadEntity(configuration);
        }
        catch (ConfigurationException ce) {
            String errMsg = "failure to load an existing entity: " + entityID;
            LOGGER.error(errMsg, (Throwable)ce);
            throw new TCShutdownServerException(errMsg, (Throwable)ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDestroyed(FetchID id) {
        this.snapshotLock.acquireUninterruptibly();
        try {
            ManagedEntity e = this.entityIndex.computeIfPresent(id, (fetch, entity) -> {
                if (entity.isRemoveable()) {
                    this.entities.entrySet().removeIf(i -> ((FetchID)i.getValue()).equals(fetch));
                    return null;
                }
                return entity;
            });
            if (e == null) {
                LOGGER.debug("removed " + id);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.snapshotLock.release();
        }
    }

    @Override
    public Optional<ManagedEntity> getEntity(EntityDescriptor descriptor) throws ServerException {
        if (descriptor.isIndexed()) {
            return this.getEntity(descriptor.getFetchID());
        }
        return this.getEntity(descriptor.getEntityID(), descriptor.getClientSideVersion());
    }

    private Optional<ManagedEntity> getEntity(FetchID idx) {
        Assert.assertFalse((boolean)idx.isNull());
        return Optional.ofNullable(this.entityIndex.get(idx));
    }

    private Optional<ManagedEntity> getEntity(EntityID id, long version) throws ServerException {
        Assert.assertNotNull((Object)id);
        if (EntityID.NULL_ID == id) {
            return Optional.empty();
        }
        FetchID fetch = (FetchID)this.entities.get(id);
        if (fetch != null) {
            ManagedEntity entity = (ManagedEntity)this.entityIndex.get(fetch);
            if (version > 0L && entity.getVersion() != version) {
                throw ServerException.createEntityVersionMismatch((EntityID)id, (String)(entity.getVersion() + " does not match " + version));
            }
            return Optional.of(entity);
        }
        return this.getCompatibleEntity(id, version);
    }

    private Optional<ManagedEntity> getCompatibleEntity(EntityID id, long version) throws ServerException {
        for (Map.Entry e : this.entityIndex.entrySet()) {
            if (!((ManagedEntity)e.getValue()).isCompatibleEntity(id)) continue;
            this.entities.put(id, (FetchID)e.getKey());
            if (version > 0L && ((ManagedEntity)e.getValue()).getVersion() != version) {
                throw ServerException.createEntityVersionMismatch((EntityID)id, (String)(((ManagedEntity)e.getValue()).getVersion() + " does not match " + version));
            }
            return Optional.of(e.getValue());
        }
        return Optional.empty();
    }

    @Override
    public Collection<ManagedEntity> getAll() {
        return new ArrayList<ManagedEntity>(this.entityIndex.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ManagedEntity> snapshot(Predicate<ManagedEntity> runFirst) {
        this.snapshotLock.acquireUninterruptibly();
        ArrayList<ManagedEntity> sortingList = new ArrayList<ManagedEntity>(this.entityIndex.values());
        try {
            Collections.sort(sortingList, this.consumerIdSorter);
            if (runFirst != null) {
                Iterator list = sortingList.iterator();
                while (list.hasNext()) {
                    if (runFirst.test((ManagedEntity)list.next())) continue;
                    list.remove();
                }
            }
            ArrayList<ManagedEntity> arrayList = sortingList;
            return arrayList;
        }
        finally {
            this.snapshotLock.release();
        }
    }

    private EntityServerService<EntityMessage, EntityResponse> getVersionCheckedService(EntityID entityID, long version) throws ServerException {
        String typeName = entityID.getClassName();
        Object service = (EntityServerService)this.entityServices.get(typeName);
        if (service == null) {
            try {
                service = this.creationLoader.getService(typeName);
            }
            catch (ClassNotFoundException notfound) {
                throw ServerException.createEntityNotProvided((EntityID)entityID);
            }
            Assert.assertNotNull((Object)service);
            EntityServerService<EntityMessage, EntityResponse> oldService = this.entityServices.putIfAbsent(typeName, (EntityServerService<EntityMessage, EntityResponse>)service);
            Assert.assertNull(oldService);
        }
        Assert.assertNotNull((Object)service);
        long serviceVersion = service.getVersion();
        if (version > 0L && serviceVersion != version) {
            throw ServerException.createEntityVersionMismatch((EntityID)entityID, (String)(serviceVersion + " does not match " + version));
        }
        return service;
    }

    @Override
    public void resetReferences() {
        this.clientEntityStateManager.clearClientReferences();
        for (ManagedEntity me : this.entityIndex.values()) {
            me.resetReferences(0);
        }
    }

    public MessageCodec<? extends EntityMessage, ? extends EntityResponse> getMessageCodec(EntityDescriptor eid) {
        ManagedEntity e = (ManagedEntity)this.entityIndex.get(eid.getFetchID());
        if (e != null) {
            return e.getCodec();
        }
        return null;
    }

    public String toString() {
        return "EntityManagerImpl{entities=" + this.entities.keySet() + '}';
    }

    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> entityMap = new LinkedHashMap<String, Object>();
        Set entries = this.entities.entrySet();
        entityMap.put("className", this.getClass().getName());
        entityMap.put("size", entries.size());
        ArrayList entities = new ArrayList(this.entityIndex.size());
        entityMap.put("entities", entities);
        this.entityIndex.values().forEach(entity -> entities.add(entity.getState()));
        return entityMap;
    }
}

