/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.net.ClientID;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.FetchID;
import com.tc.objectserver.entity.ClientDescriptorImpl;
import com.tc.objectserver.entity.ClientEntityStateManager;
import com.tc.util.Assert;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientEntityStateManagerImpl
implements ClientEntityStateManager {
    private final Map<ClientDescriptorImpl, FetchID> clientStates = new ConcurrentHashMap<ClientDescriptorImpl, FetchID>();
    private static final Logger logger = LoggerFactory.getLogger(ClientEntityStateManagerImpl.class);

    @Override
    public boolean addReference(ClientDescriptorImpl instance, FetchID eid) {
        Assert.assertFalse((instance.getClientInstanceID() == ClientInstanceID.NULL_ID ? 1 : 0) != 0);
        FetchID check = this.clientStates.put(instance, eid);
        return Objects.isNull(check);
    }

    @Override
    public boolean removeReference(ClientDescriptorImpl descriptor) {
        Assert.assertFalse((descriptor.getClientInstanceID() == ClientInstanceID.NULL_ID ? 1 : 0) != 0);
        FetchID eid = this.clientStates.remove(descriptor);
        return Objects.nonNull(eid);
    }

    @Override
    public boolean verifyNoEntityReferences(FetchID eid) {
        return !this.clientStates.values().stream().anyMatch(led -> led.equals((Object)eid));
    }

    @Override
    public boolean verifyNoClientReferences(ClientID eid) {
        return !this.clientStates.keySet().stream().anyMatch(led -> led.getNodeID().equals((Object)eid));
    }

    @Override
    public List<FetchID> clientDisconnected(ClientID client) {
        return this.clientStates.entrySet().stream().filter(e -> ((ClientDescriptorImpl)e.getKey()).getNodeID().equals((Object)client)).map(e -> (FetchID)e.getValue()).distinct().collect(Collectors.toList());
    }

    @Override
    public List<EntityDescriptor> clientDisconnectedFromEntity(ClientID client, FetchID entity) {
        return this.clientStates.entrySet().stream().filter(e -> ((ClientDescriptorImpl)e.getKey()).getNodeID().equals((Object)client) && ((FetchID)e.getValue()).equals((Object)entity)).map(e -> EntityDescriptor.createDescriptorForInvoke((FetchID)((FetchID)e.getValue()), (ClientInstanceID)((ClientDescriptorImpl)e.getKey()).getClientInstanceID())).collect(Collectors.toList());
    }

    @Override
    public Set<ClientID> clearClientReferences() {
        Set<ClientID> msgs = this.clientStates.keySet().stream().map(ClientDescriptorImpl::getNodeID).distinct().collect(Collectors.toSet());
        this.clientStates.clear();
        return msgs;
    }
}

