/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.entity.VoltronEntityMessage;
import com.tc.net.ClientID;
import com.tc.object.EntityDescriptor;
import com.tc.object.tx.TransactionID;
import java.util.function.Consumer;
import org.terracotta.entity.EntityMessage;

public class ClientDisconnectMessage
implements VoltronEntityMessage,
Runnable {
    private final ClientID clientID;
    private final EntityDescriptor descriptor;
    private final Runnable disconnectComplete;
    private final Consumer<Exception> disconnectException;

    public ClientDisconnectMessage(ClientID clientID, EntityDescriptor entityID, Runnable completion, Consumer<Exception> exception) {
        this.clientID = clientID;
        this.descriptor = entityID;
        this.disconnectComplete = completion;
        this.disconnectException = exception;
    }

    public ClientID getSource() {
        return this.clientID;
    }

    public TransactionID getTransactionID() {
        return TransactionID.NULL_ID;
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.descriptor;
    }

    public boolean doesRequireReplication() {
        return true;
    }

    public boolean doesRequestReceived() {
        return true;
    }

    public boolean doesRequestRetired() {
        return false;
    }

    public VoltronEntityMessage.Type getVoltronType() {
        return VoltronEntityMessage.Type.DISCONNECT_CLIENT;
    }

    public TCByteBuffer getExtendedData() {
        return TCByteBufferFactory.getInstance((int)0);
    }

    public TransactionID getOldestTransactionOnClient() {
        return TransactionID.NULL_ID;
    }

    public EntityMessage getEntityMessage() {
        return null;
    }

    @Override
    public void run() {
        if (this.disconnectComplete != null) {
            this.disconnectComplete.run();
        }
    }

    public void disconnectException(Exception e) {
        if (this.disconnectException != null) {
            this.disconnectException.accept(e);
        }
    }

    public String toString() {
        return "ClientDisconnectMessage{clientID=" + this.clientID + ", entityDescriptor=" + this.descriptor + '}';
    }
}

