/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.async.api.Sink;
import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.l2.msg.ReplicationAckTuple;
import com.tc.l2.msg.ReplicationMessageAck;
import com.tc.l2.msg.ReplicationResultCode;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.l2.state.ConsistencyManager;
import com.tc.l2.state.ServerMode;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.groups.GroupEventsListener;
import com.tc.net.groups.GroupManager;
import com.tc.net.utils.L2Utils;
import com.tc.object.session.SessionID;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.entity.ActivePassiveAckWaiter;
import com.tc.objectserver.entity.PassiveReplicationBroker;
import com.tc.objectserver.entity.ReplicationSender;
import com.tc.objectserver.handler.ProcessTransactionHandler;
import com.tc.objectserver.handler.ReplicationReceivingAction;
import com.tc.objectserver.persistence.EntityPersistor;
import com.tc.util.AbstractIdentifier;
import com.tc.util.Assert;
import com.tc.util.DaemonThreadFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.tripwire.Event;
import org.terracotta.tripwire.TripwireFactory;

public class ActiveToPassiveReplication
implements PassiveReplicationBroker,
GroupEventsListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveToPassiveReplication.class);
    private boolean activated = false;
    private final Map<ServerID, SessionID> passiveNodes = new ConcurrentHashMap<ServerID, SessionID>();
    private final Set<NodeID> standByNodes = new HashSet<NodeID>();
    private final ConcurrentHashMap<SyncReplicationActivity.ActivityID, ActivePassiveAckWaiter> waiters = new ConcurrentHashMap();
    private final ReplicationSender replicationSender;
    private final ExecutorService passiveSyncPool = Executors.newCachedThreadPool(new DaemonThreadFactory("active-to-passive-"));
    private final EntityPersistor persistor;
    private final GroupManager serverCheck;
    private final ProcessTransactionHandler snapshotter;
    private final ConsistencyManager consistencyMgr;
    private final Sink<ReplicationReceivingAction> receiveHandler;
    private final AtomicLong sessionMaker = new AtomicLong();

    public ActiveToPassiveReplication(ConsistencyManager consistencyMgr, ProcessTransactionHandler snapshotter, EntityPersistor persistor, ReplicationSender replicationSender, Sink<ReplicationReceivingAction> processor, GroupManager serverMatch) {
        this.consistencyMgr = consistencyMgr;
        this.replicationSender = replicationSender;
        this.persistor = persistor;
        this.serverCheck = serverMatch;
        this.snapshotter = snapshotter;
        this.receiveHandler = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zapAndWait(NodeID node) {
        Set<NodeID> set = this.standByNodes;
        synchronized (set) {
            LOGGER.warn("ZAPPING " + node + " due to inconsistent lifecycle result");
            try {
                if (this.standByNodes.contains(node)) {
                    this.serverCheck.zapNode(node, 2, "inconsistent lifecycle");
                }
                while (this.standByNodes.contains(node)) {
                    this.standByNodes.wait();
                }
            }
            catch (InterruptedException ie) {
                L2Utils.handleInterrupted(LOGGER, ie);
            }
        }
    }

    public void enterActiveState(Set<ServerID> passives) {
        Assert.assertFalse((boolean)this.activated);
        this.primePassives(passives);
        this.activated = true;
    }

    private void primePassives(Set<ServerID> passives) {
        passives.forEach(i -> {
            SessionID session = this.prime((ServerID)i);
            if (session.isNull()) {
                LOGGER.warn("add passive disallowed for " + i);
            }
        });
    }

    private SessionID prime(ServerID node) {
        Assert.assertFalse((boolean)node.isNull());
        SessionID current = this.passiveNodes.get(node);
        if (current == null && this.serverIsValid(node)) {
            if (!this.consistencyMgr.requestTransition(ServerMode.ACTIVE, (NodeID)node, ConsistencyManager.Transition.ADD_PASSIVE)) {
                this.serverCheck.zapNode((NodeID)node, 255, "unable to verify active");
                return SessionID.NULL_ID;
            }
            LOGGER.debug("Starting message sequence on " + node);
            SessionID newSession = new SessionID(this.sessionMaker.incrementAndGet());
            if (this.passiveNodes.putIfAbsent(node, newSession) == null) {
                boolean sent = this.replicationSender.addPassive(node, newSession, ActiveToPassiveReplication.executionLane(newSession), SyncReplicationActivity.createStartMessage());
                Assert.assertTrue((boolean)sent);
                return newSession;
            }
        }
        return SessionID.NULL_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean serverIsValid(ServerID server) {
        boolean connected = this.serverCheck.isNodeConnected((NodeID)server);
        Set<NodeID> set = this.standByNodes;
        synchronized (set) {
            if (connected) {
                connected = this.standByNodes.contains(server);
            }
        }
        return connected;
    }

    private static int executionLane(SessionID session) {
        return Long.hashCode(session.toLong());
    }

    public boolean startPassiveSync(ServerID newNode) {
        Assert.assertTrue((boolean)this.activated);
        SessionID session = this.prime(newNode);
        if (session.isValid()) {
            LOGGER.info("Starting sync to node: {} session: {}", (Object)newNode, (Object)session);
            this.executePassiveSync(newNode, session);
            return true;
        }
        if (!this.passiveNodes.containsKey(newNode)) {
            LOGGER.info("passive node {} to requesting prime is no longer a valid passive", (Object)newNode);
        } else {
            LOGGER.info("unable to prime connection to {} for passive sync", (Object)newNode);
            this.serverCheck.closeMember(newNode);
        }
        return false;
    }

    private void executePassiveSync(ServerID newNode, SessionID session) {
        Event sync = TripwireFactory.createSyncEvent((String)newNode.getName(), (byte[])newNode.getUID(), (long)session.toLong());
        this.executeOnPool(() -> {
            sync.begin();
            LOGGER.debug("starting sync for " + newNode + " on session " + session);
            ArrayList tuplesForCreation = new ArrayList();
            Iterable<ManagedEntity> e = this.snapshotter.snapshotEntityList(entity -> {
                SyncReplicationActivity.EntityCreationTuple data = entity.startSync();
                if (data != null) {
                    tuplesForCreation.add(data);
                    return true;
                }
                return false;
            });
            this.replicateActivity(SyncReplicationActivity.createStartSyncMessage((SyncReplicationActivity.EntityCreationTuple[])tuplesForCreation.toArray(new SyncReplicationActivity.EntityCreationTuple[tuplesForCreation.size()])), Collections.singleton(session)).waitForCompleted();
            for (ManagedEntity entity2 : e) {
                LOGGER.debug("starting sync for entity " + newNode + "/" + entity2.getID());
                entity2.sync(session);
                LOGGER.debug("ending sync for entity " + newNode + "/" + entity2.getID());
            }
            LOGGER.debug("ending sync " + newNode);
            this.replicateActivity(SyncReplicationActivity.createEndSyncMessage((TCByteBuffer)TCByteBufferFactory.wrap((byte[])this.replicateEntityPersistor())), Collections.singleton(session)).waitForCompleted();
            sync.end();
            sync.commit();
        });
    }

    private byte[] replicateEntityPersistor() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream data = new ObjectOutputStream(out);
            this.persistor.serialize(data);
            data.close();
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void batchAckReceived(ReplicationMessageAck context) {
        ServerID messageFrom = context.messageFrom();
        SessionID session = this.passiveNodes.getOrDefault(messageFrom, SessionID.NULL_ID);
        if (session.isValid()) {
            this.receiveHandler.addToSink((Object)new ReplicationReceivingAction(ActiveToPassiveReplication.executionLane(session), () -> {
                for (ReplicationAckTuple tuple : context.getBatch()) {
                    if (ReplicationResultCode.RECEIVED == tuple.result) {
                        ActivePassiveAckWaiter waiter = this.waiters.get(tuple.respondTo);
                        if (null == waiter) continue;
                        waiter.didReceiveOnPassive(messageFrom);
                        continue;
                    }
                    this.internalAckCompleted(tuple.respondTo, messageFrom, tuple.result);
                }
            }));
        }
    }

    private void internalAckCompleted(SyncReplicationActivity.ActivityID activityID, ServerID passive, ReplicationResultCode payload) {
        boolean shouldDiscardWaiter;
        ActivePassiveAckWaiter waiter = this.waiters.get(activityID);
        if (null != waiter && (shouldDiscardWaiter = waiter.didCompleteOnPassive(passive, payload))) {
            this.waiters.remove(activityID);
        }
    }

    @Override
    public Set<SessionID> passives() {
        final Collection copy = this.passiveNodes.values().stream().filter(AbstractIdentifier::isValid).collect(Collectors.toCollection(() -> new ArrayList(this.passiveNodes.size())));
        return new AbstractSet<SessionID>(){

            @Override
            public Iterator<SessionID> iterator() {
                return copy.iterator();
            }

            @Override
            public int size() {
                return copy.size();
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ActivePassiveAckWaiter replicateActivity(SyncReplicationActivity activity, Set<SessionID> all) {
        block3: {
            waiter = new ActivePassiveAckWaiter(this.passiveNodes, all, this);
            if (all.isEmpty()) break block3;
            activityID = activity.getActivityID();
            if (this.serverCheck.isStopped()) ** GOTO lbl9
            if (this.passiveSyncPool.isShutdown()) {
lbl9:
                // 2 sources

                all.forEach((Consumer<SessionID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, failedToSendToPassive(com.tc.object.session.SessionID ), (Lcom/tc/object/session/SessionID;)V)((ActivePassiveAckWaiter)waiter));
            } else {
                this.waiters.put(activityID, waiter);
            }
            isLocalFlush = SyncReplicationActivity.ActivityType.FLUSH_LOCAL_PIPELINE == activity.getActivityType();
            for (SessionID node : all) {
                if (isLocalFlush || !node.isValid()) continue;
                this.replicationSender.replicateMessage(node, activity, (Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$replicateActivity$5(com.tc.objectserver.entity.ActivePassiveAckWaiter com.tc.object.session.SessionID com.tc.l2.msg.SyncReplicationActivity$ActivityID java.lang.Boolean ), (Ljava/lang/Boolean;)V)((ActiveToPassiveReplication)this, (ActivePassiveAckWaiter)waiter, (SessionID)node, (SyncReplicationActivity.ActivityID)activityID));
            }
        }
        return waiter;
    }

    private void executeOnPool(Runnable r) {
        try {
            this.passiveSyncPool.execute(r);
        }
        catch (RejectedExecutionException exec) {
            LOGGER.info("rejected execution", (Throwable)exec);
        }
    }

    private void removePassive(NodeID nodeID) {
        SessionID session = this.passiveNodes.putIfAbsent((ServerID)nodeID, SessionID.NULL_ID);
        LOGGER.info("removing passive: {} with session: {}", (Object)nodeID, (Object)session);
        this.executeOnPool(() -> {
            while (!this.consistencyMgr.requestTransition(ServerMode.ACTIVE, nodeID, ConsistencyManager.Transition.REMOVE_PASSIVE)) {
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException ie) {
                    L2Utils.handleInterrupted(LOGGER, ie);
                }
            }
            if (this.passiveNodes.remove(nodeID, session)) {
                this.removePassiveSession(session);
                LOGGER.info("removed passive: {} with session {}", (Object)nodeID, (Object)session);
            } else {
                Assert.assertTrue((boolean)this.passiveNodes.remove(nodeID, SessionID.NULL_ID));
            }
        });
    }

    private void removePassiveSession(SessionID session) {
        this.replicationSender.removePassive(session);
        Iterator<Map.Entry<SyncReplicationActivity.ActivityID, ActivePassiveAckWaiter>> scan = this.waiters.entrySet().iterator();
        while (scan.hasNext()) {
            Map.Entry<SyncReplicationActivity.ActivityID, ActivePassiveAckWaiter> e = scan.next();
            if (!e.getValue().failedToSendToPassive(session)) continue;
            scan.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeJoined(NodeID nodeID) {
        Set<NodeID> set = this.standByNodes;
        synchronized (set) {
            this.standByNodes.add(nodeID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeLeft(NodeID nodeID) {
        if (this.activated) {
            this.removePassive(nodeID);
        } else {
            LOGGER.info("not activated, no passives to remove: {}", (Object)nodeID);
        }
        Set<NodeID> set = this.standByNodes;
        synchronized (set) {
            this.standByNodes.remove(nodeID);
            this.standByNodes.notifyAll();
        }
    }

    public void close() {
        this.passiveSyncPool.shutdownNow();
        while (!this.waiters.isEmpty()) {
            LOGGER.info("waiters not empty on shutdown.  Removing:" + this.passiveNodes);
            Iterator<Map.Entry<SyncReplicationActivity.ActivityID, ActivePassiveAckWaiter>> items = this.waiters.entrySet().iterator();
            while (items.hasNext()) {
                items.next().getValue().abandon();
                items.remove();
            }
        }
    }

    Map<SyncReplicationActivity.ActivityID, ActivePassiveAckWaiter> getWaiters() {
        return this.waiters;
    }

    void finishPassiveSync(long timeout) throws InterruptedException {
        this.passiveSyncPool.shutdown();
        this.passiveSyncPool.awaitTermination(timeout, TimeUnit.MILLISECONDS);
    }

    private /* synthetic */ void lambda$replicateActivity$5(ActivePassiveAckWaiter waiter, SessionID node, SyncReplicationActivity.ActivityID activityID, Boolean sent) {
        boolean complete;
        if (!sent.booleanValue() && (complete = waiter.failedToSendToPassive(node))) {
            this.waiters.remove(activityID);
        }
    }
}

