/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.exception.TCServerRestartException;
import com.tc.l2.msg.ReplicationResultCode;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.utils.L2Utils;
import com.tc.object.session.SessionID;
import com.tc.objectserver.entity.PassiveReplicationBroker;
import com.tc.util.Assert;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivePassiveAckWaiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivePassiveAckWaiter.class);
    private final Map<ServerID, SessionID> session;
    private final Set<SessionID> start;
    private final Set<SessionID> receivedPending;
    private final Set<SessionID> receivedByComplete;
    private final Set<SessionID> completedPending;
    private Runnable finalizer;
    private final Map<NodeID, ReplicationResultCode> results;
    private final PassiveReplicationBroker parent;
    private volatile boolean abandoned = false;

    public ActivePassiveAckWaiter(Map<ServerID, SessionID> map, Set<SessionID> allPassiveNodes, PassiveReplicationBroker parent) {
        this.session = map;
        this.start = Collections.unmodifiableSet(allPassiveNodes);
        this.receivedPending = new HashSet<SessionID>(allPassiveNodes);
        this.completedPending = new HashSet<SessionID>(allPassiveNodes);
        this.receivedByComplete = new HashSet<SessionID>();
        this.results = new HashMap<NodeID, ReplicationResultCode>();
        this.parent = parent;
    }

    public synchronized void waitForReceived() {
        try {
            while (!this.abandoned && !this.receivedPending.isEmpty()) {
                this.wait();
            }
            if (this.abandoned) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException ie) {
            L2Utils.handleInterrupted(LOGGER, ie);
        }
    }

    public synchronized void abandon() {
        this.abandoned = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenCompleted(Runnable r) {
        Runnable runInPlace = null;
        ActivePassiveAckWaiter activePassiveAckWaiter = this;
        synchronized (activePassiveAckWaiter) {
            this.finalizer = this.finalizer != null ? () -> {
                this.finalizer.run();
                r.run();
            } : r;
            if (this.completedPending.isEmpty()) {
                runInPlace = this.finalizer;
                this.finalizer = null;
            }
        }
        if (runInPlace != null) {
            runInPlace.run();
        }
    }

    public synchronized void waitForCompleted() {
        try {
            while (!this.abandoned && !this.completedPending.isEmpty()) {
                this.wait();
            }
            if (this.abandoned) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException ie) {
            L2Utils.handleInterrupted(LOGGER, ie);
        }
    }

    public boolean verifyLifecycleResult(boolean success) {
        if (this.results.entrySet().stream().anyMatch(e -> e.getValue() == (success ? ReplicationResultCode.FAIL : ReplicationResultCode.SUCCESS))) {
            boolean zapped = false;
            for (Map.Entry<NodeID, ReplicationResultCode> r : this.results.entrySet()) {
                if (r.getValue() != ReplicationResultCode.FAIL) continue;
                this.parent.zapAndWait(r.getKey());
                zapped = true;
            }
            if (!success) {
                throw new TCServerRestartException("inconsistent lifecycle");
            }
            return zapped;
        }
        return false;
    }

    public synchronized boolean isCompleted() {
        return this.completedPending.isEmpty();
    }

    private SessionID nodeToSession(ServerID node) {
        return this.session.getOrDefault(node, SessionID.NULL_ID);
    }

    public synchronized void didReceiveOnPassive(ServerID onePassive) {
        SessionID current = this.nodeToSession(onePassive);
        boolean didContain = this.receivedPending.remove(current);
        if (!didContain) {
            Assert.assertTrue((Object)(onePassive + " " + this.toString()), (boolean)this.receivedByComplete.contains(current));
        }
        if (this.receivedPending.isEmpty()) {
            this.notifyAll();
        }
    }

    public boolean didCompleteOnPassive(ServerID onePassive, ReplicationResultCode payload) {
        this.results.put((NodeID)onePassive, payload);
        return this.runFinalizerOnComplete(this.updateCompletionFlags(this.nodeToSession(onePassive), true));
    }

    public boolean failedToSendToPassive(SessionID session) {
        return this.runFinalizerOnComplete(this.updateCompletionFlags(session, false));
    }

    private boolean runFinalizerOnComplete(boolean completed) {
        Runnable clear;
        if (completed && (clear = this.clearFinalizer()) != null) {
            clear.run();
        }
        return completed;
    }

    private synchronized Runnable clearFinalizer() {
        Runnable f = this.finalizer;
        this.finalizer = null;
        return f;
    }

    private synchronized boolean updateCompletionFlags(SessionID onePassive, boolean isNormal) {
        boolean didContainInReceived = this.receivedPending.remove(onePassive);
        if (didContainInReceived) {
            this.receivedByComplete.add(onePassive);
        }
        boolean didContainInCompleted = this.completedPending.remove(onePassive);
        if (isNormal && !didContainInCompleted) {
            throw new AssertionError((Object)"was completed twice");
        }
        boolean isDoneWaiting = this.completedPending.isEmpty();
        if (didContainInReceived && this.receivedPending.isEmpty() || isDoneWaiting) {
            this.notifyAll();
        }
        return isDoneWaiting;
    }

    public String toString() {
        return "ActivePassiveAckWaiter{start=" + this.start + ", receivedPending=" + this.receivedPending + ", receivedByComplete=" + this.receivedByComplete + ", completedPending=" + this.completedPending + ", results=" + this.results + '}';
    }
}

