/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.util.concurrent.SetOnceFlag;
import java.util.function.Consumer;
import org.terracotta.entity.ActiveInvokeChannel;
import org.terracotta.entity.EntityResponse;

public class ActiveInvokeChannelImpl<R extends EntityResponse>
implements ActiveInvokeChannel<R> {
    private final Consumer<R> account;
    private final Consumer<Exception> exception;
    private final Runnable retirementTrigger;
    private final SetOnceFlag closed = new SetOnceFlag();

    public ActiveInvokeChannelImpl(Consumer<R> account, Consumer<Exception> exception, Runnable retirementTrigger) {
        this.account = account;
        this.exception = exception;
        this.retirementTrigger = retirementTrigger;
    }

    public void sendResponse(R response) {
        if (this.closed.isSet()) {
            throw new IllegalStateException("trying to send a response on a closed channel");
        }
        this.account.accept(response);
    }

    public void sendException(Exception response) {
        if (!this.closed.attemptSet()) {
            throw new IllegalStateException("trying to send an exception on a closed channel");
        }
        this.exception.accept(response);
    }

    public void close() {
        if (this.closed.attemptSet()) {
            this.retirementTrigger.run();
        }
    }
}

