/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.entity;

import com.tc.entity.VoltronEntityAppliedResponse;
import com.tc.entity.VoltronEntityReceivedResponse;
import com.tc.entity.VoltronEntityResponse;
import com.tc.entity.VoltronEntityRetiredResponse;
import com.tc.exception.ServerException;
import com.tc.net.ClientID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.utils.L2Utils;
import com.tc.object.ClientInstanceID;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.Retiree;
import com.tc.objectserver.api.ServerEntityAction;
import com.tc.objectserver.api.ServerEntityRequest;
import com.tc.objectserver.api.ServerEntityResponse;
import com.tc.util.Assert;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public abstract class AbstractServerEntityRequestResponse
implements ServerEntityRequest,
ServerEntityResponse,
Retiree {
    private final ServerEntityRequest request;
    private final Consumer<byte[]> complete;
    private final Consumer<ServerException> fail;
    private final Consumer<VoltronEntityResponse> messageSender;
    private boolean isComplete = false;
    private boolean isRetired = false;
    private volatile Future<Void> transactionOrderPersistenceFuture;

    public AbstractServerEntityRequestResponse(ServerEntityRequest action, Consumer<VoltronEntityResponse> messageSender, Consumer<byte[]> complete, Consumer<ServerException> fail) {
        this.request = action;
        this.messageSender = messageSender;
        this.complete = complete;
        this.fail = fail;
    }

    public abstract Optional<MessageChannel> getReturnChannel();

    @Override
    public ClientInstanceID getClientInstance() {
        return this.request.getClientInstance();
    }

    @Override
    public boolean requiresReceived() {
        return this.request.requiresReceived();
    }

    @Override
    public TransactionID getTransaction() {
        return this.request.getTransaction();
    }

    @Override
    public TransactionID getOldestTransactionOnClient() {
        return this.request.getOldestTransactionOnClient();
    }

    @Override
    public Set<SessionID> replicateTo(Set<SessionID> current) {
        return this.request.replicateTo(current);
    }

    @Override
    public String getTraceID() {
        return this.request.getTraceID();
    }

    @Override
    public ClientID getNodeID() {
        return this.request.getNodeID();
    }

    @Override
    public ServerEntityAction getAction() {
        return this.request.getAction();
    }

    @Override
    public void failure(ServerException e) {
        if (!this.getNodeID().isNull()) {
            this.getReturnChannel().ifPresent(channel -> {
                VoltronEntityAppliedResponse message = (VoltronEntityAppliedResponse)channel.createMessage(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE);
                message.setFailure(this.request.getTransaction(), e);
                this.messageSender.accept((VoltronEntityResponse)message);
            });
            this.isComplete = true;
        }
        if (this.fail != null) {
            this.fail.accept(e);
        }
    }

    @Override
    public synchronized void received() {
        this.getReturnChannel().ifPresent(channel -> {
            VoltronEntityReceivedResponse message = (VoltronEntityReceivedResponse)channel.createMessage(TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE);
            if (this.transactionOrderPersistenceFuture != null) {
                try {
                    this.transactionOrderPersistenceFuture.get();
                }
                catch (InterruptedException ie) {
                    L2Utils.handleInterrupted(null, ie);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Caught exception while persisting transaction order", e);
                }
            }
            message.setTransactionID(this.request.getTransaction());
            this.messageSender.accept((VoltronEntityResponse)message);
        });
    }

    @Override
    public void complete() {
        if (!this.getNodeID().isNull()) {
            this.getReturnChannel().ifPresent(channel -> {
                VoltronEntityAppliedResponse actionResponse = (VoltronEntityAppliedResponse)channel.createMessage(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE);
                switch (this.request.getAction()) {
                    case DISCONNECT_CLIENT: {
                        break;
                    }
                    case FETCH_ENTITY: 
                    case CREATE_ENTITY: 
                    case DESTROY_ENTITY: 
                    case RELEASE_ENTITY: {
                        actionResponse.setSuccess(this.request.getTransaction(), new byte[0]);
                        this.messageSender.accept((VoltronEntityResponse)actionResponse);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected action in complete() " + (Object)((Object)this.request.getAction()));
                    }
                }
            });
            this.isComplete = true;
        }
        if (this.complete != null) {
            this.complete.accept(null);
        }
    }

    @Override
    public void complete(byte[] value) {
        if (!this.getNodeID().isNull()) {
            this.getReturnChannel().ifPresent(channel -> {
                switch (this.request.getAction()) {
                    case DISCONNECT_CLIENT: {
                        break;
                    }
                    case INVOKE_ACTION: 
                    case FETCH_ENTITY: 
                    case RECONFIGURE_ENTITY: {
                        VoltronEntityAppliedResponse actionResponse = (VoltronEntityAppliedResponse)channel.createMessage(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE);
                        actionResponse.setSuccess(this.request.getTransaction(), value);
                        this.messageSender.accept((VoltronEntityResponse)actionResponse);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected action in complete(byte[]) " + (Object)((Object)this.request.getAction()));
                    }
                }
            });
            this.isComplete = true;
        }
        if (this.complete != null) {
            this.complete.accept(value);
        }
    }

    public void setTransactionOrderPersistenceFuture(Future<Void> transactionOrderPersistenceFuture) {
        this.transactionOrderPersistenceFuture = transactionOrderPersistenceFuture;
    }

    @Override
    public CompletionStage<Void> retired() {
        Assert.assertTrue((Object)"Double-retire", (!this.isRetired() ? 1 : 0) != 0);
        this.getReturnChannel().ifPresent(channel -> {
            VoltronEntityRetiredResponse response = (VoltronEntityRetiredResponse)channel.createMessage(TCMessageType.VOLTRON_ENTITY_RETIRED_RESPONSE);
            response.setTransactionID(this.request.getTransaction());
            this.messageSender.accept((VoltronEntityResponse)response);
        });
        this.isRetired = true;
        return CompletableFuture.completedFuture(null);
    }

    protected boolean isComplete() {
        return this.isComplete;
    }

    protected boolean isRetired() {
        return this.isRetired;
    }
}

