/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.core.impl;

import com.tc.async.api.StageManager;
import com.tc.async.impl.ConfigurationContextImpl;
import com.tc.l2.api.L2Coordinator;
import com.tc.object.net.ChannelStats;
import com.tc.object.net.DSOChannelManager;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.handshakemanager.ServerClientHandshakeManager;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ServerConfigurationContextImpl
extends ConfigurationContextImpl
implements ServerConfigurationContext {
    private final DSOChannelManager channelManager;
    private final ServerClientHandshakeManager clientHandshakeManager;
    private final ChannelStats channelStats;
    private final L2Coordinator l2Coordinator;
    private final List<Runnable> shutdownItems = Collections.synchronizedList(new LinkedList());

    public ServerConfigurationContextImpl(String identifier, StageManager stageManager, DSOChannelManager channelManager, ServerClientHandshakeManager clientHandshakeManager, ChannelStats channelStats, L2Coordinator l2Coordinator) {
        super(identifier, stageManager);
        this.channelManager = channelManager;
        this.clientHandshakeManager = clientHandshakeManager;
        this.channelStats = channelStats;
        this.l2Coordinator = l2Coordinator;
    }

    @Override
    public L2Coordinator getL2Coordinator() {
        return this.l2Coordinator;
    }

    @Override
    public ServerClientHandshakeManager getClientHandshakeManager() {
        return this.clientHandshakeManager;
    }

    @Override
    public ChannelStats getChannelStats() {
        return this.channelStats;
    }

    @Override
    public void addShutdownItem(Runnable c) {
        this.shutdownItems.add(c);
    }

    @Override
    public void shutdown() {
        this.shutdownItems.forEach(Runnable::run);
        this.clientHandshakeManager.stop();
    }
}

