/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.core.impl;

import com.tc.l2.state.StateManager;
import com.tc.net.ClientID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.objectserver.core.api.ITopologyEventCollector;
import com.tc.objectserver.entity.ClientDescriptorImpl;
import com.tc.objectserver.handshakemanager.ClientHandshakeMonitoringInfo;
import com.tc.util.Assert;
import com.tc.util.State;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.monitoring.IMonitoringProducer;
import org.terracotta.monitoring.PlatformClientFetchedEntity;
import org.terracotta.monitoring.PlatformConnectedClient;
import org.terracotta.monitoring.PlatformEntity;
import org.terracotta.monitoring.PlatformMonitoringConstants;
import org.terracotta.monitoring.ServerState;

public class ManagementTopologyEventCollector
implements ITopologyEventCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementTopologyEventCollector.class);
    private final IMonitoringProducer serviceInterface;
    private final Set<ClientID> connectedClients;
    private final Map<Long, EntityID> entities;
    private final Map<ClientID, Collection<FetchID>> incomingDisconnects;
    private final Map<ClientID, Collection<ClientInstanceID>> incomingReleases;
    private final Map<ClientID, Collection<ResolvedDescriptors>> incomingFetches;
    private boolean isActiveState;

    public ManagementTopologyEventCollector(IMonitoringProducer serviceInterface) {
        this.serviceInterface = serviceInterface;
        this.connectedClients = new HashSet<ClientID>();
        this.entities = new HashMap<Long, EntityID>();
        this.incomingReleases = new HashMap<ClientID, Collection<ClientInstanceID>>();
        this.incomingFetches = new HashMap<ClientID, Collection<ResolvedDescriptors>>();
        this.incomingDisconnects = new HashMap<ClientID, Collection<FetchID>>();
        this.isActiveState = false;
        if (null != this.serviceInterface) {
            this.serviceInterface.addNode(new String[0], "platform", null);
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "clients", null);
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "entities", null);
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "fetched", null);
        }
    }

    @Override
    public synchronized void serverDidEnterState(State state, long activateTime) {
        String stateValue;
        this.isActiveState = StateManager.ACTIVE_COORDINATOR.getName().equals(state.getName());
        boolean syncing = false;
        boolean standby = false;
        if (!this.isActiveState && !(syncing = StateManager.PASSIVE_SYNCING.equals((Object)state))) {
            standby = StateManager.PASSIVE_STANDBY.equals((Object)state);
        }
        String string = this.isActiveState ? "ACTIVE" : (standby ? "PASSIVE" : (stateValue = syncing ? "SYNCHRONIZING" : "UNINITIALIZED"));
        if (null != this.serviceInterface) {
            this.serviceInterface.addNode(PlatformMonitoringConstants.PLATFORM_PATH, "state", (Serializable)new ServerState(stateValue, System.currentTimeMillis(), activateTime));
        }
        LOGGER.debug("server entered state " + state + " at " + activateTime);
    }

    @Override
    public synchronized void clientDidConnect(MessageChannel channel, ClientID client) {
        Assert.assertFalse((boolean)this.connectedClients.contains(client));
        this.connectedClients.add(client);
        Collection<ResolvedDescriptors> earlyFetches = this.incomingFetches.remove(client);
        if (null != this.serviceInterface) {
            InetSocketAddress localAddress = channel.getLocalAddress();
            InetSocketAddress remoteAddress = channel.getRemoteAddress();
            ClientHandshakeMonitoringInfo minfo = (ClientHandshakeMonitoringInfo)channel.getAttachment(ClientHandshakeMonitoringInfo.MONITORING_INFO_ATTACHMENT);
            Assert.assertNotNull((Object)minfo);
            PlatformConnectedClient clientDescription = new PlatformConnectedClient(minfo.getUuid(), minfo.getName(), localAddress.getAddress(), localAddress.getPort(), remoteAddress.getAddress(), remoteAddress.getPort(), (long)minfo.getPid() & 0xFFFFFFFFL);
            String nodeName = this.clientIdentifierForService(client);
            this.serviceInterface.addNode(PlatformMonitoringConstants.CLIENTS_PATH, nodeName, (Serializable)clientDescription);
            String[] extrasPath = Arrays.copyOf(PlatformMonitoringConstants.CLIENTS_PATH, PlatformMonitoringConstants.CLIENTS_PATH.length + 1);
            extrasPath[PlatformMonitoringConstants.CLIENTS_PATH.length] = nodeName;
            if (minfo.hasClientVersion()) {
                this.serviceInterface.addNode(extrasPath, "version", (Serializable)((Object)minfo.getVersion()));
            }
            if (minfo.hasClientReportedAddress()) {
                this.serviceInterface.addNode(extrasPath, "clientReportedAddress", (Serializable)((Object)minfo.getClientReportedAddress()));
            }
            if (minfo.hasClientRevision()) {
                this.serviceInterface.addNode(extrasPath, "clientRevision", (Serializable)((Object)minfo.getRevision()));
            }
            if (earlyFetches != null && !earlyFetches.isEmpty()) {
                for (ResolvedDescriptors ed : earlyFetches) {
                    String fetchIdentifier = this.fetchIdentifierForService(client, ed.id, ed.consumerID, ed.instance);
                    boolean didAdd = this.serviceInterface.addNode(PlatformMonitoringConstants.FETCHED_PATH, fetchIdentifier, (Serializable)new PlatformClientFetchedEntity(this.clientIdentifierForService(client), this.entityIdentifierForService(ed.id, ed.consumerID), (ClientDescriptor)new ClientDescriptorImpl(client, ed.getClientInstanceID())));
                    if (didAdd) continue;
                    LOGGER.warn("unbalanced client connect " + fetchIdentifier);
                }
            }
        }
        LOGGER.debug("client did connect " + channel);
    }

    public synchronized void clientDidDisconnect(ClientID client) {
        Assert.assertTrue((boolean)this.connectedClients.contains(client));
        this.connectedClients.remove(client);
        this.removeClientIfPossible(client);
        LOGGER.debug("client did disconnect " + client);
    }

    @Override
    public synchronized void entityWasCreated(EntityID id, long consumerID, boolean isActive) {
        Assert.assertTrue((isActive == this.isActiveState ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.entities.containsKey(consumerID));
        this.addEntityToTracking(id, consumerID, isActive);
        LOGGER.debug("entity created " + id);
    }

    @Override
    public synchronized void entityWasDestroyed(EntityID id, long consumerID) {
        Assert.assertTrue((boolean)this.entities.containsKey(consumerID));
        this.removeEntityFromTracking(id, consumerID);
        LOGGER.debug("entity destroyed " + id);
    }

    @Override
    public synchronized void entityWasReloaded(EntityID id, long consumerID, boolean isActive) {
        this.addEntityToTracking(id, consumerID, isActive);
        LOGGER.debug("entity reloaded " + id);
    }

    @Override
    public synchronized void clientDidFetchEntity(ClientID client, EntityID entity, long consumerID, ClientInstanceID instance) {
        if (null != this.serviceInterface) {
            String clientIdentifier = this.clientIdentifierForService(client);
            String entityIdentifier = this.entityIdentifierForService(entity, consumerID);
            PlatformClientFetchedEntity record = new PlatformClientFetchedEntity(clientIdentifier, entityIdentifier, (ClientDescriptor)new ClientDescriptorImpl(client, instance));
            if (this.connectedClients.contains(client)) {
                String fetchIdentifier = this.fetchIdentifierForService(client, entity, consumerID, instance);
                boolean didAdd = this.serviceInterface.addNode(PlatformMonitoringConstants.FETCHED_PATH, fetchIdentifier, (Serializable)record);
                if (!didAdd) {
                    LOGGER.warn("unbalanced client fetch " + fetchIdentifier);
                }
            } else {
                Collection set = this.incomingFetches.computeIfAbsent(client, c -> new HashSet());
                set.add(new ResolvedDescriptors(entity, consumerID, instance));
            }
        }
        LOGGER.debug("client " + client + " fetched " + instance);
    }

    @Override
    public synchronized void clientDidReleaseEntity(ClientID client, EntityID entity, long consumerID, ClientInstanceID instance) {
        String fetchIdentifier;
        boolean didRemove;
        if (null != this.serviceInterface && !(didRemove = this.serviceInterface.removeNode(PlatformMonitoringConstants.FETCHED_PATH, fetchIdentifier = this.fetchIdentifierForService(client, entity, consumerID, instance)))) {
            LOGGER.warn("unbalanced client release " + fetchIdentifier);
        }
        if (this.incomingReleases.containsKey(client)) {
            Collection<ClientInstanceID> expected = this.incomingReleases.get(client);
            Assert.assertTrue((boolean)expected.remove(instance));
            if (expected.isEmpty()) {
                this.incomingReleases.remove(client);
                this.removeClientIfPossible(client);
            }
        }
        LOGGER.debug("client " + client + " released " + entity);
    }

    public synchronized void expectedDisconnects(ClientID cid, Collection<FetchID> releases) {
        if (null != this.serviceInterface) {
            if (!releases.isEmpty()) {
                this.incomingDisconnects.put(cid, new ArrayList<FetchID>(releases));
            } else {
                Assert.assertFalse((boolean)this.incomingReleases.containsKey(cid));
                Assert.assertTrue((boolean)this.removeClientIfPossible(cid));
            }
        }
    }

    public synchronized void clientDisconnectedFromEntity(ClientID cid, FetchID fetch, Collection<EntityDescriptor> fids) {
        if (null != this.serviceInterface) {
            Collection<FetchID> fetches = this.incomingDisconnects.get(cid);
            this.expectedReleases(cid, fids);
            Assert.assertTrue((boolean)fetches.remove(fetch));
            if (fetches.isEmpty()) {
                this.incomingDisconnects.remove(cid);
                this.removeClientIfPossible(cid);
            }
        }
    }

    private boolean removeClientIfPossible(ClientID client) {
        if (!this.incomingReleases.containsKey(client) && !this.incomingDisconnects.containsKey(client)) {
            if (null != this.serviceInterface) {
                String nodeName = this.clientIdentifierForService(client);
                this.serviceInterface.removeNode(PlatformMonitoringConstants.CLIENTS_PATH, nodeName);
            }
            return true;
        }
        return false;
    }

    private void expectedReleases(ClientID cid, Collection<EntityDescriptor> releases) {
        if (!releases.isEmpty()) {
            this.incomingReleases.compute(cid, (ignore, ex) -> {
                if (ex == null) {
                    ex = new HashSet();
                }
                ex.addAll(releases.stream().map(EntityDescriptor::getClientInstanceID).collect(Collectors.toList()));
                return ex;
            });
        }
    }

    private void addEntityToTracking(EntityID id, long consumerID, boolean isActive) {
        this.entities.put(consumerID, id);
        if (null != this.serviceInterface) {
            String entityClassName = id.getClassName();
            String entityName = id.getEntityName();
            PlatformEntity record = new PlatformEntity(entityClassName, entityName, consumerID, isActive);
            String entityIdentifier = this.entityIdentifierForService(id, consumerID);
            this.serviceInterface.addNode(PlatformMonitoringConstants.ENTITIES_PATH, entityIdentifier, (Serializable)record);
        }
    }

    private void removeEntityFromTracking(EntityID id, long consumerID) {
        this.entities.remove(consumerID);
        if (null != this.serviceInterface) {
            String entityIdentifier = this.entityIdentifierForService(id, consumerID);
            this.serviceInterface.removeNode(PlatformMonitoringConstants.ENTITIES_PATH, entityIdentifier);
        }
    }

    private String clientIdentifierForService(ClientID id) {
        return "" + id.toLong();
    }

    private String entityIdentifierForService(EntityID id, long consumerID) {
        return id.getClassName() + id.getEntityName() + consumerID;
    }

    private String fetchIdentifierForService(ClientID client, EntityID entity, long consumerID, ClientInstanceID cid) {
        return this.clientIdentifierForService(client) + "_" + this.entityIdentifierForService(entity, consumerID) + "_" + cid.getID();
    }

    private static class ResolvedDescriptors {
        private final EntityID id;
        private final long consumerID;
        private final ClientInstanceID instance;

        public ResolvedDescriptors(EntityID entityID, long consumerID, ClientInstanceID instance) {
            this.id = entityID;
            this.consumerID = consumerID;
            this.instance = instance;
        }

        public long getConsumerID() {
            return this.consumerID;
        }

        public ClientInstanceID getClientInstanceID() {
            return this.instance;
        }

        public EntityID getEntityID() {
            return this.id;
        }
    }
}

