/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.core.impl;

import com.tc.net.ClientID;
import com.tc.net.TCSocketAddress;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.objectserver.core.impl.ServerManagementContext;
import com.tc.objectserver.handshakemanager.ClientHandshakeMonitoringInfo;
import com.tc.objectserver.impl.DistributedObjectServer;
import com.tc.server.TCServerImpl;
import com.tc.spi.Guardian;
import com.tc.util.Assert;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class GuardianContext {
    private static final ConcurrentHashMap<ChannelID, MessageChannel> CONTEXT = new ConcurrentHashMap();
    private static final ThreadLocal<ChannelID> CURRENTID = new ThreadLocal();
    private static TCServerImpl server;

    public static void setServer(TCServerImpl server) {
        GuardianContext.server = server;
    }

    private static Properties createGuardContext(String callName) {
        return GuardianContext.createGuardContext(callName, new Properties());
    }

    private static Properties createGuardContext(String callName, Properties existing) {
        ChannelID cid = CURRENTID.get();
        if (cid != null) {
            Properties props = GuardianContext.createGuardContext(callName, existing, CONTEXT.get(cid));
            props.setProperty("clientID", Long.toString(cid.toLong()));
            return props;
        }
        return new Properties();
    }

    private static Properties createGuardContext(String callName, Properties props, MessageChannel c) {
        if (callName != null) {
            props.setProperty("id", callName);
        }
        if (c != null) {
            ClientHandshakeMonitoringInfo info = (ClientHandshakeMonitoringInfo)c.getAttachment(ClientHandshakeMonitoringInfo.MONITORING_INFO_ATTACHMENT);
            props.setProperty(ClientHandshakeMonitoringInfo.MONITORING_INFO_ATTACHMENT, String.valueOf(info));
            String handshakeAddress = "";
            if (info != null) {
                GuardianContext.translateMaptoProperty(props, "handshake", info.getStateMap());
                handshakeAddress = info.getClientReportedAddress();
            }
            props.setProperty("product", c.getProductID().name());
            MessageTransport transport = (MessageTransport)c.getAttachment("transportInfo");
            String remoteAddress = "";
            if (transport != null) {
                GuardianContext.translateMaptoProperty(props, "transportInfo", transport.getStateMap());
                remoteAddress = TCSocketAddress.getStringForm((InetSocketAddress)transport.getRemoteAddress());
            }
            props.setProperty("natDetected", Boolean.toString(!handshakeAddress.equals(remoteAddress)));
        }
        return props;
    }

    private static void translateMaptoProperty(Properties props, String root, Map<String, ?> map) {
        map.forEach((k, v) -> {
            if (v instanceof Map) {
                GuardianContext.translateMaptoProperty(props, root + "." + k, (Map)v);
            } else {
                props.put(root + "." + k, String.valueOf(v));
            }
        });
    }

    public static void channelCreated(MessageChannel channel) {
        CONTEXT.put(channel.getChannelID(), channel);
    }

    public static void channelRemoved(MessageChannel channel) {
        CONTEXT.remove(channel.getChannelID());
    }

    public static void clientRemoved(ClientID removed) {
        CONTEXT.remove(removed.getChannelID());
    }

    public static boolean attach(String name, Object data) {
        MessageChannel channel = CONTEXT.get(CURRENTID.get());
        if (channel != null) {
            channel.addAttachment(name, data, true);
            return true;
        }
        return false;
    }

    public static void setCurrentChannelID(ChannelID cid) {
        CURRENTID.set(cid);
    }

    public static void clearCurrentChannelID(ChannelID cid) {
        ChannelID current = CURRENTID.get();
        Assert.assertEquals((Object)cid, (Object)current);
        CURRENTID.remove();
    }

    public static Properties getCurrentChannelProperties() {
        return GuardianContext.createGuardContext("context");
    }

    public static MessageChannel getCurrentMessageChannel() {
        ChannelID current = CURRENTID.get();
        return CONTEXT.get(current);
    }

    private static Guardian getOperationGuardian() {
        ServerManagementContext cxt;
        DistributedObjectServer dso;
        if (server != null && (dso = server.getDSOServer()) != null && (cxt = dso.getManagementContext()) != null) {
            return cxt.getOperationGuardian();
        }
        return (o, p) -> true;
    }

    public static boolean validate(Guardian.Op op, String id) {
        return GuardianContext.getOperationGuardian().validate(op, GuardianContext.createGuardContext(id));
    }

    public static boolean validate(Guardian.Op op, String id, MessageChannel channel) {
        return GuardianContext.getOperationGuardian().validate(op, GuardianContext.createGuardContext(id, new Properties(), channel));
    }

    public static boolean validate(Guardian.Op op, String id, Properties additional) {
        return GuardianContext.getOperationGuardian().validate(op, GuardianContext.createGuardContext(id, additional));
    }
}

