/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

import com.tc.l2.L2DebugLogging;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.TCGroupManagerImpl;
import com.tc.net.groups.TCGroupMember;
import com.tc.net.groups.TCGroupMessageWrapper;
import com.tc.net.protocol.tcm.ChannelEvent;
import com.tc.net.protocol.tcm.ChannelEventListener;
import com.tc.net.protocol.tcm.ChannelEventType;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.utils.L2Utils;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCGroupMemberImpl
implements TCGroupMember,
ChannelEventListener {
    private static final Logger logger = LoggerFactory.getLogger(TCGroupMemberImpl.class);
    private TCGroupManagerImpl manager;
    private final MessageChannel channel;
    private final ServerID localNodeID;
    private final ServerID peerNodeID;
    private final AtomicBoolean ready = new AtomicBoolean(false);
    private final AtomicBoolean joined = new AtomicBoolean(false);
    private volatile boolean memberAdding = false;

    public TCGroupMemberImpl(ServerID localNodeID, ServerID peerNodeID, MessageChannel channel) {
        this.channel = channel;
        this.localNodeID = localNodeID;
        this.peerNodeID = peerNodeID;
        this.channel.addListener((ChannelEventListener)this);
    }

    @Override
    public MessageChannel getChannel() {
        return this.channel;
    }

    @Override
    public void send(AbstractGroupMessage msg, Runnable sentCallback) throws GroupException {
        if (!this.channel.isOpen()) {
            throw new GroupException("Channel is not ready: " + this.toString());
        }
        this.sendMessage(msg, sentCallback);
    }

    @Override
    public void sendIgnoreNotReady(AbstractGroupMessage msg) {
        if (!this.channel.isOpen()) {
            logger.warn("Attempting send to a not ready member " + this + ", msg will not be sent: " + msg);
            return;
        }
        Runnable sentCallback = null;
        try {
            this.sendMessage(msg, sentCallback);
        }
        catch (GroupException ge) {
            logger.warn("Attempting send to a not ready member " + this + ", msg will not be sent: " + msg, (Throwable)ge);
        }
    }

    private void sendMessage(AbstractGroupMessage msg, Runnable sentCallback) throws GroupException {
        TCGroupMessageWrapper wrapper = (TCGroupMessageWrapper)this.channel.createMessage(TCMessageType.GROUP_WRAPPER_MESSAGE);
        wrapper.setGroupMessage(msg);
        if (null != sentCallback) {
            wrapper.addProcessedCallback(sentCallback);
        }
        if (!wrapper.send()) {
            throw new GroupException("message not sent:" + msg);
        }
    }

    public String toString() {
        return "Group Member: " + this.localNodeID + " <-> " + this.peerNodeID + " " + this.channel + "; Ready:" + this.ready + "; Joined: " + this.joined + "; memberAdding:" + this.memberAdding + "; HighPri: " + this.isHighPriorityNode();
    }

    public void notifyChannelEvent(ChannelEvent event) {
        if (event.getChannel() == this.channel) {
            if (event.getType() == ChannelEventType.TRANSPORT_CONNECTED_EVENT) {
                if (this.isJoinedEventFired()) {
                    this.ready.set(true);
                }
            } else if (event.getType() == ChannelEventType.TRANSPORT_DISCONNECTED_EVENT || event.getType() == ChannelEventType.CHANNEL_CLOSED_EVENT) {
                this.ready.set(false);
            }
        }
    }

    @Override
    public ServerID getLocalNodeID() {
        return this.localNodeID;
    }

    @Override
    public ServerID getPeerNodeID() {
        return this.peerNodeID;
    }

    @Override
    public void setTCGroupManager(TCGroupManagerImpl manager) {
        this.manager = manager;
    }

    @Override
    public TCGroupManagerImpl getTCGroupManager() {
        return this.manager;
    }

    @Override
    public boolean isReady() {
        this.waitForMemberAdded();
        return this.ready.get();
    }

    @Override
    public void setReady(boolean isReady) {
        this.ready.set(isReady);
    }

    @Override
    public boolean isJoinedEventFired() {
        return this.joined.get();
    }

    @Override
    public void setJoinedEventFired(boolean isReady) {
        this.joined.set(isReady);
    }

    @Override
    public void close() {
        this.ready.set(false);
        TCGroupMemberImpl.debugInfo("Closing channel: " + this.channel);
        this.getChannel().close();
    }

    @Override
    public boolean isHighPriorityNode() {
        return this.localNodeID.compareTo((NodeID)this.peerNodeID) > 0;
    }

    @Override
    public synchronized void memberAddingInProcess() {
        this.memberAdding = true;
    }

    @Override
    public synchronized void abortMemberAdding() {
        if (this.memberAdding) {
            this.memberAdding = false;
            this.notifyAll();
        }
    }

    @Override
    public synchronized void notifyMemberAdded() {
        this.memberAdding = false;
        this.notifyAll();
    }

    private synchronized void waitForMemberAdded() {
        while (this.memberAdding) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                L2Utils.handleInterrupted(logger, e);
            }
        }
    }

    private static void debugInfo(String message) {
        L2DebugLogging.log(logger, L2DebugLogging.LogLevel.INFO, message, null);
    }
}

