/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

import java.util.Objects;

public class Node {
    private static final String DELIMITER = ":";
    private final String host;
    private final int port;
    private final int groupPort;
    private final int hashCode;

    public Node(String host, int port) {
        this(host, port, 0);
    }

    public Node(String host, int port, int groupPort) {
        Node.checkArgs(host, port, groupPort);
        this.host = host.trim();
        this.port = port;
        this.groupPort = groupPort;
        this.hashCode = Objects.hash(host, port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getGroupPort() {
        return this.groupPort;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Node) {
            Node that = (Node)obj;
            return this.port == that.port && this.host.equals(that.host);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static void checkArgs(String host, int port, int groupPort) throws IllegalArgumentException {
        if (host == null || host.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid host name: " + host);
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port number: " + port);
        }
        if (groupPort < 0) {
            throw new IllegalArgumentException("Invalid group port number: " + groupPort);
        }
    }

    public String toString() {
        return "Node{host=" + this.getName() + "}";
    }

    public String getServerNodeName() {
        return this.getName();
    }

    private String getName() {
        return this.host + DELIMITER + this.port;
    }

    private static String getHost(String hostPort) {
        Objects.requireNonNull(hostPort);
        return hostPort.split(DELIMITER)[0];
    }

    private static int getPort(String hostPort) {
        Objects.requireNonNull(hostPort);
        String[] tokens = hostPort.split(DELIMITER);
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Unexpected format: " + hostPort + " expected: host" + DELIMITER + "port");
        }
        return Integer.parseInt(tokens[1]);
    }
}

