/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management.beans;

import com.tc.async.impl.MonitoringEventCreator;
import com.tc.l2.context.StateChangedEvent;
import com.tc.l2.state.ServerMode;
import com.tc.l2.state.StateChangeListener;
import com.tc.l2.state.StateManager;
import com.tc.management.AbstractTerracottaMBean;
import com.tc.management.beans.StateChangeNotificationInfo;
import com.tc.management.beans.TCServerInfoMBean;
import com.tc.productinfo.ProductInfo;
import com.tc.properties.TCPropertiesImpl;
import com.tc.runtime.JVMMemoryManager;
import com.tc.runtime.TCRuntime;
import com.tc.server.TCServer;
import com.tc.stats.Client;
import com.tc.text.AbbreviatedMapListPrettyPrint;
import com.tc.text.MapListPrettyPrint;
import com.tc.text.PrettyPrinter;
import com.tc.util.StringUtil;
import com.tc.util.runtime.ThreadDumpUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.server.ServerEnv;
import org.terracotta.server.StopAction;

public class TCServerInfo
extends AbstractTerracottaMBean
implements TCServerInfoMBean,
StateChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(TCServerInfo.class);
    private static final boolean DEBUG = false;
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private final TCServer server;
    private final ProductInfo productInfo;
    private final String buildID;
    private final StateChangeNotificationInfo stateChangeNotificationInfo;
    private long nextSequenceNumber;
    private final JVMMemoryManager manager;

    public TCServerInfo(TCServer server) throws NotCompliantMBeanException {
        super(TCServerInfoMBean.class, true);
        this.server = server;
        this.productInfo = server.productInfo();
        this.buildID = this.productInfo.buildID();
        this.nextSequenceNumber = 1L;
        this.stateChangeNotificationInfo = new StateChangeNotificationInfo();
        this.manager = TCRuntime.getJVMMemoryManager();
        if (TCPropertiesImpl.getProperties().getBoolean("tc.pipeline.monitoring.stats", false)) {
            this.setPipelineMonitoring(true);
        }
    }

    public void reset() {
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public boolean isActive() {
        return this.server.isActive();
    }

    public boolean isPassiveUninitialized() {
        return this.server.isPassiveUnitialized();
    }

    public boolean isPassiveStandby() {
        return this.server.isPassiveStandby();
    }

    public boolean isReconnectWindow() {
        return this.server.isReconnectWindow();
    }

    public boolean isAcceptingClients() {
        return this.server.isAcceptingClients();
    }

    public int getReconnectWindowTimeout() {
        return this.server.getReconnectWindowTimeout();
    }

    public long getStartTime() {
        return this.server.getStartTime();
    }

    public long getActivateTime() {
        return this.server.getActivateTime();
    }

    public void stop() {
        this.server.stop(new StopAction[0]);
        this._sendNotification("TCServer stopped", "Started", "java.lang.Boolean", Boolean.TRUE, Boolean.FALSE);
    }

    public boolean stopAndWait() {
        this.server.stop(new StopAction[0]);
        return this.server.waitUntilShutdown();
    }

    public boolean isShutdownable() {
        return this.server.canShutdown();
    }

    public void shutdown() {
        if (!this.server.canShutdown()) {
            String msg = "Server cannot be shutdown because it is not fully started.";
            logger.error(msg);
            throw new RuntimeException(msg);
        }
        logger.warn("shutdown is invoked by MBean");
        Timer timer = new Timer("TCServerInfo shutdown timer");
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                TCServerInfo.this.server.shutdown();
            }
        };
        timer.schedule(task, 1000L);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return Arrays.asList(NOTIFICATION_INFO).toArray(EMPTY_NOTIFICATION_INFO);
    }

    public String toString() {
        if (this.isStarted()) {
            return "starting, startTime(" + this.getStartTime() + ")";
        }
        if (this.isActive()) {
            return "active, activateTime(" + this.getActivateTime() + ")";
        }
        return "stopped";
    }

    public String getState() {
        return this.server.getState().getName();
    }

    public String getVersion() {
        return this.productInfo.toShortString();
    }

    public String getBuildID() {
        return this.buildID;
    }

    public boolean isPatched() {
        return this.productInfo.isPatched();
    }

    public String getPatchLevel() {
        if (this.productInfo.isPatched()) {
            return this.productInfo.patchLevel();
        }
        return "";
    }

    public String getPatchVersion() {
        if (this.productInfo.isPatched()) {
            return this.productInfo.toLongPatchString();
        }
        return "";
    }

    public String getPatchBuildID() {
        if (this.productInfo.isPatched()) {
            return this.productInfo.patchBuildID();
        }
        return "";
    }

    public String getCopyright() {
        return this.productInfo.copyright();
    }

    public String getL2Identifier() {
        return this.server.getL2Identifier();
    }

    public int getTSAListenPort() {
        return this.server.getTSAListenPort();
    }

    public int getTSAGroupPort() {
        return this.server.getTSAGroupPort();
    }

    public long getUsedMemory() {
        return this.manager.getMemoryUsage().getUsedMemory();
    }

    public long getMaxMemory() {
        return this.manager.getMemoryUsage().getMaxMemory();
    }

    public Map<String, Object> getStatistics() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memory used", this.getUsedMemory());
        map.put("memory max", this.getMaxMemory());
        return map;
    }

    public byte[] takeCompressedThreadDump(long requestMillis) {
        return ThreadDumpUtil.getCompressedThreadDump();
    }

    public String getEnvironment() {
        return this.format(System.getProperties());
    }

    public String getTCProperties() {
        Properties props = TCPropertiesImpl.getProperties().addAllPropertiesTo(new Properties());
        String keyPrefix = null;
        return this.format(props, keyPrefix);
    }

    private String format(Properties properties) {
        return this.format(properties, null);
    }

    private String format(Properties properties, String keyPrefix) {
        StringBuilder sb = new StringBuilder();
        Enumeration<?> keys = properties.propertyNames();
        ArrayList<Object> l = new ArrayList<Object>();
        while (keys.hasMoreElements()) {
            Object o = keys.nextElement();
            if (!(o instanceof String)) continue;
            String key = (String)o;
            l.add(key);
        }
        Object[] props = l.toArray(new String[l.size()]);
        Arrays.sort(props);
        l.clear();
        l.addAll(Arrays.asList(props));
        int maxKeyLen = 0;
        for (String string : l) {
            maxKeyLen = Math.max(string.length(), maxKeyLen);
        }
        for (String string : l) {
            if (keyPrefix != null) {
                sb.append(keyPrefix);
            }
            sb.append(string);
            sb.append(":");
            int spaceLen = maxKeyLen - string.length() + 1;
            for (int i = 0; i < spaceLen; ++i) {
                sb.append(" ");
            }
            sb.append(properties.getProperty(string));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String[] getProcessArguments() {
        Object[] args = this.server.processArguments();
        List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (args == null) {
            return inputArgs.toArray(new String[inputArgs.size()]);
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add(StringUtil.toString((Object[])args, (String)" ", null, null));
        l.addAll(inputArgs);
        return l.toArray(new String[l.size()]);
    }

    public String getConfig() {
        return this.server.getConfig();
    }

    public String getConnectedClients() throws IOException {
        Properties props = new Properties();
        String format = "clients.%d.%s";
        List<Client> clients = this.server.getConnectedClients();
        int numClients = clients.size();
        props.setProperty("clients.count", Integer.toString(numClients));
        for (int i = 0; i < numClients; ++i) {
            Client c = clients.get(i);
            props.setProperty(String.format("clients.%d.%s", i, "id"), c.getRemoteUUID());
            props.setProperty(String.format("clients.%d.%s", i, "name"), c.getRemoteName());
            props.setProperty(String.format("clients.%d.%s", i, "version"), c.getVersion());
            props.setProperty(String.format("clients.%d.%s", i, "revision"), c.getRevision());
            props.setProperty(String.format("clients.%d.%s", i, "ipAddress"), c.getRemoteAddress());
        }
        StringWriter writer = new StringWriter();
        props.store(writer, null);
        return writer.toString();
    }

    public String getCurrentChannelProperties() throws IOException {
        Properties props = ServerEnv.getServer().getCurrentChannelProperties();
        StringWriter writer = new StringWriter();
        props.store(writer, null);
        return writer.toString();
    }

    public String getHealthStatus() {
        return "OK";
    }

    @Override
    public void l2StateChanged(StateChangedEvent sce) {
        ServerMode cmode = StateManager.convert(sce.getCurrentState());
        this.debugPrintln("*****  msg=[" + this.stateChangeNotificationInfo.getMsg(cmode) + "] attrName=[" + this.stateChangeNotificationInfo.getAttributeName(cmode) + "] attrType=[" + this.stateChangeNotificationInfo.getAttributeType(cmode) + "] stateName=[" + cmode.getName() + "]");
        this._sendNotification(this.stateChangeNotificationInfo.getMsg(cmode), this.stateChangeNotificationInfo.getAttributeName(cmode), this.stateChangeNotificationInfo.getAttributeType(cmode), Boolean.FALSE, Boolean.TRUE);
    }

    private synchronized void _sendNotification(String msg, String attr, String type, Object oldVal, Object newVal) {
        this.sendNotification(new AttributeChangeNotification(this, this.nextSequenceNumber++, System.currentTimeMillis(), msg, attr, type, oldVal, newVal));
    }

    private void debugPrintln(String s) {
    }

    public void gc() {
        ManagementFactory.getMemoryMXBean().gc();
    }

    public boolean isVerboseGC() {
        return ManagementFactory.getMemoryMXBean().isVerbose();
    }

    public void setVerboseGC(boolean verboseGC) {
        boolean oldValue = this.isVerboseGC();
        ManagementFactory.getMemoryMXBean().setVerbose(verboseGC);
        this._sendNotification("VerboseGC changed", "VerboseGC", "java.lang.Boolean", oldValue, verboseGC);
    }

    public final void setPipelineMonitoring(boolean monitor) {
        if (monitor) {
            MonitoringEventCreator.setPipelineMonitor(consumer -> logger.info(consumer.toString()));
        } else {
            MonitoringEventCreator.setPipelineMonitor(null);
        }
    }

    public String getClusterState(boolean shortForm) {
        AbbreviatedMapListPrettyPrint pp = shortForm ? new AbbreviatedMapListPrettyPrint() : new MapListPrettyPrint();
        return this.server.getClusterState((PrettyPrinter)pp);
    }

    static {
        String[] notifTypes = new String[]{"jmx.attribute.change"};
        String name = AttributeChangeNotification.class.getName();
        String description = "An attribute of this MBean has changed";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "An attribute of this MBean has changed")};
    }
}

