/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management.beans;

import com.tc.management.AbstractTerracottaMBean;
import com.tc.management.TerracottaManagement;
import com.tc.management.beans.L2DumperMBean;
import com.tc.server.TCServerImpl;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2Dumper
extends AbstractTerracottaMBean
implements L2DumperMBean {
    private static final Logger logger = LoggerFactory.getLogger(L2Dumper.class);
    private final TCServerImpl dumper;
    private final MBeanServer mbs;

    public L2Dumper(TCServerImpl dumper, MBeanServer mbs) throws NotCompliantMBeanException {
        super(L2DumperMBean.class, false);
        this.dumper = dumper;
        this.mbs = mbs;
    }

    @Override
    public void doServerDump() {
        logger.info("Server dump: ");
        this.dumper.dump();
    }

    @Override
    public void doThreadDump() throws Exception {
        logger.info("Server Threads: ");
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        StringBuilder allThreads = new StringBuilder("\n\n");
        for (Map.Entry<Thread, StackTraceElement[]> s : threads.entrySet()) {
            allThreads.append(s.getKey().getName());
            allThreads.append(":\n");
            for (StackTraceElement e : s.getValue()) {
                allThreads.append("    ");
                allThreads.append(e.toString());
                allThreads.append('\n');
            }
        }
        logger.info(allThreads.toString());
    }

    public void reset() {
    }

    @Override
    public void dumpClusterState() {
        Set allL2DumperMBeans;
        try {
            allL2DumperMBeans = TerracottaManagement.getAllL2DumperMBeans((MBeanServerConnection)this.mbs);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return;
        }
        for (ObjectName l2DumperBean : allL2DumperMBeans) {
            try {
                this.mbs.invoke(l2DumperBean, "doServerDump", new Object[0], new String[0]);
            }
            catch (Exception e) {
                logger.error("error dumping on " + l2DumperBean, (Throwable)e);
            }
        }
    }
}

