/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.l2.state.StateSyncManager;
import com.tc.net.NodeID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class StateSyncManagerImpl
implements StateSyncManager {
    private final ConcurrentMap<NodeID, SyncValue> syncMessagesProcessedMap = new ConcurrentHashMap<NodeID, SyncValue>();

    @Override
    public void objectSyncComplete(NodeID nodeID) {
        SyncValue value = this.getOrCreateSyncValue(nodeID);
        value.objectSyncCompleteMessageAcked();
    }

    protected SyncValue getOrCreateSyncValue(NodeID nodeID) {
        SyncValue value = this.createSyncValue();
        SyncValue old = this.syncMessagesProcessedMap.putIfAbsent(nodeID, value);
        return old == null ? value : old;
    }

    @Override
    public void removeL2(NodeID nodeID) {
        this.syncMessagesProcessedMap.remove(nodeID);
    }

    @Override
    public void objectSyncComplete() {
    }

    @Override
    public boolean isSyncComplete(NodeID nodeID) {
        SyncValue value = (SyncValue)this.syncMessagesProcessedMap.get(nodeID);
        if (value == null) {
            return false;
        }
        return value.isSyncMesssagesAcked();
    }

    protected SyncValue createSyncValue() {
        return new SyncValue(){
            private volatile boolean objectSyncCompleteMessageProcessed = false;

            @Override
            public void objectSyncCompleteMessageAcked() {
                this.objectSyncCompleteMessageProcessed = true;
            }

            @Override
            public boolean isSyncMesssagesAcked() {
                return this.objectSyncCompleteMessageProcessed;
            }
        };
    }

    static interface SyncValue {
        public void objectSyncCompleteMessageAcked();

        public boolean isSyncMesssagesAcked();
    }
}

