/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.async.api.EventHandler;
import com.tc.async.api.Sink;
import com.tc.async.api.StageManager;
import com.tc.async.impl.StageController;
import com.tc.exception.TCServerRestartException;
import com.tc.l2.context.StateChangedEvent;
import com.tc.l2.ha.WeightGeneratorFactory;
import com.tc.l2.msg.L2StateMessage;
import com.tc.l2.state.ConsistencyManager;
import com.tc.l2.state.ElectionContext;
import com.tc.l2.state.ElectionManagerImpl;
import com.tc.l2.state.Enrollment;
import com.tc.l2.state.ServerMode;
import com.tc.l2.state.StateChangeListener;
import com.tc.l2.state.StateManager;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.GroupException;
import com.tc.net.groups.GroupManager;
import com.tc.net.utils.L2Utils;
import com.tc.objectserver.core.impl.ManagementTopologyEventCollector;
import com.tc.objectserver.impl.Topology;
import com.tc.objectserver.impl.TopologyManager;
import com.tc.objectserver.persistence.ClusterStatePersistor;
import com.tc.util.Assert;
import com.tc.util.State;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.server.ServerEnv;
import org.terracotta.tripwire.TripwireFactory;

public class StateManagerImpl
implements StateManager {
    private static final Logger logger = LoggerFactory.getLogger(StateManagerImpl.class);
    private final Logger consoleLogger;
    private final GroupManager<AbstractGroupMessage> groupManager;
    private final ElectionManagerImpl electionMgr;
    private final ConsistencyManager availabilityMgr;
    private final TopologyManager topologyManager;
    private final StageController stateChangeSink;
    private final ManagementTopologyEventCollector eventCollector;
    private final Sink<ElectionContext> electionSink;
    private final Sink<StateChangedEvent> publishSink;
    private final WeightGeneratorFactory weightsFactory;
    private final CopyOnWriteArrayList<StateChangeListener> listeners = new CopyOnWriteArrayList();
    private boolean didStartElection;
    private final ClusterStatePersistor clusterStatePersistor;
    private NodeID activeNode = ServerID.NULL_ID;
    private NodeID syncedTo = ServerID.NULL_ID;
    private volatile ServerMode state = ServerMode.INITIAL;
    private final ServerMode startState;
    private final ElectionGate elections = new ElectionGate();
    private Enrollment verification = null;

    public StateManagerImpl(Logger consoleLogger, GroupManager<AbstractGroupMessage> groupManager, StageController controller, ManagementTopologyEventCollector eventCollector, StageManager mgr, int expectedServers, int electionTimeInSec, WeightGeneratorFactory weightFactory, ConsistencyManager availabilityMgr, ClusterStatePersistor clusterStatePersistor, TopologyManager topologyManager) {
        this.consoleLogger = consoleLogger;
        this.groupManager = groupManager;
        this.stateChangeSink = controller;
        this.eventCollector = eventCollector;
        this.weightsFactory = weightFactory;
        this.availabilityMgr = availabilityMgr;
        this.topologyManager = topologyManager;
        this.electionMgr = new ElectionManagerImpl(groupManager, electionTimeInSec);
        this.electionSink = mgr.createStage("l2_election_handler_stage", ElectionContext.class, this.electionMgr.getEventHandler(), 1, 1024, false, false).getSink();
        this.publishSink = mgr.createStage("l2_state_change_stage", StateChangedEvent.class, EventHandler.consumer(this::publishStateChange), 1, 1024, false, false).getSink();
        this.clusterStatePersistor = clusterStatePersistor;
        this.startState = StateManager.convert(clusterStatePersistor.getInitialState());
    }

    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("startState", (Object)this.startState);
        map.put("currentState", (Object)this.state);
        map.put("active", this.activeNode);
        map.put("consistency", this.availabilityMgr.getStateMap());
        return map;
    }

    @Override
    public synchronized ServerMode getCurrentMode() {
        return this.state;
    }

    private Enrollment createVerificationEnrollment() {
        return this.availabilityMgr.createVerificationEnrollment(this.syncedTo, this.weightsFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean electionStarted() {
        boolean isElectionStarted = this.elections.electionStarted();
        if (isElectionStarted) {
            StateManagerImpl stateManagerImpl = this;
            synchronized (stateManagerImpl) {
                this.verification = this.createVerificationEnrollment();
            }
        }
        return isElectionStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean electionFinished() {
        StateManagerImpl stateManagerImpl = this;
        synchronized (stateManagerImpl) {
            this.verification = null;
        }
        return this.elections.electionFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDeclaredActive() throws InterruptedException {
        StateManagerImpl stateManagerImpl = this;
        synchronized (stateManagerImpl) {
            while (this.activeNode.isNull() && this.state != ServerMode.ACTIVE) {
                this.wait();
            }
        }
        this.elections.waitForElectionToFinish();
    }

    public void waitForElectionsToFinish() throws InterruptedException {
        this.elections.waitForElectionToFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeAndStartElection() {
        StateManagerImpl.debugInfo("Starting election");
        this.info("Starting election initial state:" + (Object)((Object)this.startState));
        if (this.canStartElection()) {
            this.runElection();
        } else {
            this.info("Ignoring Election request since not in right state: " + (Object)((Object)this.state));
        }
        StateManagerImpl stateManagerImpl = this;
        synchronized (stateManagerImpl) {
            Assert.assertFalse((boolean)this.didStartElection);
            this.didStartElection = true;
            this.notifyAll();
        }
    }

    @Override
    public void shutdown() {
        this.moveToStopState();
        logger.info("shutting down elections");
        this.electionMgr.shutdown();
    }

    private void runElection() {
        if (!this.electionStarted()) {
            return;
        }
        Topology lockedTopology = this.topologyManager.getTopology();
        NodeID myNodeID = this.getLocalNodeID();
        boolean isNew = this.isFreshServer();
        if (this.getActiveNodeID().isNull()) {
            StateManagerImpl.debugInfo("Running election - isNew: " + isNew);
            this.electionSink.addToSink((Object)new ElectionContext(myNodeID, lockedTopology.getServers(), isNew, this.weightsFactory, this.state.getState(), nodeid -> {
                boolean rerun = false;
                if (nodeid == myNodeID) {
                    StateManagerImpl.debugInfo("Won Election, moving to active state. myNodeID/winner=" + myNodeID);
                    if (this.getCurrentMode().canBeActive() && this.clusterStatePersistor.isDBClean() && this.availabilityMgr.requestTransition(this.state, (NodeID)nodeid, lockedTopology, ConsistencyManager.Transition.MOVE_TO_ACTIVE)) {
                        this.moveToActiveState(this.electionMgr.passiveStandbys(), lockedTopology);
                    } else {
                        if (!this.clusterStatePersistor.isDBClean()) {
                            logger.info("rerunning election because " + nodeid + " must be synced to an active");
                        } else {
                            logger.info("rerunning election because " + nodeid + " not allowed to transition");
                        }
                        rerun = true;
                    }
                } else if (nodeid.isNull()) {
                    rerun = true;
                } else {
                    StateManagerImpl.debugInfo("Lost election, waiting for winner to declare as active, winner=" + nodeid);
                    if (!this.waitUntilActiveNodeIDNotNull(this.electionMgr.getElectionTime())) {
                        logger.info("rerunning election because " + nodeid + " never declared active");
                        rerun = true;
                    }
                }
                this.electionFinished();
                this.moveToStartStateIfBootstrapping();
                if (rerun && this.canStartElection()) {
                    this.electionMgr.reset((NodeID)ServerID.NULL_ID, null);
                    this.runElection();
                }
            }));
        } else {
            this.electionFinished();
        }
    }

    private synchronized boolean waitUntilActiveNodeIDNotNull(long timeout) {
        while (this.activeNode.isNull() && timeout > 0L) {
            long start = System.currentTimeMillis();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                L2Utils.handleInterrupted(logger, e);
            }
            timeout -= System.currentTimeMillis() - start;
        }
        StateManagerImpl.debugInfo("Wait for other active to declare as active over. Declared? activeNodeId.isNull() = " + this.activeNode.isNull() + ", activeNode=" + this.activeNode);
        return !this.activeNode.isNull();
    }

    private synchronized void setActiveNodeID(NodeID nodeID) {
        this.info("SETTING activeNode=" + nodeID);
        this.activeNode = nodeID;
        if (!nodeID.isNull()) {
            this.syncedTo = nodeID;
        }
        this.notifyAll();
    }

    private NodeID getLocalNodeID() {
        return this.groupManager.getLocalNodeID();
    }

    @Override
    public void registerForStateChangeEvents(StateChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void fireStateChangedEvent(StateChangedEvent sce) {
        this.listeners.forEach(listener -> listener.l2StateChanged(sce));
    }

    private void moveToPassiveReady(L2StateMessage src) {
        long term;
        Enrollment winningEnrollment = src.getEnrollment();
        ServerID active = src.messageFrom();
        this.electionMgr.reset((NodeID)active, winningEnrollment);
        long[] weights = winningEnrollment.getWeights();
        if (weights.length == this.weightsFactory.size() && (term = weights[weights.length - 1]) > 0L && term < Long.MAX_VALUE) {
            this.availabilityMgr.setCurrentTerm(term);
        }
        if (!this.getActiveNodeID().isNull()) {
            logger.info("active already set");
            if (!this.getActiveNodeID().equals(active)) {
                this.zapAndResyncLocalNode("server already syncing with an active");
            }
            return;
        }
        logger.info("moving to passive ready " + (Object)((Object)this.state) + " " + src + " " + active);
        logger.info("verification = {}", (Object)this.getVerificationEnrollment());
        if (this.startState.containsData()) {
            this.zapAndResyncLocalNode("server contains stale data.");
            return;
        }
        ServerMode newState = !winningEnrollment.getNodeID().isNull() && this.getVerificationEnrollment().equals((Object)winningEnrollment) ? ServerMode.PASSIVE : ServerMode.UNINITIALIZED;
        EnumSet<ServerMode> modes = newState == ServerMode.UNINITIALIZED ? EnumSet.of(ServerMode.INITIAL, ServerMode.START, ServerMode.UNINITIALIZED) : EnumSet.of(ServerMode.PASSIVE);
        try {
            this.setActiveNodeID((NodeID)active);
            ServerMode oldState = this.switchToState(newState, modes);
            switch (oldState) {
                case INITIAL: 
                case START: {
                    Assert.assertEquals((Object)((Object)ServerMode.UNINITIALIZED), (Object)((Object)newState));
                    break;
                }
                case UNINITIALIZED: {
                    Assert.assertEquals((Object)((Object)ServerMode.UNINITIALIZED), (Object)((Object)newState));
                    break;
                }
                case PASSIVE: {
                    Assert.assertEquals((Object)((Object)ServerMode.PASSIVE), (Object)((Object)newState));
                    break;
                }
                default: {
                    throw new IllegalStateException((Object)((Object)this.state) + " at move to passive ready");
                }
            }
        }
        catch (IllegalStateException state) {
            this.zapAndResyncLocalNode(state.getMessage());
        }
    }

    @Override
    public void moveToPassiveSyncing(NodeID connectedTo) {
        ServerMode old = this.switchToState(ServerMode.SYNCING, EnumSet.of(ServerMode.UNINITIALIZED));
        Assert.assertEquals((Object)connectedTo, (Object)this.getActiveNodeID());
    }

    @Override
    public void moveToPassiveStandbyState() {
        ServerMode old = this.switchToState(ServerMode.PASSIVE, EnumSet.complementOf(EnumSet.of(ServerMode.ACTIVE)));
        if (old != ServerMode.PASSIVE) {
            this.clusterStatePersistor.setDBClean(true);
        } else {
            this.info("Already in " + (Object)((Object)this.state));
        }
    }

    @Override
    public void moveToStopState() {
        this.switchToState(ServerMode.STOP, EnumSet.allOf(ServerMode.class));
    }

    @Override
    public void moveToDiagnosticMode() {
        this.switchToState(ServerMode.DIAGNOSTIC, EnumSet.of(ServerMode.INITIAL));
    }

    private void moveToStartStateIfBootstrapping() {
        try {
            if (this.getCurrentMode() == ServerMode.INITIAL) {
                this.switchToState(ServerMode.START, EnumSet.of(ServerMode.INITIAL));
            }
        }
        catch (IllegalStateException state) {
            logger.info("request to start denied. Current state: {}", (Object)this.getCurrentMode());
        }
    }

    @Override
    public boolean moveToStopStateIf(Set<ServerMode> validStates) {
        try {
            this.switchToState(ServerMode.STOP, EnumSet.of(this.getCurrentMode()));
            return true;
        }
        catch (IllegalStateException state) {
            logger.info("request to stop denied. Current state: {}", (Object)this.getCurrentMode());
            return false;
        }
    }

    private void moveToActiveState(Set<ServerID> passives, Topology topology) {
        ServerMode oldState = this.switchToState(ServerMode.ACTIVE, EnumSet.of(ServerMode.INITIAL, ServerMode.START, ServerMode.PASSIVE));
        StateManagerImpl.debugInfo("Moving to active state");
        for (NodeID nodeID : passives) {
            if (this.availabilityMgr.requestTransition(this.state, nodeID, topology, ConsistencyManager.Transition.ADD_PASSIVE)) continue;
            this.groupManager.zapNode(nodeID, 1, "unable to add passive");
        }
        Enrollment verify = this.createVerificationEnrollment();
        this.electionMgr.declareWinner(verify, oldState.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ServerMode switchToState(ServerMode newState, Set<ServerMode> validOldStates) throws IllegalStateException {
        if (!EnumSet.of(ServerMode.DIAGNOSTIC, ServerMode.STOP).contains((Object)newState)) {
            this.synchronizedWaitForStart();
        }
        if (!validOldStates.contains((Object)this.state)) {
            throw new IllegalStateException("Cant move to " + (Object)((Object)newState) + " from " + (Object)((Object)this.state) + " valid states " + validOldStates);
        }
        try {
            logger.debug("Switching to " + (Object)((Object)newState));
            if (this.state != newState) {
                TripwireFactory.createServerStateEvent((String)newState.toString(), (ServerMode.ACTIVE == newState ? 1 : 0) != 0).commit();
                this.publishSink.addToSink((Object)new StateChangedEvent(this.state.getState(), newState.getState()));
            }
            ServerMode serverMode = this.state;
            return serverMode;
        }
        finally {
            this.state = newState;
            this.notifyAll();
        }
    }

    private void publishStateChange(StateChangedEvent event) {
        State newState = event.getCurrentState();
        if (event.movedToActive()) {
            long activate = System.currentTimeMillis();
            try {
                activate = ServerEnv.getServer().getActivateTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.eventCollector.serverDidEnterState(newState, activate);
        } else {
            this.eventCollector.serverDidEnterState(newState, System.currentTimeMillis());
        }
        if (StateManager.convert(event.getOldState()) != StateManager.convert(newState)) {
            this.stateChangeSink.transition(event.getOldState(), newState);
        }
        this.fireStateChangedEvent(event);
        this.info("Moved to " + newState, true);
    }

    @Override
    public synchronized NodeID getActiveNodeID() {
        if (this.state == ServerMode.ACTIVE) {
            return this.getLocalNodeID();
        }
        return this.activeNode;
    }

    private synchronized boolean isFreshServer() {
        return this.state.isStartup() && this.startState.isStartup();
    }

    private synchronized boolean canStartElection() {
        return this.state.canStartElection();
    }

    @Override
    public synchronized boolean isActiveCoordinator() {
        return this.state == ServerMode.ACTIVE;
    }

    public synchronized boolean isPassiveUnitialized() {
        return this.state == ServerMode.UNINITIALIZED;
    }

    public synchronized boolean isPassiveStandby() {
        return this.state == ServerMode.PASSIVE;
    }

    private synchronized Enrollment getVerificationEnrollment() {
        return this.verification != null ? this.verification : this.createVerificationEnrollment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleClusterStateMessage(L2StateMessage clusterMsg) {
        StateManagerImpl stateManagerImpl = this;
        synchronized (stateManagerImpl) {
            this.synchronizedWaitForStart();
        }
        StateManagerImpl.debugInfo("Received cluster state message: " + clusterMsg);
        try {
            switch (clusterMsg.getType()) {
                case 0: {
                    this.handleStartElectionRequest(clusterMsg);
                    break;
                }
                case 4: {
                    this.handleElectionAbort(clusterMsg);
                    break;
                }
                case 1: {
                    this.handleElectionResultMessage(clusterMsg);
                    break;
                }
                case 5: {
                    this.handleElectionWonMessage(clusterMsg);
                    break;
                }
                case 6: {
                    this.handleElectionAlreadyWonMessage(clusterMsg);
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("This message shouldn't have been routed here : " + clusterMsg));
                }
            }
        }
        catch (GroupException ge) {
            logger.error("Caught Exception while handling Message : " + clusterMsg, (Throwable)ge);
        }
    }

    private void handleElectionWonMessage(L2StateMessage clusterMsg) {
        boolean transition;
        StateManagerImpl.debugInfo("Received election_won msg: " + clusterMsg);
        boolean verify = this.checkIfPeerWinsVerificationElection(clusterMsg) && !this.isActiveCoordinator();
        boolean bl = transition = verify && this.availabilityMgr.requestTransition(this.state, clusterMsg.getEnrollment().getNodeID(), ConsistencyManager.Transition.CONNECT_TO_ACTIVE);
        if (transition) {
            this.moveToPassiveReady(clusterMsg);
        } else {
            this.groupManager.closeMember(clusterMsg.messageFrom());
        }
    }

    private void handleElectionAlreadyWonMessage(L2StateMessage clusterMsg) {
        StateManagerImpl.debugInfo("Received election_already_won msg: " + clusterMsg);
        if (this.isActiveCoordinator()) {
            logger.info("split-brain detected");
        }
        this.verifyActiveDeclarationAndRespond(clusterMsg);
    }

    private boolean checkIfPeerWinsVerificationElection(L2StateMessage clusterMsg) {
        Enrollment winningEnrollment = clusterMsg.getEnrollment();
        Enrollment verify = this.getVerificationEnrollment();
        int len = Math.min(winningEnrollment.getWeights().length, verify.getWeights().length);
        boolean peerWins = !this.isActiveCoordinator();
        for (int x = 0; x < len; ++x) {
            if (winningEnrollment.getWeights()[x] == verify.getWeights()[x]) continue;
            peerWins = false;
            break;
        }
        logger.info("verifying election won results isActive:{} remote:{} local:{} remoteWins:{}", new Object[]{this.isActiveCoordinator(), winningEnrollment, verify, peerWins |= winningEnrollment.wins(verify)});
        return peerWins;
    }

    private void zapAndResyncLocalNode(String msg) {
        this.clusterStatePersistor.setDBClean(false);
        throw new TCServerRestartException("Clear and resync - " + msg);
    }

    private synchronized void handleElectionResultMessage(L2StateMessage msg) throws GroupException {
        if (this.activeNode.equals(msg.getEnrollment().getNodeID())) {
            Assert.assertFalse((boolean)ServerID.NULL_ID.equals((Object)this.activeNode));
            L2StateMessage resultAgreed = L2StateMessage.createResultAgreedMessage((L2StateMessage)msg, (Enrollment)msg.getEnrollment(), (State)this.state.getState());
            logger.info("Agreed with Election Result from " + msg.messageFrom() + " : " + resultAgreed);
            this.groupManager.sendTo((NodeID)msg.messageFrom(), (AbstractGroupMessage)resultAgreed);
        } else if (this.state == ServerMode.ACTIVE || !this.activeNode.isNull() || msg.getEnrollment().isANewCandidate() && !this.state.isStartup()) {
            L2StateMessage resultConflict = L2StateMessage.createResultConflictMessage((L2StateMessage)msg, (Enrollment)msg.getEnrollment(), (State)this.state.getState());
            this.warn("WARNING :: Active Node = " + this.activeNode + " , " + (Object)((Object)this.state) + " received ELECTION_RESULT message from another node : " + msg + " : Forcing re-election " + resultConflict);
            this.groupManager.sendTo((NodeID)msg.messageFrom(), (AbstractGroupMessage)resultConflict);
        } else {
            StateManagerImpl.debugInfo("ElectionMgr handling election result msg: " + msg);
            this.electionMgr.handleElectionResultMessage(msg, this.state.getState());
        }
    }

    private void handleElectionAbort(L2StateMessage clusterMsg) {
        this.electionMgr.handleElectionAbort(clusterMsg, this.state.getState());
        if (this.isActiveCoordinator()) {
            logger.info("split-brain detected");
        }
        this.verifyActiveDeclarationAndRespond(clusterMsg);
    }

    private void verifyActiveDeclarationAndRespond(L2StateMessage clusterMsg) {
        boolean transition;
        boolean verify = this.checkIfPeerWinsVerificationElection(clusterMsg) && !this.isActiveCoordinator();
        boolean bl = transition = verify && this.availabilityMgr.requestTransition(this.state, clusterMsg.getEnrollment().getNodeID(), ConsistencyManager.Transition.CONNECT_TO_ACTIVE);
        if (transition) {
            this.sendVerificationOKResponse(clusterMsg);
            this.moveToPassiveReady(clusterMsg);
        } else {
            this.sendVerificationNGResponse(clusterMsg);
        }
    }

    private void handleStartElectionRequest(L2StateMessage msg) throws GroupException {
        if (this.getCurrentMode() == ServerMode.ACTIVE) {
            Enrollment verify = this.createVerificationEnrollment();
            L2StateMessage abortMsg = L2StateMessage.createAbortElectionMessage((L2StateMessage)msg, (Enrollment)verify, (State)this.state.getState());
            this.info("Forcing Abort Election for " + msg + " with " + abortMsg);
            L2StateMessage response = (L2StateMessage)this.groupManager.sendToAndWaitForResponse((NodeID)msg.messageFrom(), (AbstractGroupMessage)abortMsg);
            this.validatePeerResponseToActiveDelaration(response);
        } else if (!this.electionMgr.handleStartElectionRequest(msg, this.state.getState())) {
            this.startElectionIfNecessary((NodeID)ServerID.NULL_ID);
        }
    }

    @Override
    public void publishActiveState(NodeID nodeID) throws GroupException {
        StateManagerImpl.debugInfo("Publishing active state to nodeId: " + nodeID);
        Assert.assertTrue((boolean)this.isActiveCoordinator());
        Enrollment verify = this.createVerificationEnrollment();
        L2StateMessage msg = L2StateMessage.createElectionWonAlreadyMessage((Enrollment)verify, (State)this.state.getState());
        L2StateMessage response = (L2StateMessage)this.groupManager.sendToAndWaitForResponse(nodeID, (AbstractGroupMessage)msg);
        this.validatePeerResponseToActiveDelaration(response);
    }

    private void validatePeerResponseToActiveDelaration(L2StateMessage response) throws GroupException {
        if (response != null) {
            ServerID nodeID = response.messageFrom();
            ServerMode peerState = StateManager.convert(response.getState());
            if (response.getType() != 2) {
                String error = "Recd wrong response from : " + nodeID + " : msg = " + response + " while publishing Active State";
                logger.info(error);
                boolean doesPeerWin = this.checkIfPeerWinsVerificationElection(response);
                if (doesPeerWin) {
                    if (peerState == ServerMode.ACTIVE) {
                        Assert.assertTrue((boolean)this.isActiveCoordinator());
                    } else if (peerState.canBeActive()) {
                        this.zapAndResyncLocalNode("Passive has more recent data compared to active, node is restarting");
                    } else {
                        logger.info("Node peer has more current data yet cannot be active.  Server is going dormant until next election.");
                    }
                } else if (peerState == ServerMode.ACTIVE) {
                    this.groupManager.zapNode((NodeID)nodeID, 255, this.getVerificationEnrollment() + " wins over " + response.getEnrollment());
                } else if (peerState.canBeActive()) {
                    logger.info("results not agreed for verification election in state: {}", (Object)peerState);
                } else {
                    logger.info("results not agreed for verification election in state: {}", (Object)peerState);
                }
            }
        }
    }

    @Override
    public Set<ServerID> getPassiveStandbys() {
        return this.electionMgr.passiveStandbys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElectionIfNecessary(NodeID disconnectedNode) {
        StateManagerImpl stateManagerImpl = this;
        synchronized (stateManagerImpl) {
            this.synchronizedWaitForStart();
        }
        Assert.assertFalse((boolean)disconnectedNode.equals(this.getLocalNodeID()));
        boolean elect = false;
        StateManagerImpl stateManagerImpl2 = this;
        synchronized (stateManagerImpl2) {
            if (this.state.isStartup() || !disconnectedNode.isNull() && disconnectedNode.equals(this.activeNode)) {
                this.info("ACTIVE is gone");
                this.setActiveNodeID((NodeID)ServerID.NULL_ID);
            }
            if (this.state == ServerMode.SYNCING && this.activeNode.equals(disconnectedNode)) {
                logger.error("Passive only partially synced when active disappeared.");
                elect = true;
            } else if (this.state != ServerMode.ACTIVE && this.activeNode.isNull()) {
                elect = true;
            }
        }
        if (elect) {
            this.info("Starting Election to determine cluster wide ACTIVE L2");
            this.runElection();
        } else {
            StateManagerImpl.debugInfo("Not starting election even though node left: " + disconnectedNode);
        }
    }

    private void sendVerificationOKResponse(L2StateMessage msg) {
        try {
            Assert.assertTrue((msg.getType() != 5 ? 1 : 0) != 0);
            ServerMode sendState = this.state.isStartup() ? this.startState : this.state;
            this.groupManager.sendTo((NodeID)msg.messageFrom(), (AbstractGroupMessage)L2StateMessage.createResultAgreedMessage((L2StateMessage)msg, (Enrollment)this.getVerificationEnrollment(), (State)sendState.getState()));
        }
        catch (GroupException e) {
            logger.error("Error handling message : " + msg, (Throwable)e);
        }
    }

    private void sendVerificationNGResponse(L2StateMessage msg) {
        try {
            Assert.assertTrue((msg.getType() != 5 ? 1 : 0) != 0);
            ServerMode sendState = this.state.isStartup() ? this.startState : this.state;
            this.groupManager.sendTo((NodeID)msg.messageFrom(), (AbstractGroupMessage)L2StateMessage.createResultConflictMessage((L2StateMessage)msg, (Enrollment)this.getVerificationEnrollment(), (State)sendState.getState()));
        }
        catch (GroupException e) {
            logger.error("Error handling message : " + msg, (Throwable)e);
        }
    }

    public String toString() {
        return StateManagerImpl.class.getSimpleName() + ":" + this.state.toString();
    }

    private void info(String message) {
        this.info(message, false);
    }

    private void info(String message, boolean console) {
        if (console) {
            this.consoleLogger.info(message);
        } else {
            logger.info(message);
        }
    }

    private void warn(String message) {
        this.warn(message, false);
    }

    private void warn(String message, boolean console) {
        if (console) {
            this.consoleLogger.warn(message);
        } else {
            logger.warn(message);
        }
    }

    private static void debugInfo(String message) {
        logger.debug(message);
    }

    private void synchronizedWaitForStart() {
        while (!this.didStartElection) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                L2Utils.handleInterrupted(logger, e);
            }
        }
    }

    private static class ElectionGate {
        private boolean electionInProgress = false;

        private ElectionGate() {
        }

        public synchronized boolean electionStarted() {
            try {
                boolean bl = !this.electionInProgress;
                return bl;
            }
            finally {
                this.electionInProgress = true;
                this.notifyAll();
            }
        }

        public synchronized boolean electionFinished() {
            try {
                boolean bl = this.electionInProgress;
                return bl;
            }
            finally {
                this.electionInProgress = false;
                this.notifyAll();
            }
        }

        public synchronized void waitForElectionToFinish() throws InterruptedException {
            while (this.electionInProgress) {
                this.wait();
            }
        }
    }
}

